/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public final class RenderHelper {
    public static final double RENDER_OFFSET = 0.001953125;
    public static final ResourceLocation MC_BLOCK_SHEET = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation MC_FONT_DEFAULT = new ResourceLocation("textures/font/ascii.png");
    public static final ResourceLocation MC_FONT_ALTERNATE = new ResourceLocation("textures/font/ascii_sga.png");
    public static final ResourceLocation MC_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    private RenderHelper() {
    }

    public static TextureManager engine() {
        return Minecraft.func_71410_x().field_71446_o;
    }

    public static TextureMap textureMap() {
        return Minecraft.func_71410_x().func_147117_R();
    }

    public static Tessellator tessellator() {
        return Tessellator.func_178181_a();
    }

    public static RenderItem renderItem() {
        return Minecraft.func_71410_x().func_175599_af();
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static void resetColor() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderIcon(TextureAtlasSprite icon, double z) {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(0.0, 16.0, z).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94210_h());
        buffer.func_181662_b(16.0, 16.0, z).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94210_h());
        buffer.func_181662_b(16.0, 0.0, z).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94206_g());
        buffer.func_181662_b(0.0, 0.0, z).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94206_g());
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderIcon(double x, double y, double z, TextureAtlasSprite icon, int width, int height) {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x, y + (double)height, z).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94210_h());
        buffer.func_181662_b(x + (double)width, y + (double)height, z).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94210_h());
        buffer.func_181662_b(x + (double)width, y, z).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94206_g());
        buffer.func_181662_b(x, y, z).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94206_g());
        Tessellator.func_178181_a().func_78381_a();
    }

    public static TextureAtlasSprite getFluidTexture(Fluid fluid) {
        if (fluid == null) {
            fluid = FluidRegistry.LAVA;
        }
        return RenderHelper.getTexture(fluid.getStill());
    }

    public static TextureAtlasSprite getFluidTexture(FluidStack fluid) {
        if (fluid == null || fluid.getFluid().getStill(fluid) == null) {
            fluid = new FluidStack(FluidRegistry.LAVA, 1);
        }
        return RenderHelper.getTexture(fluid.getFluid().getStill(fluid));
    }

    public static void bindTexture(ResourceLocation texture) {
        RenderHelper.engine().func_110577_a(texture);
    }

    public static void setBlockTextureSheet() {
        RenderHelper.bindTexture(MC_BLOCK_SHEET);
    }

    public static void setDefaultFontTextureSheet() {
        RenderHelper.bindTexture(MC_FONT_DEFAULT);
    }

    public static TextureAtlasSprite getTexture(String location) {
        return RenderHelper.textureMap().func_110572_b(location);
    }

    public static TextureAtlasSprite getTexture(ResourceLocation location) {
        return RenderHelper.getTexture(location.toString());
    }

    public static void setSGAFontTextureSheet() {
        RenderHelper.bindTexture(MC_FONT_ALTERNATE);
    }

    public static void enableGUIStandardItemLighting() {
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
    }

    public static void enableStandardItemLighting() {
        net.minecraft.client.renderer.RenderHelper.func_74519_b();
    }
}

