/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.modroadworksreborn.items;

import com.clussmanproductions.modroadworksreborn.ModBlocks;
import com.clussmanproductions.modroadworksreborn.ModRoadworksReborn;
import com.clussmanproductions.modroadworksreborn.blocks.BlockStripeBase;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArrowPainter
extends Item {
    public ItemArrowPainter() {
        this.setRegistryName("arrowpainter");
        this.func_77655_b("modroadworksreborn.arrowpainter");
        this.func_77637_a(ModRoadworksReborn.ROADWORKSREBORN);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        final ModelResourceLocation step0 = new ModelResourceLocation(this.getRegistryName() + "_step0", "inventory");
        final ModelResourceLocation step1 = new ModelResourceLocation(this.getRegistryName() + "_step1", "inventory");
        final ModelResourceLocation step2 = new ModelResourceLocation(this.getRegistryName() + "_step2", "inventory");
        final ModelResourceLocation step3 = new ModelResourceLocation(this.getRegistryName() + "_step3", "inventory");
        final ModelResourceLocation step4 = new ModelResourceLocation(this.getRegistryName() + "_step4", "inventory");
        final ModelResourceLocation step5 = new ModelResourceLocation(this.getRegistryName() + "_step5", "inventory");
        final ModelResourceLocation step6 = new ModelResourceLocation(this.getRegistryName() + "_step6", "inventory");
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{step0, step1, step2, step3, step4, step5, step6});
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                switch (ItemArrowPainter.this.getStep(stack)) {
                    case 0: {
                        return step0;
                    }
                    case 1: {
                        return step1;
                    }
                    case 2: {
                        return step2;
                    }
                    case 3: {
                        return step3;
                    }
                    case 4: {
                        return step4;
                    }
                    case 5: {
                        return step5;
                    }
                    case 6: {
                        return step6;
                    }
                }
                return null;
            }
        });
    }

    private int getStep(ItemStack stack) {
        NBTTagCompound compound = this.getOrCreateTagCompound(stack);
        if (!compound.func_74764_b("step")) {
            compound.func_74768_a("step", 0);
        }
        return compound.func_74762_e("step");
    }

    private NBTTagCompound getOrCreateTagCompound(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    public void increaseStep(ItemStack stack) {
        int step = this.getStep(stack);
        if (++step > 6) {
            step = 0;
        }
        NBTTagCompound compound = this.getOrCreateTagCompound(stack);
        compound.func_74768_a("step", step);
    }

    public String getName(ItemStack stack) {
        int step = this.getStep(stack);
        switch (step) {
            case 0: {
                return "Forward";
            }
            case 1: {
                return "Right";
            }
            case 2: {
                return "Left";
            }
            case 3: {
                return "Forward-Right";
            }
            case 4: {
                return "Forward-Left";
            }
            case 5: {
                return "Right-Left";
            }
            case 6: {
                return "Forward-Right-Left";
            }
        }
        return null;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        BlockPos offset = pos.func_177972_a(facing);
        IBlockState offsetBlockState = worldIn.func_180495_p(offset);
        Block offsetBlock = offsetBlockState.func_177230_c();
        if (!offsetBlock.func_176200_f((IBlockAccess)worldIn, offset)) {
            return EnumActionResult.SUCCESS;
        }
        BlockStripeBase blockToPlace = this.getBlockToPlace(player.func_184614_ca());
        IBlockState blockState = blockToPlace.func_176223_P().func_177226_a((IProperty)BlockStripeBase.FACING, (Comparable)player.func_174811_aO());
        worldIn.func_175656_a(offset, blockState);
        return EnumActionResult.SUCCESS;
    }

    private BlockStripeBase getBlockToPlace(ItemStack stack) {
        int step = this.getStep(stack);
        switch (step) {
            case 0: {
                return ModBlocks.forward;
            }
            case 1: {
                return ModBlocks.right;
            }
            case 2: {
                return ModBlocks.left;
            }
            case 3: {
                return ModBlocks.forwardRight;
            }
            case 4: {
                return ModBlocks.forwardLeft;
            }
            case 5: {
                return ModBlocks.rightLeft;
            }
            case 6: {
                return ModBlocks.forwardRightLeft;
            }
        }
        return null;
    }
}

