/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.world.gen.structure;

import java.util.Map;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponentTemplate;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2weapons;

public class ScatteredFeatureTF2Base
extends StructureComponentTemplate {
    public static String[] templateNames = new String[]{"red", "blu"};
    private String templateName;
    private Rotation rotation;
    private Mirror mirror;
    private int groundLevel;

    public ScatteredFeatureTF2Base() {
    }

    public ScatteredFeatureTF2Base(TemplateManager manager, String name, BlockPos pos, Rotation rot, World world) {
        this(manager, name, pos, rot, Mirror.NONE, world);
    }

    public ScatteredFeatureTF2Base(TemplateManager p_i47356_1_, String p_i47356_2_, BlockPos p_i47356_3_, Rotation p_i47356_4_, Mirror p_i47356_5_, World world) {
        super(0);
        this.templateName = p_i47356_2_;
        this.field_186178_c = p_i47356_3_;
        this.rotation = p_i47356_4_;
        this.mirror = p_i47356_5_;
        this.loadTemplate(p_i47356_1_);
    }

    private void loadTemplate(TemplateManager p_191081_1_) {
        Template template = p_191081_1_.func_186237_a((MinecraftServer)null, new ResourceLocation("rafradek_tf2_weapons", "tf2base/" + this.templateName));
        PlacementSettings placementsettings = new PlacementSettings().func_186222_a(false).func_186220_a(this.rotation).func_186214_a(this.mirror).func_186223_a(this.field_74887_e);
        this.func_186173_a(template, this.field_186178_c, placementsettings);
        for (Map.Entry entr : template.func_186258_a(this.field_186178_c, placementsettings).entrySet()) {
            if (!((String)entr.getValue()).equals("GLevel")) continue;
            this.groundLevel = ((BlockPos)entr.getKey()).func_177956_o() - this.field_74887_e.field_78895_b;
        }
    }

    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        tagCompound.func_74778_a("Template", this.templateName);
        tagCompound.func_74778_a("Rot", this.field_186177_b.func_186215_c().name());
        tagCompound.func_74778_a("Mi", this.field_186177_b.func_186212_b().name());
    }

    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
        super.func_143011_b(tagCompound, p_143011_2_);
        this.templateName = tagCompound.func_74779_i("Template");
        this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
        this.mirror = Mirror.valueOf((String)tagCompound.func_74779_i("Mi"));
        this.loadTemplate(p_143011_2_);
    }

    public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
        boolean done;
        if (this.field_186178_c.func_177956_o() == 64) {
            int averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
            if (averageGroundLvl < 0) {
                return true;
            }
            this.func_181138_a(0, averageGroundLvl - this.field_74887_e.field_78895_b - this.groundLevel, 0);
        }
        if (done = super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn)) {
            for (int i = 0; i < this.field_74887_e.func_78883_b(); ++i) {
                for (int j = 0; j < this.field_74887_e.func_78880_d(); ++j) {
                    this.func_175808_b(worldIn, Blocks.field_150346_d.func_176223_P(), i, -1 + this.groundLevel, j, structureBoundingBoxIn);
                }
            }
        }
        return done;
    }

    protected int getAverageGroundLevel(World worldIn, StructureBoundingBox structurebb) {
        int i = 0;
        int j = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
            for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                blockpos$mutableblockpos.func_181079_c(l, 64, k);
                if (!structurebb.func_175898_b((Vec3i)blockpos$mutableblockpos)) continue;
                i += Math.max(worldIn.func_175672_r((BlockPos)blockpos$mutableblockpos).func_177956_o(), worldIn.field_73011_w.func_76557_i() - 1);
                ++j;
            }
        }
        if (j == 0) {
            return -1;
        }
        return i / j;
    }

    protected void func_186175_a(String function, BlockPos pos, World worldIn, Random rand, StructureBoundingBox sbb) {
        if (function.startsWith("ChestB")) {
            BlockPos off = pos.func_177977_b();
            TileEntity ent = worldIn.func_175625_s(off);
            ((TileEntityChest)ent).func_189404_a(TF2weapons.lootTF2Base, rand.nextLong());
        }
    }

    public static class MapGen
    extends MapGenStructure {
        private int distance;
        private IChunkGenerator provider;

        public MapGen(IChunkGenerator provider) {
            this.provider = provider;
            this.distance = TF2ConfigVars.baseChance;
        }

        public String func_143025_a() {
            return "TF2BaseScatt";
        }

        protected boolean func_75047_a(int chunkX, int chunkZ) {
            boolean flag;
            int i = chunkX;
            int j = chunkZ;
            if (chunkX < 0) {
                chunkX -= this.distance - 1;
            }
            if (chunkZ < 0) {
                chunkZ -= this.distance - 1;
            }
            int k = chunkX / this.distance;
            int l = chunkZ / this.distance;
            Random random = this.field_75039_c.func_72843_D(k, l, 1456463);
            k *= this.distance;
            l *= this.distance;
            return i == (k += random.nextInt(Math.max(1, this.distance - 8))) && j == (l += random.nextInt(Math.max(1, this.distance - 8))) && (flag = this.field_75039_c.func_72959_q().func_76940_a(i * 16 + 8, j * 16 + 8, 0, MapGenVillage.field_75055_e));
        }

        public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
            this.field_75039_c = worldIn;
            return MapGen.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.distance, (int)8, (int)10387312, (boolean)false, (int)100, (boolean)findUnexplored);
        }

        protected StructureStart func_75049_b(int chunkX, int chunkZ) {
            return new Start(this.field_75039_c, this.field_75038_b, this.provider, chunkX, chunkZ);
        }
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World worldIn, Random random, IChunkGenerator provider, int chunkX, int chunkZ) {
            this(worldIn, random, provider, chunkX, chunkZ, worldIn.func_180494_b(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8)));
        }

        public Start(World worldIn, Random random, IChunkGenerator provider, int chunkX, int chunkZ, Biome biomeIn) {
            super(chunkX, chunkZ);
            Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
            BlockPos pos = new BlockPos(chunkX * 16 + 8, 64, chunkZ * 16 + 8);
            this.field_75075_a.add(new ScatteredFeatureTF2Base(worldIn.func_72860_G().func_186340_h(), templateNames[random.nextInt(templateNames.length)], pos, rotation, worldIn));
            this.func_75072_c();
        }
    }
}

