/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.world.gen.structure;

import java.util.Random;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.template.TemplateManager;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.block.BlockUpgradeStation;
import rafradek.TF2weapons.entity.mercenary.EntitySaxtonHale;

public class MannCoBuilding
extends StructureComponent {
    private boolean haleSpawned;
    protected int averageGroundLvl = -1;

    public MannCoBuilding() {
    }

    public MannCoBuilding(int p5, Random random, StructureBoundingBox structureboundingbox, EnumFacing facing) {
        super(p5);
        this.func_186164_a(facing);
        this.field_74887_e = structureboundingbox;
    }

    protected void func_143012_a(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("HPos", this.averageGroundLvl);
        tagCompound.func_74757_a("HS", this.haleSpawned);
    }

    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
        this.averageGroundLvl = tagCompound.func_74762_e("HPos");
        this.haleSpawned = tagCompound.func_74767_n("HS");
    }

    public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
        if (this.averageGroundLvl < 0) {
            this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
            if (this.averageGroundLvl < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 15, 0);
        }
        IBlockState stone = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE_SMOOTH);
        IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
        IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
        IBlockState wood = this.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P());
        IBlockState upgradeStation = this.getBiomeSpecificBlockState(TF2weapons.blockUpgradeStation.func_176223_P().func_177226_a((IProperty)BlockUpgradeStation.HOLDER, (Comparable)Boolean.valueOf(false)));
        IBlockState upgradeStationHolder = this.getBiomeSpecificBlockState(TF2weapons.blockUpgradeStation.func_176223_P().func_177226_a((IProperty)BlockUpgradeStation.HOLDER, (Comparable)Boolean.valueOf(true)));
        IBlockState iblockstate5 = this.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176223_P());
        IBlockState iblockstate6 = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
        this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 13, 16, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 2, 13, 15, 10, stone, Blocks.field_150350_a.func_176223_P(), false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 3, 12, 0, 9, wood, wood, false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 3, 12, 4, 9, stone, stone, false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 3, 0, 3, 9, Blocks.field_150410_aZ.func_176223_P(), Blocks.field_150410_aZ.func_176223_P(), false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 13, 2, 3, 13, 3, 9, Blocks.field_150410_aZ.func_176223_P(), Blocks.field_150410_aZ.func_176223_P(), false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 2, 12, 3, 2, Blocks.field_150410_aZ.func_176223_P(), Blocks.field_150410_aZ.func_176223_P(), false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 10, 12, 3, 10, Blocks.field_150410_aZ.func_176223_P(), Blocks.field_150410_aZ.func_176223_P(), false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 0, 2, 8, 3, 2, wood, wood, false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 1, 2, 7, 2, 2, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 0, 1, 7, 0, 1, iblockstate2, iblockstate2, false);
        this.func_175811_a(worldIn, Blocks.field_150426_aN.func_176223_P(), 7, 4, 6, structureBoundingBoxIn);
        this.func_175811_a(worldIn, Blocks.field_150426_aN.func_176223_P(), 4, 4, 6, structureBoundingBoxIn);
        this.func_175811_a(worldIn, Blocks.field_150426_aN.func_176223_P(), 10, 4, 6, structureBoundingBoxIn);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 5, 1, 2, 7, upgradeStation.func_177226_a((IProperty)BlockUpgradeStation.FACING, (Comparable)EnumFacing.EAST), upgradeStation.func_177226_a((IProperty)BlockUpgradeStation.FACING, (Comparable)EnumFacing.WEST), false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 1, 5, 12, 2, 7, upgradeStation.func_177226_a((IProperty)BlockUpgradeStation.FACING, (Comparable)EnumFacing.WEST), upgradeStation.func_177226_a((IProperty)BlockUpgradeStation.FACING, (Comparable)EnumFacing.EAST), false);
        this.func_175811_a(worldIn, upgradeStationHolder.func_177226_a((IProperty)BlockUpgradeStation.FACING, (Comparable)EnumFacing.EAST), 1, 1, 6, structureBoundingBoxIn);
        this.func_175811_a(worldIn, upgradeStationHolder.func_177226_a((IProperty)BlockUpgradeStation.FACING, (Comparable)EnumFacing.WEST), 12, 1, 6, structureBoundingBoxIn);
        for (int k = 0; k < 10; ++k) {
            for (int j = 0; j < 13; ++j) {
                this.func_74871_b(worldIn, j, 17, k, structureBoundingBoxIn);
                this.func_175808_b(worldIn, stone, j, -1, k, structureBoundingBoxIn);
            }
        }
        if (!this.haleSpawned) {
            EntitySaxtonHale shopkeeper = new EntitySaxtonHale(worldIn);
            shopkeeper.func_70012_b(this.func_74865_a(7, 5), this.func_74862_a(1), this.func_74873_b(7, 5), 0.0f, 0.0f);
            shopkeeper.func_110163_bv();
            this.haleSpawned = true;
            worldIn.func_72838_d((Entity)shopkeeper);
        }
        return true;
    }

    protected IBlockState getBiomeSpecificBlockState(IBlockState blockstateIn) {
        return blockstateIn;
    }

    protected int getAverageGroundLevel(World worldIn, StructureBoundingBox structurebb) {
        int i = 0;
        int j = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
            for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                blockpos$mutableblockpos.func_181079_c(l, 64, k);
                if (!structurebb.func_175898_b((Vec3i)blockpos$mutableblockpos)) continue;
                i += Math.max(worldIn.func_175672_r((BlockPos)blockpos$mutableblockpos).func_177956_o(), worldIn.field_73011_w.func_76557_i() - 1);
                ++j;
            }
        }
        if (j == 0) {
            return -1;
        }
        return i / j;
    }

    public static class MapGen
    extends MapGenStructure {
        private int distance = TF2ConfigVars.mannCoChance;

        public String func_143025_a() {
            return "MannCoBuild";
        }

        protected boolean func_75047_a(int chunkX, int chunkZ) {
            boolean flag;
            int i = chunkX;
            int j = chunkZ;
            if (chunkX < 0) {
                chunkX -= this.distance - 1;
            }
            if (chunkZ < 0) {
                chunkZ -= this.distance - 1;
            }
            int k = chunkX / this.distance;
            int l = chunkZ / this.distance;
            Random random = this.field_75039_c.func_72843_D(k, l, 4234124);
            k *= this.distance;
            l *= this.distance;
            return i == (k += random.nextInt(Math.max(1, this.distance - 8))) && j == (l += random.nextInt(Math.max(1, this.distance - 8))) && (flag = this.field_75039_c.func_72959_q().func_76940_a(i * 16 + 8, j * 16 + 8, 0, MapGenVillage.field_75055_e));
        }

        public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
            this.field_75039_c = worldIn;
            return MapGen.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.distance, (int)8, (int)10387312, (boolean)false, (int)100, (boolean)findUnexplored);
        }

        protected StructureStart func_75049_b(int chunkX, int chunkZ) {
            return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
        }
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World worldIn, Random random, int chunkX, int chunkZ) {
            this(worldIn, random, chunkX, chunkZ, worldIn.func_180494_b(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8)));
        }

        public Start(World worldIn, Random random, int chunkX, int chunkZ, Biome biomeIn) {
            super(chunkX, chunkZ);
            EnumFacing facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(random);
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)(chunkX * 16), (int)64, (int)(chunkZ * 16), (int)0, (int)0, (int)0, (int)14, (int)16, (int)11, (EnumFacing)facing);
            this.field_75075_a.add(new MannCoBuilding(0, random, structureboundingbox, facing));
            this.func_75072_c();
        }
    }
}

