/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.logging.log4j.Level;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemKillstreakKit;
import rafradek.TF2weapons.util.PropertyType;

public class WeaponData
implements ICapabilityProvider {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(WeaponData.class, (Object)new Serializer()).create();
    private static String nameItemLoaded;
    public static PropertyType<?>[] propertyTypes;
    public static Map<String, JsonDeserializer<ICapabilityProvider>> propertyDeserializers;
    public HashMap<PropertyType<?>, Object> properties = new HashMap();
    public CapabilityDispatcher capabilities;
    public int maxCrateValue;
    private String name;

    public WeaponData() {
    }

    public WeaponData(String name) {
        this();
        this.name = name;
    }

    public void addCapabilities(Map<ResourceLocation, ICapabilityProvider> map) {
        this.capabilities = new CapabilityDispatcher(map);
    }

    public int getInt(PropertyType<Integer> propType) {
        Integer property = (Integer)this.properties.get(propType);
        if (property != null) {
            return property;
        }
        return 0;
    }

    public String getString(PropertyType<String> propType) {
        String property = (String)this.properties.get(propType);
        if (property != null) {
            return property;
        }
        return "";
    }

    public boolean getBoolean(PropertyType<Boolean> propType) {
        Boolean property = (Boolean)this.properties.get(propType);
        if (property != null) {
            return property;
        }
        return false;
    }

    public float getFloat(PropertyType<Float> propType) {
        Float property = (Float)this.properties.get(propType);
        if (property != null) {
            return property.floatValue();
        }
        return 0.0f;
    }

    public <A> A get(PropertyType<A> propType) {
        Object property = this.properties.get(propType);
        if (property != null) {
            return (A)property;
        }
        return propType.getDefaultValue();
    }

    public <A> A get(PropertyType<A> propType, A def) {
        Object property = this.properties.get(propType);
        if (property != null) {
            return (A)property;
        }
        return def;
    }

    public boolean hasProperty(PropertyType<?> property) {
        return this.properties.containsKey(property);
    }

    public void addProperty(String name, JsonElement element, JsonDeserializationContext context) {
        PropertyType<?> propType = MapList.propertyTypes.get(name);
        try {
            this.properties.put(propType, propType.deserialize(element, propType.type, context));
        }
        catch (Exception e) {
            TF2weapons.LOGGER.error("Error reading property {} for {}, value is {}", (Object)name, (Object)nameItemLoaded, (Object)element.toString());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static ArrayList<WeaponData> parseFile(String fileData, String filename) {
        ArrayList<WeaponData> list = new ArrayList<WeaponData>();
        try {
            String s = fileData;
            JsonObject tree = new JsonParser().parse(s).getAsJsonObject();
            for (Map.Entry entry : tree.getAsJsonObject().entrySet()) {
                nameItemLoaded = (String)entry.getKey();
                WeaponData data = (WeaponData)GSON.fromJson((JsonElement)entry.getValue(), WeaponData.class);
                data.name = (String)entry.getKey();
                list.add(data);
            }
        }
        catch (Exception e) {
            TF2weapons.LOGGER.error("Skipped reading weapon data from file: {}", (Object)filename);
            TF2weapons.LOGGER.catching(Level.ERROR, (Throwable)e);
        }
        return list;
    }

    public static WeaponDataCapability getCapability(ItemStack stack) {
        return (WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.capabilities.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)this.capabilities.getCapability(capability, facing);
    }

    static {
        propertyTypes = new PropertyType[256];
    }

    public static class WeaponDataCapability
    implements ICapabilityProvider {
        public WeaponData inst = ItemFromData.BLANK_DATA;
        public HashMap<String, Float> cachedAttrMult = new HashMap();
        public HashMap<String, Float> cachedAttrAdd = new HashMap();
        public boolean cached = false;
        public int active;
        public int usedClass = -1;
        public int fire1Cool = 0;
        public int fire2Cool = 0;
        public int clip = 0;

        public float getAttributeValue(ItemStack stack, String nameattr, float initial) {
            if (!this.cached) {
                TF2Attribute attribute;
                NBTBase tag;
                this.cachedAttrMult.clear();
                this.cachedAttrAdd.clear();
                NBTTagCompound attributelist = MapList.buildInAttributes.get(ItemFromData.getData(stack).getName());
                if (attributelist != null) {
                    for (String name : attributelist.func_150296_c()) {
                        tag = attributelist.func_74781_a(name);
                        if (!(tag instanceof NBTTagFloat)) continue;
                        attribute = TF2Attribute.attributes[Integer.parseInt(name)];
                        if (attribute.typeOfValue == TF2Attribute.Type.ADDITIVE) {
                            if (!this.cachedAttrAdd.containsKey(attribute.effect)) {
                                this.cachedAttrAdd.put(attribute.effect, Float.valueOf(0.0f));
                            }
                            this.cachedAttrAdd.put(attribute.effect, Float.valueOf(this.cachedAttrAdd.get(attribute.effect).floatValue() + ((NBTTagFloat)tag).func_150288_h()));
                            continue;
                        }
                        if (!this.cachedAttrMult.containsKey(attribute.effect)) {
                            this.cachedAttrMult.put(attribute.effect, Float.valueOf(1.0f));
                        }
                        this.cachedAttrMult.put(attribute.effect, Float.valueOf(this.cachedAttrMult.get(attribute.effect).floatValue() * ((NBTTagFloat)tag).func_150288_h()));
                    }
                }
                if (stack.func_77942_o()) {
                    attributelist = stack.func_77978_p().func_74775_l("Attributes");
                    for (String name : attributelist.func_150296_c()) {
                        tag = attributelist.func_74781_a(name);
                        if (!(tag instanceof NBTTagFloat)) continue;
                        attribute = TF2Attribute.attributes[Integer.parseInt(name)];
                        if (attribute.typeOfValue == TF2Attribute.Type.ADDITIVE) {
                            if (!this.cachedAttrAdd.containsKey(attribute.effect)) {
                                this.cachedAttrAdd.put(attribute.effect, Float.valueOf(0.0f));
                            }
                            this.cachedAttrAdd.put(attribute.effect, Float.valueOf(this.cachedAttrAdd.get(attribute.effect).floatValue() + ((NBTTagFloat)tag).func_150288_h()));
                            continue;
                        }
                        if (!this.cachedAttrMult.containsKey(attribute.effect)) {
                            this.cachedAttrMult.put(attribute.effect, Float.valueOf(1.0f));
                        }
                        this.cachedAttrMult.put(attribute.effect, Float.valueOf(this.cachedAttrMult.get(attribute.effect).floatValue() * ((NBTTagFloat)tag).func_150288_h()));
                    }
                    if (stack.func_77978_p().func_74764_b("StrAtt")) {
                        TF2Attribute attribute2 = TF2Attribute.attributes[stack.func_77978_p().func_74765_d("StrAtt")];
                        float value = ItemKillstreakKit.getKillstreakBonus(attribute2, stack.func_77978_p().func_74771_c("StrLev"), stack.func_77978_p().func_74762_e("StrKil"), this.inst);
                        if (attribute2.typeOfValue == TF2Attribute.Type.ADDITIVE) {
                            if (!this.cachedAttrAdd.containsKey(attribute2.effect)) {
                                this.cachedAttrAdd.put(attribute2.effect, Float.valueOf(0.0f));
                            }
                            this.cachedAttrAdd.put(attribute2.effect, Float.valueOf(this.cachedAttrAdd.get(attribute2.effect).floatValue() + value));
                        } else {
                            if (!this.cachedAttrMult.containsKey(attribute2.effect)) {
                                this.cachedAttrMult.put(attribute2.effect, Float.valueOf(1.0f));
                            }
                            if (value > attribute2.defaultValue) {
                                this.cachedAttrMult.put(attribute2.effect, Float.valueOf(this.cachedAttrMult.get(attribute2.effect).floatValue() + value - attribute2.defaultValue));
                            } else {
                                this.cachedAttrMult.put(attribute2.effect, Float.valueOf(this.cachedAttrMult.get(attribute2.effect).floatValue() * value));
                            }
                        }
                    }
                }
                this.cached = true;
            }
            Float valueadd = this.cachedAttrAdd.get(nameattr);
            Float valuemult = this.cachedAttrMult.get(nameattr);
            if (valueadd == null) {
                valueadd = Float.valueOf(0.0f);
            }
            if (valuemult == null) {
                valuemult = Float.valueOf(1.0f);
            }
            return (initial + valueadd.floatValue()) * valuemult.floatValue();
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return TF2weapons.WEAPONS_DATA_CAP != null && capability == TF2weapons.WEAPONS_DATA_CAP;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (TF2weapons.WEAPONS_DATA_CAP != null && capability == TF2weapons.WEAPONS_DATA_CAP) {
                return (T)TF2weapons.WEAPONS_DATA_CAP.cast((Object)this);
            }
            return null;
        }
    }

    public static abstract class SpecialProperty
    implements ICapabilityProvider {
        public abstract void serialize(DataOutput var1, WeaponData var2) throws IOException;

        public abstract void deserialize(DataInput var1, WeaponData var2) throws IOException;
    }

    public static class Serializer
    implements JsonDeserializer<WeaponData> {
        public WeaponData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            WeaponData data = new WeaponData();
            for (Map.Entry property : json.getAsJsonObject().entrySet()) {
                data.addProperty((String)property.getKey(), (JsonElement)property.getValue(), context);
            }
            return data;
        }
    }
}

