/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2EventsCommon;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.TF2EventsClient;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.client.particle.EnumTF2Particles;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.EntityStatue;
import rafradek.TF2weapons.entity.IEntityTF2;
import rafradek.TF2weapons.entity.boss.EntityMerasmus;
import rafradek.TF2weapons.entity.boss.EntityMonoculus;
import rafradek.TF2weapons.entity.boss.EntityTF2Boss;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.building.EntityDispenser;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.entity.projectile.EntityProjectileBase;
import rafradek.TF2weapons.inventory.InventoryWearables;
import rafradek.TF2weapons.item.ItemAmmo;
import rafradek.TF2weapons.item.ItemBackpack;
import rafradek.TF2weapons.item.ItemFireAmmo;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemMeleeWeapon;
import rafradek.TF2weapons.item.ItemMoney;
import rafradek.TF2weapons.item.ItemSniperRifle;
import rafradek.TF2weapons.item.ItemToken;
import rafradek.TF2weapons.item.ItemUsable;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.util.DamageSourceDirect;
import rafradek.TF2weapons.util.DamageSourceProjectile;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.ReflectionAccess;
import rafradek.TF2weapons.util.TF2DamageSource;
import rafradek.TF2weapons.util.TF2Explosion;
import rafradek.TF2weapons.util.WeaponData;

public class TF2Util {
    public static final UUID FOLLOW_MODIFIER;
    public static final Block[] NATURAL_BLOCKS;
    public static final Predicate<Entity> TARGETABLE;
    public static int[] colorCode;
    public static final float[] ASIN_VALUES;

    public static List<RayTraceResult> pierce(World world, Entity living, double startX, double startY, double startZ, double endX, double endY, double endZ, boolean headshot, float size, boolean pierce, Predicate<Entity> selector) {
        ArrayList<RayTraceResult> targets = new ArrayList<RayTraceResult>();
        Vec3d var3 = new Vec3d(endX, endY, endZ);
        Vec3d var17 = new Vec3d(startX, startY, startZ);
        boolean split = var3.func_178788_d(var17).func_189985_c() > 16384.0;
        Vec3d mid = new Vec3d((startX + endX) / 2.0, (startY + endY) / 2.0, (startZ + endZ) / 2.0);
        RayTraceResult var4 = world.func_147447_a(var17, var3, false, true, false);
        var3 = var4 != null ? new Vec3d(var4.field_72307_f.field_72450_a, var4.field_72307_f.field_72448_b, var4.field_72307_f.field_72449_c) : new Vec3d(endX, endY, endZ);
        Entity var5 = null;
        Iterable var6 = var3.func_178788_d(var17).func_189985_c() > 16384.0 ? Iterables.concat((Iterable)living.field_70170_p.func_72839_b(living, new AxisAlignedBB(startX, startY, startZ, mid.field_72450_a, mid.field_72448_b, mid.field_72449_c).func_72314_b(2.0, 2.0, 2.0)), (Iterable)living.field_70170_p.func_72839_b(living, new AxisAlignedBB(mid.field_72450_a, mid.field_72448_b, mid.field_72449_c, endX, endY, endZ).func_72314_b(2.0, 2.0, 2.0))) : living.field_70170_p.func_72839_b(living, new AxisAlignedBB(startX, startY, startZ, endX, endY, endZ).func_72314_b(2.0, 2.0, 2.0));
        double var7 = 0.0;
        RayTraceResult collideVec = new RayTraceResult((Entity)null, null);
        for (Entity target : var6) {
            AxisAlignedBB var12;
            RayTraceResult var13;
            if (!selector.apply((Object)target)) continue;
            AxisAlignedBB oldBB = target.func_174813_aQ();
            if (world.field_72995_K && TF2EventsClient.moveEntities) {
                float ticktime = TF2EventsClient.tickTime;
                target.func_174826_a(target.func_174813_aQ().func_72317_d((target.field_70169_q - target.field_70165_t) * (double)(1.0f - ticktime), (target.field_70167_r - target.field_70163_u) * (double)(1.0f - ticktime), (target.field_70166_s - target.field_70161_v) * (double)(1.0f - ticktime)));
            }
            if ((var13 = (var12 = target.func_174813_aQ().func_72314_b((double)size, (double)size, (double)size)).func_72327_a(var17, var3)) == null && var12.func_72318_a(var3)) {
                var13 = new RayTraceResult(var3, EnumFacing.EAST);
            }
            if (var13 != null) {
                double var14 = var17.func_72436_e(var13.field_72307_f);
                if (!pierce && (var14 < var7 || var7 == 0.0)) {
                    var5 = target;
                    var7 = var14;
                    collideVec = var13;
                } else if (pierce) {
                    targets.add(TF2Util.getTraceResult(target, var13, size, headshot, var17, var3));
                }
            }
            target.func_174826_a(oldBB);
        }
        if (!(pierce || var5 == null || var5 instanceof EntityLivingBase && ((EntityLivingBase)var5).func_110143_aJ() <= 0.0f)) {
            targets.add(TF2Util.getTraceResult(var5, collideVec, size, headshot, var17, var3));
        }
        if ((pierce || targets.isEmpty()) && var4 != null && var4.field_72313_a == RayTraceResult.Type.BLOCK) {
            targets.add(var4);
        } else if (targets.isEmpty()) {
            targets.add(new RayTraceResult(RayTraceResult.Type.MISS, var3, null, null));
        }
        return targets;
    }

    public static List<RayTraceResult> pierce(World world, Entity living, double startX, double startY, double startZ, double endX, double endY, double endZ, boolean headshot, float size, boolean pierce) {
        return TF2Util.pierce(world, living, startX, startY, startZ, endX, endY, endZ, headshot, size, pierce, TARGETABLE);
    }

    public static List<RayTraceResult> pierce(World world, Entity living, double length, boolean headshot, float size, boolean pierce) {
        Vec3d look = living.func_70040_Z().func_186678_a(length);
        return TF2Util.pierce(world, living, living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v, living.field_70165_t + look.field_72450_a, living.field_70163_u + (double)living.func_70047_e() + look.field_72448_b, living.field_70161_v + look.field_72449_c, headshot, size, pierce, TARGETABLE);
    }

    public static RayTraceResult getTraceResult(Entity target, RayTraceResult hitVec, float size, boolean headshot, Vec3d start, Vec3d end) {
        RayTraceResult result = new RayTraceResult(target, hitVec.field_72307_f);
        if (headshot && target instanceof EntityLivingBase && (!(target instanceof IEntityTF2) || ((IEntityTF2)target).hasHead())) {
            Boolean var13 = TF2Util.getHead((EntityLivingBase)target).func_72327_a(start, end.func_178787_e(end.func_178788_d(start).func_72432_b())) != null;
            result.hitInfo = var13;
        }
        result.field_178784_b = hitVec.field_178784_b;
        return result;
    }

    public static AxisAlignedBB getHead(EntityLivingBase target) {
        AxisAlignedBB head;
        double ymax = target.field_70163_u + (double)target.func_70047_e();
        boolean custom = target instanceof IEntityTF2;
        if (!custom || (head = ((IEntityTF2)target).getHeadBox()) == null) {
            head = new AxisAlignedBB(target.field_70165_t - 0.25, ymax - 0.16, target.field_70161_v - 0.25, target.field_70165_t + 0.25, ymax + 0.25, target.field_70161_v + 0.25);
            if ((double)target.field_70130_N >= 0.63) {
                float offsetX = -MathHelper.func_76126_a((float)(target.field_70761_aq * ((float)Math.PI / 180))) * Math.max(0.0f, target.field_70130_N * 0.6f - 0.32f);
                float offsetZ = MathHelper.func_76134_b((float)(target.field_70761_aq * ((float)Math.PI / 180))) * Math.max(0.0f, target.field_70130_N * 0.6f - 0.32f);
                head = head.func_72317_d((double)offsetX, 0.0, (double)offsetZ);
            }
        }
        return head;
    }

    public static Vec3d radiusRandom2D(float radius, Random random) {
        float a = random.nextFloat();
        float b = random.nextFloat();
        return new Vec3d((double)(Math.max(a, b) * radius * MathHelper.func_76134_b((float)((float)(Math.PI * 2 * (double)Math.min(a, b) / (double)Math.max(a, b))))), (double)(Math.max(a, b) * radius * MathHelper.func_76126_a((float)((float)(Math.PI * 2 * (double)Math.min(a, b) / (double)Math.max(a, b))))), 0.0);
    }

    public static Vec3d radiusRandom2D(float radius, Random random, float yaw, float pitch, double dist) {
        float a = random.nextFloat();
        float b = random.nextFloat();
        double x = Math.max(a, b) * radius * MathHelper.func_76134_b((float)((float)(Math.PI * 2 * (double)Math.min(a, b) / (double)Math.max(a, b))));
        double y = Math.max(a, b) * radius * MathHelper.func_76126_a((float)((float)(Math.PI * 2 * (double)Math.min(a, b) / (double)Math.max(a, b))));
        double z = 1.0;
        float f = MathHelper.func_76134_b((float)yaw);
        float f1 = MathHelper.func_76126_a((float)yaw);
        float f2 = MathHelper.func_76134_b((float)pitch);
        float f3 = MathHelper.func_76126_a((float)pitch);
        double y1 = y * (double)f2 + z * (double)f3;
        double z1 = z * (double)f2 - y * (double)f3;
        double x1 = x * (double)f + z1 * (double)f1;
        double z2 = z1 * (double)f - x * (double)f1;
        return new Vec3d(x1 * dist, y1 * dist, z2 * dist);
    }

    public static boolean isUsingShield(Entity shielded, DamageSource source) {
        if (shielded instanceof EntityLivingBase && ((EntityLivingBase)shielded).func_184585_cz()) {
            Vec3d location = source.func_188404_v();
            if (location == null) {
                location = source.func_76364_f().func_174791_d();
            }
            if (location != null) {
                Vec3d vec3d1 = shielded.func_70676_i(1.0f);
                Vec3d vec3d2 = location.func_72444_a(shielded.func_174791_d()).func_72432_b();
                vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
                if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                    return true;
                }
            }
        }
        return false;
    }

    public static int calculateCritPost(Entity target, EntityLivingBase shooter, int initial, ItemStack stack) {
        if (initial > 0 && target instanceof EntityLivingBase && ((EntityLivingBase)target).func_70660_b(TF2weapons.backup) != null) {
            initial = 0;
        }
        if (initial == 0 && target instanceof EntityLivingBase && (((EntityLivingBase)target).func_70660_b(TF2weapons.markDeath) != null || ((EntityLivingBase)target).func_70660_b(TF2weapons.jarate) != null)) {
            initial = 1;
        }
        if (!(initial != 0 || stack.func_190926_b() || target.field_70122_E || target.func_70090_H() || TF2Attribute.getModifier("Minicrit Airborne", stack, 0.0f, shooter) == 0.0f || WeaponsCapability.get(target) != null && !WeaponsCapability.get(target).isExpJump())) {
            initial = 1;
        }
        if (initial == 0 && !stack.func_190926_b() && shooter != null) {
            float mindist = TF2Attribute.getModifier("Minicrit Distance", stack, 0.0f, shooter);
            if ((mindist *= mindist) != 0.0f && target.func_70068_e((Entity)shooter) >= (double)mindist) {
                initial = 1;
            }
        }
        if (initial == 0 && !stack.func_190926_b() && target.func_70027_ad() && TF2Attribute.getModifier("Crit Burn", stack, 0.0f, shooter) == 2.0f) {
            initial = 1;
        } else if (initial < 2 && !stack.func_190926_b() && target.func_70027_ad() && TF2Attribute.getModifier("Crit Burn", stack, 0.0f, shooter) == 1.0f) {
            initial = 2;
        }
        if (initial < 2 && !stack.func_190926_b() && target instanceof EntityLivingBase && ((EntityLivingBase)target).func_70660_b(TF2weapons.stun) != null && TF2Attribute.getModifier("Crit Stun", stack, 0.0f, shooter) != 0.0f) {
            initial = 2;
        }
        if (initial < 2 && !stack.func_190926_b() && shooter != null && shooter instanceof EntityPlayer && (((WeaponsCapability)shooter.getCapability(TF2weapons.WEAPONS_CAP, null)).isExpJump() || shooter.func_184613_cA()) && TF2Attribute.getModifier("Crit Rocket", stack, 0.0f, shooter) != 0.0f) {
            initial = 2;
        }
        if (initial == 1 && !stack.func_190926_b() && shooter != null && shooter instanceof EntityPlayer && TF2Attribute.getModifier("Crit Mini", stack, 0.0f, shooter) != 0.0f) {
            initial = 2;
        }
        if (target instanceof EntityBuilding && initial == 1) {
            initial = 0;
        }
        if (target instanceof EntityTF2Boss && initial == 1) {
            initial = 0;
        }
        if (target instanceof EntityMerasmus && ((EntityMerasmus)target).func_70660_b(TF2weapons.stun) != null) {
            initial = 2;
        }
        return initial;
    }

    public static float calculateDamage(Entity target, World world, EntityLivingBase living, ItemStack stack, int critical, float distance) {
        ItemWeapon weapon = (ItemWeapon)stack.func_77973_b();
        float calculateddamage = weapon.getWeaponDamage(stack, living, target);
        if (calculateddamage == 0.0f) {
            return 0.0f;
        }
        if (target == living) {
            return calculateddamage;
        }
        if (!(critical != 2 || target instanceof IEntityTF2 && ((IEntityTF2)target).isBuilding())) {
            calculateddamage *= 3.0f;
        } else if (critical == 1) {
            calculateddamage *= 1.35f;
        }
        if (target == TF2weapons.dummyEnt) {
            distance *= 0.5f;
        }
        float falloff = weapon.getWeaponDamageFalloff(stack);
        float falloffmax = weapon.getWeaponDamageFalloffMaxRange(stack, living);
        if (!(target instanceof IEntityTF2 && !((IEntityTF2)target).hasDamageFalloff() || !(falloff > 0.0f) || critical >= 2 && target != living)) {
            if (distance <= falloff) {
                calculateddamage *= TF2Util.lerp(weapon.getWeaponMaxDamage(stack, living), 1.0f, distance / falloff);
            } else if (critical == 0) {
                calculateddamage *= TF2Util.lerp(1.0f, weapon.getWeaponMinDamage(stack, living), Math.min(1.0f, (distance - falloff) / (falloffmax - falloff)));
            }
        }
        if (target instanceof EntityEnderman && !(stack.func_77973_b() instanceof ItemMeleeWeapon) && TF2Attribute.getModifier("Unblockable", stack, 0.0f, living) == 0.0f) {
            calculateddamage *= 0.4f;
        }
        return calculateddamage;
    }

    public static float lerp(float v0, float v1, float t) {
        return (1.0f - t) * v0 + t * v1;
    }

    public static float position(float v0, float v1, float lerp) {
        return (lerp - v1) * (1.0f / (v0 - v1));
    }

    public static boolean isOnSameTeam(Entity entity1, Entity entity2) {
        return entity2 != null && (TF2Util.getTeam(entity1) == TF2Util.getTeam(entity2) && TF2Util.getTeam(entity1) != null || entity1 instanceof IEntityOwnable && ((IEntityOwnable)entity1).func_70902_q() == entity2 || entity2 instanceof IEntityOwnable && ((IEntityOwnable)entity2).func_70902_q() == entity1 || entity1 == entity2);
    }

    public static Team getTeam(Entity living) {
        if (living == null) {
            return null;
        }
        if (!(living instanceof IThrowableEntity)) {
            return living.func_96124_cp();
        }
        return TF2Util.getTeam(((IThrowableEntity)living).getThrower());
    }

    public static int getTeamColor(Entity living) {
        return colorCode[living != null ? TF2Util.getTeamColorNumber(living) : 0];
    }

    public static int getTeamForDisplay(Entity living) {
        if (living instanceof EntityTF2Character) {
            return ((EntityTF2Character)living).getEntTeam();
        }
        if (living instanceof EntityBuilding) {
            return ((EntityBuilding)living).getEntTeam();
        }
        if (living instanceof EntityPlayer) {
            return ((EntityPlayer)living).func_96124_cp() == living.field_70170_p.func_96441_U().func_96508_e("BLU") ? 1 : 0;
        }
        if (living instanceof IThrowableEntity) {
            return TF2Util.getTeamForDisplay(((IThrowableEntity)living).getThrower());
        }
        return 0;
    }

    public static int getTeamColorNumber(Entity living) {
        if (living.func_70089_S() && TF2Util.getTeam(living) != null && TF2Util.getTeam(living).func_178775_l().func_175746_b() >= 0) {
            return TF2Util.getTeam(living).func_178775_l().func_175746_b();
        }
        return 7;
    }

    public static boolean canHit(EntityLivingBase shooter, Entity ent) {
        return ent.func_70089_S() && (!(ent instanceof EntityLivingBase) || !TF2Util.isOnSameTeam((Entity)shooter, ent) || shooter.func_96124_cp() != null && shooter.func_96124_cp().func_96665_g() || ent == shooter);
    }

    public static boolean lookingAt(EntityLivingBase entity, double max, double targetX, double targetY, double targetZ) {
        return TF2Util.isLyingInCone(new Vec3d(targetX, targetY, targetZ), entity.func_174824_e(1.0f), entity.func_174824_e(1.0f).func_178787_e(entity.func_70676_i(1.0f)), (float)Math.toRadians(max));
    }

    public static boolean lookingAt(EntityLivingBase entity, double max, Entity target) {
        return TF2Util.isLyingInCone(target.func_174824_e(1.0f), entity.func_174824_e(1.0f), entity.func_174824_e(1.0f).func_178787_e(entity.func_70676_i(1.0f)), (float)Math.toRadians(max));
    }

    public static boolean lookingAtFast(EntityLivingBase entity, double max, double targetX, double targetY, double targetZ) {
        double d0 = targetX - entity.field_70165_t;
        double d1 = targetY - (entity.field_70163_u + (double)entity.func_70047_e());
        double d2 = targetZ - entity.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 180.0 / Math.PI) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 180.0 / Math.PI));
        float compareyaw = Math.abs(180.0f - Math.abs(Math.abs(f - MathHelper.func_76142_g((float)entity.field_70759_as)) - 180.0f));
        float comparepitch = Math.abs(180.0f - Math.abs(Math.abs(f1 - entity.field_70125_A) - 180.0f));
        return (double)compareyaw < max && (double)comparepitch < max / 2.0;
    }

    public static boolean isLyingInCone(Vec3d x, Vec3d start, Vec3d end, float aperture) {
        Vec3d axisVect;
        float halfAperture = aperture / 2.0f;
        Vec3d apexToXVect = start.func_178788_d(x);
        boolean isInInfiniteCone = apexToXVect.func_72430_b(axisVect = start.func_178788_d(end)) / apexToXVect.func_72433_c() / axisVect.func_72433_c() > (double)MathHelper.func_76134_b((float)halfAperture);
        return isInInfiniteCone;
    }

    public static boolean dealDamage(Entity entity, World world, EntityLivingBase living, ItemStack stack, int critical, float damage, DamageSource source) {
        boolean invPeriod;
        boolean knockback;
        if (world.field_72995_K || damage == 0.0f) {
            return false;
        }
        if (TF2ConfigVars.batchDamage == 0) {
            entity.field_70172_ad = 0;
            if (entity instanceof MultiPartEntityPart && !(((MultiPartEntityPart)entity).field_70259_a instanceof EntityDragon)) {
                ((Entity)((MultiPartEntityPart)entity).field_70259_a).field_70172_ad = 0;
            }
        }
        if (entity instanceof EntityPlayer && !(living instanceof EntityPlayer) && !source.func_76350_n()) {
            damage = world.func_175659_aa() == EnumDifficulty.NORMAL ? (damage *= 0.7f) : (world.func_175659_aa() == EnumDifficulty.HARD ? (damage *= 0.9f) : (damage *= 0.45f));
        }
        damage *= TF2ConfigVars.damageMultiplier;
        if (entity == living && source instanceof TF2DamageSource && living instanceof EntityPlayer && living.func_96124_cp() != null) {
            ((TF2DamageSource)source).setAttackSelf();
        }
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemWeapon && ItemFromData.getData(stack).hasProperty(PropertyType.HIT_SOUND)) {
            ((ItemWeapon)stack.func_77973_b()).playHitSound(stack, living, entity);
        }
        if ((knockback = TF2Util.canHit(living, entity)) && TF2Util.isUsingShield(entity, source) && source.func_188404_v() == null && TF2Attribute.getModifier("Unblockable", stack, 0.0f, living) != 1.0f) {
            ((EntityLivingBase)entity).func_184607_cu().func_77972_a((int)(damage * (source.func_94541_c() ? 4.0f : 2.0f)), (EntityLivingBase)entity);
            damage *= source.func_94541_c() ? 0.3f : 0.45f;
        }
        boolean bl = invPeriod = (float)entity.field_70172_ad > (entity instanceof EntityLivingBase ? (float)((EntityLivingBase)entity).field_70771_an / 2.0f : 10.0f);
        if (TF2ConfigVars.batchDamage == 1 && ((TF2EventsCommon.TF2WorldStorage)world.getCapability(TF2weapons.WORLD_CAP, null)).damage.containsKey(entity)) {
            damage += ((TF2EventsCommon.TF2WorldStorage)world.getCapability(TF2weapons.WORLD_CAP, null)).damage.get((Object)entity).damage;
            ((TF2EventsCommon.TF2WorldStorage)world.getCapability(TF2weapons.WORLD_CAP, null)).damage.remove(entity);
        }
        if (knockback && (!invPeriod || TF2ConfigVars.batchDamage != 1)) {
            return TF2Util.dealDamageActual(entity, world, living, stack, critical, damage, source);
        }
        if (knockback && invPeriod && TF2ConfigVars.batchDamage == 1) {
            TF2EventsCommon.InboundDamage inbound = ((TF2EventsCommon.TF2WorldStorage)world.getCapability(TF2weapons.WORLD_CAP, null)).damage.get(entity);
            if (inbound != null) {
                damage += inbound.damage;
            }
            ((TF2EventsCommon.TF2WorldStorage)world.getCapability(TF2weapons.WORLD_CAP, null)).damage.put(entity, new TF2EventsCommon.InboundDamage(source, damage, critical, living, stack));
            return true;
        }
        return false;
    }

    public static boolean dealDamageActual(Entity entity, World world, EntityLivingBase living, ItemStack stack, int critical, float damage, DamageSource source) {
        float prehealth;
        double lvelocityX = entity.field_70159_w;
        double lvelocityY = entity.field_70181_x;
        double lvelocityZ = entity.field_70179_y;
        float f = prehealth = entity instanceof EntityLivingBase ? ((EntityLivingBase)entity).func_110143_aJ() + ((EntityLivingBase)entity).func_110139_bj() : 0.0f;
        if (entity.func_70097_a(source, damage)) {
            if (source instanceof TF2DamageSource && !((TF2DamageSource)source).getWeaponOrig().func_190926_b()) {
                stack = ((TF2DamageSource)source).getWeaponOrig();
            }
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemWeapon) {
                ((ItemWeapon)stack.func_77973_b()).onDealDamage(stack, living, entity, source, entity instanceof EntityLivingBase ? prehealth - (((EntityLivingBase)entity).func_110143_aJ() + ((EntityLivingBase)entity).func_110139_bj()) : 0.0f);
            }
            if (entity instanceof EntityLivingBase) {
                if (living instanceof EntityPlayer) {
                    TF2PlayerCapability.get((EntityPlayer)living).addLastDamage(damage, entity instanceof EntityPlayer);
                }
                EntityLivingBase livingTarget = (EntityLivingBase)entity;
                try {
                    if (living instanceof EntityTF2Character && ((EntityTF2Character)living).isSharing()) {
                        ReflectionAccess.entityRecentlyHit.setInt(entity, 100);
                        if (((EntityTF2Character)living).func_70902_q() != null) {
                            ReflectionAccess.entityAttackingPlayer.set(entity, ((EntityTF2Character)living).func_70902_q());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                livingTarget.field_70172_ad = 20;
                if (TF2Attribute.getModifier("Silent Kill", stack, 0.0f, living) == 0.0f) {
                    if (critical == 2) {
                        TF2Util.playSound(entity, TF2Sounds.MISC_CRIT, 1.5f, 1.2f / (world.field_73012_v.nextFloat() * 0.2f + 0.9f));
                    } else if (critical == 1) {
                        TF2Util.playSound(entity, TF2Sounds.MISC_MINI_CRIT, 1.5f, 1.2f / (world.field_73012_v.nextFloat() * 0.2f + 0.9f));
                    }
                    if (!(entity instanceof EntityBuilding)) {
                        TF2Util.playSound(entity, TF2Sounds.MISC_PAIN, 1.0f, 1.2f / (world.field_73012_v.nextFloat() * 0.2f + 0.9f));
                    }
                }
                livingTarget.field_70160_al = false;
                livingTarget.field_70159_w = lvelocityX;
                livingTarget.field_70181_x = lvelocityY;
                livingTarget.field_70179_y = lvelocityZ;
                livingTarget.field_70133_I = false;
            }
            return true;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemWeapon) {
            ((ItemWeapon)stack.func_77973_b()).onHitFinal(stack, living, entity, source);
        }
        return false;
    }

    public static float damageBlock(BlockPos pos, EntityLivingBase living, World world, ItemStack stack, int critical, float damage, Vec3d forwardVec, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos) || TF2ConfigVars.destTerrain == 0 || state.func_185887_b(world, pos) < 0.0f || !(living instanceof EntityPlayer) && !world.func_82736_K().func_82766_b("mobGriefing") || living instanceof EntityPlayer && !world.func_175660_a((EntityPlayer)living, pos)) {
            return 0.0f;
        }
        TF2EventsCommon.DestroyBlockEntry finalEntry = null;
        int entryId = 0;
        int emptyId = -1;
        TF2EventsCommon.TF2WorldStorage cap = (TF2EventsCommon.TF2WorldStorage)world.getCapability(TF2weapons.WORLD_CAP, null);
        for (int i = 0; i < cap.destroyProgress.size(); ++i) {
            TF2EventsCommon.DestroyBlockEntry entry = cap.destroyProgress.get(i);
            if (emptyId == -1 && entry == null) {
                emptyId = i;
            }
            if (entry == null || entry.world != world || !entry.pos.equals((Object)pos)) continue;
            finalEntry = entry;
            entryId = i;
            break;
        }
        if (finalEntry == null) {
            finalEntry = new TF2EventsCommon.DestroyBlockEntry(pos, world);
            if (emptyId != -1) {
                cap.destroyProgress.set(emptyId, finalEntry);
                entryId = emptyId;
            } else {
                cap.destroyProgress.add(finalEntry);
                entryId = cap.destroyProgress.size() - 1;
            }
        }
        float hardness = TF2Util.getHardness(state, world, pos);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemSniperRifle && hardness > 100.0f) {
            damage *= 3.0f;
        }
        finalEntry.curDamage += damage;
        if (living != null) {
            world.func_175715_c(Math.min(Integer.MAX_VALUE, 65535 + entryId), pos, (int)(finalEntry.curDamage / hardness * 10.0f));
        }
        if (finalEntry.curDamage >= hardness) {
            boolean flag;
            if (living != null && living instanceof EntityPlayer) {
                block.func_180657_a(world, (EntityPlayer)living, pos, state, null, stack);
            } else {
                block.func_176226_b(world, pos, state, (int)TF2Attribute.getModifier("Looting", stack, 0.0f, living));
                block.onBlockExploded(world, pos, explosion);
            }
            cap.destroyProgress.remove(finalEntry);
            boolean bl = flag = living == null || !(living instanceof EntityPlayer) && world.func_175623_d(pos) || block.removedByPlayer(state, world, pos, (EntityPlayer)living, true);
            if (flag) {
                RayTraceResult trace;
                if (living != null) {
                    world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                    world.func_175715_c(Math.min(Integer.MAX_VALUE, 65535 + entryId), pos, -1);
                }
                block.func_176206_d(world, pos, state);
                if (forwardVec != null && (trace = world.func_147447_a(living.func_174791_d().func_72441_c(0.0, (double)living.func_70047_e(), 0.0), forwardVec, false, true, false)) != null) {
                    TF2Util.damageBlock(trace.func_178782_a(), living, world, stack, critical, finalEntry.curDamage - hardness, forwardVec, explosion);
                }
            }
            return finalEntry.curDamage - hardness;
        }
        return 0.0f;
    }

    public static float getHardness(IBlockState state, World world, BlockPos pos) {
        return state.func_185887_b(world, pos) * (!state.func_185904_a().func_76229_l() && !(state.func_177230_c() instanceof BlockStone) ? 12.0f : 5.5f);
    }

    public static int getExperiencePoints(EntityPlayer player) {
        InventoryWearables wearables = (InventoryWearables)((Object)player.getCapability(TF2weapons.INVENTORY_CAP, null));
        int totalMoney = 0;
        for (int i = 5; i < 8; ++i) {
            ItemStack stack = wearables.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemMoney)) continue;
            totalMoney += ((ItemMoney)stack.func_77973_b()).getValue(wearables.func_70301_a(i));
        }
        return totalMoney;
    }

    public static void setExperiencePoints(EntityPlayer player, int amount) {
        InventoryWearables wearables = (InventoryWearables)((Object)player.getCapability(TF2weapons.INVENTORY_CAP, null));
        int big = amount / 81;
        if (big > 64) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(TF2weapons.itemMoney, big - 64, 2));
        }
        int medium = amount % 81 / 9;
        int small = amount % 9;
        wearables.func_70299_a(5, new ItemStack(TF2weapons.itemMoney, small, 0));
        wearables.func_70299_a(6, new ItemStack(TF2weapons.itemMoney, medium, 1));
        wearables.func_70299_a(7, new ItemStack(TF2weapons.itemMoney, big, 2));
    }

    public static double getDistanceSqBox(Entity target, double x, double y, double z, double widthO, double heightO) {
        double xdiff = target.field_70165_t - x;
        double ydiff = target.field_70163_u + (double)(target.field_70131_O / 2.0f) - y - heightO / 2.0;
        double zdiff = target.field_70161_v - z;
        double widthCom = ((double)target.field_70130_N + widthO) / 2.0;
        double heightCom = ((double)target.field_70131_O + heightO) / 2.0;
        if (Math.abs(xdiff) - widthCom < 0.0) {
            xdiff = 0.0;
        } else {
            double d = xdiff = xdiff > 0.0 ? xdiff - widthCom : xdiff + widthCom;
        }
        if (Math.abs(zdiff) - widthCom < 0.0) {
            zdiff = 0.0;
        } else {
            double d = zdiff = zdiff > 0.0 ? zdiff - widthCom : zdiff + widthCom;
        }
        ydiff = Math.abs(ydiff) - heightCom < 0.0 ? 0.0 : (ydiff > 0.0 ? ydiff - (double)(target.field_70131_O / 2.0f) : ydiff + (double)(target.field_70131_O / 2.0f));
        return xdiff * xdiff + zdiff * zdiff + ydiff * ydiff;
    }

    public static double getDistanceBox(Entity target, double x, double y, double z, double widthO, double heightO) {
        return Math.sqrt(TF2Util.getDistanceSqBox(target, x, y, z, widthO, heightO));
    }

    public static boolean canInteract(EntityLivingBase entity) {
        return (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_175149_v()) && entity.func_70660_b(TF2weapons.stun) == null && (!entity.hasCapability(TF2weapons.WEAPONS_CAP, null) || WeaponsCapability.get((Entity)entity).invisTicks == 0 && !WeaponsCapability.get((Entity)entity).isFeign()) && entity.func_70660_b(TF2weapons.bonk) == null;
    }

    public static void explosion(World world, EntityLivingBase shooter, ItemStack weapon, Entity exploder, Entity direct, double x, double y, double z, float size, float damageMult, int critical, float distance) {
        float blockDmg = TF2Attribute.getModifier("Destroy Block", weapon, 0.0f, shooter) * TF2Util.calculateDamage((Entity)TF2weapons.dummyEnt, world, shooter, weapon, critical, distance);
        if (blockDmg > 0.0f && TF2Attribute.getModifier("Onyx Projectile", weapon, 0.0f, shooter) != 0.0f) {
            blockDmg *= TF2Attribute.getModifier("Onyx Projectile", weapon, 0.0f, shooter);
        }
        SoundEvent sound = exploder instanceof EntityProjectileBase ? ((EntityProjectileBase)exploder).getExplosionSound() : ItemFromData.getSound(weapon, PropertyType.EXPLOSION_SOUND);
        TF2Explosion explosion = new TF2Explosion(world, exploder, x, y, z, size, direct, blockDmg, 1.0f, sound);
        explosion.isFlaming = false;
        explosion.isSmoking = true;
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        boolean killedInRow = false;
        for (Map.Entry<Entity, Float> entry : explosion.affectedEntities.entrySet()) {
            boolean fromSentry;
            Entity ent = entry.getKey();
            int criticalloc = critical;
            if (exploder instanceof EntityProjectileBase) {
                if (((EntityProjectileBase)exploder).hitEntities.contains(ent)) {
                    criticalloc = Math.max(criticalloc, 1);
                    TF2Util.playSound(ent, TF2Sounds.DOUBLE_DONK, 3.0f, 1.0f);
                    entry.setValue(Float.valueOf(1.0f));
                }
                distance = ((EntityProjectileBase)exploder).getDistanceToTarget(ent, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
            } else {
                distance = (float)TF2Util.getDistanceBox((Entity)shooter, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, (double)ent.field_70130_N + 0.1, (double)ent.field_70131_O + 0.1);
            }
            criticalloc = TF2Util.calculateCritPost(ent, shooter, criticalloc, weapon);
            float dmg = TF2Util.calculateDamage(ent, world, shooter, weapon, criticalloc, distance) * damageMult;
            Vec3d vec = explosion.getKnockbackMap().get(ent);
            if (vec != null) {
                boolean expJump = ent == shooter;
                double scale = dmg;
                if (expJump) {
                    String used = TF2Util.getWeaponUsedByClass(weapon);
                    if (used != null) {
                        scale *= ItemToken.EXPLOSION_VALUES[ItemToken.getClassID(used)];
                    }
                } else if (ent instanceof EntityLivingBase) {
                    scale *= 1.0 - ((EntityLivingBase)ent).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
                }
                scale = Math.min(7.5, scale);
                if (expJump) {
                    scale = TF2Attribute.getModifier("Self Push Force", weapon, (float)scale, shooter);
                }
                vec = vec.func_186678_a(scale * (double)TF2ConfigVars.explosionKnockback);
                if (ent.field_70181_x != 0.0) {
                    ent.field_70143_R = (float)Math.max(0.0, (double)ent.field_70143_R * ((ent.field_70181_x + vec.field_72448_b) / ent.field_70181_x));
                }
                if (vec.field_72448_b > 0.0) {
                    ent.field_70122_E = false;
                    if (!expJump) {
                        ent.field_70143_R = (float)((double)ent.field_70143_R - (vec.field_72448_b * 3.0 - 1.0));
                    }
                }
                ent.func_70024_g(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                explosion.getKnockbackMap().put(ent, vec);
            }
            if (ent == shooter) {
                dmg = TF2Attribute.getModifier("Self Damage", weapon, dmg, shooter);
                if (shooter.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() == TF2weapons.itemGunboats) {
                    dmg *= 0.4f;
                }
            }
            boolean bl = fromSentry = exploder instanceof EntityProjectileBase && ((EntityProjectileBase)exploder).sentry != null && ent instanceof EntityLivingBase;
            DamageSource source = TF2Attribute.getModifier("Unblockable", weapon, 0.0f, shooter) == 1.0f ? TF2Util.causeDirectDamage(weapon, (Entity)shooter, criticalloc) : TF2Util.causeBulletDamage(weapon, (Entity)shooter, criticalloc, (Entity)(fromSentry ? ((EntityProjectileBase)exploder).sentry : exploder));
            if (fromSentry && ((EntityProjectileBase)exploder).sentry.fromPDA) {
                ((TF2DamageSource)source).addAttackFlag(4);
            }
            TF2Util.dealDamage(ent, world, shooter, weapon, criticalloc, entry.getValue().floatValue() * dmg, source.func_94540_d());
            if (ent.hasCapability(TF2weapons.WEAPONS_CAP, null)) {
                ((WeaponsCapability)ent.getCapability(TF2weapons.WEAPONS_CAP, null)).setExpJump(true);
            }
            if (!fromSentry) continue;
            EntitySentry sentry = ((EntityProjectileBase)exploder).sentry;
            ((EntityLivingBase)ent).func_130011_c((Entity)sentry);
            ((EntityLivingBase)ent).func_70604_c((EntityLivingBase)sentry);
            if (ent.func_70089_S()) continue;
            sentry.scoreKill((EntityLivingBase)ent);
        }
        for (EntityPlayer entityplayer : world.field_73010_i) {
            if (!(entityplayer.func_70092_e(x, y, z) < 4096.0) || !explosion.getKnockbackMap().containsKey(entityplayer)) continue;
            TF2weapons.network.sendTo(new TF2Message.VelocityAddMessage(explosion.getKnockbackMap().get(entityplayer), true), (EntityPlayerMP)entityplayer);
        }
    }

    public static int calculateCritPre(ItemStack stack, EntityLivingBase living) {
        ItemWeapon item;
        int thisCritical = 0;
        WeaponsCapability cap = (WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null);
        if (living.func_70660_b(TF2weapons.crit) != null || living.func_70660_b(TF2weapons.buffbanner) != null) {
            thisCritical = 1;
        }
        if (thisCritical == 0 && (cap.focusedShot(stack) || cap.focusShotRemaining > 0)) {
            thisCritical = 1;
        }
        if (thisCritical == 0 && !living.field_70122_E && TF2Attribute.getModifier("Minicrit Airborne Self", stack, 0.0f, living) == 1.0f) {
            thisCritical = 1;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemWeapon && (!(item = (ItemWeapon)stack.func_77973_b()).rapidFireCrits(stack) && item.hasRandomCrits(stack, (Entity)living) && living.func_70681_au().nextFloat() <= item.critChance(stack, (Entity)living) || cap.getCritTime() > 0)) {
            thisCritical = 2;
        }
        if (living.func_70660_b(TF2weapons.critBoost) != null) {
            thisCritical = 2;
        }
        if (cap.hitNoMiss > 0 && (float)(cap.hitNoMiss + 1) >= TF2Attribute.getModifier("Hit Crit", stack, 0.0f, living)) {
            thisCritical = 2;
        }
        if (!(stack.func_190926_b() || stack.func_77973_b() instanceof ItemWeapon && !(stack.func_77973_b() instanceof ItemMeleeWeapon) || living.func_70660_b(TF2weapons.charging) == null && cap.ticksBash <= 0)) {
            if (thisCritical < 2 && cap.ticksBash > 0 && cap.bashCritical || living.func_70660_b(TF2weapons.charging) != null && living.func_70660_b(TF2weapons.charging).func_76459_b() < 14) {
                thisCritical = 2;
            } else if (thisCritical == 0 && (cap.ticksBash > 0 || living.func_70660_b(TF2weapons.charging).func_76459_b() < 35)) {
                thisCritical = 1;
            }
        }
        return thisCritical;
    }

    public static DamageSource causeBulletDamage(ItemStack weapon, Entity shooter, int critical, Entity projectile) {
        return new DamageSourceProjectile(weapon, projectile, shooter, critical).func_76349_b();
    }

    public static DamageSource causeDirectDamage(ItemStack weapon, Entity shooter, int critical) {
        return new DamageSourceDirect(weapon, shooter, critical);
    }

    public static Vec3d radiusRandom3D(float radius, Random random) {
        double z;
        double y;
        double x;
        double radius2 = radius * radius;
        while ((x = random.nextDouble() * (double)radius * 2.0 - (double)radius) * x + (y = random.nextDouble() * (double)radius * 2.0 - (double)radius) * y + (z = random.nextDouble() * (double)radius * 2.0 - (double)radius) * z > radius2) {
        }
        return new Vec3d(x, y, z);
    }

    public static Vec3d rangeRandom3D(float radius, Random random) {
        float yaw = random.nextFloat() * 2.0f * (float)Math.PI;
        float y = random.nextFloat() * 2.0f - 1.0f;
        float x = MathHelper.func_76134_b((float)yaw) * MathHelper.func_76134_b((float)TF2Util.asin(y));
        float z = MathHelper.func_76126_a((float)yaw) * MathHelper.func_76134_b((float)TF2Util.asin(y));
        return new Vec3d((double)(x * radius), (double)(y * radius), (double)(z * radius));
    }

    public static float asin(float value) {
        if (value >= 0.0f) {
            return ASIN_VALUES[(int)(value * 511.0f)];
        }
        return -ASIN_VALUES[(int)(-value * 511.0f)];
    }

    public static void stun(EntityLivingBase living, int duration, boolean noMovement) {
        if (!(living instanceof EntityPlayer) || !((EntityPlayer)living).field_71075_bZ.field_75098_d) {
            living.func_70690_d(new PotionEffect(TF2weapons.stun, duration, noMovement ? 1 : 0));
            living.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration, 0));
        }
    }

    public static void playSound(Entity entity, SoundEvent event, float volume, float pitch) {
        entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, event, entity.func_184176_by(), volume, pitch);
    }

    public static boolean isEnemy(EntityLivingBase living, EntityLivingBase living2) {
        return (living2 instanceof IMob || living2 instanceof EntityPlayer || living2 instanceof EntityLiving && !(living2 instanceof EntityBuilding) && ((EntityLiving)living2).func_70638_az() == living) && !TF2Util.isOnSameTeam((Entity)living, (Entity)living2);
    }

    public static void igniteAndAchievement(Entity target, EntityLivingBase living, int sec, float upgrade) {
        try {
            int fire = ReflectionAccess.entityFire.getInt(target);
            if (target instanceof EntityLivingBase) {
                upgrade *= TF2Attribute.getModifier("Afterburn Reduction", ItemBackpack.getBackpack((EntityLivingBase)target), 1.0f, living);
                fire = (int)((float)fire * (40.0f / (float)EnchantmentProtection.func_92093_a((EntityLivingBase)((EntityLivingBase)target), (int)40)));
            }
            if (fire <= 0) {
                target.func_70015_d(1 + MathHelper.func_76123_f((float)((float)sec * upgrade)));
            } else if (fire < 20 * MathHelper.func_76123_f((float)(8.0f * upgrade)) + 20) {
                target.func_70015_d(Math.min(MathHelper.func_76141_d((float)((float)fire / 20.0f)) + Math.round((float)sec * upgrade), MathHelper.func_76123_f((float)(8.0f * upgrade))));
                ReflectionAccess.entityFire.setInt(target, ReflectionAccess.entityFire.getInt(target) + fire % 20);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static void sendParticle(EnumTF2Particles type, Entity tracking, double x, double y, double z, double offsetX, double offsetY, double offsetZ, int count, int ... params) {
        TF2Util.sendTracking(new TF2Message.ParticleSpawnMessage(type.ordinal(), x, y, z, offsetX, offsetY, offsetZ, count, params), tracking);
    }

    public static void sendParticle(EnumTF2Particles type, World world, double x, double y, double z, double offsetX, double offsetY, double offsetZ, int count, int ... params) {
        TF2weapons.network.sendToAllAround(new TF2Message.ParticleSpawnMessage(type.ordinal(), x, y, z, offsetX, offsetY, offsetZ, count, params), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, (double)type.getRange()));
    }

    public static void sendTracking(IMessage message, Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            TF2weapons.network.sendTo(message, (EntityPlayerMP)entity);
        }
        for (EntityPlayer player : ((WorldServer)entity.field_70170_p).func_73039_n().getTrackingPlayers(entity)) {
            TF2weapons.network.sendTo(message, (EntityPlayerMP)player);
        }
    }

    public static void sendTrackingExcluding(IMessage message, Entity entity) {
        for (EntityPlayer player : ((WorldServer)entity.field_70170_p).func_73039_n().getTrackingPlayers(entity)) {
            TF2weapons.network.sendTo(message, (EntityPlayerMP)player);
        }
    }

    public static float getDamageBeforeAbsorb(float damage, float totalArmor, float toughnessAttribute) {
        float f = 2.0f + toughnessAttribute / 4.0f;
        float f1 = MathHelper.func_76131_a((float)(totalArmor - damage / f), (float)(totalArmor * 0.2f), (float)20.0f);
        return damage * (1.0f - f1 / 25.0f);
    }

    public static boolean isOre(String ore, ItemStack stack) {
        for (ItemStack stackin : OreDictionary.getOres((String)ore)) {
            if (!stackin.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getFirstItem(IInventory inventory, Predicate<ItemStack> pred) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || !pred.apply((Object)stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getFirstItem(IItemHandler inventory, Predicate<ItemStack> pred) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !pred.apply((Object)stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static int getFirstItemSlot(IInventory inventory, Predicate<ItemStack> pred) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || !pred.apply((Object)stack)) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstItemSlot(IItemHandler inventory, Predicate<ItemStack> pred) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !pred.apply((Object)stack)) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack getBestItem(IInventory inventory, Comparator<ItemStack> comp, Predicate<ItemStack> pred) {
        ItemStack greater = ItemStack.field_190927_a;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (pred != null && !pred.apply((Object)stack) || comp.compare(stack, greater) <= 0) continue;
            greater = stack;
        }
        return greater;
    }

    public static ItemStack getBestItem(IItemHandler inventory, Comparator<ItemStack> comp, Predicate<ItemStack> pred) {
        ItemStack greater = ItemStack.field_190927_a;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (pred != null && !pred.apply((Object)stack) || comp.compare(stack, greater) <= 0) continue;
            greater = stack;
        }
        return greater;
    }

    public static ItemStack mergeStackByDamage(IItemHandler inventory, ItemStack stack) {
        int amount;
        ItemStack existingAmmo;
        if (stack.func_190926_b() || stack.func_190916_E() > 1) {
            return stack;
        }
        for (amount = 0; amount < ((ItemAmmo)stack.func_77973_b()).getAmount(stack) && !(existingAmmo = TF2Util.getFirstItem(inventory, (Predicate<ItemStack>)((Predicate)stackL -> stackL.func_190916_E() == 1 && stackL.func_77973_b() == stack.func_77973_b() && ((ItemFireAmmo)stackL.func_77973_b()).getAmount((ItemStack)stackL) != ((ItemFireAmmo)stackL.func_77973_b()).uses))).func_190926_b(); amount += ((ItemFireAmmo)existingAmmo.func_77973_b()).restoreAmmo(existingAmmo, ((ItemAmmo)stack.func_77973_b()).getAmount(stack))) {
            if (((ItemFireAmmo)existingAmmo.func_77973_b()).getAmount(existingAmmo) != ((ItemFireAmmo)existingAmmo.func_77973_b()).uses) continue;
            ItemStack copy = existingAmmo.func_77946_l();
            existingAmmo.func_190920_e(0);
            ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)copy, (boolean)false);
        }
        ((ItemAmmo)stack.func_77973_b()).consumeAmmo(null, stack, amount);
        return stack;
    }

    public static boolean hasEnoughItem(IInventory inventory, Predicate<ItemStack> pred, int amount) {
        int count = 0;
        if (amount <= 0) {
            return true;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || !pred.apply((Object)stack) || (count += stack.func_190916_E()) < amount) continue;
            return true;
        }
        return count >= amount;
    }

    public static boolean hasEnoughItem(IItemHandler inventory, Predicate<ItemStack> pred, int amount) {
        int count = 0;
        if (amount <= 0) {
            return true;
        }
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !pred.apply((Object)stack) || (count += stack.func_190916_E()) < amount) continue;
            return true;
        }
        return count >= amount;
    }

    public static int removeItemsMatching(IItemHandler inventory, int amount, Predicate<ItemStack> match) {
        int left = amount;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!match.apply((Object)inventory.getStackInSlot(i)) || (left -= inventory.extractItem(i, left, false).func_190916_E()) > 0) continue;
            return 0;
        }
        return left;
    }

    public static void attractMobs(EntityLivingBase living, World world) {
        if (!world.field_72995_K && TF2ConfigVars.shootAttract && world.func_175659_aa().func_151525_a() > 1) {
            int range = world.func_175659_aa() == EnumDifficulty.HARD ? 60 : 38;
            for (EntityCreature mob : world.func_175647_a(EntityCreature.class, living.func_174813_aQ().func_72314_b((double)range, (double)range, (double)range), (Predicate)new Predicate<EntityCreature>(){

                public boolean apply(EntityCreature input) {
                    return input.func_70638_az() == null && input.func_184222_aU() && TF2Util.isHostile((EntityLivingBase)input);
                }
            })) {
                mob.func_70671_ap().func_75651_a((Entity)living, 60.0f, 30.0f);
                if (TF2Util.isOnSameTeam((Entity)living, (Entity)mob) || !mob.func_70635_at().func_75522_a((Entity)living) && !(mob.func_70068_e((Entity)living) < 150.0)) continue;
                mob.func_70624_b(living);
                if (mob.func_70638_az() == null || mob.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111127_a(FOLLOW_MODIFIER) != null) continue;
                mob.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier(FOLLOW_MODIFIER, "Follow Check", 65.0 - mob.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(), 0));
                mob.getEntityData().func_74768_a("TF2AM", (int)world.func_82737_E());
            }
        }
    }

    public static void addModifierSafe(EntityLivingBase living, IAttribute attribute, AttributeModifier modifier, boolean saved) {
        living.func_110148_a(attribute).func_188479_b(modifier.func_111167_a());
        living.func_110148_a(attribute).func_111121_a(modifier);
        living.func_110148_a(attribute).func_111126_e();
        if (!saved) {
            modifier.func_111168_a(false);
        }
    }

    public static boolean isHostile(EntityLivingBase living) {
        return living instanceof IMob && !TF2ConfigVars.hostileBlacklist.contains(EntityList.func_191301_a((Entity)living));
    }

    public static Vec3d getRotationVector(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static double getYaw(double x, double z) {
        return MathHelper.func_181159_b((double)x, (double)z) * 180.0 / Math.PI;
    }

    public static boolean isBaseSame(NBTTagCompound base, NBTTagCompound second) {
        if (base != null) {
            for (String key : base.func_150296_c()) {
                if (base.func_74781_a(key).equals((Object)second.func_74781_a(key))) continue;
                return false;
            }
        }
        return true;
    }

    public static Vec3d getMovementVector(EntityLivingBase living) {
        Vec3d moveDir = new Vec3d((double)living.field_191988_bg, (double)living.field_70702_br, 0.0).func_72432_b();
        float cos = MathHelper.func_76134_b((float)(living.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float sin = MathHelper.func_76126_a((float)(living.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        return new Vec3d(-moveDir.field_72448_b * (double)cos + moveDir.field_72450_a * (double)sin, -moveDir.field_72450_a * (double)cos - moveDir.field_72448_b * (double)sin, 0.0);
    }

    public static boolean teleportSafe(EntityLiving toTeleport, Entity dest) {
        int i = MathHelper.func_76128_c((double)dest.field_70165_t) - 2;
        int j = MathHelper.func_76128_c((double)dest.field_70161_v) - 2;
        int k = MathHelper.func_76128_c((double)dest.func_174813_aQ().field_72338_b);
        for (int l = 0; l <= 4; ++l) {
            for (int i1 = 0; i1 <= 4; ++i1) {
                if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !TF2Util.isTeleportFriendlyBlock((EntityLivingBase)toTeleport, i, j, k, l, i1)) continue;
                toTeleport.func_70012_b((double)((float)(i + l) + 0.5f), (double)k, (double)((float)(j + i1) + 0.5f), toTeleport.field_70177_z, toTeleport.field_70125_A);
                toTeleport.func_70661_as().func_75499_g();
                return true;
            }
        }
        return false;
    }

    public static boolean isTeleportFriendlyBlock(EntityLivingBase owner, int x, int p_192381_2_, int y, int p_192381_4_, int p_192381_5_) {
        BlockPos blockpos = new BlockPos(x + p_192381_4_, y - 1, p_192381_2_ + p_192381_5_);
        IBlockState iblockstate = owner.field_70170_p.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockAccess)owner.field_70170_p, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a((Entity)owner) && owner.field_70170_p.func_175623_d(blockpos.func_177984_a()) && owner.field_70170_p.func_175623_d(blockpos.func_177981_b(2));
    }

    public static float getGravity(EntityLivingBase living) {
        if (living.func_70090_H() || living.func_189652_ae() || living.func_184613_cA() || living instanceof EntityWither || living instanceof EntityMonoculus || living instanceof EntityGhast) {
            return 0.0f;
        }
        return 0.08f;
    }

    public static void addAndSendEffect(EntityLivingBase living, PotionEffect effect) {
        living.func_70690_d(effect);
        if (!living.field_70170_p.field_72995_K) {
            for (EntityPlayer player : ((WorldServer)living.field_70170_p).func_73039_n().getTrackingPlayers((Entity)living)) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(living.func_145782_y(), effect));
            }
        }
    }

    public static Entity findAmmoSource(final EntityLivingBase living, double range, final boolean immediate) {
        return (Entity)Iterables.getFirst((Iterable)living.field_70170_p.func_175647_a(EntityDispenser.class, living.func_174813_aQ().func_72314_b(range, range / 4.0, range), (Predicate)new Predicate<EntityDispenser>(){

            public boolean apply(EntityDispenser input) {
                return TF2Util.isOnSameTeam((Entity)input, (Entity)living) && (!immediate || !input.isDisabled() && input.getMetal() > 0);
            }
        }), null);
    }

    public static boolean isNaturalBlock(World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        for (Block block2 : NATURAL_BLOCKS) {
            if (block != block2) continue;
            return true;
        }
        Biome biome = world.func_180494_b(pos);
        return block == biome.field_76752_A.func_177230_c() || block == biome.field_76753_B.func_177230_c();
    }

    public static Vec2f getAngleFromFacing(EnumFacing facing) {
        switch (facing) {
            case UP: {
                return new Vec2f(0.0f, 90.0f);
            }
            case DOWN: {
                return new Vec2f(0.0f, -90.0f);
            }
        }
        return new Vec2f(facing.func_185119_l(), 0.0f);
    }

    public static void stomp(final EntityLivingBase living) {
        for (EntityLivingBase target : living.field_70170_p.func_175647_a(EntityLivingBase.class, living.func_174813_aQ().func_72314_b(0.25, -living.field_70181_x, 0.25), (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase input) {
                return input != living && !TF2Util.isOnSameTeam((Entity)input, (Entity)living);
            }
        })) {
            float damage = Math.max(0.0f, living.field_70143_R - 3.0f) * 1.8f;
            living.field_70143_R = 0.0f;
            if (!(damage > 0.0f)) continue;
            target.func_70097_a((DamageSource)new EntityDamageSource("fallpl", (Entity)living), damage);
            TF2Util.playSound((Entity)living, TF2Sounds.WEAPON_MANTREADS, 1.5f, 1.0f);
        }
    }

    public static void extractData(String input, File output, File source) {
        try {
            byte[] bytes = Resources.toByteArray((URL)TF2Util.class.getResource("/assets/rafradek_tf2_weapons/" + input));
            FileOutputStream ostream = new FileOutputStream(output);
            ostream.write(bytes);
            ostream.flush();
            ostream.close();
        }
        catch (IOException e) {
            TF2weapons.corrupted = true;
            e.printStackTrace();
        }
        if (TF2weapons.corrupted) {
            output.delete();
            TF2weapons.instance.weaponDir.delete();
            TF2weapons.proxy.displayCorruptedFileError();
        }
    }

    public static boolean isWeaponOfClass(ItemStack stack, int slot, String name) {
        if (ItemFromData.getData(stack).hasProperty(PropertyType.SLOT)) {
            return ItemFromData.isItemOfClassSlot(ItemFromData.getData(stack), slot, name);
        }
        String parent = ItemFromData.getData(stack).getString(PropertyType.BASED_ON);
        if (!parent.isEmpty()) {
            return ItemFromData.isItemOfClassSlot(MapList.nameToData.get(parent), slot, name);
        }
        return false;
    }

    public static String getWeaponUsedByClass(ItemStack stack) {
        if (ItemFromData.getData(stack) == ItemFromData.BLANK_DATA) {
            return null;
        }
        String parent = ItemFromData.getData(stack).getString(PropertyType.BASED_ON);
        WeaponData data = !parent.isEmpty() && MapList.nameToData.get(parent).hasProperty(PropertyType.SLOT) ? MapList.nameToData.get(parent) : ItemFromData.getData(stack);
        if (data.hasProperty(PropertyType.SLOT)) {
            return (String)Iterables.getFirst(data.get(PropertyType.SLOT).keySet(), null);
        }
        return null;
    }

    public static EntityLivingBase getOwnerIfOwnable(EntityLivingBase living) {
        if (living instanceof IEntityOwnable && ((IEntityOwnable)living).func_70902_q() != null) {
            return (EntityLivingBase)((IEntityOwnable)living).func_70902_q();
        }
        return living;
    }

    public static Vec3d getHeightVec(World world, BlockPos pos) {
        Vec3d vec = new Vec3d(0.0, 0.0, 0.0);
        IBlockState center = world.func_180495_p(pos);
        IBlockState down = world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN));
        IBlockState north = world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH));
        IBlockState south = world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH));
        IBlockState west = world.func_180495_p(pos.func_177972_a(EnumFacing.WEST));
        IBlockState east = world.func_180495_p(pos.func_177972_a(EnumFacing.EAST));
        if (center.func_185890_d((IBlockAccess)world, pos) != null) {
            vec = vec.func_72441_c(0.0, 1.0 - center.func_185890_d((IBlockAccess)world, (BlockPos)pos).field_72337_e, 0.0);
        } else if (down.func_185890_d((IBlockAccess)world, pos) != null) {
            vec = vec.func_72441_c(0.0, 2.0 - down.func_185890_d((IBlockAccess)world, (BlockPos)pos).field_72337_e, 0.0);
        }
        if (north.func_185890_d((IBlockAccess)world, pos) != null) {
            vec = vec.func_72441_c(0.0, 0.0, north.func_185890_d((IBlockAccess)world, (BlockPos)pos).field_72337_e);
        }
        if (south.func_185890_d((IBlockAccess)world, pos) != null) {
            vec = vec.func_72441_c(0.0, 0.0, -south.func_185890_d((IBlockAccess)world, (BlockPos)pos).field_72337_e);
        }
        if (west.func_185890_d((IBlockAccess)world, pos) != null) {
            vec = vec.func_72441_c(west.func_185890_d((IBlockAccess)world, (BlockPos)pos).field_72337_e, 0.0, 0.0);
        }
        if (east.func_185890_d((IBlockAccess)world, pos) != null) {
            vec = vec.func_72441_c(-east.func_185890_d((IBlockAccess)world, (BlockPos)pos).field_72337_e, 0.0, 0.0);
        }
        return vec;
    }

    public static void setVelocity(Entity entity, double motionX, double motionY, double motionZ) {
        entity.field_70159_w = motionX;
        entity.field_70181_x = motionY;
        entity.field_70179_y = motionZ;
        entity.field_70133_I = true;
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity));
        }
    }

    public static ItemStack pickAmmo(ItemStack stack, EntityPlayer player, boolean addNormalInventory) {
        if (stack.func_77973_b() instanceof ItemFireAmmo && stack.func_190916_E() == 1) {
            stack = TF2Util.mergeStackByDamage((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), stack);
            if (!((InventoryWearables)((Object)player.getCapability(TF2weapons.INVENTORY_CAP, null))).func_70301_a(3).func_190926_b()) {
                stack = TF2Util.mergeStackByDamage((IItemHandler)((InventoryWearables)((Object)player.getCapability(TF2weapons.INVENTORY_CAP, null))).func_70301_a(3).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), stack);
            }
            if (stack.func_190926_b()) {
                return stack;
            }
        }
        if (stack.func_77973_b() instanceof ItemAmmo && player.hasCapability(TF2weapons.INVENTORY_CAP, null) || addNormalInventory) {
            ItemStack weapon;
            IItemHandler inv;
            if (!((InventoryWearables)((Object)player.getCapability(TF2weapons.INVENTORY_CAP, null))).func_70301_a(3).func_190926_b()) {
                inv = (IItemHandler)((InventoryWearables)((Object)player.getCapability(TF2weapons.INVENTORY_CAP, null))).func_70301_a(3).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                stack = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)false);
                weapon = player.func_184614_ca();
                if (!weapon.func_190926_b() && weapon.func_77973_b() instanceof ItemWeapon) {
                    TF2weapons.network.sendTo(new TF2Message.UseMessage(((ItemWeapon)weapon.func_77973_b()).getClip(weapon), false, ((ItemUsable)weapon.func_77973_b()).getAmmoAmount((EntityLivingBase)player, weapon), EnumHand.MAIN_HAND), (EntityPlayerMP)player);
                }
            }
            if (!stack.func_190926_b() && addNormalInventory) {
                inv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                stack = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)false);
                weapon = player.func_184614_ca();
                if (!weapon.func_190926_b() && weapon.func_77973_b() instanceof ItemWeapon) {
                    TF2weapons.network.sendTo(new TF2Message.UseMessage(((ItemWeapon)weapon.func_77973_b()).getClip(weapon), false, ((ItemUsable)weapon.func_77973_b()).getAmmoAmount((EntityLivingBase)player, weapon), EnumHand.MAIN_HAND), (EntityPlayerMP)player);
                }
            }
            if (stack.func_190926_b()) {
                return stack;
            }
        }
        return stack;
    }

    public static int getValueOnAxis(Vec3i vec, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return vec.func_177958_n();
            }
            case Y: {
                return vec.func_177956_o();
            }
            case Z: {
                return vec.func_177952_p();
            }
        }
        return 0;
    }

    public static BlockPos setValueOnAxis(Vec3i vec, EnumFacing.Axis axis, int value) {
        switch (axis) {
            case X: {
                return new BlockPos(value, vec.func_177956_o(), vec.func_177952_p());
            }
            case Y: {
                return new BlockPos(vec.func_177958_n(), value, vec.func_177952_p());
            }
            case Z: {
                return new BlockPos(vec.func_177958_n(), vec.func_177956_o(), value);
            }
        }
        return new BlockPos(vec);
    }

    public static float getReducedHealing(EntityLivingBase attacker, EntityLivingBase target, float damage) {
        return TF2Util.getDamageReduction(new DamageSource("").func_76349_b(), attacker, 15.0f) / 15.0f * damage;
    }

    public static float getDamageReduction(DamageSource source, EntityLivingBase living, float damage) {
        return CombatRules.func_188401_b((float)CombatRules.func_189427_a((float)damage, (float)living.func_70658_aO(), (float)((float)living.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e())), (float)EnchantmentHelper.func_77508_a((Iterable)living.func_184193_aE(), (DamageSource)source));
    }

    public static int getTotalCurrency(IItemHandler handler) {
        int money = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!(stack.func_77973_b() instanceof ItemMoney)) continue;
            money += ((ItemMoney)stack.func_77973_b()).getValue(stack);
        }
        return money;
    }

    public static void setTotalCurrency(IItemHandler handler, int fromSlot, int amount) {
        int big = amount / 81;
        int medium = amount % 81 / 9;
        int small = amount % 9;
        handler.extractItem(fromSlot, 64, false);
        handler.insertItem(fromSlot, new ItemStack(TF2weapons.itemMoney, small, 0), false);
        handler.extractItem(fromSlot + 1, 64, false);
        handler.insertItem(fromSlot + 1, new ItemStack(TF2weapons.itemMoney, medium, 1), false);
        handler.extractItem(fromSlot + 2, 64, false);
        handler.insertItem(fromSlot + 2, new ItemStack(TF2weapons.itemMoney, big, 2), false);
    }

    public static void playSoundToPlayer(EntityPlayer player, SoundEvent event, SoundCategory category, double x, double y, double z, float volume, float pitch) {
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(event, category, x, y, z, volume, pitch));
        } else if (player.func_130014_f_().field_72995_K && player == Minecraft.func_71410_x().field_71439_g) {
            player.func_130014_f_().func_184134_a(x, y, z, event, category, volume, pitch, false);
        }
    }

    static {
        int i;
        FOLLOW_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE978AD348");
        NATURAL_BLOCKS = new Block[]{Blocks.field_150348_b};
        TARGETABLE = target -> target.func_70067_L() && (!(target instanceof EntityLivingBase) || target instanceof EntityLivingBase && ((EntityLivingBase)target).field_70725_aQ <= 0) && !(target instanceof EntityStatue);
        colorCode = new int[32];
        ASIN_VALUES = new float[512];
        for (i = 0; i < 512; ++i) {
            TF2Util.ASIN_VALUES[i] = (float)Math.asin((double)i / 511.0);
        }
        for (i = 0; i < 32; ++i) {
            int j = (i >> 3 & 1) * 85;
            int k = (i >> 2 & 1) * 170 + j;
            int l = (i >> 1 & 1) * 170 + j;
            int i1 = (i >> 0 & 1) * 170 + j;
            if (i == 6) {
                k += 85;
            }
            if (i >= 16) {
                k /= 4;
                l /= 4;
                i1 /= 4;
            }
            TF2Util.colorCode[i] = (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
        }
    }
}

