/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.client.particle.EnumTF2Particles;
import rafradek.TF2weapons.entity.projectile.EntityProjectileBase;
import rafradek.TF2weapons.util.TF2Util;

public class TF2Explosion
extends Explosion {
    private Random explosionRNG = new Random();
    public World field_77287_j;
    public List<BlockPos> field_77281_g = new ArrayList<BlockPos>();
    public HashMap<Entity, Float> affectedEntities = new HashMap();
    private Entity directHit;
    public boolean isFlaming;
    public boolean isSmoking;
    private final double explosionX;
    private final double explosionY;
    private final double explosionZ;
    private final Entity exploder;
    private final float explosionSize;
    private final Map<Entity, Vec3d> knockbackMap;
    private final Vec3d position;
    private float harvestDamage;
    private float pushScale;
    private SoundEvent sound;

    public TF2Explosion(World world, Entity exploder, double x, double y, double z, float size, Entity direct, float harvestDamage, float pushScale, SoundEvent sound) {
        super(world, exploder, x, y, z, size, false, true);
        this.explosionRNG = new Random();
        this.field_77281_g = Lists.newArrayList();
        this.knockbackMap = Maps.newHashMap();
        this.exploder = exploder;
        this.explosionSize = size;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
        this.position = new Vec3d(this.explosionX, this.explosionY, this.explosionZ);
        this.field_77287_j = world;
        this.directHit = direct;
        this.harvestDamage = harvestDamage;
        this.pushScale = pushScale;
        this.sound = sound;
    }

    public void func_77278_a() {
        double d4;
        int k;
        int j;
        HashSet hashset = Sets.newHashSet();
        if (TF2ConfigVars.destTerrain == 2 || TF2ConfigVars.destTerrain == 1 && this.harvestDamage > 0.0f) {
            for (int i = 0; i < 16; ++i) {
                for (j = 0; j < 16; ++j) {
                    for (k = 0; k < 16; ++k) {
                        IBlockState iblockstate;
                        BlockPos blockpos;
                        float f;
                        if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                        double d0 = (float)i / 15.0f * 2.0f - 1.0f;
                        double d1 = (float)j / 15.0f * 2.0f - 1.0f;
                        double d2 = (float)k / 15.0f * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        d4 = this.explosionX;
                        double d6 = this.explosionY;
                        double d8 = this.explosionZ;
                        if (TF2ConfigVars.destTerrain == 2) {
                            for (f = TF2ConfigVars.destTerrain == 2 ? this.explosionSize * (0.7f + this.field_77287_j.field_73012_v.nextFloat() * 0.6f) : this.harvestDamage / 64.0f; f > 0.0f; f -= 0.22500001f) {
                                blockpos = new BlockPos(d4, d6, d8);
                                iblockstate = this.field_77287_j.func_180495_p(blockpos);
                                if (iblockstate.func_185904_a() != Material.field_151579_a) {
                                    float f2 = this.exploder != null ? this.exploder.func_180428_a((Explosion)this, this.field_77287_j, blockpos, iblockstate) : iblockstate.func_177230_c().getExplosionResistance(this.field_77287_j, blockpos, (Entity)null, (Explosion)this);
                                    f -= (f2 + 0.3f) * 0.3f;
                                }
                                if (f > 0.0f && (this.exploder == null || this.exploder.func_174816_a((Explosion)this, this.field_77287_j, blockpos, iblockstate, f))) {
                                    hashset.add(blockpos);
                                }
                                d4 += d0 * (double)0.3f;
                                d6 += d1 * (double)0.3f;
                                d8 += d2 * (double)0.3f;
                            }
                            continue;
                        }
                        while (f > 0.0f) {
                            blockpos = new BlockPos(d4, d6, d8);
                            iblockstate = this.field_77287_j.func_180495_p(blockpos);
                            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                                f = TF2Util.damageBlock(blockpos, null, this.field_77287_j, ItemStack.field_190927_a, 0, f, null, this);
                            }
                            d4 += d0 * (double)0.3f;
                            d6 += d1 * (double)0.3f;
                            d8 += d2 * (double)0.3f;
                            f -= 0.015f;
                        }
                    }
                }
            }
        }
        this.field_77281_g.addAll(hashset);
        float f3 = Math.max(6.0f, this.explosionSize * 2.0f);
        j = MathHelper.func_76128_c((double)(this.explosionX - (double)f3 - 1.0));
        k = MathHelper.func_76128_c((double)(this.explosionX + (double)f3 + 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.explosionY - (double)f3 - 1.0));
        int l = MathHelper.func_76128_c((double)(this.explosionY + (double)f3 + 1.0));
        int k1 = MathHelper.func_76128_c((double)(this.explosionZ - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.explosionZ + (double)f3 + 1.0));
        List list = this.field_77287_j.func_175647_a(Entity.class, new AxisAlignedBB((double)j, (double)j1, (double)k1, (double)k, (double)l, (double)i1), (Predicate)new Predicate<Entity>(){

            public boolean apply(Entity input) {
                return input != TF2Explosion.this.exploder && !input.func_180427_aV() && (input.func_70075_an() || TF2ConfigVars.destTerrain == 2) && TF2Util.canHit(TF2Explosion.this.func_94613_c(), input);
            }
        });
        ForgeEventFactory.onExplosionDetonate((World)this.field_77287_j, (Explosion)this, (List)list, (double)f3);
        Vec3d Vec3d2 = new Vec3d(this.explosionX, this.explosionY, this.explosionZ);
        int livingEntities = 0;
        for (Object obj : list) {
            if (!(obj instanceof EntityLivingBase)) continue;
            ++livingEntities;
        }
        for (int l1 = 0; l1 < list.size(); ++l1) {
            double d7;
            Entity entity = (Entity)list.get(l1);
            d4 = TF2Util.getDistanceBox(entity, this.explosionX, this.explosionY, this.explosionZ, 0.0, 0.0) / (double)this.getExplosionSize(entity) * 0.5;
            if (!(d4 <= 0.5)) continue;
            boolean isExploder = this.func_94613_c() == entity;
            boolean expJump = isExploder && this.directHit == null;
            double d5 = entity.field_70165_t - this.explosionX;
            double d6 = isExploder ? entity.field_70163_u + (double)entity.func_70047_e() - 0.185 - this.explosionY : entity.field_70163_u + (entity.func_174813_aQ().field_72337_e - entity.func_174813_aQ().field_72338_b) / 2.0 - this.explosionY;
            double d9 = MathHelper.func_76133_a((double)(d5 * d5 + d6 * d6 + (d7 = entity.field_70161_v - this.explosionZ) * d7));
            if (d9 == 0.0) continue;
            Vec3d move = new Vec3d(d5 /= d9, d6 /= d9, d7 /= d9).func_72432_b();
            double d10 = this.getBlockDensity(Vec3d2, entity.func_174813_aQ().func_72314_b((double)-0.05f, (double)-0.05f, (double)-0.05f));
            double d11 = (1.0 - d4) * d10;
            if (entity == this.directHit) {
                d11 = 1.0;
            }
            if (d11 == 0.0) continue;
            this.affectedEntities.put(entity, Float.valueOf((float)(d11 / (double)(expJump ? 2 : 1))));
            d11 = d11 * 0.5 + 0.5;
            if (entity instanceof EntityPlayerMP) {
                this.getKnockbackMap().put(entity, move.func_186678_a(d11));
                continue;
            }
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111266_c).func_111126_e() >= 1.0) continue;
            this.getKnockbackMap().put(entity, move);
        }
    }

    public void func_77279_a(boolean spawnParticles) {
        if (this.sound != null) {
            this.field_77287_j.func_184148_a((EntityPlayer)null, this.explosionX, this.explosionY, this.explosionZ, this.sound, SoundCategory.BLOCKS, this.func_94613_c() instanceof EntityPlayer ? 4.0f : 1.0f, 1.0f);
        }
        if (this.isSmoking) {
            TF2Util.sendParticle(EnumTF2Particles.EXPLOSION, this.field_77287_j, this.explosionX, this.explosionY, this.explosionZ, (double)this.explosionSize, 0.0, 0.0, 1, new int[0]);
        } else {
            this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0, new int[0]);
        }
        if (this.isSmoking && TF2ConfigVars.destTerrain == 2) {
            for (BlockPos blockpos : this.field_77281_g) {
                IBlockState iblockstate = this.field_77287_j.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (spawnParticles) {
                    double d0 = (float)blockpos.func_177958_n() + this.field_77287_j.field_73012_v.nextFloat();
                    double d1 = (float)blockpos.func_177956_o() + this.field_77287_j.field_73012_v.nextFloat();
                    double d2 = (float)blockpos.func_177952_p() + this.field_77287_j.field_73012_v.nextFloat();
                    double d3 = d0 - this.explosionX;
                    double d4 = d1 - this.explosionY;
                    double d5 = d2 - this.explosionZ;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)this.explosionSize + 0.1);
                    this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + this.explosionX) / 2.0, (d1 + this.explosionY) / 2.0, (d2 + this.explosionZ) / 2.0, d3 *= (d7 *= (double)(this.field_77287_j.field_73012_v.nextFloat() * this.field_77287_j.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
                    this.field_77287_j.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
                }
                if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
                if (block.func_149659_a((Explosion)this)) {
                    block.func_180653_a(this.field_77287_j, blockpos, this.field_77287_j.func_180495_p(blockpos), 1.0f / this.explosionSize, 0);
                }
                block.onBlockExploded(this.field_77287_j, blockpos, (Explosion)this);
            }
        }
        if (this.isFlaming) {
            for (BlockPos blockpos1 : this.field_77281_g) {
                if (this.field_77287_j.func_180495_p(blockpos1).func_185904_a() != Material.field_151579_a || !this.field_77287_j.func_180495_p(blockpos1.func_177977_b()).func_185913_b() || this.explosionRNG.nextInt(3) != 0) continue;
                this.field_77287_j.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    public float getBlockDensity(Vec3d origin, AxisAlignedBB p_72842_2_) {
        double d0 = 1.0 / ((p_72842_2_.field_72336_d - p_72842_2_.field_72340_a) * 2.0 + 1.0);
        double d1 = 1.0 / ((p_72842_2_.field_72337_e - p_72842_2_.field_72338_b) * 2.0 + 1.0);
        double d2 = 1.0 / ((p_72842_2_.field_72334_f - p_72842_2_.field_72339_c) * 2.0 + 1.0);
        List collisionBoxes = this.field_77287_j.func_184144_a(null, p_72842_2_.func_72314_b(1.0, 1.0, 1.0));
        if (d0 >= 0.0 && d1 >= 0.0 && d2 >= 0.0) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d3 = p_72842_2_.field_72340_a + (p_72842_2_.field_72336_d - p_72842_2_.field_72340_a) * (double)f;
                        double d4 = p_72842_2_.field_72338_b + (p_72842_2_.field_72337_e - p_72842_2_.field_72338_b) * (double)f1;
                        double d5 = p_72842_2_.field_72339_c + (p_72842_2_.field_72334_f - p_72842_2_.field_72339_c) * (double)f2;
                        Vec3d start = new Vec3d(d3, d4, d5);
                        boolean free = true;
                        for (AxisAlignedBB box : collisionBoxes) {
                            if (box.func_72327_a(start, origin) == null) continue;
                            free = false;
                            break;
                        }
                        if (free) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public Map<Entity, Vec3d> getKnockbackMap() {
        return this.knockbackMap;
    }

    public float getExplosionSize(Entity target) {
        return target == this.func_94613_c() && this.exploder instanceof EntityProjectileBase ? ((EntityProjectileBase)this.exploder).getExplosionSize() : this.explosionSize;
    }

    public EntityLivingBase func_94613_c() {
        if (this.exploder instanceof EntityProjectileBase) {
            return ((EntityProjectileBase)this.exploder).shootingEntity;
        }
        return (EntityLivingBase)this.exploder;
    }

    public void func_180342_d() {
        this.field_77281_g.clear();
    }

    public List<BlockPos> func_180343_e() {
        return this.field_77281_g;
    }

    public Vec3d getPosition() {
        return this.position;
    }
}

