/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.item.ItemCrate;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.util.WeaponData;

public class PropertyType<T>
implements JsonDeserializer<T> {
    public static final PropertyType<String> FIRE_SOUND = new PropertyType<String>(3, "Fire sound", String.class);
    public static final PropertyType<String> RENDER = new PropertyType<String>(2, "Render", String.class);
    public static final PropertyType<Map<String, Integer>> SLOT = new PropertyTypeMap<Integer>(1, "Slot", Integer.class);
    public static final PropertyType<String> NAME = new PropertyType<String>(0, "Name", String.class);
    public static final PropertyType<String> RELOAD_SOUND = new PropertyType<String>(4, "Reload sound", String.class);
    public static final PropertyType<Integer> FIRE_SPEED = new PropertyType<Integer>(5, "Firing speed", Integer.class);
    public static final PropertyType<Integer> PELLETS = new PropertyType<Integer>(6, "Pellets", Integer.class);
    public static final PropertyType<Float> DAMAGE = new PropertyType<Float>(7, "Damage", Float.class);
    public static final PropertyType<Float> MAX_DAMAGE = new PropertyType<Float>(8, "Max damage", Float.class);
    public static final PropertyType<Float> MIN_DAMAGE = new PropertyType<Float>(9, "Min damage", Float.class);
    public static final PropertyType<Boolean> RANDOM_CRITS = new PropertyType<Boolean>(10, "Random crits", Boolean.class);
    public static final PropertyType<Boolean> RAPIDFIRE_CRITS = new PropertyType<Boolean>(11, "Rapidfire crits", Boolean.class);
    public static final PropertyType<Float> DAMAGE_FALOFF = new PropertyType<Float>(12, "Damage falloff", Float.class);
    public static final PropertyType<Boolean> RELOADS_CLIP = new PropertyType<Boolean>(13, "Reloads clip", Boolean.class);
    public static final PropertyType<Boolean> RELOADS_FULL_CLIP = new PropertyType<Boolean>(14, "Reloads full clip", Boolean.class);
    public static final PropertyType<Integer> RELOAD_TIME_FIRST = new PropertyType<Integer>(15, "Reload time first", Integer.class);
    public static final PropertyType<Integer> RELOAD_TIME = new PropertyType<Integer>(16, "Reload time", Integer.class);
    public static final PropertyType<Integer> CLIP_SIZE = new PropertyType<Integer>(17, "Clip size", Integer.class);
    public static final PropertyType<Integer> KNOCKBACK = new PropertyType<Integer>(18, "Knockback", Integer.class);
    public static final PropertyType<Boolean> SPREAD_RECOVERY = new PropertyType<Boolean>(19, "Spread recovery", Boolean.class);
    public static final PropertyType<Float> DUAL_WIELD_SPEED = new PropertyType<Float>(20, "Dual wield speed", Float.class);
    public static final PropertyType<String> FIRE_LOOP_SOUND = new PropertyType<String>(21, "Fire loop sound", String.class);
    public static final PropertyType<String> SPIN_SOUND = new PropertyType<String>(22, "Spin sound", String.class);
    public static final PropertyType<String> WIND_UP_SOUND = new PropertyType<String>(23, "Wind up sound", String.class);
    public static final PropertyType<String> WIND_DOWN_SOUND = new PropertyType<String>(24, "Wind down sound", String.class);
    public static final PropertyType<String> FIRE_START_SOUND = new PropertyType<String>(25, "Fire start sound", String.class);
    public static final PropertyType<String> FIRE_STOP_SOUND = new PropertyType<String>(26, "Fire stop sound", String.class);
    public static final PropertyType<String> AIRBLAST_SOUND = new PropertyType<String>(27, "Airblast sound", String.class);
    public static final PropertyType<String> AIRBLAST_ROCKET_SOUND = new PropertyType<String>(37, "Airblast rocket sound", String.class);
    public static final PropertyType<Boolean> HIDDEN = new PropertyType<Boolean>(38, "Hidden", Boolean.class);
    public static final PropertyType<String> CLOAK_SOUND = new PropertyType<String>(28, "Cloak sound", String.class);
    public static final PropertyType<String> DECLOAK_SOUND = new PropertyType<String>(29, "Decloak sound", String.class);
    public static final PropertyType<String> BUILD_HIT_SUCCESS_SOUND = new PropertyType<String>(30, "Build hit success sound", String.class);
    public static final PropertyType<String> BUILD_HIT_FAIL_SOUND = new PropertyType<String>(31, "Build hit fail sound", String.class);
    public static final PropertyType<String> EFFECT_TYPE = new PropertyType<String>(32, "Effect type", String.class);
    public static final PropertyType<Integer> DURATION = new PropertyType<Integer>(33, "Duration", Integer.class);
    public static final PropertyType<Integer> COOLDOWN = new PropertyType<Integer>(34, "Cooldown", Integer.class);
    public static final PropertyType<String> HEAL_START_SOUND = new PropertyType<String>(35, "Heal start sound", String.class);
    public static final PropertyType<String> NO_TARGET_SOUND = new PropertyType<String>(36, "No target sound", String.class);
    public static final PropertyType<String> CHARGED_SOUND = new PropertyType<String>(39, "Charged sound", String.class);
    public static final PropertyType<String> UBER_START_SOUND = new PropertyType<String>(40, "Uber start sound", String.class);
    public static final PropertyType<String> UBER_STOP_SOUND = new PropertyType<String>(41, "Uber stop sound", String.class);
    public static final PropertyType<Float> HEAL = new PropertyType<Float>(42, "Heal", Float.class);
    public static final PropertyType<Float> MAX_OVERHEAL = new PropertyType<Float>(43, "Max overheal", Float.class);
    public static final PropertyType<Float> RANGE = new PropertyType<Float>(44, "Range", Float.class);
    public static final PropertyType<Float> PROJECTILE_SPEED = new PropertyType<Float>(45, "Projectile speed", Float.class);
    public static final PropertyType<String> PROJECTILE = new PropertyType<String>(46, "Projectile", String.class);
    public static final PropertyType<String> BASED_ON = new PropertyType<String>(47, "Based on", String.class);
    public static final PropertyType<String> RENDER_BACKSTAB = new PropertyType<String>(48, "Render backstab", String.class);
    public static final PropertyType<String> CHARGE_SOUND = new PropertyType<String>(49, "Charge sound", String.class);
    public static final PropertyType<String> DETONATE_SOUND = new PropertyType<String>(50, "Detonate sound", String.class);
    public static final PropertyType<String> CLASS = new PropertyType<String>(51, "Class", String.class);
    public static final PropertyType<Float> SPREAD = new PropertyType<Float>(52, "Spread", Float.class);
    public static final PropertyType<String> HIT_SOUND = new PropertyType<String>(53, "Hit sound", String.class);
    public static final PropertyType<Integer> AMMO_TYPE = new PropertyType<Integer>(54, "Ammo type", Integer.class);
    public static final PropertyType<Integer> ROLL_HIDDEN = new PropertyType<Integer>(55, "Roll hidden", Integer.class);
    public static final PropertyType<String> MOB_TYPE = new PropertyType<String>(56, "Mobs", String.class);
    public static final PropertyType<Float> RECOIL = new PropertyType<Float>(57, "Recoil", Float.class);
    public static final PropertyType<Float> DROP_CHANCE = new PropertyType<Float>(58, "Drop chance", Float.class);
    public static final PropertyType<Integer> COST = new PropertyType<Integer>(59, "Cost", Integer.class);
    public static final PropertyType<Integer> WEAR = new PropertyType<Integer>(60, "Wear flags", Integer.class);
    public static final PropertyType<String> ARMOR_IMAGE = new PropertyType<String>(61, "Overlay", String.class);
    public static final PropertyType<String> HEAD_MODEL = new PropertyType<String>(62, "Head model", String.class);
    public static final PropertyType<String> BODY_MODEL = new PropertyType<String>(63, "Body model", String.class);
    public static final PropertyType<Float> ARMOR = new PropertyType<Float>(64, "Armor", Float.class);
    public static final PropertyType<Float> ARMOR_TOUGHNESS = new PropertyType<Float>(65, "Armor toughness", Float.class);
    public static final PropertyType<String> HORN_RED_SOUND = new PropertyType<String>(66, "Horn red sound", String.class);
    public static final PropertyType<String> HORN_BLU_SOUND = new PropertyType<String>(67, "Horn blu sound", String.class);
    public static final PropertyType<String> DESC = new PropertyType<String>(68, "Description", String.class);
    public static final PropertyType<String> HIT_WORLD_SOUND = new PropertyType<String>(69, "Hit world sound", String.class);
    public static final PropertyType<String> HIT_LOOP_SOUND = new PropertyType<String>(70, "Hit loop sound", String.class);
    public static final PropertyType<Float> EFFICIENT_RANGE = new PropertyType<Float>(71, "Efficient range", Float.class);
    public static final PropertyType<Boolean> STOCK = new PropertyType<Boolean>(72, "Stock", Boolean.class);
    public static final PropertyType<String> NO_FIRE_SOUND = new PropertyType<String>(73, "No fire sound", String.class);
    public static final PropertyType<String> CHARGED_FIRE_SOUND = new PropertyType<String>(73, "Charged fire sound", String.class);
    public static final PropertyType<Boolean> PENETRATE = new PropertyType<Boolean>(74, "Penetrate", Boolean.class);
    public static final PropertyType<String> OVERRIDE = new PropertyType<String>(75, "Weapon override", String.class);
    public static final PropertyType<Integer> MAX_AMMO = new PropertyType<Integer>(76, "Max ammo", Integer.class);
    public static final PropertyType<String> EXPLOSION_SOUND = new PropertyType<String>(77, "Explosion sound", String.class);
    public static final PropertyType<Float> ARMOR_PEN_SCALE = new PropertyType<Float>(78, "Armor penetration scale", Float.class);
    public static final PropertyType<String> SPECIAL_1_SOUND = new PropertyType<String>(79, "Special 1 sound", String.class);
    public static final PropertyType<String> SPECIAL_2_SOUND = new PropertyType<String>(80, "Special 2 sound", String.class);
    public static final PropertyType<ItemFromData.AttributeProvider> ATTRIBUTES = new ItemFromData.PropertyAttribute(81, "Attributes", ItemFromData.AttributeProvider.class);
    public static final PropertyType<ItemCrate.CrateContent> CONTENT = new ItemCrate.PropertyContent(82, "Content", ItemCrate.CrateContent.class);
    public static final PropertyType<Integer> COLOR = new PropertyType<Integer>(83, "Color", Integer.class);
    public static final PropertyType<Boolean> F2P = new PropertyType<Boolean>(84, "F2P", Boolean.class);
    public static final PropertyType<Float> KNOCKBACK_Z = new PropertyType<Float>(85, "Knockback Z", Float.class);
    public static final PropertyType<Float> MINIMAL_RANGE = new PropertyType<Float>(86, "Minimal range", Float.class);
    public static final PropertyType<Float> COOLDOWN_LONG = new PropertyType<Float>(87, "Long cooldown", Float.class);
    public static final PropertyType<Boolean> TEMPLATE = new PropertyType<Boolean>(88, "Template", Boolean.class);
    public Class<T> type;
    public int id;
    public String name;

    public PropertyType(int id, String name, Class<T> type) {
        this.name = name;
        this.id = id;
        this.type = type;
        WeaponData.propertyTypes[id] = this;
        MapList.propertyTypes.put(name, this);
    }

    public static void init() {
    }

    public void serialize(DataOutput buf, WeaponData data, T value) throws IOException {
        if (this.type == Boolean.class) {
            buf.writeBoolean((Boolean)value);
        } else if (this.type == Integer.class) {
            buf.writeInt((Integer)value);
        } else if (this.type == Float.class) {
            buf.writeFloat(((Float)value).floatValue());
        } else if (this.type == String.class) {
            buf.writeUTF((String)value);
        }
    }

    public T deserialize(DataInput buf, WeaponData data) throws IOException {
        T prop = null;
        if (this.type == Boolean.class) {
            prop = this.type.cast(buf.readBoolean());
        } else if (this.type == Integer.class) {
            prop = this.type.cast(buf.readInt());
        } else if (this.type == Float.class) {
            prop = this.type.cast(Float.valueOf(buf.readFloat()));
        } else if (this.type == String.class) {
            prop = this.type.cast(buf.readUTF());
        }
        return prop;
    }

    public T getDefaultValue() {
        if (this.type == Boolean.class) {
            return this.type.cast(false);
        }
        if (this.type == Integer.class) {
            return this.type.cast(0);
        }
        if (this.type == Float.class) {
            return this.type.cast(Float.valueOf(0.0f));
        }
        if (this.type == String.class) {
            return this.type.cast("");
        }
        return null;
    }

    public boolean hasKey(WeaponData data) {
        return data.properties.get(this) != null;
    }

    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (this.type == Boolean.class) {
            return this.type.cast(json.getAsBoolean());
        }
        if (this.type == Integer.class) {
            return this.type.cast(json.getAsInt());
        }
        if (this.type == String.class) {
            return this.type.cast(json.getAsString());
        }
        if (this.type == Float.class) {
            return this.type.cast(Float.valueOf(json.getAsFloat()));
        }
        return null;
    }

    public static class PropertyTypeMap<T>
    extends PropertyType<Map<String, T>> {
        public Class<T> mapType;
        public static Map<?, ?> defaultValue = new HashMap();

        public PropertyTypeMap(int id, String name, Class<T> type) {
            super(id, name, null);
            this.mapType = type;
        }

        @Override
        public void serialize(DataOutput buf, WeaponData data, Map<String, T> value) throws IOException {
            buf.writeByte(value.size());
            for (Map.Entry<String, T> entry : value.entrySet()) {
                buf.writeUTF(entry.getKey());
                if (this.mapType == Boolean.class) {
                    buf.writeBoolean((Boolean)entry.getValue());
                    continue;
                }
                if (this.mapType == Integer.class) {
                    buf.writeInt((Integer)entry.getValue());
                    continue;
                }
                if (this.mapType == Float.class) {
                    buf.writeFloat(((Float)entry.getValue()).floatValue());
                    continue;
                }
                if (this.mapType != String.class) continue;
                buf.writeUTF((String)entry.getValue());
            }
        }

        @Override
        public Map<String, T> deserialize(DataInput buf, WeaponData data) throws IOException {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            int count = buf.readByte();
            for (int i = 0; i < count; ++i) {
                String name = buf.readUTF();
                Object value = null;
                if (this.mapType == Boolean.class) {
                    value = this.mapType.cast(buf.readBoolean());
                } else if (this.mapType == Integer.class) {
                    value = this.mapType.cast(buf.readInt());
                } else if (this.mapType == Float.class) {
                    value = this.mapType.cast(Float.valueOf(buf.readFloat()));
                } else if (this.mapType == String.class) {
                    value = this.mapType.cast(buf.readUTF());
                }
                prop.put(name, value);
            }
            return prop;
        }

        @Override
        public Map<String, T> getDefaultValue() {
            return defaultValue;
        }

        @Override
        public Map<String, T> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HashMap prop = new HashMap();
            for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                if (this.mapType == Boolean.class) {
                    prop.put(entry.getKey(), this.mapType.cast(((JsonElement)entry.getValue()).getAsBoolean()));
                    continue;
                }
                if (this.mapType == Integer.class) {
                    prop.put(entry.getKey(), this.mapType.cast(((JsonElement)entry.getValue()).getAsInt()));
                    continue;
                }
                if (this.mapType == String.class) {
                    prop.put(entry.getKey(), this.mapType.cast(((JsonElement)entry.getValue()).getAsString()));
                    continue;
                }
                if (this.mapType != Float.class) continue;
                prop.put(entry.getKey(), this.mapType.cast(Float.valueOf(((JsonElement)entry.getValue()).getAsFloat())));
            }
            return prop;
        }
    }
}

