/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import rafradek.TF2weapons.TF2EventsCommon;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.building.EntityDispenser;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.entity.building.EntityTeleporter;

public class PlayerPersistStorage
implements INBTSerializable<NBTTagCompound> {
    public final UUID uuid;
    public HashSet<BlockPos> lostMercPos = new HashSet();
    public HashSet<BlockPos> medicMercPos = new HashSet();
    public HashSet<BlockPos> restMercPos = new HashSet();
    public Tuple<UUID, NBTTagCompound>[] buildings = new Tuple[4];
    public ArrayList<UUID> disposableBuildings = new ArrayList(5);
    public NonNullList<ItemStack> itemsToGive = NonNullList.func_191196_a();
    public boolean save = false;

    public PlayerPersistStorage(UUID uuid) {
        this.uuid = uuid;
    }

    /*
     * WARNING - void declaration
     */
    public NBTTagCompound serializeNBT() {
        void var5_10;
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (BlockPos blockPos : this.lostMercPos) {
            list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()}));
        }
        NBTTagList list2 = new NBTTagList();
        for (BlockPos blockPos : this.medicMercPos) {
            list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()}));
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (BlockPos pos : this.restMercPos) {
            list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
        }
        tag.func_74782_a("MercsLost", (NBTBase)list);
        tag.func_74782_a("MercsMedic", (NBTBase)list2);
        tag.func_74782_a("MercsRest", (NBTBase)nBTTagList);
        if (this.buildings[0] != null) {
            tag.func_186854_a("SentryUUID", (UUID)this.buildings[0].func_76341_a());
            tag.func_74782_a("Sentry", (NBTBase)this.buildings[0].func_76340_b());
        }
        if (this.buildings[1] != null) {
            tag.func_186854_a("DispenserUUID", (UUID)this.buildings[1].func_76341_a());
            tag.func_74782_a("Dispenser", (NBTBase)this.buildings[1].func_76340_b());
        }
        if (this.buildings[2] != null) {
            tag.func_186854_a("TeleporterAUUID", (UUID)this.buildings[2].func_76341_a());
            tag.func_74782_a("TeleporterA", (NBTBase)this.buildings[2].func_76340_b());
        }
        if (this.buildings[3] != null) {
            tag.func_186854_a("TeleporterBUUID", (UUID)this.buildings[3].func_76341_a());
            tag.func_74782_a("TeleporterB", (NBTBase)this.buildings[3].func_76340_b());
        }
        tag.func_74774_a("DispBuildingsCount", (byte)this.disposableBuildings.size());
        boolean bl = false;
        while (var5_10 < this.disposableBuildings.size()) {
            tag.func_186854_a("SentryAdd" + (int)var5_10 + "UUID", this.disposableBuildings.get((int)var5_10));
            ++var5_10;
        }
        ItemStackHelper.func_191282_a((NBTTagCompound)tag, this.itemsToGive);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        int[] pos;
        int i;
        NBTTagList list;
        this.save = true;
        for (String key : nbt.func_74775_l("MercsLost").func_150296_c()) {
            list = nbt.func_150295_c(key, 11);
            for (i = 0; i < list.func_74745_c(); ++i) {
                pos = list.func_150306_c(i);
                this.lostMercPos.add(new BlockPos(pos[0], pos[1], pos[2]));
            }
        }
        for (String key : nbt.func_74775_l("MercsMedic").func_150296_c()) {
            list = nbt.func_150295_c(key, 11);
            for (i = 0; i < list.func_74745_c(); ++i) {
                pos = list.func_150306_c(i);
                this.medicMercPos.add(new BlockPos(pos[0], pos[1], pos[2]));
            }
        }
        for (String key : nbt.func_74775_l("MercsRest").func_150296_c()) {
            list = nbt.func_150295_c(key, 11);
            for (i = 0; i < list.func_74745_c(); ++i) {
                pos = list.func_150306_c(i);
                this.restMercPos.add(new BlockPos(pos[0], pos[1], pos[2]));
            }
        }
        if (nbt.func_186855_b("SentryUUID")) {
            this.buildings[0] = new Tuple((Object)nbt.func_186857_a("SentryUUID"), (Object)nbt.func_74775_l("Sentry"));
        }
        if (nbt.func_186855_b("DispenserUUID")) {
            this.buildings[1] = new Tuple((Object)nbt.func_186857_a("DispenserUUID"), (Object)nbt.func_74775_l("Dispenser"));
        }
        if (nbt.func_186855_b("TeleporterAUUID")) {
            this.buildings[2] = new Tuple((Object)nbt.func_186857_a("TeleporterAUUID"), (Object)nbt.func_74775_l("TeleporterA"));
        }
        if (nbt.func_186855_b("TeleporterBUUID")) {
            this.buildings[3] = new Tuple((Object)nbt.func_186857_a("TeleporterBUUID"), (Object)nbt.func_74775_l("TeleporterB"));
        }
        int count = nbt.func_74771_c("DispBuildingsCount");
        for (int i2 = 0; i2 < count; ++i2) {
            this.disposableBuildings.add(nbt.func_186857_a("SentryAdd" + i2 + "UUID"));
        }
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.itemsToGive);
    }

    public void setSave() {
        this.save = true;
    }

    public void setBuilding(EntityBuilding building, int maxsentries) {
        NBTTagCompound tag = new NBTTagCompound();
        building.func_70014_b(tag);
        if (building.getDisposableID() != -1) {
            this.disposableBuildings.add(building.func_110124_au());
            if (this.disposableBuildings.size() > maxsentries) {
                this.disposableBuildings.remove(0);
            }
        } else if (building instanceof EntitySentry) {
            this.buildings[0] = new Tuple((Object)building.func_110124_au(), (Object)tag);
        } else if (building instanceof EntityDispenser) {
            this.buildings[1] = new Tuple((Object)building.func_110124_au(), (Object)tag);
        } else if (building instanceof EntityTeleporter && ((EntityTeleporter)building).isExit()) {
            this.buildings[3] = new Tuple((Object)building.func_110124_au(), (Object)tag);
        } else {
            this.buildings[2] = new Tuple((Object)building.func_110124_au(), (Object)tag);
        }
        this.setSave();
    }

    public boolean hasBuilding(int slot) {
        return slot != 4 && this.buildings[slot] != null;
    }

    public boolean allowBuilding(EntityBuilding building) {
        if (building.getDisposableID() == -1) {
            return this.buildings[building.getBuildingID()] == null || ((UUID)this.buildings[building.getBuildingID()].func_76341_a()).equals(building.func_110124_au());
        }
        return this.disposableBuildings.contains(building.func_110124_au());
    }

    public static PlayerPersistStorage get(EntityPlayer player) {
        return PlayerPersistStorage.get(player.field_70170_p, player.func_110124_au());
    }

    public static PlayerPersistStorage get(World world, UUID uuid) {
        return ((TF2EventsCommon.TF2WorldStorage)world.getCapability(TF2weapons.WORLD_CAP, null)).getPlayerStorage(uuid);
    }
}

