/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import rafradek.TF2weapons.block.BlockOverheadDoor;
import rafradek.TF2weapons.common.TF2Attribute;

public class TileEntityUpgrades
extends TileEntity {
    public static final int UPGRADES_COUNT = 10;
    public HashMap<TF2Attribute, Integer> attributes = new HashMap();
    public List<TF2Attribute> attributeList = new ArrayList<TF2Attribute>();
    private int maxSize;
    public boolean placed;

    public TileEntityUpgrades() {
    }

    public TileEntityUpgrades(World world) {
        this.field_145850_b = world;
    }

    public void generateUpgrades(Random rand) {
        List<TF2Attribute> passAttributes = TF2Attribute.getAllPassibleAttributesForUpgradeStation();
        this.maxSize = passAttributes.size();
        int size = (int)((float)passAttributes.size() * 0.67f);
        for (int i = 0; i < size; ++i) {
            TF2Attribute attr;
            while (this.attributes.containsKey(attr = passAttributes.get(rand.nextInt(passAttributes.size()))) || attr.weight <= rand.nextInt(8)) {
            }
            this.attributeList.add(attr);
            boolean high = i % 2 == 0;
            this.attributes.put(attr, Math.max(1, Math.round((float)attr.numLevels * (high ? 1.0f : 0.5f))));
        }
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.attributeList.clear();
        this.attributes.clear();
        this.maxSize = compound.func_74765_d("MaxS");
        this.placed = compound.func_74767_n("Placed");
        if (compound.func_74764_b("Attributes") && this.maxSize == TF2Attribute.getAllPassibleAttributesForUpgradeStation().size()) {
            NBTTagCompound attrs = compound.func_74775_l("Attributes");
            NBTTagList attrList = (NBTTagList)compound.func_74781_a("AttributesList");
            for (String key : attrs.func_150296_c()) {
                this.attributes.put(TF2Attribute.attributes[Integer.parseInt(key)], attrs.func_74762_e(key));
            }
            for (int i = 0; i < attrList.func_74745_c(); ++i) {
                this.attributeList.add(TF2Attribute.attributes[attrList.func_186858_c(i)]);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound attrs = new NBTTagCompound();
        NBTTagList attrList = new NBTTagList();
        compound.func_74777_a("MaxS", (short)this.maxSize);
        compound.func_74782_a("Attributes", (NBTBase)attrs);
        compound.func_74782_a("AttributesList", (NBTBase)attrList);
        compound.func_74757_a("Placed", this.placed);
        for (TF2Attribute attr : this.attributeList) {
            if (attr == null) continue;
            attrList.func_74742_a((NBTBase)new NBTTagInt(attr.id));
            attrs.func_74768_a(String.valueOf(attr.id), this.attributes.get(attr).intValue());
        }
        return compound;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c() || (Boolean)newSate.func_177229_b((IProperty)BlockOverheadDoor.HOLDER) == false;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 29, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

