/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.tileentity;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import rafradek.TF2weapons.block.BlockRobotDeploy;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.entity.mercenary.TF2CharacterAdditionalData;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemMoney;
import rafradek.TF2weapons.item.ItemRobotPart;
import rafradek.TF2weapons.item.ItemToken;
import rafradek.TF2weapons.util.TF2Util;

public class TileEntityRobotDeploy
extends TileEntity
implements ITickable {
    public static final int[] NORMAL_REQUIRE = new int[]{2, 2, 1};
    public static final int[] GIANT_REQUIRE = new int[]{4, 5, 3};
    public static final int MONEY_NORMAL_REQUIRE = 20;
    public static final int MONEY_GIANT_REQUIRE = 100;
    boolean filled;
    private boolean joined;
    UUID owner;
    public ItemStackHandler weapon = new ItemStackHandler(9){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            String name = TF2Util.getWeaponUsedByClass(stack);
            if (name == null || ItemFromData.getSlotForClass(ItemFromData.getData(stack), name) > 4 || ItemFromData.getSlotForClass(ItemFromData.getData(stack), name) == -1) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            TileEntityRobotDeploy.this.calculateHasInput();
        }
    };
    public ItemStackHandler parts = new ItemStackHandler(ItemRobotPart.LEVEL.length){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!(stack.func_77973_b() instanceof ItemRobotPart) || stack.func_77952_i() != slot) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            TileEntityRobotDeploy.this.calculateHasInput();
        }
    };
    public ItemStackHandler money = new ItemStackHandler(3){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!(stack.func_77973_b() instanceof ItemMoney) || stack.func_77952_i() != slot) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            TileEntityRobotDeploy.this.calculateHasInput();
        }
    };
    private String ownerName;
    public int progress;
    public int maxprogress;
    int hasWeapon;
    String weaponName;
    public int progressClient;
    public int classType;

    public int getRequirement(int level) {
        if (this.joined) {
            return GIANT_REQUIRE[level];
        }
        return NORMAL_REQUIRE[level];
    }

    public int getCurrencyRequirement() {
        if (this.joined) {
            return 100;
        }
        return 20;
    }

    public boolean produceGiant() {
        return this.joined;
    }

    public void calculateHasInput() {
        int money;
        ItemStack stack;
        int i;
        this.hasWeapon = -1;
        this.weaponName = null;
        for (i = 0; i < this.weapon.getSlots(); ++i) {
            String name;
            stack = this.weapon.getStackInSlot(i);
            if (stack.func_190926_b() || (name = TF2Util.getWeaponUsedByClass(stack)) == null) continue;
            this.hasWeapon = i;
            this.weaponName = name;
            break;
        }
        this.filled = true;
        for (i = 0; i < this.parts.getSlots(); ++i) {
            stack = this.parts.getStackInSlot(i);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemRobotPart && stack.func_77952_i() == i && stack.func_190916_E() >= this.getRequirement(ItemRobotPart.LEVEL[i])) continue;
            this.filled = false;
            break;
        }
        if ((money = TF2Util.getTotalCurrency((IItemHandler)this.money)) < this.getCurrencyRequirement()) {
            this.filled = false;
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasWeapon >= 0 && this.filled) {
                if (this.progress == 0) {
                    int n = this.maxprogress = this.joined ? 800 : 500;
                }
                if (this.progress % 20 == 0) {
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 0);
                }
                if (++this.progress >= this.maxprogress) {
                    int i;
                    ItemStack stack = this.weapon.extractItem(this.hasWeapon, 64, false);
                    String weaponName = TF2Util.getWeaponUsedByClass(stack);
                    EnumFacing facing = (EnumFacing)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockRobotDeploy.FACING);
                    EntityTF2Character entity = (EntityTF2Character)EntityList.func_188429_b((ResourceLocation)new ResourceLocation("rafradek_tf2_weapons", weaponName), (World)this.field_145850_b);
                    BlockPos frontpos = this.field_174879_c.func_177972_a(facing);
                    entity.func_70107_b(frontpos.func_177958_n(), frontpos.func_177956_o(), frontpos.func_177952_p());
                    TF2CharacterAdditionalData data = new TF2CharacterAdditionalData();
                    data.team = 2;
                    data.isGiant = this.joined;
                    entity.robotStrength = 1.0f;
                    entity.setSharing(true);
                    entity.setOwnerID(this.ownerName, this.owner);
                    entity.func_180482_a(this.field_145850_b.func_175649_E(frontpos), data);
                    entity.func_70642_aH();
                    for (i = 0; i < entity.loadout.getSlots(); ++i) {
                        entity.loadout.setStackInSlot(i, ItemStack.field_190927_a);
                    }
                    entity.loadout.setStackInSlot(ItemFromData.getSlotForClass(ItemFromData.getData(stack), entity), stack);
                    entity.switchSlot(ItemFromData.getSlotForClass(ItemFromData.getData(stack), entity));
                    entity.setOrder(EntityTF2Character.Order.HOLD);
                    entity.setMoneyDrop(this.getCurrencyRequirement());
                    this.func_145831_w().func_72838_d((Entity)entity);
                    for (i = 0; i < this.parts.getSlots(); ++i) {
                        this.parts.extractItem(i, ItemRobotPart.LEVEL[i] == 2 ? 1 : 2, false);
                    }
                    TF2Util.setTotalCurrency((IItemHandler)this.money, 0, TF2Util.getTotalCurrency((IItemHandler)this.money) - this.getCurrencyRequirement());
                    this.progress = 0;
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 0);
                }
            } else if (this.progress > 0) {
                this.progress = 0;
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 0);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.owner != null) {
            compound.func_186854_a("Owner", this.owner);
            compound.func_74778_a("OwnerName", this.ownerName);
        }
        compound.func_74782_a("Weapons", (NBTBase)this.weapon.serializeNBT());
        compound.func_74782_a("Parts", (NBTBase)this.parts.serializeNBT());
        compound.func_74782_a("Money", (NBTBase)this.money.serializeNBT());
        compound.func_74777_a("Progress", (short)this.progress);
        compound.func_74777_a("MaxProgress", (short)this.maxprogress);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_186855_b("Owner")) {
            this.owner = compound.func_186857_a("Owner");
            this.ownerName = compound.func_74779_i("OwnerName");
        } else {
            this.owner = null;
        }
        this.weapon.deserializeNBT(compound.func_74775_l("Weapons"));
        this.parts.deserializeNBT(compound.func_74775_l("Parts"));
        this.money.deserializeNBT(compound.func_74775_l("Money"));
        this.progress = compound.func_74765_d("Progress");
        this.maxprogress = compound.func_74765_d("MaxProgress");
        this.calculateHasInput();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.maxprogress > 0) {
            tag.func_74774_a("P", (byte)((float)this.progress / (float)this.maxprogress * 7.0f));
            if (this.progress > 0) {
                tag.func_74774_a("C", (byte)ItemToken.getClassID(TF2Util.getWeaponUsedByClass(this.weapon.extractItem(this.hasWeapon, 64, true))));
            }
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, 9999, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.progressClient = pkt.func_148857_g().func_74771_c("P");
        this.classType = pkt.func_148857_g().func_74771_c("C");
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing.func_176740_k() == EnumFacing.Axis.Y) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.weapon);
            }
            if (facing.func_176740_k() == EnumFacing.Axis.X) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.parts);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.money);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void setOwner(String name, UUID uniqueID) {
        this.owner = uniqueID;
        this.ownerName = name;
    }

    public void onLoad() {
        this.joined = (Boolean)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockRobotDeploy.JOINED);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (newSate.func_177230_c() == oldState.func_177230_c()) {
            this.joined = (Boolean)newSate.func_177229_b((IProperty)BlockRobotDeploy.JOINED);
        }
        return oldState.func_177230_c() != newSate.func_177230_c() || (Boolean)newSate.func_177229_b((IProperty)BlockRobotDeploy.HOLDER) == false;
    }

    public void dropInventory() {
        int i;
        for (i = 0; i < this.parts.getSlots(); ++i) {
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.parts.extractItem(i, 64, false));
        }
        for (i = 0; i < this.weapon.getSlots(); ++i) {
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.weapon.extractItem(i, 64, false));
        }
        for (i = 0; i < this.money.getSlots(); ++i) {
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.money.extractItem(i, 64, false));
        }
    }
}

