/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.tileentity;

import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.block.BlockOverheadDoor;
import rafradek.TF2weapons.util.TF2Util;

public class TileEntityOverheadDoor
extends TileEntity
implements ITickable {
    public float amountScrolled = 1.0f;
    public Team team;
    public Allow allow;
    boolean entitySome;
    public BlockPos minBounds;
    public BlockPos maxBounds;
    public float motion;
    public boolean powered;
    public boolean hasEntity;
    public boolean clientOpen;
    public boolean lastIsEntity;
    public long tickTime;

    public float getUpSpeed() {
        return 0.25f;
    }

    public float getDownSpeed() {
        return 0.25f;
    }

    public void func_145843_s() {
        if (this.func_145830_o()) {
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                BlockPos sidepos = this.field_174879_c.func_177972_a(facing);
                TileEntity ent = this.field_145850_b.func_175625_s(sidepos);
                if (!(ent instanceof TileEntityOverheadDoor)) continue;
                ((TileEntityOverheadDoor)ent).updateMasterStatus();
            }
            this.dropController();
        }
        super.func_145843_s();
    }

    public void func_73660_a() {
        boolean isClosed;
        boolean isEntity;
        if (this.minBounds == null) {
            this.minBounds = this.field_174879_c;
        }
        if (this.minBounds != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.minBounds.func_177977_b());
            if (state.func_177230_c().isAir(state, (IBlockAccess)this.field_145850_b, this.minBounds.func_177977_b())) {
                this.minBounds = this.minBounds.func_177977_b();
            } else if (this.field_145850_b.func_180495_p(this.minBounds.func_177977_b()).func_177230_c() instanceof BlockOverheadDoor) {
                this.minBounds = this.minBounds.func_177977_b();
                this.amountScrolled += 1.0f;
            } else if (!(this.field_145850_b.func_180495_p(this.minBounds).func_177230_c() instanceof BlockOverheadDoor) && !this.field_145850_b.func_175623_d(this.minBounds)) {
                this.minBounds = new BlockPos(this.minBounds.func_177958_n(), this.field_174879_c.func_177956_o(), this.minBounds.func_177952_p());
            }
        }
        this.hasEntity = !this.field_145850_b.field_72995_K && this.allow != null && !this.powered ? this.field_145850_b.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(this.maxBounds, this.minBounds).func_72314_b(2.0, 1.0, 2.0), input -> this.allow == Allow.PLAYER && input instanceof EntityPlayer || this.allow == Allow.TEAM && input.func_96124_cp() == this.team || this.allow == Allow.ENTITY && input instanceof EntityLivingBase).size() > 0 : false;
        this.motion = 0.0f;
        boolean bl = isEntity = this.powered || this.hasEntity || this.entitySome || this.clientOpen;
        if (isEntity && !this.entitySome && !this.field_145850_b.field_72995_K) {
            this.updateAmountScrolled(15, false);
        }
        if (isEntity && (double)this.amountScrolled > 0.25) {
            this.motion = -this.getUpSpeed();
        }
        if (!isEntity && !this.entitySome && (float)(this.field_174879_c.func_177956_o() - this.minBounds.func_177956_o() + 1) > this.amountScrolled) {
            this.motion = this.getDownSpeed();
        }
        if (this.motion != 0.0f) {
            this.amountScrolled += this.motion;
        }
        if (this.lastIsEntity != isEntity) {
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, isEntity ? 1 : 0);
            if (!this.entitySome) {
                this.updateAmountScrolled(15, true);
            }
        }
        boolean bl2 = isClosed = this.field_145850_b.func_180495_p(this.minBounds).func_177230_c() == this.func_145838_q();
        if (isClosed && (float)(this.field_174879_c.func_177956_o() - this.minBounds.func_177956_o() + 1) > this.amountScrolled) {
            if (!this.field_145850_b.field_72995_K) {
                for (int y = this.field_174879_c.func_177956_o() - 1; y >= this.minBounds.func_177956_o(); --y) {
                    BlockPos doorpos = new BlockPos(this.field_174879_c.func_177958_n(), y, this.field_174879_c.func_177952_p());
                    if (this.field_145850_b.func_180495_p(doorpos).func_177230_c() != this.func_145838_q()) continue;
                    this.field_145850_b.func_175698_g(doorpos);
                }
                this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockOverheadDoor.SLIDING, (Comparable)Boolean.valueOf(true)));
            }
        } else if (!isClosed && (float)(this.field_174879_c.func_177956_o() - this.minBounds.func_177956_o() + 1) <= this.amountScrolled) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockOverheadDoor.HOLDER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockOverheadDoor.SLIDING, (Comparable)Boolean.valueOf(false));
            for (int y = this.field_174879_c.func_177956_o() - 1; y >= this.minBounds.func_177956_o(); --y) {
                BlockPos doorpos = new BlockPos(this.field_174879_c.func_177958_n(), y, this.field_174879_c.func_177952_p());
                if (this.field_145850_b.func_175623_d(doorpos)) {
                    if (this.field_145850_b.field_72995_K) continue;
                    this.field_145850_b.func_175656_a(doorpos, state);
                    continue;
                }
                this.minBounds = new BlockPos(this.field_174879_c.func_177958_n(), doorpos.func_177956_o() + 1, this.field_174879_c.func_177952_p());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockOverheadDoor.SLIDING, (Comparable)Boolean.valueOf(false)));
            }
        }
        this.lastIsEntity = isEntity;
        this.tickTime = this.field_145850_b.func_82737_E();
        this.entitySome = false;
    }

    public boolean isPowered() {
        return this.hasEntity || this.powered || this.clientOpen || this.entitySome;
    }

    public void updateAmountScrolled(int reach, boolean updateEvents) {
        BlockPos pos;
        TileEntity ent;
        int i;
        EnumFacing facing = ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176732_a(EnumFacing.Axis.Y);
        if (facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
            facing = facing.func_176734_d();
        }
        int axispos = TF2Util.getValueOnAxis((Vec3i)this.minBounds, facing.func_176740_k());
        int minReach = axispos - reach;
        int maxReach = axispos + reach;
        for (i = axispos - 1; i >= minReach && (ent = this.field_145850_b.func_175625_s(pos = TF2Util.setValueOnAxis((Vec3i)this.field_174879_c, facing.func_176740_k(), i))) instanceof TileEntityOverheadDoor; --i) {
            if (!(((TileEntityOverheadDoor)ent).amountScrolled >= this.amountScrolled)) continue;
            if (!updateEvents) {
                ((TileEntityOverheadDoor)ent).entitySome = true;
                continue;
            }
            this.field_145850_b.func_175641_c(pos, this.func_145838_q(), 1, ((TileEntityOverheadDoor)ent).isPowered() ? 1 : 0);
        }
        for (i = axispos + 1; i <= maxReach && (ent = this.field_145850_b.func_175625_s(pos = TF2Util.setValueOnAxis((Vec3i)this.field_174879_c, facing.func_176740_k(), i))) instanceof TileEntityOverheadDoor; ++i) {
            if (!(((TileEntityOverheadDoor)ent).amountScrolled >= this.amountScrolled)) continue;
            if (!updateEvents) {
                ((TileEntityOverheadDoor)ent).entitySome = true;
                continue;
            }
            this.field_145850_b.func_175641_c(pos, this.func_145838_q(), 1, ((TileEntityOverheadDoor)ent).isPowered() ? 1 : 0);
        }
    }

    public void onLoad() {
        this.updateMasterStatus();
    }

    public void updateMasterStatus() {
        EnumFacing facing = ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176732_a(EnumFacing.Axis.Y);
        if (facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
            facing = facing.func_176734_d();
        }
        BlockPos minBounds = this.field_174879_c;
        BlockPos maxBounds = this.field_174879_c;
        this.minBounds = minBounds;
        this.maxBounds = maxBounds;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            if (this.field_145850_b.field_72995_K) {
                this.clientOpen = type != 0;
            }
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c() || (Boolean)newSate.func_177229_b((IProperty)BlockOverheadDoor.HOLDER) == false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.minBounds == null) {
            return new AxisAlignedBB(this.field_174879_c);
        }
        return new AxisAlignedBB(this.field_174879_c, this.minBounds).func_186662_g(1.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.team != null) {
            compound.func_74778_a("Team", this.team.func_96661_b());
        }
        if (this.allow != null) {
            compound.func_74774_a("Allow", (byte)this.allow.ordinal());
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.func_145830_o() && compound.func_74764_b("Team")) {
            this.team = this.field_145850_b.func_96441_U().func_96508_e(compound.func_74779_i("Team"));
        }
        if (compound.func_74764_b("Allow")) {
            this.allow = Allow.values()[compound.func_74771_c("Allow")];
        }
    }

    public boolean setController(String string) {
        this.dropController();
        if (string.equals("players")) {
            this.allow = Allow.PLAYER;
        } else if (string.equals("mobs")) {
            this.allow = Allow.ENTITY;
        } else {
            ScorePlayerTeam target = this.field_145850_b.func_96441_U().func_96508_e(string);
            if (target == null) {
                return false;
            }
            this.allow = Allow.TEAM;
            this.team = target;
        }
        return true;
    }

    public void dropController() {
        if (this.allow == null) {
            return;
        }
        int meta = 0;
        if (this.allow == Allow.ENTITY) {
            meta = 1;
        } else if (this.allow == Allow.TEAM) {
            if (this.team != null && this.team.func_96661_b().equals("RED")) {
                meta = 2;
            } else if (this.team != null && this.team.func_96661_b().equals("BLU")) {
                meta = 3;
            }
        }
        this.func_145831_w().func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), new ItemStack(TF2weapons.itemDoorController, 1, meta)));
    }

    protected void func_190201_b(World worldIn) {
        this.func_145834_a(worldIn);
    }

    public static enum Allow {
        ENTITY,
        PLAYER,
        TEAM;

    }
}

