/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import rafradek.TF2weapons.block.BlockAmmoFurnace;
import rafradek.TF2weapons.inventory.ContainerAmmoFurnace;
import rafradek.TF2weapons.item.ItemAmmo;
import rafradek.TF2weapons.item.ItemFireAmmo;
import rafradek.TF2weapons.item.crafting.TF2CraftingManager;

public class TileEntityAmmoFurnace
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] SLOTS_BOTTOM = new int[]{10, 11, 12, 13, 14, 15, 16, 17, 18, 9};
    private static final int[] SLOTS_SIDES = new int[]{9};
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)19, (Object)ItemStack.field_190927_a);
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;
    private String furnaceCustomName;
    private int ammoSmeltType;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    @Nullable
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.furnaceItemStacks.get(index);
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.furnaceItemStacks, (int)index, (int)count);
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.furnaceItemStacks, (int)index);
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        boolean flag = !stack.func_190926_b() && stack.func_77969_a((ItemStack)this.furnaceItemStacks.get(index)) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)this.furnaceItemStacks.get(index)));
        this.furnaceItemStacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index < 9 && !flag) {
            this.totalCookTime = this.getCookTime(stack);
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.furnaceCustomName : "container.ammofurnace";
    }

    public boolean func_145818_k_() {
        return this.furnaceCustomName != null && !this.furnaceCustomName.isEmpty();
    }

    public void setCustomInventoryName(String p_145951_1_) {
        this.furnaceCustomName = p_145951_1_;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.furnaceItemStacks);
        this.furnaceBurnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileEntityAmmoFurnace.getItemBurnTime((ItemStack)this.furnaceItemStacks.get(1));
        if (compound.func_150297_b("CustomName", 8)) {
            this.furnaceCustomName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.furnaceBurnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.totalCookTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.furnaceItemStacks);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.furnaceCustomName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.isBurning() || this.furnaceItemStacks.get(9) != null) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityAmmoFurnace.getItemBurnTime((ItemStack)this.furnaceItemStacks.get(9));
                    if (this.isBurning()) {
                        flag1 = true;
                        if (this.furnaceItemStacks.get(9) != null) {
                            ((ItemStack)this.furnaceItemStacks.get(9)).func_190918_g(1);
                            if (((ItemStack)this.furnaceItemStacks.get(9)).func_190916_E() == 0) {
                                this.furnaceItemStacks.set(9, (Object)((ItemStack)this.furnaceItemStacks.get(9)).func_77973_b().getContainerItem((ItemStack)this.furnaceItemStacks.get(9)));
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime((ItemStack)this.furnaceItemStacks.get(0));
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                BlockAmmoFurnace.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int getCookTime(@Nullable ItemStack stack) {
        return 200;
    }

    private boolean canSmelt() {
        int[] ammoTypesCount = new int[ItemAmmo.AMMO_TYPES.length];
        for (int i = 0; i < 9; ++i) {
            ItemStack base = (ItemStack)this.furnaceItemStacks.get(i);
            if (base == null || base.func_77960_j() >= TF2CraftingManager.AMMO_RECIPES.length || !(base.func_77973_b() instanceof ItemAmmo) || base.func_77973_b() instanceof ItemFireAmmo || TF2CraftingManager.AMMO_RECIPES[base.func_77952_i()] == null) continue;
            int n = base.func_77952_i();
            ammoTypesCount[n] = ammoTypesCount[n] + base.func_190916_E();
            if (ammoTypesCount[base.func_77952_i()] < MathHelper.func_76123_f((float)((float)TF2CraftingManager.AMMO_RECIPES[base.func_77952_i()].func_77571_b().func_190916_E() * 1.2f))) continue;
            this.ammoSmeltType = base.func_77952_i();
            return true;
        }
        return false;
    }

    public void smeltItem() {
        int ammoToConsume = MathHelper.func_76123_f((float)((float)TF2CraftingManager.AMMO_RECIPES[this.ammoSmeltType].func_77571_b().func_190916_E() * 1.2f));
        for (int i = 0; i < 9; ++i) {
            ItemStack base = (ItemStack)this.furnaceItemStacks.get(i);
            if (base == null || !(base.func_77973_b() instanceof ItemAmmo) || base.func_77952_i() != this.ammoSmeltType) continue;
            ShapelessOreRecipe recipe = TF2CraftingManager.AMMO_RECIPES[base.func_77952_i()];
            int ammoConsumed = Math.min(base.func_190916_E(), ammoToConsume);
            base.func_190918_g(ammoConsumed);
            ammoToConsume -= ammoConsumed;
            if (base.func_190916_E() <= 0) {
                this.func_70299_a(i, ItemStack.field_190927_a);
            }
            if (ammoToConsume > 0) continue;
            block1: for (Ingredient obj : recipe.func_192400_c()) {
                ItemStack out = obj.func_193365_a()[0];
                for (int j = 10; j < 19; ++j) {
                    int size;
                    boolean handled = false;
                    ItemStack inSlot = this.func_70301_a(j);
                    if (inSlot.func_190926_b()) {
                        this.func_70299_a(j, out.func_77946_l());
                        handled = true;
                    } else if (out.func_77969_a(inSlot) && ItemStack.func_77970_a((ItemStack)out, (ItemStack)inSlot) && (size = out.func_190916_E() + inSlot.func_190916_E()) <= out.func_77976_d()) {
                        inSlot.func_190920_e(size);
                        handled = true;
                    }
                    if (handled) continue block1;
                }
            }
            return;
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_176223_P().func_185904_a() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && "WOOD".equals(((ItemTool)item).func_77861_e())) {
            return 200;
        }
        if (item instanceof ItemSword && "WOOD".equals(((ItemSword)item).func_150932_j())) {
            return 200;
        }
        if (item instanceof ItemHoe && "WOOD".equals(((ItemHoe)item).func_77842_f())) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityAmmoFurnace.getItemBurnTime(stack) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index > 9) {
            return false;
        }
        if (index != 9) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(9);
        return TileEntityAmmoFurnace.isItemFuel(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && (itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151133_ar);
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 9 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public String func_174875_k() {
        return "minecraft:furnace";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerAmmoFurnace(playerInventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            this.furnaceItemStacks.set(9, (Object)ItemStack.field_190927_a);
        }
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.furnaceItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

