/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.message.udp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.internal.SocketUtils;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.message.udp.TF2UdpServer;

public class UdpChannelHandlerServer
extends SimpleChannelInboundHandler<DatagramPacket> {
    public TF2UdpServer server;
    private Constructor<MessageContext> constr;

    public UdpChannelHandlerServer(TF2UdpServer server) {
        this.server = server;
    }

    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
        ByteBuf buffer = (ByteBuf)msg.content();
        short plid = buffer.readShort();
        int seq = buffer.readUnsignedShort();
        byte msgid = buffer.readByte();
        if (msgid == -128) {
            this.server.outboundTargets.put(plid, SocketUtils.socketAddress((String)((InetSocketAddress)msg.sender()).getAddress().getHostAddress(), (int)((InetSocketAddress)msg.sender()).getPort()));
        } else {
            EntityPlayerMP player = this.server.playerList.get(plid);
            IMessage message = TF2weapons.network.messages[msgid].newInstance();
            message.fromBytes(buffer);
            IMessageHandler<IMessage, IMessage> handler = TF2weapons.network.handlerList.get(message.getClass());
            if (this.constr == null) {
                this.constr = MessageContext.class.getDeclaredConstructor(INetHandler.class, Side.class);
                this.constr.setAccessible(true);
            }
            MessageContext context = this.constr.newInstance(player.field_71135_a, Side.SERVER);
            handler.onMessage(message, context);
        }
    }
}

