/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.message;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.WeaponData;

public class TF2WeaponDataHandler
implements IMessageHandler<TF2Message.WeaponDataMessage, IMessage> {
    public static int size;

    public IMessage onMessage(TF2Message.WeaponDataMessage message, MessageContext ctx) {
        try {
            DataInputStream input = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(message.bytes, 0, message.bytes.length))));
            MapList.nameToData.clear();
            MapList.buildInAttributes.clear();
            while (input.available() > 0) {
                WeaponData weapon = new WeaponData(input.readUTF());
                int propertyCount = input.readByte();
                for (int i = 0; i < propertyCount; ++i) {
                    byte propId = input.readByte();
                    PropertyType<?> prop = WeaponData.propertyTypes[propId];
                    weapon.properties.put(prop, prop.deserialize(input, weapon));
                }
                TF2weapons.loadWeapon(weapon.getName(), weapon);
                ClientProxy.RegisterWeaponData(weapon);
            }
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

