/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.message.udp.TF2UdpClient;

public class TF2NetworkWrapper
extends SimpleNetworkWrapper {
    public boolean useUdp;
    public HashMap<Class<? extends IMessage>, IMessageHandler<IMessage, IMessage>> handlerList;
    public HashSet<IMessageHandler<IMessage, IMessage>> udpEnabled;
    public HashMap<Class<? extends IMessage>, Byte> discriminators;
    public Class<? extends IMessage>[] messages = new Class[256];

    public TF2NetworkWrapper(String channelName) {
        super(channelName);
        this.udpEnabled = new HashSet();
        this.handlerList = new HashMap();
        this.discriminators = new HashMap();
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<? extends IMessageHandler<REQ, REPLY>> messageHandler, Class<REQ> requestMessageType, int discriminator, Side side, boolean useUdp) {
        try {
            this.registerMessage(messageHandler.newInstance(), requestMessageType, discriminator, side, useUdp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestMessageType, int discriminator, Side side, boolean useUdp) {
        super.registerMessage(messageHandler, requestMessageType, discriminator, side);
        if (useUdp) {
            this.handlerList.put(requestMessageType, messageHandler);
            this.messages[discriminator] = requestMessageType;
            this.discriminators.put(requestMessageType, (byte)discriminator);
        }
    }

    public void sendToAll(IMessage message) {
        if (this.useUdp && this.discriminators.containsKey(message.getClass())) {
            for (EntityPlayer player : TF2weapons.server.func_184103_al().func_181057_v()) {
                InetSocketAddress address = TF2weapons.udpServer.outboundTargets.get(((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).udpServerId);
                if (address != null) {
                    ByteBuf buffer = Unpooled.buffer();
                    buffer.writeShort(0);
                    buffer.writeByte((int)this.discriminators.get(message.getClass()).byteValue());
                    message.toBytes(buffer);
                    DatagramPacket packet = new DatagramPacket(buffer, address);
                    TF2weapons.udpServer.channel.writeAndFlush((Object)packet);
                    continue;
                }
                super.sendTo(message, (EntityPlayerMP)player);
            }
        } else {
            super.sendToAll(message);
        }
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        if (this.useUdp && this.discriminators.containsKey(message.getClass())) {
            InetSocketAddress address = TF2weapons.udpServer.outboundTargets.get(((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).udpServerId);
            if (address != null) {
                ByteBuf buffer = Unpooled.buffer();
                buffer.writeShort(0);
                buffer.writeByte((int)this.discriminators.get(message.getClass()).byteValue());
                message.toBytes(buffer);
                DatagramPacket packet = new DatagramPacket(buffer, address);
                TF2weapons.udpServer.channel.writeAndFlush((Object)packet);
            }
        } else {
            super.sendTo(message, player);
        }
    }

    public void sendToServer(IMessage message) {
        if (this.useUdp && TF2UdpClient.instance != null && this.discriminators.containsKey(message.getClass())) {
            InetSocketAddress address = TF2UdpClient.instance.address;
            if (address != null) {
                ByteBuf buffer = Unpooled.buffer();
                buffer.writeShort(TF2UdpClient.playerId);
                buffer.writeShort(0);
                buffer.writeByte((int)this.discriminators.get(message.getClass()).byteValue());
                message.toBytes(buffer);
                DatagramPacket packet = new DatagramPacket(buffer, address);
                TF2UdpClient.instance.channel.writeAndFlush((Object)packet);
            }
        } else {
            super.sendToServer(message);
        }
    }
}

