/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.message;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketAdvancementInfo;
import net.minecraft.network.play.server.SPacketSelectAdvancementsTab;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.util.Contract;

public abstract class TF2Message
implements IMessage {

    public static class ContractNewMessage
    extends TF2Message {
        Packet<?> packet;
        int type;

        public ContractNewMessage() {
        }

        public ContractNewMessage(Packet<?> packet) {
            if (packet instanceof SPacketAdvancementInfo) {
                this.type = 0;
            } else if (packet instanceof SPacketSelectAdvancementsTab) {
                this.type = 1;
            }
            this.packet = packet;
        }

        public void fromBytes(ByteBuf buf) {
            this.type = buf.readByte();
            this.packet = this.type == 0 ? new SPacketAdvancementInfo() : new SPacketSelectAdvancementsTab();
            try {
                this.packet.func_148837_a(new PacketBuffer(buf));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.type);
            try {
                this.packet.func_148840_b(new PacketBuffer(buf));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class InitClientMessage
    extends TF2Message {
        int sentryTargets;
        boolean dispenserPlayer;
        boolean teleporterPlayer;
        boolean teleporterEntity;
        boolean breakBlocks;

        public InitClientMessage() {
        }

        public InitClientMessage(Configuration conf) {
            ConfigCategory cat = conf.getCategory("default building targets");
            this.sentryTargets = cat.get("Attack on hurt").getBoolean() ? 1 : 0;
            this.sentryTargets += cat.get("Attack other players").getBoolean() ? 2 : 0;
            this.sentryTargets += cat.get("Attack hostile mobs").getBoolean() ? 4 : 0;
            this.sentryTargets += cat.get("Attack friendly creatures").getBoolean() ? 8 : 0;
            this.dispenserPlayer = cat.get("Dispensers heal neutral players").getBoolean();
            this.teleporterPlayer = cat.get("Neutral players can teleport").getBoolean();
            this.teleporterEntity = cat.get("Entities can teleport").getBoolean();
            this.breakBlocks = TF2ConfigVars.swapAttackButton;
        }

        public void fromBytes(ByteBuf buf) {
            this.sentryTargets = buf.readByte();
            this.dispenserPlayer = buf.readBoolean();
            this.teleporterPlayer = buf.readBoolean();
            this.teleporterEntity = buf.readBoolean();
            this.breakBlocks = buf.readBoolean();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.sentryTargets);
            buf.writeBoolean(this.dispenserPlayer);
            buf.writeBoolean(this.teleporterPlayer);
            buf.writeBoolean(this.teleporterEntity);
            buf.writeBoolean(this.breakBlocks);
        }
    }

    public static class InitMessage
    extends TF2Message {
        int port;
        int id;
        boolean energyUse;
        Multimap<String, Property> property;

        public InitMessage() {
        }

        public InitMessage(int port, int id, boolean energyUse) {
            this.port = port;
            this.id = id;
            this.energyUse = energyUse;
        }

        public void fromBytes(ByteBuf buf) {
            this.port = buf.readUnsignedShort();
            this.id = buf.readShort();
            this.energyUse = buf.readBoolean();
            PacketBuffer packet = new PacketBuffer(buf);
            this.property = HashMultimap.create();
            while (packet.readableBytes() > 0) {
                this.property.put((Object)packet.func_150789_c(255), (Object)new Property(packet.func_150789_c(255), packet.func_150789_c(255), Property.Type.STRING));
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeShort(this.port);
            buf.writeShort(this.id);
            buf.writeBoolean(this.energyUse);
            PacketBuffer packet = new PacketBuffer(buf);
            for (Map.Entry entry : TF2ConfigVars.propertyNetworked.entries()) {
                packet.func_180714_a(((ConfigCategory)entry.getKey()).getName());
                packet.func_180714_a(((Property)entry.getValue()).getName());
                packet.func_180714_a(((Property)entry.getValue()).getString());
            }
        }
    }

    public static class NetworkedSoundStopMessage
    extends TF2Message {
        int id;

        public NetworkedSoundStopMessage() {
        }

        public NetworkedSoundStopMessage(int id) {
            this.id = id;
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readShort();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeShort(this.id);
        }
    }

    public static class NetworkedSoundMessage
    extends TF2Message {
        SoundEvent event;
        int target;
        Vec3d pos;
        float volume;
        float pitch;
        SoundCategory category;
        int id;
        boolean repeat;

        public NetworkedSoundMessage() {
        }

        private NetworkedSoundMessage(SoundEvent event, float volume, float pitch, SoundCategory category, int id, boolean repeat) {
            this.event = event;
            this.volume = volume;
            this.pitch = pitch;
            this.category = category;
            this.id = id;
            this.repeat = true;
        }

        public NetworkedSoundMessage(Entity entity, SoundEvent event, float volume, float pitch, SoundCategory category, int id, boolean repeat) {
            this(event, volume, pitch, category, id, repeat);
            this.target = entity.func_145782_y();
        }

        public NetworkedSoundMessage(Vec3d pos, SoundEvent event, float volume, float pitch, SoundCategory category, int id, boolean repeat) {
            this(event, volume, pitch, category, id, repeat);
            this.pos = pos;
        }

        public void fromBytes(ByteBuf buf) {
            this.event = (SoundEvent)SoundEvent.field_187505_a.func_148754_a(buf.readInt());
            this.volume = buf.readFloat();
            this.pitch = buf.readFloat();
            this.category = SoundCategory.values()[buf.readByte()];
            this.id = buf.readShort();
            this.repeat = buf.readBoolean();
            if (buf.readableBytes() > 4) {
                this.pos = new Vec3d((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
            } else {
                this.target = buf.readInt();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(SoundEvent.field_187505_a.func_148757_b((Object)this.event));
            buf.writeFloat(this.volume);
            buf.writeFloat(this.pitch);
            buf.writeByte(this.category.ordinal());
            buf.writeShort(this.id);
            buf.writeBoolean(this.repeat);
            if (this.pos != null) {
                buf.writeFloat((float)this.pos.field_72450_a);
                buf.writeFloat((float)this.pos.field_72448_b);
                buf.writeFloat((float)this.pos.field_72449_c);
            } else {
                buf.writeInt(this.target);
            }
        }
    }

    public static class AttackSyncMessage
    extends TF2Message {
        long time;
        int entity;

        public AttackSyncMessage() {
        }

        public AttackSyncMessage(long value, EntityLivingBase entity) {
            this.time = value;
            this.entity = entity.func_145782_y();
        }

        public AttackSyncMessage(long value) {
            this.time = value;
        }

        public void fromBytes(ByteBuf buf) {
            this.time = buf.readLong();
            if (buf.readableBytes() > 0) {
                this.entity = buf.readInt();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeLong(this.time);
            if (this.entity != 0) {
                buf.writeInt(this.entity);
            }
        }
    }

    public static class VelocityAddMessage
    extends TF2Message {
        public float x;
        public float y;
        public float z;
        public boolean airborne;

        public VelocityAddMessage() {
        }

        public VelocityAddMessage(Vec3d vec, boolean airborne) {
            this.x = (float)vec.field_72450_a;
            this.y = (float)vec.field_72448_b;
            this.z = (float)vec.field_72449_c;
            this.airborne = airborne;
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readFloat();
            this.y = buf.readFloat();
            this.z = buf.readFloat();
            this.airborne = buf.readBoolean();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeFloat(this.x);
            buf.writeFloat(this.y);
            buf.writeFloat(this.z);
            buf.writeBoolean(this.airborne);
        }
    }

    public static class ParticleSpawnMessage
    extends TF2Message {
        public float x;
        public float y;
        public float z;
        public float offsetX;
        public float offsetY;
        public float offsetZ;
        public int count;
        public int[] params;
        public int id;

        public ParticleSpawnMessage() {
        }

        public ParticleSpawnMessage(int id, double x, double y, double z, double offsetX, double offsetY, double offsetZ, int count, int[] params) {
            this.id = id;
            this.x = (float)x;
            this.y = (float)y;
            this.z = (float)z;
            this.offsetX = (float)offsetX;
            this.offsetY = (float)offsetY;
            this.offsetZ = (float)offsetZ;
            this.count = count;
            this.params = params;
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readByte();
            this.x = buf.readFloat();
            this.y = buf.readFloat();
            this.z = buf.readFloat();
            this.offsetX = buf.readFloat();
            this.offsetY = buf.readFloat();
            this.offsetZ = buf.readFloat();
            this.count = buf.readByte();
            this.params = new int[buf.readableBytes() / 4];
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i] = buf.readInt();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.id);
            buf.writeFloat(this.x);
            buf.writeFloat(this.y);
            buf.writeFloat(this.z);
            buf.writeFloat(this.offsetX);
            buf.writeFloat(this.offsetY);
            buf.writeFloat(this.offsetZ);
            buf.writeByte(this.count);
            for (int param : this.params) {
                buf.writeInt(param);
            }
        }
    }

    public static class ContractMessage
    extends TF2Message {
        public int id;
        public Contract contract;

        public ContractMessage() {
        }

        public ContractMessage(int id, Contract contract) {
            this.id = id;
            this.contract = contract;
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readByte();
            String name = new PacketBuffer(buf).func_150789_c(256);
            int expireDay = buf.readInt();
            short progress = buf.readShort();
            Contract.Objective[] objectives = new Contract.Objective[buf.readByte()];
            for (int i = 0; i < objectives.length; ++i) {
                objectives[i] = Contract.Objective.values()[buf.readByte()];
            }
            this.contract = new Contract(name, expireDay, objectives);
            this.contract.progress = progress;
            this.contract.active = buf.readBoolean();
            this.contract.rewards = buf.readByte();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.id);
            new PacketBuffer(buf).func_180714_a(this.contract.className);
            buf.writeInt(this.contract.expireDay);
            buf.writeShort(this.contract.progress);
            buf.writeByte(this.contract.objectives.length);
            for (Contract.Objective obj : this.contract.objectives) {
                buf.writeByte(obj.ordinal());
            }
            buf.writeBoolean(this.contract.active);
            buf.writeByte(this.contract.rewards);
        }
    }

    public static class EffectCooldownMessage
    extends TF2Message {
        public String name;
        public int time;

        public EffectCooldownMessage() {
        }

        public EffectCooldownMessage(String name, int time) {
            this.time = time;
            this.name = name;
        }

        public void fromBytes(ByteBuf buf) {
            this.name = new PacketBuffer(buf).func_150789_c(256);
            this.time = buf.readShort();
        }

        public void toBytes(ByteBuf buf) {
            new PacketBuffer(buf).func_180714_a(this.name);
            buf.writeShort(this.time);
        }
    }

    public static class WeaponDroppedMessage
    extends TF2Message {
        public String name;

        public WeaponDroppedMessage() {
        }

        public WeaponDroppedMessage(String name) {
            this.name = name;
        }

        public void fromBytes(ByteBuf buf) {
            this.name = new PacketBuffer(buf).func_150789_c(256);
        }

        public void toBytes(ByteBuf buf) {
            new PacketBuffer(buf).func_180714_a(this.name);
        }
    }

    public static class WearableChangeMessage
    extends TF2Message {
        public int slot;
        public int entityID;
        public ItemStack stack;

        public WearableChangeMessage() {
        }

        public WearableChangeMessage(Entity player, int slot, ItemStack stack) {
            this.slot = slot;
            this.entityID = player.func_145782_y();
            this.stack = stack;
        }

        public void fromBytes(ByteBuf buf) {
            this.slot = buf.readByte();
            this.entityID = buf.readInt();
            try {
                this.stack = new PacketBuffer(buf).func_150791_c();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.slot);
            buf.writeInt(this.entityID);
            new PacketBuffer(buf).func_150788_a(this.stack);
        }
    }

    public static class WeaponDataMessage
    extends TF2Message {
        byte[] bytes;

        public WeaponDataMessage() {
        }

        public WeaponDataMessage(byte[] bytes) {
            this.bytes = bytes;
        }

        public void fromBytes(ByteBuf buf) {
            this.bytes = new byte[buf.readableBytes()];
            buf.readBytes(this.bytes);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeBytes(this.bytes);
        }
    }

    public static class ShowGuiMessage
    extends TF2Message {
        public int id;

        public ShowGuiMessage() {
        }

        public ShowGuiMessage(int id) {
            this.id = id;
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readByte();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.id);
        }
    }

    public static class GuiConfigMessage
    extends TF2Message {
        int entityid;
        BlockPos pos;
        boolean isTile;
        byte id;
        boolean exit;
        boolean grab;
        int value;
        int targetFlags;

        public GuiConfigMessage() {
        }

        public GuiConfigMessage(int entityID, byte id, int value) {
            this.isTile = true;
            this.id = id;
            this.value = value;
            this.entityid = entityID;
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readByte();
            this.entityid = buf.readInt();
            this.value = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte((int)this.id);
            buf.writeInt(this.entityid);
            buf.writeInt(this.value);
        }
    }

    public static class BulletMessage
    extends TF2Message {
        public ArrayList<RayTraceResult> target;
        public ArrayList<Object[]> readData;
        public int slot;
        public EnumHand hand;

        public BulletMessage() {
        }

        public BulletMessage(int slot, ArrayList<RayTraceResult> target, EnumHand hand) {
            this.slot = slot;
            this.target = target;
            this.hand = hand;
        }

        public void fromBytes(ByteBuf buf) {
            this.slot = buf.readByte();
            this.hand = buf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
            this.readData = new ArrayList();
            while (buf.readableBytes() > 0) {
                Object[] obj = new Object[]{buf.readInt(), buf.readBoolean(), Float.valueOf(buf.readFloat())};
                this.readData.add(obj);
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.slot);
            buf.writeBoolean(this.hand == EnumHand.MAIN_HAND);
            for (RayTraceResult mop : this.target) {
                buf.writeInt(mop.field_72308_g.func_145782_y());
                buf.writeBoolean(((float[])mop.hitInfo)[0] == 1.0f);
                buf.writeFloat(((float[])mop.hitInfo)[1]);
            }
        }
    }

    public static class PlayerCapabilityMessage
    extends TF2Message {
        List<EntityDataManager.DataEntry<?>> entries;
        int entityID;

        public PlayerCapabilityMessage() {
        }

        public PlayerCapabilityMessage(Entity entity, boolean sendAll) {
            TF2PlayerCapability cap = (TF2PlayerCapability)entity.getCapability(TF2weapons.PLAYER_CAP, null);
            this.entityID = entity.func_145782_y();
            this.entries = sendAll ? cap.dataManager.func_187231_c() : cap.dataManager.func_187221_b();
        }

        public void fromBytes(ByteBuf buf) {
            this.entityID = buf.readInt();
            try {
                this.entries = EntityDataManager.func_187215_b((PacketBuffer)new PacketBuffer(buf));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.entityID);
            try {
                EntityDataManager.func_187229_a(this.entries, (PacketBuffer)new PacketBuffer(buf));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class CapabilityMessage
    extends TF2Message {
        int entityID;
        long totalTime;
        List<EntityDataManager.DataEntry<?>> entries;
        boolean sendAll;

        public CapabilityMessage() {
        }

        public CapabilityMessage(Entity entity, boolean sendAll) {
            WeaponsCapability cap = (WeaponsCapability)entity.getCapability(TF2weapons.WEAPONS_CAP, null);
            this.entityID = entity.func_145782_y();
            this.totalTime = cap.ticksTotal;
            this.entries = sendAll ? cap.dataManager.func_187231_c() : cap.dataManager.func_187221_b();
        }

        public void fromBytes(ByteBuf buf) {
            this.entityID = buf.readInt();
            this.totalTime = buf.readLong();
            try {
                this.entries = EntityDataManager.func_187215_b((PacketBuffer)new PacketBuffer(buf));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.entityID);
            buf.writeLong(this.totalTime);
            try {
                EntityDataManager.func_187229_a(this.entries, (PacketBuffer)new PacketBuffer(buf));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class PropertyMessage
    extends TF2Message {
        String name;
        int intValue;
        float floatValue;
        short shortValue;
        byte byteValue;
        String stringValue;
        int entityID;
        byte type;

        public PropertyMessage() {
        }

        public PropertyMessage(String name, Number value) {
            this.name = name;
            if (value instanceof Integer) {
                this.type = 0;
                this.intValue = value.intValue();
            } else if (value instanceof Float) {
                this.type = 1;
                this.floatValue = value.floatValue();
            } else if (value instanceof Byte) {
                this.type = (byte)2;
                this.byteValue = value.byteValue();
            }
        }

        public PropertyMessage(String name, Number value, Entity entity) {
            this(name, value);
            this.entityID = entity.func_145782_y();
        }

        public PropertyMessage(String name, String value, Entity entity) {
            this.type = (byte)3;
            this.name = name;
            this.stringValue = value;
            this.entityID = entity.func_145782_y();
        }

        public void fromBytes(ByteBuf buf) {
            this.entityID = buf.readInt();
            this.type = buf.readByte();
            if (this.type == 0) {
                this.intValue = buf.readInt();
            } else if (this.type == 1) {
                this.floatValue = buf.readFloat();
            } else if (this.type == 2) {
                this.byteValue = buf.readByte();
            } else if (this.type == 3) {
                byte stringLength = buf.readByte();
                this.stringValue = buf.toString(buf.readerIndex(), (int)stringLength, StandardCharsets.UTF_8);
                buf.readerIndex(buf.readerIndex() + stringLength);
            }
            this.name = buf.toString(buf.readerIndex(), buf.readableBytes(), StandardCharsets.UTF_8);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.entityID);
            buf.writeByte((int)this.type);
            if (this.type == 0) {
                buf.writeInt(this.intValue);
            } else if (this.type == 1) {
                buf.writeFloat(this.floatValue);
            } else if (this.type == 2) {
                buf.writeByte((int)this.byteValue);
            } else if (this.type == 3) {
                byte[] stringValueArray = this.stringValue.getBytes(StandardCharsets.UTF_8);
                buf.writeByte(stringValueArray.length);
                buf.writeBytes(stringValueArray);
            }
            byte[] stringNameArray = this.name.getBytes(StandardCharsets.UTF_8);
            buf.writeBytes(stringNameArray);
        }
    }

    public static class PredictionMessage
    extends TF2Message {
        public double x;
        public double y;
        public double z;
        public float pitch;
        public float yaw;
        public long time;
        public EnumHand hand;
        public List<RayTraceResult> target;
        public List<Object[]> readData;
        public int state;

        public PredictionMessage() {
        }

        public PredictionMessage(double x, double y, double z, float pitch, float yaw, int state, EnumHand hand) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.pitch = pitch;
            this.yaw = yaw;
            this.hand = hand;
            this.state = state;
        }

        public PredictionMessage(double x, double y, double z, float pitch, float yaw, int state, EnumHand hand, List<RayTraceResult> target2) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.pitch = pitch;
            this.yaw = yaw;
            this.hand = hand;
            this.target = target2;
            this.state = state;
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
            this.pitch = buf.readFloat();
            this.yaw = buf.readFloat();
            this.hand = buf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
            this.state = buf.readByte();
            if (buf.readableBytes() > 0) {
                this.readData = new ArrayList<Object[]>();
                while (buf.readableBytes() > 0) {
                    Object[] obj = new Object[9];
                    if (buf.readBoolean()) {
                        obj[0] = buf.readInt();
                        obj[1] = buf.readBoolean();
                    } else {
                        obj[1] = buf.readByte();
                        obj[3] = buf.readInt();
                        obj[4] = buf.readInt();
                        obj[5] = buf.readInt();
                    }
                    obj[6] = buf.readByte();
                    obj[7] = buf.readByte();
                    obj[8] = buf.readByte();
                    obj[2] = Float.valueOf(buf.readFloat());
                    this.readData.add(obj);
                }
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.writeFloat(this.pitch);
            buf.writeFloat(this.yaw);
            buf.writeBoolean(this.hand == EnumHand.MAIN_HAND);
            buf.writeByte(this.state);
            if (this.target != null) {
                for (RayTraceResult mop : this.target) {
                    if (mop.field_72308_g != null) {
                        buf.writeBoolean(true);
                        buf.writeInt(mop.field_72308_g.func_145782_y());
                        buf.writeBoolean(((float[])mop.hitInfo)[0] == 1.0f);
                        buf.writeByte((int)((byte)((mop.field_72307_f.field_72450_a - mop.field_72308_g.field_70165_t) * 16.0)));
                        buf.writeByte((int)((byte)((mop.field_72307_f.field_72448_b - mop.field_72308_g.field_70163_u) * 16.0)));
                        buf.writeByte((int)((byte)((mop.field_72307_f.field_72449_c - mop.field_72308_g.field_70161_v) * 16.0)));
                    } else {
                        buf.writeBoolean(false);
                        buf.writeByte(mop.field_178784_b.func_176745_a());
                        buf.writeInt(mop.func_178782_a().func_177958_n());
                        buf.writeInt(mop.func_178782_a().func_177956_o());
                        buf.writeInt(mop.func_178782_a().func_177952_p());
                        buf.writeByte((int)((byte)((mop.field_72307_f.field_72450_a - (double)mop.func_178782_a().func_177958_n()) * 16.0)));
                        buf.writeByte((int)((byte)((mop.field_72307_f.field_72448_b - (double)mop.func_178782_a().func_177956_o()) * 16.0)));
                        buf.writeByte((int)((byte)((mop.field_72307_f.field_72449_c - (double)mop.func_178782_a().func_177952_p()) * 16.0)));
                    }
                    buf.writeFloat(((float[])mop.hitInfo)[1]);
                }
            }
        }
    }

    public static class UseMessage
    extends TF2Message {
        int value;
        int newAmmo;
        boolean reload;
        EnumHand hand;

        public UseMessage() {
        }

        public UseMessage(int value, boolean reload, int newAmmoValue, EnumHand hand) {
            this.value = value;
            this.newAmmo = newAmmoValue;
            this.reload = reload;
            this.hand = hand;
        }

        public void fromBytes(ByteBuf buf) {
            this.value = buf.readShort();
            this.reload = buf.readBoolean();
            this.newAmmo = buf.readShort();
            this.hand = buf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeShort(this.value);
            buf.writeBoolean(this.reload);
            buf.writeShort(this.newAmmo);
            buf.writeBoolean(this.hand == EnumHand.MAIN_HAND);
        }
    }

    public static class DisguiseMessage
    extends TF2Message {
        String value;

        public DisguiseMessage() {
        }

        public DisguiseMessage(String name) {
            this.value = name;
        }

        public void fromBytes(ByteBuf buf) {
            byte stringLength = buf.readByte();
            this.value = buf.toString(buf.readerIndex(), (int)stringLength, StandardCharsets.UTF_8);
            buf.readerIndex(buf.readerIndex() + stringLength);
        }

        public void toBytes(ByteBuf buf) {
            byte[] stringValueArray = this.value.getBytes(StandardCharsets.UTF_8);
            buf.writeByte(stringValueArray.length);
            buf.writeBytes(stringValueArray);
        }
    }

    public static class ActionMessage
    extends TF2Message {
        int value;
        int entity;

        public ActionMessage() {
        }

        public ActionMessage(int value, EntityLivingBase entity) {
            this.value = value;
            this.entity = entity.func_145782_y();
        }

        public ActionMessage(int value) {
            this.value = value;
        }

        public void fromBytes(ByteBuf buf) {
            this.value = buf.readByte();
            if (buf.readableBytes() > 0) {
                this.entity = buf.readInt();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.value);
            if (this.entity != 0) {
                buf.writeInt(this.entity);
            }
        }
    }
}

