/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.loot;

import com.google.common.base.Predicate;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.WeaponData;

public class RandomWeaponFunction
extends LootFunction {
    public RandomValueRange upgradeRange;
    public float valveWepChance;

    public RandomWeaponFunction(LootCondition[] conditionsIn, RandomValueRange range, float valve) {
        super(conditionsIn);
        this.upgradeRange = range;
        this.valveWepChance = valve;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        stack = this.valveWepChance * 0.35f < rand.nextFloat() ? ItemFromData.getRandomWeapon(rand, (Predicate<WeaponData>)((Predicate)input -> !input.getBoolean(PropertyType.HIDDEN) && input.getInt(PropertyType.ROLL_HIDDEN) == 0 && !input.getString(PropertyType.CLASS).equals("cosmetic") && !input.getString(PropertyType.CLASS).equals("crate"))) : ItemFromData.getRandomWeapon(rand, (Predicate<WeaponData>)((Predicate)input -> input.getInt(PropertyType.ROLL_HIDDEN) == 2));
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemWeapon && this.valveWepChance >= rand.nextFloat()) {
            stack.func_77978_p().func_74757_a("Valve", true);
            TF2Attribute.setAttribute(stack, TF2Attribute.attributes[0], 1.15f);
            TF2Attribute.setAttribute(stack, TF2Attribute.attributes[2], 2.5f);
            TF2Attribute.setAttribute(stack, TF2Attribute.attributes[6], 0.85f);
            TF2Attribute.setAttribute(stack, TF2Attribute.attributes[61], 1.5f);
            TF2Attribute.setAttribute(stack, TF2Attribute.attributes[37], 1.0f);
            TF2Attribute.setAttribute(stack, TF2Attribute.attributes[45], 5.0f);
            TF2Attribute.setAttribute(stack, TF2Attribute.attributes[48], 5.0f);
            TF2Attribute.setAttribute(stack, TF2Attribute.attributes[49], 0.85f);
            TF2Attribute.setAttribute(stack, TF2Attribute.attributes[46], 1.15f);
        }
        if (this.upgradeRange.func_186512_b() > 0.0f) {
            TF2Attribute.upgradeItemStack(stack, this.upgradeRange.func_186511_a(rand), rand);
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<RandomWeaponFunction> {
        public Serializer() {
            super(new ResourceLocation("set_weapon_upgraded"), RandomWeaponFunction.class);
        }

        public void serialize(JsonObject object, RandomWeaponFunction functionClazz, JsonSerializationContext serializationContext) {
            object.add("upgrade_range", serializationContext.serialize((Object)functionClazz.upgradeRange));
            object.add("valve_chance", serializationContext.serialize((Object)Float.valueOf(functionClazz.valveWepChance)));
        }

        public RandomWeaponFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            return new RandomWeaponFunction(conditionsIn, (RandomValueRange)JsonUtils.func_188174_a((JsonObject)object, (String)"upgrade_range", (JsonDeserializationContext)deserializationContext, RandomValueRange.class), object.get("valve_chance").getAsFloat());
        }
    }
}

