/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item.crafting;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.crafting.AustraliumRecipe;
import rafradek.TF2weapons.item.crafting.IngredientWeapon;
import rafradek.TF2weapons.item.crafting.JumperRecipe;
import rafradek.TF2weapons.item.crafting.OpenCrateRecipe;
import rafradek.TF2weapons.item.crafting.RecipeApplyEffect;
import rafradek.TF2weapons.item.crafting.RecipeToScrap;
import rafradek.TF2weapons.item.crafting.RecipeToken;

public class TF2CraftingManager {
    public static final ShapelessOreRecipe[] AMMO_RECIPES = new ShapelessOreRecipe[14];
    public static final TF2CraftingManager INSTANCE = new TF2CraftingManager();
    private final List<IRecipe> recipes = Lists.newArrayList();
    private final Map<IRecipe, Predicate<EntityPlayer>> recipeConditions = new HashMap<IRecipe, Predicate<EntityPlayer>>();

    public TF2CraftingManager() {
        ItemStack bonk = ItemFromData.getNewStack("bonk");
        bonk.func_190920_e(2);
        ItemStack cola = ItemFromData.getNewStack("critcola");
        cola.func_190920_e(2);
        TF2CraftingManager.AMMO_RECIPES[1] = new ShapelessOreRecipe(null, new ItemStack(TF2weapons.itemAmmo, 16, 1), new Object[]{"ingotCopper", "ingotLead", "gunpowder"});
        this.addRecipe((IRecipe)TF2CraftingManager.AMMO_RECIPES[1]);
        this.addRecipe((IRecipe)new ShapelessOreRecipe(null, new ItemStack(TF2weapons.itemAmmoMinigun, 1, 0), new Object[]{"ingotCopper", "ingotLead", "gunpowder", "ingotCopper", "ingotLead", "gunpowder", "gunpowder"}));
        this.addRecipe((IRecipe)new ShapelessOreRecipe(null, new ItemStack(TF2weapons.itemAmmoPistol, 5, 0), new Object[]{"ingotCopper", "ingotLead", "gunpowder"}));
        TF2CraftingManager.AMMO_RECIPES[4] = new ShapelessOreRecipe(null, new ItemStack(TF2weapons.itemAmmo, 20, 4), new Object[]{"ingotCopper", "ingotLead", "gunpowder"});
        this.addRecipe((IRecipe)TF2CraftingManager.AMMO_RECIPES[4]);
        TF2CraftingManager.AMMO_RECIPES[5] = new ShapelessOreRecipe(null, new ItemStack(TF2weapons.itemAmmoSMG, 4, 0), new Object[]{"ingotCopper", "ingotLead", "gunpowder"});
        this.addRecipe((IRecipe)TF2CraftingManager.AMMO_RECIPES[5]);
        TF2CraftingManager.AMMO_RECIPES[6] = new ShapelessOreRecipe(null, new ItemStack(TF2weapons.itemAmmo, 5, 6), new Object[]{"ingotCopper", "ingotLead", "gunpowder"});
        this.addRecipe((IRecipe)TF2CraftingManager.AMMO_RECIPES[6]);
        TF2CraftingManager.AMMO_RECIPES[7] = new ShapelessOreRecipe(null, new ItemStack(TF2weapons.itemAmmo, 22, 7), new Object[]{"ingotIron", "ingotIron", Blocks.field_150335_W});
        this.addRecipe((IRecipe)TF2CraftingManager.AMMO_RECIPES[7]);
        TF2CraftingManager.AMMO_RECIPES[8] = new ShapelessOreRecipe(null, new ItemStack(TF2weapons.itemAmmo, 22, 8), new Object[]{"ingotIron", "ingotIron", Blocks.field_150335_W});
        this.addRecipe((IRecipe)TF2CraftingManager.AMMO_RECIPES[8]);
        TF2CraftingManager.AMMO_RECIPES[11] = new ShapelessOreRecipe(null, new ItemStack(TF2weapons.itemAmmo, 18, 11), new Object[]{"ingotIron", "ingotIron", Blocks.field_150335_W});
        this.addRecipe((IRecipe)TF2CraftingManager.AMMO_RECIPES[11]);
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, new ItemStack(TF2weapons.itemAmmo, 11, 13), new Object[]{" R ", "RIR", " R ", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone"}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, new ItemStack(TF2weapons.itemAmmo, 8, 14), new Object[]{" S ", "SLS", " S ", Character.valueOf('S'), "string", Character.valueOf('L'), "leather"}));
        this.addShapelessRecipe(new ItemStack(TF2weapons.itemAmmoMedigun, 1), Items.field_151060_bw, Items.field_151073_bk, new ItemStack(Items.field_151100_aR, 1, 15));
        this.addRecipe((IRecipe)new ShapelessOreRecipe(null, new ItemStack(TF2weapons.itemAmmoFire, 1), new Object[]{"ingotIron", Items.field_151064_bs, "ingotIron"}));
        TF2CraftingManager.AMMO_RECIPES[9] = new ShapelessOreRecipe(null, new ItemStack(TF2weapons.itemAmmoSyringe, 2, 0), new Object[]{"ingotIron", "paper", "paper", "paper", "paper", "paper", "paper", "paneGlass", "paneGlass"});
        this.addRecipe((IRecipe)TF2CraftingManager.AMMO_RECIPES[9]);
        ItemStack cleaver = ItemFromData.getNewStack("cleaver");
        cleaver.func_190920_e(1);
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, cleaver, new Object[]{"I", "W", Character.valueOf('I'), "ingotIron", Character.valueOf('W'), "stickWood"}));
        this.addRecipe(new AustraliumRecipe());
        this.addRecipe(new RecipeApplyEffect(TF2weapons.itemStrangifier));
        this.addRecipe(new RecipeApplyEffect(TF2weapons.itemKillstreak));
        this.addRecipe(new JumperRecipe("rocketlauncher", "rocketjumper"));
        this.addRecipe(new JumperRecipe("stickybomblauncher", "stickyjumper"));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, ItemFromData.getNewStack("cloak"), new Object[]{"AAA", "LGL", "AAA", Character.valueOf('A'), "ingotAustralium", Character.valueOf('G'), "blockGlass", Character.valueOf('L'), "leather"}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, ItemFromData.getNewStack("deadringer"), new Object[]{" A ", "AGA", " A ", Character.valueOf('A'), "ingotAustralium", Character.valueOf('G'), "blockGlass"}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, TF2weapons.itemDisguiseKit, new Object[]{"I I", "PAG", "I I", Character.valueOf('A'), "ingotAustralium", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "blockGlass", Character.valueOf('P'), "paper"}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, ItemFromData.getNewStack("sapper"), new Object[]{" R ", "IRI", " R ", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone"}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, new ItemStack(TF2weapons.itemBuildingBox, 1, 18), new Object[]{"IDI", "GRG", "III", Character.valueOf('D'), new ItemStack(Blocks.field_150367_z), Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "gunpowder", Character.valueOf('R'), new ItemStack(TF2weapons.itemTF2, 1, 11)}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, new ItemStack(TF2weapons.itemBuildingBox, 1, 20), new Object[]{"MDR", "SIm", "rIG", Character.valueOf('D'), new ItemStack(Blocks.field_150367_z), Character.valueOf('I'), "ingotIron", Character.valueOf('M'), new ItemStack(TF2weapons.itemAmmoMedigun), Character.valueOf('G'), new ItemStack(TF2weapons.itemAmmo, 1, 8), Character.valueOf('R'), new ItemStack(TF2weapons.itemTF2, 1, 11), Character.valueOf('r'), new ItemStack(TF2weapons.itemAmmo, 1, 7), Character.valueOf('S'), new ItemStack(TF2weapons.itemAmmo, 1, 1), Character.valueOf('m'), new ItemStack(TF2weapons.itemAmmo, 1, 6)}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, new ItemStack(TF2weapons.itemBuildingBox, 1, 22), new Object[]{"IAI", "ARA", "IAI", Character.valueOf('I'), "ingotIron", Character.valueOf('A'), new ItemStack(TF2weapons.itemTF2, 1, 6), Character.valueOf('R'), new ItemStack(TF2weapons.itemTF2, 1, 11)}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, ItemFromData.getNewStack("pda"), new Object[]{"SDT", "AGA", "BRB", Character.valueOf('G'), "paneGlass", Character.valueOf('A'), new ItemStack(TF2weapons.itemTF2, 1, 2), Character.valueOf('R'), new ItemStack(TF2weapons.itemTF2, 1, 3), Character.valueOf('B'), new ItemStack(Blocks.field_150430_aB), Character.valueOf('S'), new ItemStack(TF2weapons.itemBuildingBox, 1, 18), Character.valueOf('D'), new ItemStack(TF2weapons.itemBuildingBox, 1, 20), Character.valueOf('T'), new ItemStack(TF2weapons.itemBuildingBox, 1, 22)}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, new ItemStack(TF2weapons.itemAmmoBelt), new Object[]{" IL", "IL ", "L  ", Character.valueOf('I'), "ingotIron", Character.valueOf('L'), "leather"}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, bonk, new Object[]{"SDS", "IWI", "SAS", Character.valueOf('I'), "ingotIron", Character.valueOf('A'), new ItemStack(TF2weapons.itemTF2, 1, 6), Character.valueOf('W'), new ItemStack(Items.field_151131_as), Character.valueOf('S'), new ItemStack(Items.field_151102_aT), Character.valueOf('D'), "dyeYellow"}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, cola, new Object[]{"SDS", "IWI", "SAS", Character.valueOf('I'), "ingotIron", Character.valueOf('A'), new ItemStack(TF2weapons.itemTF2, 1, 6), Character.valueOf('W'), new ItemStack(Items.field_151131_as), Character.valueOf('S'), new ItemStack(Items.field_151102_aT), Character.valueOf('D'), "dyeMagenta"}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, new ItemStack(TF2weapons.itemSandvich), new Object[]{" B ", "LHL", " B ", Character.valueOf('B'), new ItemStack(Items.field_151025_P), Character.valueOf('L'), new ItemStack((Block)Blocks.field_150329_H, 1, 1), Character.valueOf('H'), new ItemStack(Items.field_151147_al)}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, new ItemStack(TF2weapons.itemChocolate, 2), new Object[]{"CCC", "CCC", "MII", Character.valueOf('C'), new ItemStack(Items.field_151100_aR, 1, 3), Character.valueOf('M'), new ItemStack(Items.field_151117_aB), Character.valueOf('I'), "paper"}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, new ItemStack(TF2weapons.itemScoutBoots), new Object[]{"FFF", "FBF", "FFF", Character.valueOf('F'), new ItemStack(Items.field_151008_G), Character.valueOf('B'), new ItemStack((Item)Items.field_151021_T)}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, new ItemStack(TF2weapons.itemMantreads), new Object[]{"LBL", " I ", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), new ItemStack((Item)Items.field_151167_ab), Character.valueOf('L'), "leather"}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, new ItemStack(TF2weapons.itemGunboats), new Object[]{" B ", "III", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), new ItemStack((Item)Items.field_151167_ab)}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, new ItemStack(TF2weapons.itemTF2, 1, 11), new Object[]{"C r", "CRr", "C r", Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('R'), "blockRedstone", Character.valueOf('r'), Items.field_151107_aW}));
        ItemStack jarate = ItemFromData.getNewStack("jarate");
        jarate.func_77978_p().func_74757_a("IsEmpty", true);
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, jarate, new Object[]{" G ", "G G", "GGG", Character.valueOf('G'), "paneGlass"}));
        ItemStack madmilk = ItemFromData.getNewStack("madmilk");
        madmilk.func_77978_p().func_74757_a("IsEmpty", true);
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, madmilk, new Object[]{" G ", "G G", "GGG", Character.valueOf('G'), "paneGlass"}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, ItemFromData.getNewStack("basejumper"), new Object[]{"LLL", "S S", " s ", Character.valueOf('L'), "leather", Character.valueOf('S'), "string", Character.valueOf('s'), new ItemStack(TF2weapons.itemTF2, 1, 3)}));
        ItemStack banner = new ItemStack(Items.field_179564_cE, 1, EnumDyeColor.RED.func_176767_b());
        banner.func_190925_c("BlockEntityTag").func_74782_a("Patterns", (NBTBase)new NBTTagList());
        banner.func_190920_e(2);
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, banner, new Object[]{"WWW", "WWW", "AS ", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L), Character.valueOf('A'), new ItemStack(TF2weapons.itemTF2, 1, 2), Character.valueOf('S'), Items.field_151055_y}));
        ItemStack bannern = new ItemStack(Items.field_179564_cE, 1, EnumDyeColor.GRAY.func_176767_b());
        bannern.func_190925_c("BlockEntityTag").func_74782_a("Patterns", (NBTBase)new NBTTagList());
        bannern.func_190920_e(4);
        NBTTagCompound pattern = new NBTTagCompound();
        pattern.func_74778_a("Pattern", "nb");
        pattern.func_74768_a("Color", 15);
        bannern.func_190925_c("BlockEntityTag").func_150295_c("Patterns", 10).func_74742_a((NBTBase)pattern);
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, bannern, new Object[]{"WWW", "WWW", " SA", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L), Character.valueOf('A'), new ItemStack(TF2weapons.itemTF2, 1, 2), Character.valueOf('S'), Items.field_151055_y}));
        this.addRecipe((IRecipe)new ShapedOreRecipe(null, ItemFromData.getNewStack("startwrench"), new Object[]{" II", " S ", "I  ", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), new ItemStack(TF2weapons.itemTF2, 1, 3)}));
        if (!TF2ConfigVars.disableBossSpawnItems) {
            this.addRecipe((IRecipe)new ShapedOreRecipe(null, new ItemStack(TF2weapons.itemBossSpawn, 1, 0), new Object[]{"II", "SA", "S ", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), "stickWood", Character.valueOf('A'), new ItemStack(TF2weapons.itemTF2, 1, 2)}));
            this.addRecipe((IRecipe)new ShapedOreRecipe(null, new ItemStack(TF2weapons.itemBossSpawn, 1, 1), new Object[]{"EAE", "ESE", "EAE", Character.valueOf('E'), Items.field_151070_bp, Character.valueOf('A'), new ItemStack(TF2weapons.itemTF2, 1, 6), Character.valueOf('S'), new IngredientWeapon("bottle")}));
            this.addRecipe((IRecipe)new ShapedOreRecipe(null, new ItemStack(TF2weapons.itemBossSpawn, 1, 2), new Object[]{"BEG", "NAN", "GEB", Character.valueOf('E'), "gemEmerald", Character.valueOf('A'), new ItemStack(TF2weapons.itemTF2, 1, 2), Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('G'), Items.field_151069_bo, Character.valueOf('N'), "cropNetherWart"}));
        }
        this.addRecipe((IRecipe)new ShapelessOreRecipe(null, new ItemStack(TF2weapons.blockUpgradeStation), new Object[]{new IngredientWeapon("headtaker"), new IngredientWeapon("monoculus"), new IngredientWeapon("merasmushat")}));
        this.addShapelessRecipe(new ItemStack(TF2weapons.itemTF2, 1, 4), new ItemStack(TF2weapons.itemTF2, 1, 3), new ItemStack(TF2weapons.itemTF2, 1, 3), new ItemStack(TF2weapons.itemTF2, 1, 3));
        this.addShapelessRecipe(new ItemStack(TF2weapons.itemTF2, 1, 5), new ItemStack(TF2weapons.itemTF2, 1, 4), new ItemStack(TF2weapons.itemTF2, 1, 4), new ItemStack(TF2weapons.itemTF2, 1, 4));
        this.addShapelessRecipe(new ItemStack(TF2weapons.itemTF2, 3, 4), new ItemStack(TF2weapons.itemTF2, 1, 5));
        this.addShapelessRecipe(new ItemStack(TF2weapons.itemTF2, 3, 3), new ItemStack(TF2weapons.itemTF2, 1, 4));
        this.addShapelessRecipe(new ItemStack(TF2weapons.itemTF2, 1, 9), new ItemStack(TF2weapons.itemTF2, 1, 3), new ItemStack(TF2weapons.itemTF2, 1, 3));
        this.addShapelessRecipe(new ItemStack(TF2weapons.itemTF2, 1, 10), new ItemStack(TF2weapons.itemTF2, 1, 5), new ItemStack(TF2weapons.itemTF2, 1, 5), new ItemStack(TF2weapons.itemTF2, 1, 5));
        this.addRecipe(new OpenCrateRecipe());
        this.addRecipe(new RecipeToScrap(-1));
        for (int i = 0; i < 9; ++i) {
            this.addRecipe(new RecipeToScrap(i));
        }
        this.addRecipe((IRecipe)new RecipeToken(null, new ItemStack(TF2weapons.itemTF2, 1, 9), new Object[]{new ItemStack(TF2weapons.itemTF2, 1, 3), new ItemStack(TF2weapons.itemToken, 1, Short.MAX_VALUE)}));
    }

    public ShapedRecipes addRecipe(ItemStack stack, Object ... recipeComponents) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])recipeComponents);
        ShapedRecipes recipe = new ShapedRecipes("", primer.width, primer.height, primer.input, stack);
        this.recipes.add((IRecipe)recipe);
        return recipe;
    }

    public IRecipe addShapelessRecipe(ItemStack stack, Object ... recipeComponents) {
        NonNullList list = NonNullList.func_191196_a();
        for (Object object : recipeComponents) {
            list.add((Object)CraftingHelper.getIngredient((Object)object));
        }
        ShapelessRecipes recipe = new ShapelessRecipes("", stack, list);
        this.recipes.add((IRecipe)recipe);
        return recipe;
    }

    public IRecipe addRecipe(IRecipe recipe) {
        this.recipes.add(recipe);
        return recipe;
    }

    public void addRecipeCondition(IRecipe recipe, Predicate<EntityPlayer> predicate) {
        this.recipeConditions.put(recipe, predicate);
    }

    @Nullable
    public ItemStack findMatchingRecipe(InventoryCrafting craftMatrix, World worldIn, EntityPlayer player) {
        for (IRecipe irecipe : this.recipes) {
            if (this.recipeConditions.containsKey(irecipe) && !this.recipeConditions.get(irecipe).apply((Object)player) || !irecipe.func_77569_a(craftMatrix, worldIn)) continue;
            return irecipe.func_77572_b(craftMatrix);
        }
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting craftMatrix, World worldIn) {
        for (IRecipe irecipe : this.recipes) {
            if (!irecipe.func_77569_a(craftMatrix, worldIn)) continue;
            return irecipe.func_179532_b(craftMatrix);
        }
        NonNullList aitemstack = NonNullList.func_191197_a((int)craftMatrix.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < aitemstack.size(); ++i) {
            aitemstack.set(i, (Object)craftMatrix.func_70301_a(i));
        }
        return aitemstack;
    }

    public List<IRecipe> getRecipeList() {
        return this.recipes;
    }
}

