/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.lwjgl.opengl.GL11;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.entity.building.EntityTeleporter;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.IItemSlotNumber;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemMeleeWeapon;
import rafradek.TF2weapons.item.ItemToken;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;

public class ItemWrench
extends ItemMeleeWeapon
implements IItemSlotNumber {
    @Override
    public boolean onHit(ItemStack stack, EntityLivingBase attacker, Entity target, float damage, int critical, boolean simulate) {
        if (target instanceof EntityBuilding && TF2Util.isOnSameTeam(target, (Entity)attacker)) {
            EntityBuilding building = (EntityBuilding)target;
            if (building.isSapped()) {
                building.removeSapper();
            } else if (building.isConstructing()) {
                building.wrenchBonusTime = 25;
                building.wrenchBonusMult = TF2Attribute.getModifier("Construction Rate", stack, 1.0f, attacker);
                building.func_184185_a(ItemFromData.getSound(stack, PropertyType.BUILD_HIT_SUCCESS_SOUND), 1.7f, 1.0f);
            } else {
                boolean useIgnot = false;
                int metalLeft = ((WeaponsCapability)attacker.getCapability(TF2weapons.WEAPONS_CAP, null)).getMetal();
                float metalMult = TF2Attribute.getModifier("Metal Used", stack, 1.0f, attacker);
                if (attacker instanceof EntityPlayer && ((EntityPlayer)attacker).field_71075_bZ.field_75098_d) {
                    metalMult = 10.0f;
                }
                ItemStack ingot = new ItemStack(Items.field_151042_j);
                if (metalLeft == 0 && attacker instanceof EntityPlayer && ((EntityPlayer)attacker).field_71071_by.func_70431_c(ingot)) {
                    metalLeft = 50;
                    ((WeaponsCapability)attacker.getCapability(TF2weapons.WEAPONS_CAP, null)).setMetal(50);
                    useIgnot = true;
                }
                int metalUse = 0;
                if (building.func_110143_aJ() < building.func_110138_aP()) {
                    metalUse = (int)Math.min(Math.min((building.func_110138_aP() - building.func_110143_aJ()) * 3.333333f, 33.0f * metalMult) + 1.0f, (float)metalLeft);
                    building.func_70691_i((float)metalUse * 0.3f);
                    metalLeft -= metalUse;
                }
                if (building instanceof EntitySentry) {
                    metalUse = Math.min(Math.min(((EntitySentry)building).getMaxAmmo() - ((EntitySentry)building).getAmmo(), (int)(40.0f * metalMult)), metalLeft);
                    ((EntitySentry)building).setAmmo(Math.min(((EntitySentry)building).getMaxAmmo(), ((EntitySentry)building).getAmmo() + metalUse));
                    metalLeft -= metalUse;
                    if (building.getLevel() == 3) {
                        metalUse = Math.min(Math.min(20 - ((EntitySentry)building).getRocketAmmo(), (int)(8.0f * metalMult)), metalLeft / 2);
                        ((EntitySentry)building).setRocketAmmo(Math.min(20, ((EntitySentry)building).getRocketAmmo() + metalUse));
                        metalLeft -= metalUse * 2;
                    }
                }
                if (building.getLevel() < building.getMaxLevel()) {
                    metalUse = Math.min(Math.min(200 - building.getProgress(), (int)TF2Attribute.getModifier("Upgrade Rate", stack, 25.0f * metalMult, attacker)), metalLeft);
                    float teleUpgradeRate = building instanceof EntityTeleporter ? TF2Attribute.getModifier("Teleporter Cost", stack, 1.0f, attacker) : 1.0f;
                    building.setProgress(Math.min(building.getProgress() + (int)((float)metalUse * teleUpgradeRate), 200));
                    metalLeft -= metalUse;
                    if (building.getProgress() >= 200) {
                        building.upgrade();
                    }
                }
                building.func_184185_a(ItemFromData.getSound(stack, metalLeft != ((WeaponsCapability)attacker.getCapability(TF2weapons.WEAPONS_CAP, null)).getMetal() ? PropertyType.BUILD_HIT_SUCCESS_SOUND : PropertyType.BUILD_HIT_FAIL_SOUND), 1.7f, 1.0f);
                if (useIgnot && metalLeft != 50) {
                    ((EntityPlayer)attacker).field_71071_by.func_174925_a(Items.field_151042_j, 0, 1, null);
                }
                if (!(attacker instanceof EntityPlayer) || !((EntityPlayer)attacker).field_71075_bZ.field_75098_d) {
                    ((WeaponsCapability)attacker.getCapability(TF2weapons.WEAPONS_CAP, null)).setMetal(metalLeft);
                }
            }
            return false;
        }
        if (target instanceof EntityTF2Character && TF2Util.isOnSameTeam(target, (Entity)attacker) && ((EntityTF2Character)target).isRobot()) {
            EntityTF2Character robot = (EntityTF2Character)target;
            if (robot.func_70660_b(TF2weapons.sapped) != null) {
                robot.func_184596_c(TF2weapons.sapped);
            } else {
                boolean useIgnot = false;
                int metalLeft = ((WeaponsCapability)attacker.getCapability(TF2weapons.WEAPONS_CAP, null)).getMetal();
                float metalMult = TF2Attribute.getModifier("Metal Used", stack, 1.0f, attacker);
                if (attacker instanceof EntityPlayer && ((EntityPlayer)attacker).field_71075_bZ.field_75098_d) {
                    metalMult = 10.0f;
                }
                ItemStack ingot = new ItemStack(Items.field_151042_j);
                if (metalLeft == 0 && attacker instanceof EntityPlayer && ((EntityPlayer)attacker).field_71071_by.func_70431_c(ingot)) {
                    metalLeft = 50;
                    ((WeaponsCapability)attacker.getCapability(TF2weapons.WEAPONS_CAP, null)).setMetal(50);
                    useIgnot = true;
                }
                int metalUse = 0;
                if (robot.func_110143_aJ() < robot.func_110138_aP()) {
                    metalUse = (int)Math.min(Math.min((robot.func_110138_aP() - robot.func_110143_aJ()) * 3.333333f, 33.0f * metalMult) + 1.0f, (float)metalLeft);
                    robot.func_70691_i((float)metalUse * 0.3f);
                    metalLeft -= metalUse;
                }
                if (useIgnot && metalLeft != 50) {
                    ((EntityPlayer)attacker).field_71071_by.func_174925_a(Items.field_151042_j, 0, 1, null);
                }
                robot.func_184185_a(ItemFromData.getSound(stack, metalLeft != ((WeaponsCapability)attacker.getCapability(TF2weapons.WEAPONS_CAP, null)).getMetal() ? PropertyType.BUILD_HIT_SUCCESS_SOUND : PropertyType.BUILD_HIT_FAIL_SOUND), 1.7f, 1.0f);
                if (!(attacker instanceof EntityPlayer) || !((EntityPlayer)attacker).field_71075_bZ.field_75098_d) {
                    ((WeaponsCapability)attacker.getCapability(TF2weapons.WEAPONS_CAP, null)).setMetal(metalLeft);
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer living, EnumHand hand) {
        ItemStack stack = living.func_184586_b(hand);
        if (((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).getMetal() >= 20 && TF2Attribute.getModifier("Weapon Mode", stack, 0.0f, (EntityLivingBase)living) == 1.0f) {
            living.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, living, hand);
    }

    public int func_77626_a(ItemStack stack) {
        return 800;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @Override
    public boolean showInfoBox(ItemStack stack, EntityPlayer player) {
        return true;
    }

    @Override
    public String[] getInfoBoxLines(ItemStack stack, EntityPlayer player) {
        return new String[]{"METAL", Integer.toString(((WeaponsCapability)player.getCapability(TF2weapons.WEAPONS_CAP, null)).getMetal())};
    }

    @Override
    public boolean catchSlotHotkey(ItemStack stack, EntityPlayer player) {
        return ItemToken.allowUse((EntityLivingBase)player, "engineer") && !player.func_184607_cu().func_190926_b() && player.func_184605_cv() < 770;
    }

    @Override
    public void onSlotSelection(ItemStack stack, EntityPlayer player, int slot) {
        if (!player.field_70170_p.field_72995_K && player.func_184607_cu().func_77973_b() instanceof ItemWrench) {
            EntityTeleporter.TeleporterData[] data;
            int dimension = 0;
            BlockPos pos = null;
            if (slot == 8) {
                dimension = player.field_71093_bK;
                pos = player.getBedLocation(player.field_71093_bK);
                if (pos == null) {
                    pos = player.getBedLocation(0);
                    dimension = 0;
                }
                pos = pos != null ? EntityPlayer.func_180467_a((World)TF2weapons.server.func_71218_a(dimension), (BlockPos)pos, (boolean)player.isSpawnForced(dimension)) : TF2weapons.server.func_71218_a((int)0).field_73011_w.getRandomizedSpawnPoint();
            } else if (EntityTeleporter.teleporters.containsKey(player.func_110124_au()) && (data = EntityTeleporter.teleporters.get(player.func_110124_au()))[slot] != null) {
                dimension = data[slot].dimension;
                pos = data[slot];
            }
            if (pos != null) {
                if (dimension != player.field_71093_bK) {
                    player.field_70170_p.func_73046_m().func_184103_al().transferPlayerToDimension((EntityPlayerMP)player, dimension, (Teleporter)new EntityTeleporter.TeleporterDim((WorldServer)player.field_70170_p, pos));
                }
                player.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.23, (double)pos.func_177952_p() + 0.5);
                player.func_184811_cZ().func_185145_a(MapList.weaponClasses.get("wrench"), 200);
                TF2Util.playSound((Entity)player, TF2Sounds.MOB_TELEPORTER_SEND, 1.0f, 1.0f);
                player.func_184602_cy();
                ((WeaponsCapability)player.getCapability(TF2weapons.WEAPONS_CAP, null)).consumeMetal(20, false);
            }
        }
    }

    @Override
    public void drawOverlay(ItemStack stack, EntityPlayer player, Tessellator tessellator, BufferBuilder renderer, ScaledResolution resolution) {
        if (player.func_184607_cu().func_77973_b() instanceof ItemWrench && player.func_184605_cv() < 770) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ClientProxy.buildingTexture);
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glDisable((int)3008);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
            GuiIngame gui = Minecraft.func_71410_x().field_71456_v;
            Minecraft.func_71410_x().field_71456_v.func_73729_b(resolution.func_78326_a() / 2 - 80, resolution.func_78328_b() / 2 - 32, 64, 192, 64, 64);
            Minecraft.func_71410_x().field_71456_v.func_73729_b(resolution.func_78326_a() / 2 + 16, resolution.func_78328_b() / 2 - 32, 0, 192, 64, 64);
            gui.func_73732_a(gui.func_175179_f(), "(1-8)", resolution.func_78326_a() / 2 - 48, resolution.func_78328_b() / 2 + 40, -1);
            gui.func_73732_a(gui.func_175179_f(), I18n.func_135052_a((String)"gui.selectlocation", (Object[])new Object[0]), resolution.func_78326_a() / 2, resolution.func_78328_b() / 2 - 50, -1);
            gui.func_73732_a(gui.func_175179_f(), "(9)", resolution.func_78326_a() / 2 + 48, resolution.func_78328_b() / 2 + 40, -1);
            GL11.glEnable((int)3553);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3008);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

