/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.projectile.EntityProjectileBase;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Explosion;
import rafradek.TF2weapons.util.TF2Util;

public class ItemWearable
extends ItemFromData {
    public static int usedModel;
    public static final Tuple<String, AttributeModifier>[] EFFECT_MODIFIERS;

    public ItemWearable() {
        this.func_185043_a(new ResourceLocation("bodyModel"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (usedModel == 1) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("headModel"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (usedModel == 2) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot slot, Entity player) {
        return slot == (this.isHat(stack) ? EntityEquipmentSlot.HEAD : EntityEquipmentSlot.CHEST);
    }

    public EntityEquipmentSlot getEquipmentSlot(ItemStack stack) {
        return this.isHat(stack) ? EntityEquipmentSlot.HEAD : EntityEquipmentSlot.CHEST;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer living, EnumHand hand) {
        if (!world.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)living, (Object)TF2weapons.instance, (int)0, (World)world, (int)0, (int)0, (int)0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)living.func_184586_b(hand));
    }

    public boolean isHat(ItemStack stack) {
        return (ItemWearable.getData(stack).getInt(PropertyType.WEAR) & 1) == 1;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return ItemWearable.getData(stack).getString(PropertyType.ARMOR_IMAGE);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        this.onUpdateWearing(itemStack, world, (EntityLivingBase)player);
    }

    public void applyRandomEffect(ItemStack stack, Random rand) {
        stack.func_77978_p().func_74774_a("UEffect", (byte)rand.nextInt(11));
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("UEffect")) {
            name = TextFormatting.DARK_PURPLE + "Unusual " + name;
        }
        return name;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("UEffect")) {
            tooltip.add("");
            String str = I18n.func_135052_a((String)("item.wearable.effect." + stack.func_77978_p().func_74771_c("UEffect")), (Object[])new Object[0]);
            tooltip.add(I18n.func_135052_a((String)"item.wearable.effect", (Object[])new Object[0]) + " " + str);
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.HEAD && stack.func_77978_p().func_74764_b("UEffect")) {
            Tuple<String, AttributeModifier> tuple = EFFECT_MODIFIERS[stack.func_77978_p().func_74771_c("UEffect") % EFFECT_MODIFIERS.length];
            multimap.put(tuple.func_76341_a(), tuple.func_76340_b());
        }
        return multimap;
    }

    public void onUpdateWearing(ItemStack stack, World par2World, EntityLivingBase living) {
        if (!living.field_70170_p.field_72995_K && living.field_70725_aQ == 18 && TF2Attribute.getModifier("Explode Death", stack, 0.0f, living) != 0.0f) {
            TF2Explosion explosion = new TF2Explosion(living.field_70170_p, (Entity)living, living.field_70165_t, living.field_70163_u + 0.5, living.field_70161_v, 5.0f, null, 0.0f, 3.0f, SoundEvents.field_187539_bB);
            explosion.isFlaming = false;
            explosion.isSmoking = true;
            explosion.func_77278_a();
            explosion.func_77279_a(true);
            for (Entity ent2 : explosion.affectedEntities.keySet()) {
                TF2Util.dealDamage(ent2, living.field_70170_p, living, ItemStack.field_190927_a, 2, explosion.affectedEntities.get(ent2).floatValue() * 26.0f, TF2Util.causeDirectDamage(stack, (Entity)living, 2).func_94540_d());
            }
            for (EntityPlayer entityplayer : living.field_70170_p.field_73010_i) {
                if (!(entityplayer.func_70092_e(living.field_70165_t, living.field_70163_u + 0.5, living.field_70161_v) < 4096.0)) continue;
                ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)new SPacketExplosion(living.field_70165_t, living.field_70163_u + 0.5, living.field_70161_v, 4.0f, explosion.field_77281_g, explosion.getKnockbackMap().get(entityplayer)));
            }
        }
        if (WeaponsCapability.get((Entity)living).isDisguised()) {
            return;
        }
        if (!living.field_70170_p.field_72995_K && living.field_70173_aa % 13 == 0 && TF2Attribute.getModifier("Bomb Enemy", stack, 0.0f, living) != 0.0f) {
            EntityLivingBase target = WeaponsCapability.get((Entity)living).lastAttacked;
            if (target == null || !target.func_70089_S() || target.func_70068_e((Entity)living) > 200.0) {
                target = (EntityLivingBase)Iterables.getFirst((Iterable)living.field_70170_p.func_175647_a(EntityLiving.class, living.func_174813_aQ().func_186662_g(11.0), ent -> ent.func_70638_az() == living && EntityAITarget.func_179445_a((EntityLiving)ent, (EntityLivingBase)living, (boolean)false, (boolean)true)), null);
            }
            if (target != null && living.func_70685_l((Entity)target) && target.func_70089_S() && target.func_70068_e((Entity)living) < 144.0) {
                ItemStack stackW = ItemFromData.getNewStack("bombinomiconbomb");
                try {
                    EntityProjectileBase proj = MapList.projectileClasses.get(ItemFromData.getData(stackW).getString(PropertyType.PROJECTILE)).getConstructor(World.class).newInstance(living.field_70170_p);
                    proj.damageModifier = TF2Attribute.getModifier("Bomb Enemy", stack, 0.0f, living);
                    proj.initProjectile(living, EnumHand.MAIN_HAND, stackW);
                    double x = target.field_70165_t;
                    double y = target.field_70163_u + (double)target.func_70047_e();
                    double z = target.field_70161_v;
                    proj.face(x, y, z, 1.0f);
                    living.field_70170_p.func_72838_d((Entity)proj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (living.field_70170_p.field_72995_K && (living != ClientProxy.getLocalPlayer() || Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) && stack.func_77978_p().func_74764_b("UEffect")) {
            EnumParticleTypes type;
            switch (stack.func_77978_p().func_74771_c("UEffect")) {
                case 0: {
                    type = EnumParticleTypes.FLAME;
                    break;
                }
                case 1: {
                    type = EnumParticleTypes.HEART;
                    break;
                }
                case 2: {
                    type = EnumParticleTypes.SMOKE_LARGE;
                    break;
                }
                case 3: {
                    type = EnumParticleTypes.WATER_BUBBLE;
                    break;
                }
                case 4: {
                    type = EnumParticleTypes.VILLAGER_ANGRY;
                    break;
                }
                case 5: {
                    type = EnumParticleTypes.VILLAGER_HAPPY;
                    break;
                }
                case 6: {
                    type = EnumParticleTypes.SUSPENDED_DEPTH;
                    break;
                }
                case 7: {
                    type = EnumParticleTypes.SLIME;
                    break;
                }
                case 8: {
                    type = EnumParticleTypes.CRIT_MAGIC;
                    break;
                }
                case 9: {
                    type = EnumParticleTypes.DRAGON_BREATH;
                    break;
                }
                case 10: {
                    type = EnumParticleTypes.NOTE;
                    break;
                }
                case 11: {
                    type = EnumParticleTypes.FIREWORKS_SPARK;
                    break;
                }
                case 12: {
                    type = EnumParticleTypes.EXPLOSION_NORMAL;
                    break;
                }
                case 13: {
                    type = EnumParticleTypes.SPELL_MOB;
                    break;
                }
                default: {
                    type = EnumParticleTypes.END_ROD;
                }
            }
            par2World.func_175688_a(type, living.field_70165_t + living.func_70681_au().nextDouble() * (double)living.field_70130_N - (double)(living.field_70130_N / 2.0f), living.field_70163_u + (double)living.field_70131_O + living.func_70681_au().nextDouble() * 0.2, living.field_70161_v + living.func_70681_au().nextDouble() * (double)living.field_70130_N - (double)(living.field_70130_N / 2.0f), living.field_70159_w, living.func_70681_au().nextDouble() * 0.02, living.field_70179_y, new int[0]);
        }
    }

    static {
        EFFECT_MODIFIERS = new Tuple[]{new Tuple((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier("Mod e1", 0.1, 2)), new Tuple((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier("Mod e2", 1.0, 0)), new Tuple((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier("Mod e3", 0.12, 1)), new Tuple((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier("Mod e4", 3.0, 0)), new Tuple((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier("Mod e5", 0.14, 2)), new Tuple((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier("Mod e6", 1.0, 0)), new Tuple((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier("Mod e7", 0.08, 2)), new Tuple((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier("Mod e8", 2.0, 0)), new Tuple((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier("Mod e9", 4.0, 0)), new Tuple((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier("Mod e10", 0.08, 2)), new Tuple((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier("Mod e11", 0.16, 1)), new Tuple((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier("Mod e12", 0.12, 2)), new Tuple((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier("Mod e13", 0.1, 1)), new Tuple((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier("Mod e14", 0.1, 2)), new Tuple((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier("Mod e15", 5.0, 0))};
    }
}

