/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import atomicstryker.dynamiclights.client.DynamicLights;
import atomicstryker.dynamiclights.client.IDynamicLightSource;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2EventsCommon;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.client.TF2EventsClient;
import rafradek.TF2weapons.client.audio.WeaponSound;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.EntityLightDynamic;
import rafradek.TF2weapons.entity.IEntityTF2;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.IItemNoSwitch;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemJar;
import rafradek.TF2weapons.item.ItemKillstreakKit;
import rafradek.TF2weapons.item.ItemMedigun;
import rafradek.TF2weapons.item.ItemMeleeWeapon;
import rafradek.TF2weapons.item.ItemUsable;
import rafradek.TF2weapons.lightsource.MuzzleFlashLightSource;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.ReflectionAccess;
import rafradek.TF2weapons.util.TF2DamageSource;
import rafradek.TF2weapons.util.TF2Util;
import rafradek.TF2weapons.util.WeaponData;

public abstract class ItemWeapon
extends ItemUsable
implements IItemNoSwitch {
    public static boolean shouldSwing = false;
    public static int critical;
    protected static final UUID HEALTH_MODIFIER;
    protected static final UUID SPEED_MODIFIER;
    public static final UUID HEADS_HEALTH;
    public static final UUID HEADS_SPEED;
    public AttributeModifier headsHealthMod = new AttributeModifier(HEADS_HEALTH, "Heads modifier", 0.0, 0);
    public AttributeModifier headsSpeedMod = new AttributeModifier(HEADS_SPEED, "Heads modifier", 0.0, 2);
    public static boolean inHand;

    public ItemWeapon() {
        this.func_77637_a(TF2weapons.tabweapontf2);
        this.func_185043_a(new ResourceLocation("inhand"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn != null && inHand) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    @Override
    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        super.func_77663_a(par1ItemStack, par2World, par3Entity, par4, par5);
        if (!par2World.field_72995_K && TF2Attribute.getModifier("No Disguise Kit", par1ItemStack, 0.0f, (EntityLivingBase)par3Entity) != 0.0f && par3Entity.hasCapability(TF2weapons.WEAPONS_CAP, null) && !WeaponsCapability.get((Entity)par3Entity).stabbedDisguise) {
            WeaponsCapability.get(par3Entity).setDisguised(false);
        }
        if (par5 && ((EntityLivingBase)par3Entity).func_184614_ca() == par1ItemStack) {
            WeaponsCapability cap = (WeaponsCapability)par3Entity.getCapability(TF2weapons.WEAPONS_CAP, null);
            NBTTagCompound tag = par1ItemStack.func_77978_p();
            if (!par2World.field_72995_K && cap.critTimeCool <= 0) {
                cap.critTimeCool = 20;
                if (this.rapidFireCrits(par1ItemStack) && this.hasRandomCrits(par1ItemStack, par3Entity) && ((EntityLivingBase)par3Entity).func_70681_au().nextFloat() <= this.critChance(par1ItemStack, par3Entity)) {
                    cap.setCritTime(40);
                }
            }
            if (TF2Attribute.getModifier("Kill Count", par1ItemStack, 0.0f, null) != 0.0f) {
                par1ItemStack.func_77978_p().func_74768_a("Heads", cap.getHeads());
            }
            while (tag.func_74762_e("StrKil") > 0 && cap.ticksTotal >= tag.func_74763_f("StrCol")) {
                tag.func_74768_a("StrKil", tag.func_74762_e("StrKil") - 1);
                int red = tag.func_74765_d("StrRed") * 2 + 1;
                tag.func_74777_a("StrRed", (short)(red > Short.MAX_VALUE ? Short.MAX_VALUE : (short)red));
                tag.func_74772_a("StrCol", tag.func_74763_f("StrLst") + (long)ItemKillstreakKit.getCooldown(tag.func_74771_c("StrLev"), tag.func_74762_e("StrKil")));
                ((WeaponData.WeaponDataCapability)par1ItemStack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).cached = false;
            }
            if (cap.getCritTime() > 0) {
                cap.setCritTime(cap.getCritTime() - 1);
            }
            --cap.critTimeCool;
        }
    }

    public boolean canPenetrate(ItemStack stack, EntityLivingBase shooter) {
        return ItemWeapon.getData(stack).getBoolean(PropertyType.PENETRATE) || TF2Attribute.getModifier("Penetration", stack, 0.0f, shooter) != 0.0f;
    }

    @Override
    public boolean use(ItemStack stack, EntityLivingBase living, World world, EnumHand hand, TF2Message.PredictionMessage message) {
        int thisCritical;
        WeaponsCapability cap = (WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null);
        if (this.holdingMode(stack, living) > 0 && !cap.isCharging()) {
            cap.setCharging(true);
            cap.chargeTicks = 0;
            if (world.field_72995_K) {
                ClientProxy.playWeaponSound(living, ItemFromData.getSound(stack, PropertyType.CHARGE_SOUND), false, 0, stack);
            }
            return true;
        }
        boolean bl = cap.autoFire = TF2Attribute.getModifier("Auto Fire", stack, 0.0f, living) != 0.0f;
        if (this.hasClip(stack)) {
            this.consumeClip(stack, 1, living, hand);
        }
        if (living instanceof EntityPlayer && hand == EnumHand.MAIN_HAND) {
            ((EntityPlayer)living).func_184821_cY();
        } else if (world.field_72995_K && Minecraft.func_71410_x().field_71439_g == living) {
            Minecraft.func_71410_x().func_175597_ag().func_187460_a(EnumHand.OFF_HAND);
        }
        critical = thisCritical = TF2Util.calculateCritPre(stack, living);
        if (cap.focusShotTicks > 0) {
            if (cap.focusedShot(stack)) {
                cap.focusShotRemaining = 8;
            }
            cap.focusShotTicks = 0;
        }
        if (!world.field_72995_K && this.getAmmoType(stack) != 0 && !this.hasClip(stack)) {
            this.consumeAmmoGlobal(living, stack, 1);
        }
        if (!world.field_72995_K && living instanceof EntityPlayerMP) {
            TF2weapons.network.sendTo(new TF2Message.UseMessage(this.getClip(stack), false, !this.hasClip(stack) ? this.getAmmoAmount(living, stack) : -1, hand), (EntityPlayerMP)living);
        }
        this.doFireSound(stack, living, world, thisCritical);
        if (world.field_72995_K) {
            this.doMuzzleFlash(stack, living, hand);
        }
        if (!living.field_70122_E && ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).fanCool <= 0 && TF2Attribute.getModifier("KnockbackFAN", stack, 0.0f, living) != 0.0f) {
            Vec3d look = living.func_70676_i(1.0f);
            living.func_70024_g(-look.field_72450_a * 0.66, -look.field_72448_b * 0.58, -look.field_72449_c * 0.66);
        }
        if (living instanceof EntityPlayer && !((EntityPlayer)living).field_71075_bZ.field_75098_d && ((TF2PlayerCapability)living.getCapability(TF2weapons.PLAYER_CAP, null)).zombieHuntTicks <= 0 && (!(this instanceof ItemMeleeWeapon) && !(this instanceof ItemJar) || ItemWeapon.getData(stack).getName().equals("fryingpan"))) {
            ((TF2PlayerCapability)living.getCapability(TF2weapons.PLAYER_CAP, null)).zombieHuntTicks = 15;
            TF2Util.attractMobs(living, world);
        }
        for (int x = 0; x < this.getWeaponPelletCount(stack, living); ++x) {
            this.shoot(stack, living, world, thisCritical, hand);
        }
        if (this.shootAllAtOnce(stack, living)) {
            while (this.getClip(stack) > 0) {
                this.consumeClip(stack, 1, living, hand);
                this.shoot(stack, living, world, thisCritical, hand);
            }
        }
        return true;
    }

    @Optional.Method(modid="dynamiclights")
    public void doMuzzleFlashLight(ItemStack stack, EntityLivingBase living) {
        MuzzleFlashLightSource light = new MuzzleFlashLightSource((Entity)living);
        TF2EventsClient.muzzleFlashes.add(light);
        DynamicLights.addLightSource((IDynamicLightSource)light);
    }

    public abstract void shoot(ItemStack var1, EntityLivingBase var2, World var3, int var4, EnumHand var5);

    public int getClip(ItemStack stack) {
        if (!this.hasClip(stack)) {
            return 0;
        }
        if (!stack.func_77978_p().func_74764_b("Clip")) {
            this.setClip(stack, this.getWeaponClipSize(stack, null));
        }
        return stack.func_77978_p().func_74762_e("Clip");
    }

    public void setClip(ItemStack stack, int value) {
        if (this.hasClip(stack)) {
            stack.func_77978_p().func_74768_a("Clip", MathHelper.func_76125_a((int)value, (int)0, (int)this.getWeaponClipSize(stack, null)));
        }
    }

    public void consumeClip(ItemStack stack, int value, EntityLivingBase living, EnumHand hand) {
        if (value <= 0 || TF2ConfigVars.mustReload || !(living instanceof EntityPlayer) || !((EntityPlayer)living).field_71075_bZ.field_75098_d) {
            this.setClip(stack, this.getClip(stack) - value);
            try {
                ((ItemStack)((NonNullList)ReflectionAccess.entityHandInv.get(living)).get(hand.ordinal())).func_77978_p().func_74768_a("Clip", this.getClip(stack));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void doFireSound(ItemStack stack, EntityLivingBase living, World world, int critical) {
        if (ItemFromData.getData(stack).hasProperty(PropertyType.FIRE_SOUND)) {
            SoundEvent soundToPlay = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(ItemFromData.getData(stack).getString(PropertyType.FIRE_SOUND) + (critical == 2 ? ".crit" : "")));
            living.func_184185_a(soundToPlay, living instanceof EntityLiving && !(((EntityLiving)living).func_70638_az() instanceof EntityPlayer) ? TF2ConfigVars.mercenaryVolume : TF2ConfigVars.gunVolume, 1.0f);
            if (world.field_72995_K) {
                ClientProxy.removeReloadSound(living);
            }
        }
    }

    @Override
    public boolean canFire(World world, EntityLivingBase living, ItemStack stack) {
        return super.canFire(world, living, stack) && (this.holdingMode(stack, living) <= 0 || !((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).isCharging()) && this.isAmmoSufficient(stack, living, false);
    }

    @Override
    public boolean endUse(ItemStack stack, EntityLivingBase living, World world, int action, int newState) {
        WeaponsCapability cap = (WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null);
        if (this.holdingMode(stack, living) > 0 && (newState & 1) == 0 && cap.isCharging()) {
            WeaponData.getCapability((ItemStack)stack).fire1Cool = this.getFiringSpeed(stack, living);
            if (world.field_72995_K && ClientProxy.fireSounds.get((Object)living) != null) {
                ((WeaponSound)((Object)ClientProxy.fireSounds.get((Object)living))).setDone();
            }
            this.use(stack, living, world, EnumHand.MAIN_HAND, null);
            cap.setCharging(false);
            cap.lastFire = 1250;
            if (world.field_72995_K) {
                ++sps;
            }
            cap.reloadCool = 0;
            if ((cap.state & 8) != 0) {
                cap.state -= 8;
            }
        }
        return false;
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        if (this.hasClip(stack)) {
            tooltip.add("Clip: " + this.getClip(stack) + "/" + this.getWeaponClipSize(stack, null));
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND && ItemWeapon.getData(stack) != ItemFromData.BLANK_DATA && stack.func_77942_o() && (((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).usedClass == -1 || ItemWeapon.getData(stack).getString(PropertyType.CLASS).isEmpty())) {
            this.addModifiersWithToken(stack, (Multimap<String, AttributeModifier>)multimap);
        }
        ((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).usedClass = -1;
        return multimap;
    }

    public void addModifiersWithToken(ItemStack stack, Multimap<String, AttributeModifier> multimap) {
        float addSpeed;
        int heads = Math.min((int)TF2Attribute.getModifier("Kill Count", stack, 0.0f, null), stack.func_77978_p().func_74762_e("Heads"));
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)(this.getWeaponDamage(stack, null, null) * (float)this.getWeaponPelletCount(stack, null) - 1.0f), 0));
        multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -4.0 + 1000.0 / (double)this.getFiringSpeed(stack, null), 0));
        float addHealth = TF2Attribute.getModifier("Health", stack, 0.0f, null) + (float)heads * TF2Attribute.getModifier("Max Health Kill", stack, 0.0f, null);
        if (addHealth != 0.0f) {
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(HEALTH_MODIFIER, "Weapon modifier", (double)addHealth, 0));
        }
        if ((addSpeed = TF2Attribute.getModifier("Speed", stack, 1.0f + (float)heads * TF2Attribute.getModifier("Speed Kill", stack, 0.0f, null), null)) != 1.0f) {
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(SPEED_MODIFIER, "Weapon modifier", (double)(addSpeed - 1.0f), 2));
        }
    }

    public float critChance(ItemStack stack, Entity entity) {
        float chance = 0.025f;
        if (entity instanceof EntityPlayer) {
            chance += TF2PlayerCapability.get((EntityPlayer)entity).getTotalLastDamage() / 800.0f;
        }
        return Math.min(chance, 0.125f);
    }

    @Override
    public boolean fireTick(ItemStack stack, EntityLivingBase living, World world) {
        WeaponsCapability cap = (WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null);
        if (this.holdingMode(stack, living) > 0 && cap.isCharging()) {
            ++cap.chargeTicks;
        }
        if (cap.chargeTicks >= this.holdingMode(stack, living) && !this.shouldKeepCharged(stack, living)) {
            this.endUse(stack, living, world, 1, 0);
        }
        return false;
    }

    public boolean func_77662_d() {
        return true;
    }

    @Override
    public boolean altFireTick(ItemStack stack, EntityLivingBase living, World world) {
        if (!world.field_72995_K && living instanceof EntityPlayer && WeaponsCapability.get((Entity)living).hasMetal(100) && TF2Attribute.getModifier("Pick Building", stack, 0.0f, living) > 0.0f) {
            Vec3d forward = living.func_70676_i(1.0f).func_186678_a(120.0).func_178787_e(living.func_174824_e(1.0f));
            RayTraceResult result = TF2Util.pierce(world, (Entity)living, living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v, forward.field_72450_a, forward.field_72448_b, forward.field_72449_c, false, 0.5f, false).get(0);
            if (result.field_72308_g != null && result.field_72308_g instanceof EntityBuilding && !((EntityBuilding)result.field_72308_g).isDisabled() && ((EntityBuilding)result.field_72308_g).getOwner() == living && WeaponsCapability.get((Entity)living).consumeMetal(100, false) != 0) {
                result.field_72308_g.func_70107_b(living.field_70165_t, living.field_70163_u, living.field_70161_v);
                ((EntityBuilding)result.field_72308_g).grab();
            }
        }
        if (!world.field_72995_K && this.getRageType(stack, living) == WeaponsCapability.RageType.MINICRIT && this.getRage(stack, living) >= this.getMaxRage(stack, living)) {
            WeaponsCapability.get((Entity)living).setRageActive(WeaponsCapability.RageType.MINICRIT, true, this.getMaxRage(stack, living) / TF2Attribute.getModifier("Minicrit Rage", stack, 0.0f, living));
            living.func_70690_d(new PotionEffect(TF2weapons.buffbanner, (int)(20.0f * TF2Attribute.getModifier("Minicrit Rage", stack, 0.0f, living))));
        }
        return false;
    }

    public boolean shootAllAtOnce(ItemStack stack, EntityLivingBase living) {
        return TF2Attribute.getModifier("Shoot Once", stack, 0.0f, living) != 0.0f;
    }

    public int getMaxDamage(ItemStack stack) {
        return stack.func_77942_o() ? this.getWeaponClipSize(stack, null) : 0;
    }

    public float getDamageForArmor(ItemStack stack, EntityLivingBase living, Entity target) {
        float damage = ItemFromData.getData(stack).getFloat(PropertyType.DAMAGE) * (float)this.getWeaponPelletCount(stack, living);
        if (ItemFromData.getData(stack).hasProperty(PropertyType.ARMOR_PEN_SCALE)) {
            damage *= ItemFromData.getData(stack).getFloat(PropertyType.ARMOR_PEN_SCALE);
        }
        return damage;
    }

    public float getWeaponDamage(ItemStack stack, EntityLivingBase living, Entity target) {
        float damage = ItemFromData.getData(stack).getFloat(PropertyType.DAMAGE);
        if (living == null || living != target) {
            damage = TF2Attribute.getModifier("Damage", stack, damage, living);
            if (living != null && (ItemWeapon.isDoubleWielding(living) || living.func_184587_cr())) {
                damage *= 0.85f;
            }
            if (target != null) {
                if (!(target.func_70027_ad() || target instanceof IEntityTF2 && ((IEntityTF2)target).isBuilding())) {
                    damage = TF2Attribute.getModifier("Damage Non Burn", stack, damage, living);
                } else if (target.func_70027_ad()) {
                    damage = TF2Attribute.getModifier("Damage Burning", stack, damage, living);
                }
                if (target instanceof IEntityTF2 && ((IEntityTF2)target).isBuilding()) {
                    damage = TF2Attribute.getModifier("Damage Building", stack, damage, living);
                } else if (target instanceof EntityLivingBase) {
                    damage = TF2Attribute.getModifier("Damage Player", stack, damage, living);
                }
            }
            if (living != null && living.func_110148_a(SharedMonsterAttributes.field_111264_e) != null) {
                damage = (float)ItemWeapon.calculateModifiers(living.func_110148_a(SharedMonsterAttributes.field_111264_e), field_111210_e, damage, 0.1111111111111111);
            }
        }
        return damage;
    }

    public float getWeaponMaxDamage(ItemStack stack, EntityLivingBase living) {
        return ItemFromData.getData(stack).getFloat(PropertyType.MAX_DAMAGE);
    }

    public float getWeaponMinDamage(ItemStack stack, EntityLivingBase living) {
        return TF2Util.lerp(ItemFromData.getData(stack).getFloat(PropertyType.MIN_DAMAGE), 1.0f, (TF2Attribute.getModifier("Accuracy", stack, 1.0f, living) - 1.0f) * 0.4f);
    }

    public float getWeaponSpread(ItemStack stack, EntityLivingBase living) {
        float base = this.getWeaponSpreadBase(stack, living);
        if (living instanceof EntityTF2Character && ((EntityTF2Character)living).func_70638_az() != null) {
            float totalRotation = 0.0f;
            for (int i = 0; i < 20; ++i) {
                totalRotation += ((EntityTF2Character)living).lastRotation[i];
            }
            base += ((EntityTF2Character)living).getMotionSensitivity() * totalRotation * 0.001f;
        }
        return Math.abs(base);
    }

    public float getWeaponSpreadBase(ItemStack stack, EntityLivingBase living) {
        if (living != null && ItemFromData.getData(stack).getBoolean(PropertyType.SPREAD_RECOVERY) && ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).lastFire <= 0) {
            return 0.0f;
        }
        float value = TF2Attribute.getModifier("Spread", stack, ItemFromData.getData(stack).getFloat(PropertyType.SPREAD), living) / TF2Attribute.getModifier("Accuracy", stack, 1.0f, living);
        if (living != null && (ItemWeapon.isDoubleWielding(living) || living.func_184587_cr())) {
            value *= 1.5f;
        }
        if (TF2Attribute.getModifier("Spread Health", stack, 1.0f, living) != 1.0f) {
            value *= this.getHealthBasedBonus(stack, living, TF2Attribute.getModifier("Spread Health", stack, 1.0f, living));
        }
        return value;
    }

    public int getWeaponPelletCount(ItemStack stack, EntityLivingBase living) {
        return (int)TF2Attribute.getModifier("Pellet Count", stack, ItemFromData.getData(stack).getInt(PropertyType.PELLETS), living);
    }

    public float getWeaponDamageFalloff(ItemStack stack) {
        return ItemFromData.getData(stack).getFloat(PropertyType.DAMAGE_FALOFF);
    }

    public float getWeaponDamageFalloffMaxRange(ItemStack stack, EntityLivingBase living) {
        return TF2Attribute.getModifier("Accuracy", stack, this.getWeaponDamageFalloff(stack) * 2.0f, living);
    }

    public float getWeaponDamageFalloffSq(ItemStack stack) {
        float falloff = this.getWeaponDamageFalloff(stack);
        return falloff * falloff;
    }

    public int getWeaponReloadTime(ItemStack stack, EntityLivingBase living) {
        return (int)TF2Attribute.getModifier("Reload Time", stack, ItemFromData.getData(stack).getInt(PropertyType.RELOAD_TIME), living);
    }

    public int getWeaponFirstReloadTime(ItemStack stack, EntityLivingBase living) {
        return (int)TF2Attribute.getModifier("Reload Time", stack, ItemFromData.getData(stack).getInt(PropertyType.RELOAD_TIME_FIRST), living);
    }

    public boolean hasClip(ItemStack stack) {
        return ItemFromData.getData(stack).getBoolean(PropertyType.RELOADS_CLIP);
    }

    public int getWeaponClipSize(ItemStack stack, EntityLivingBase living) {
        int headsbonus = (int)(TF2Attribute.getModifier("Clip Kill", stack, 0.0f, living) * Math.min(TF2Attribute.getModifier("Kill Count", stack, 0.0f, living), (float)stack.func_77978_p().func_74762_e("Heads")));
        return (int)TF2Attribute.getModifier("Clip Size", stack, ItemFromData.getData(stack).getInt(PropertyType.CLIP_SIZE), living) + headsbonus;
    }

    public boolean IsReloadingFullClip(ItemStack stack) {
        return ItemFromData.getData(stack).getBoolean(PropertyType.RELOADS_FULL_CLIP);
    }

    public boolean hasRandomCrits(ItemStack stack, Entity par3Entity) {
        return (TF2ConfigVars.randomCrits == 0 || TF2ConfigVars.randomCrits == 1 && par3Entity instanceof EntityPlayer) && !par3Entity.field_70170_p.field_72995_K && ItemFromData.getData(stack).getBoolean(PropertyType.RANDOM_CRITS) && TF2Attribute.getModifier("Random Crit", stack, 0.0f, null) == 0.0f;
    }

    public double getWeaponKnockback(ItemStack stack, EntityLivingBase living) {
        return (double)TF2Attribute.getModifier("Knockback", stack, ItemFromData.getData(stack).getInt(PropertyType.KNOCKBACK), living) * (living.hasCapability(TF2weapons.WEAPONS_CAP, null) && WeaponsCapability.get((Entity)living).isRageActive(WeaponsCapability.RageType.KNOCKBACK) && TF2Attribute.getModifier("Knockback Rage", stack, 0.0f, living) != 0.0f ? 4.5 : 1.0);
    }

    public double getKnockbackForDamage(ItemStack stack, EntityLivingBase living, float damage, DamageSource src) {
        return this.getWeaponKnockback(stack, living) * (double)damage * 0.01625;
    }

    public double getZKnockback(ItemStack stack, EntityLivingBase living, float damage, DamageSource src) {
        return ItemFromData.getData(stack).getFloat(PropertyType.KNOCKBACK_Z);
    }

    public boolean rapidFireCrits(ItemStack stack) {
        return ItemFromData.getData(stack).getBoolean(PropertyType.RAPIDFIRE_CRITS);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (TF2PlayerCapability.get((EntityPlayer)player).breakBlocks && !(this instanceof ItemMeleeWeapon)) {
            player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_188479_b(Item.field_111210_e);
            return false;
        }
        return true;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return !shouldSwing;
    }

    @Override
    public void draw(WeaponsCapability cap, ItemStack stack, EntityLivingBase living, World world) {
        cap.setCritTime(0);
        cap.stopReload();
        if (living instanceof EntityPlayerMP) {
            TF2weapons.network.sendTo(new TF2Message.UseMessage(this.getClip(stack), false, this.getAmmoAmount(living, stack), EnumHand.MAIN_HAND), (EntityPlayerMP)living);
        }
        if (TF2Attribute.getModifier("Auto Fire", stack, 0.0f, living) != 0.0f) {
            this.setClip(stack, 0);
        }
        super.draw(cap, stack, living, world);
    }

    @Override
    public void holster(WeaponsCapability cap, ItemStack stack, EntityLivingBase living, World world) {
        cap.stopReload();
        cap.focusShotRemaining = 0;
        cap.focusShotTicks = 0;
        cap.setCharging(false);
        float removeHealth = 0.0f;
        for (Map.Entry entry : stack.func_111283_C(EntityEquipmentSlot.MAINHAND).entries()) {
            if (((AttributeModifier)entry.getValue()).func_111167_a() != HEALTH_MODIFIER) continue;
            removeHealth = (float)((double)removeHealth + ((AttributeModifier)entry.getValue()).func_111164_d());
        }
        if (removeHealth != 0.0f) {
            living.func_70606_j(living.func_110138_aP() / (removeHealth + living.func_110138_aP()) * living.func_110143_aJ());
        }
        super.holster(cap, stack, living, world);
    }

    @Override
    public boolean stopSlotSwitch(ItemStack stack, EntityLivingBase living) {
        return TF2Attribute.getModifier("Auto Fire", stack, 0.0f, living) != 0.0f && this.getClip(stack) > 0;
    }

    public boolean onHit(ItemStack stack, EntityLivingBase attacker, Entity target, float damage, int critical, boolean simulate) {
        float heal;
        if (target instanceof EntityBuilding && TF2Util.isOnSameTeam((Entity)attacker, target) && !((EntityBuilding)target).isSapped()) {
            float repair = TF2Attribute.getModifier("Repair Building", stack, 0.0f, attacker);
            if (repair > 0.0f) {
                if (!simulate) {
                    ((EntityBuilding)target).func_70691_i(repair);
                }
                return false;
            }
        } else if (target instanceof EntityLivingBase && TF2Util.isOnSameTeam((Entity)attacker, target) && !(target instanceof EntityBuilding) && (heal = damage * TF2Attribute.getModifier("Heal Target", stack, 0.0f, attacker)) > 0.0f) {
            if (!simulate) {
                ((EntityLivingBase)target).func_70691_i(heal);
            }
            return false;
        }
        if (target instanceof EntityLivingBase && !TF2Util.isEnemy(attacker, (EntityLivingBase)target)) {
            float speedtime = TF2Attribute.getModifier("Speed Hit", stack, 0.0f, attacker);
            if (!simulate && speedtime > 0.0f) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76424_c, (int)(speedtime * 20.0f), 1));
                attacker.func_70690_d(new PotionEffect(MobEffects.field_76424_c, (int)(speedtime * 36.0f), 1));
            }
        }
        if (TF2Attribute.getModifier("Silent Kill", stack, 0.0f, attacker) != 0.0f) {
            target.func_174810_b(true);
            if (target instanceof EntityPlayer) {
                ((TF2EventsCommon.TF2WorldStorage)target.field_70170_p.getCapability(TF2weapons.WORLD_CAP, null)).silent = target.field_70170_p.func_82736_K().func_82766_b("showDeathMessages");
                target.field_70170_p.func_82736_K().func_82764_b("showDeathMessages", "false");
            }
        } else if (target instanceof EntityLivingBase && TF2Util.isOnSameTeam((Entity)attacker, target) && !(target instanceof EntityBuilding) && (heal = damage * TF2Attribute.getModifier("Heal Target", stack, 0.0f, attacker)) > 0.0f) {
            if (!simulate) {
                ((EntityLivingBase)target).func_70691_i(heal);
            }
            return false;
        }
        return true;
    }

    public void onDealDamage(ItemStack stack, EntityLivingBase attacker, Entity target, DamageSource source, float amount) {
        if (TF2Attribute.getModifier("Burn Hit", stack, 0.0f, attacker) > 0.0f && target != attacker) {
            TF2Util.igniteAndAchievement(target, attacker, (int)TF2Attribute.getModifier("Burn Hit", stack, 0.0f, attacker), (int)TF2Attribute.getModifier("Burn Time", stack, 1.0f, attacker));
        }
        if (target instanceof EntityLivingBase && attacker.hasCapability(TF2weapons.WEAPONS_CAP, null)) {
            float bleed;
            float healthHit;
            int metalhit;
            boolean enemy = TF2Util.isEnemy(attacker, (EntityLivingBase)target);
            int stun = (int)TF2Attribute.getModifier("Stun On Hit", stack, 0.0f, attacker);
            if (!(stun <= 0 || attacker instanceof EntityPlayer && ((EntityPlayer)attacker).func_184811_cZ().func_185141_a((Item)this))) {
                TF2Util.stun((EntityLivingBase)target, 16, true);
                if (attacker instanceof EntityPlayer) {
                    ((EntityPlayer)attacker).func_184811_cZ().func_185145_a((Item)this, stun);
                }
            }
            if ((metalhit = (int)TF2Attribute.getModifier("Metal Hit", stack, 0.0f, attacker)) != 0) {
                int restore = (int)(((TF2DamageSource)source).getAttackPower() * (float)metalhit / TF2ConfigVars.damageMultiplier);
                if (attacker.func_70068_e(target) > (double)this.getWeaponDamageFalloffSq(stack)) {
                    restore /= 2;
                }
                int metaluse = this.getActualAmmoUse(stack, attacker, (int)TF2Attribute.getModifier("Metal Ammo", stack, 0.0f, attacker));
                if (!enemy && restore > metaluse) {
                    restore = metaluse;
                }
                ((WeaponsCapability)attacker.getCapability(TF2weapons.WEAPONS_CAP, null)).setMetal(((WeaponsCapability)attacker.getCapability(TF2weapons.WEAPONS_CAP, null)).getMetal() + restore);
            }
            if (!target.func_70089_S() && !(target instanceof EntityBuilding) && TF2Attribute.getModifier("Kill Count", stack, 0.0f, attacker) != 0.0f) {
                stack.func_77978_p().func_74768_a("Heads", stack.func_77978_p().func_74762_e("Heads") + 1);
            }
            if ((healthHit = TF2Attribute.getModifier("Health Hit", stack, 0.0f, attacker)) > 0.0f) {
                attacker.func_70691_i(TF2Util.getReducedHealing(attacker, (EntityLivingBase)target, enemy ? healthHit : healthHit / 2.0f));
            }
            if ((bleed = TF2Attribute.getModifier("Bleed", stack, 0.0f, attacker)) > 0.0f) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(TF2weapons.bleeding, (int)(bleed * 20.0f) + 10, 0));
            }
            int rage = (int)TF2Attribute.getModifier("Knockback Rage", stack, 0.0f, attacker);
            if (enemy && rage > 0 && !WeaponsCapability.get((Entity)attacker).isRageActive(WeaponsCapability.RageType.KNOCKBACK)) {
                this.addRage(stack, attacker, amount * (0.012f + (float)rage * 0.008f));
            }
            int ragedamage = (int)TF2Attribute.getModifier("Build Rage Damage", stack, 0.0f, attacker);
            if (enemy && ragedamage > 0 && !WeaponsCapability.get((Entity)attacker).isRageActive(this.getRageType(stack, attacker))) {
                this.addRage(stack, attacker, amount);
            }
            if (enemy && TF2Attribute.getModifier("Regen On Hit", stack, 0.0f, attacker) > 0.0f) {
                attacker.func_70690_d(new PotionEffect(TF2weapons.regen, 10, (int)TF2Attribute.getModifier("Regen On Hit", stack, 0.0f, attacker) - 1));
            }
            if (TF2Attribute.getModifier("Rocket Specialist", stack, 0.0f, attacker) > 0.0f) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)TF2Attribute.getModifier("Rocket Specialist", stack, 0.0f, attacker) * 8, 4));
                TF2Util.setVelocity(target, 0.0, 0.0, 0.0);
            }
            if (TF2Attribute.getModifier("Fire Specialist", stack, 0.0f, attacker) > 0.0f) {
                try {
                    ((EntityLivingBase)target).func_70690_d(new PotionEffect(TF2weapons.viralfire, ReflectionAccess.entityFire.getInt(target), (int)TF2Attribute.getModifier("Fire Specialist", stack, 0.0f, attacker)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (enemy && TF2Attribute.getModifier("Uber Hit", stack, 0.0f, attacker) > 0.0f && attacker instanceof EntityPlayer) {
                for (ItemStack medigun : ((EntityPlayer)attacker).field_71071_by.field_70462_a) {
                    if (medigun == null || !(medigun.func_77973_b() instanceof ItemMedigun)) continue;
                    medigun.func_77978_p().func_74776_a("ubercharge", MathHelper.func_76131_a((float)(medigun.func_77978_p().func_74760_g("ubercharge") + TF2Attribute.getModifier("Uber Hit", stack, 0.0f, attacker) / 100.0f), (float)0.0f, (float)1.0f));
                    if (!(stack.func_77978_p().func_74760_g("ubercharge") >= 1.0f)) break;
                    attacker.func_184185_a(ItemFromData.getSound(stack, PropertyType.CHARGED_SOUND), 1.2f, 1.0f);
                    break;
                }
            }
            if (TF2Attribute.getModifier("Fire Rate Hit", stack, 1.0f, attacker) != 1.0f && !WeaponsCapability.get((Entity)attacker).fireCoolReduced) {
                ((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).fire1Cool = (int)((float)((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).fire1Cool - (float)this.getFiringSpeed(stack, attacker) * (1.0f - 1.0f / TF2Attribute.getModifier("Fire Rate Hit", stack, 1.0f, attacker)));
                WeaponsCapability.get((Entity)attacker).fireCoolReduced = true;
                if (attacker instanceof EntityPlayerMP) {
                    TF2weapons.network.sendTo(new TF2Message.ActionMessage(27, attacker), (EntityPlayerMP)attacker);
                }
            }
        }
    }

    public boolean doMuzzleFlash(ItemStack stack, EntityLivingBase attacker, EnumHand hand) {
        ClientProxy.spawnFlashParticle(attacker.field_70170_p, attacker, hand);
        attacker.field_70170_p.func_72838_d((Entity)new EntityLightDynamic(attacker.field_70170_p, (Entity)attacker, 3));
        if (TF2ConfigVars.dynamicLights) {
            this.doMuzzleFlashLight(stack, attacker);
        }
        return true;
    }

    @Override
    public boolean showInfoBox(ItemStack stack, EntityPlayer player) {
        return this.getAmmoType(stack) != 0;
    }

    @Override
    public String[] getInfoBoxLines(ItemStack stack, EntityPlayer player) {
        int progress;
        String[] result = new String[2];
        boolean metalammo = TF2Attribute.getModifier("Metal Ammo", stack, 0.0f, (EntityLivingBase)player) != 0.0f;
        int holdTickMax = this.holdingMode(stack, (EntityLivingBase)player);
        WeaponsCapability cap = (WeaponsCapability)player.getCapability(TF2weapons.WEAPONS_CAP, null);
        if (holdTickMax > 0 && cap.isCharging()) {
            int chargeTicks = cap.chargeTicks;
            progress = (int)((float)chargeTicks / (float)holdTickMax * 20.0f);
            result[0] = "";
            if (progress > 0) {
                for (int i = 0; i < 20; ++i) {
                    result[0] = i < progress ? result[0] + "|" : result[0] + ".";
                }
            }
        } else {
            result[0] = metalammo ? "METAL" : "AMMO";
            int focus = (int)TF2Attribute.getModifier("Focus", stack, 0.0f, (EntityLivingBase)player);
            progress = 0;
            if (focus != 0) {
                progress = (int)((float)cap.focusShotTicks / (float)cap.focusShotTime(stack) * 8.0f);
            } else if (TF2Attribute.getModifier("Headshot", stack, 0.0f, (EntityLivingBase)player) > 0.0f) {
                progress = (1250 - ((WeaponsCapability)player.getCapability(TF2weapons.WEAPONS_CAP, null)).lastFire) / 156;
            }
            if (progress > 0) {
                result[0] = result[0] + " ";
                for (int i = 0; i < 8; ++i) {
                    result[0] = i < progress ? result[0] + "|" : result[0] + ".";
                }
            }
        }
        int ammoLeft = 0;
        ammoLeft = this.getAmmoType(stack) < ((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).cachedAmmoCount.length ? ((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).cachedAmmoCount[this.getAmmoType(stack)] : this.getAmmoAmount((EntityLivingBase)player, stack);
        if (metalammo) {
            ammoLeft = ((WeaponsCapability)player.getCapability(TF2weapons.WEAPONS_CAP, null)).getMetal();
        }
        if (this.hasClip(stack)) {
            int inClip = this.getClip(stack);
            if (ItemWeapon.isDoubleWielding((EntityLivingBase)player)) {
                inClip += ((ItemWeapon)player.func_184592_cb().func_77973_b()).getClip(player.func_184592_cb());
            }
            result[1] = inClip + "/" + ammoLeft;
        } else {
            result[1] = Integer.toString(ammoLeft);
        }
        return result;
    }

    public int holdingMode(ItemStack stack, EntityLivingBase shooter) {
        return (int)(TF2Attribute.getModifier("Charged Grenades", stack, 0.0f, shooter) * TF2Attribute.getModifier("Fire Rate", stack, 1.0f, shooter));
    }

    public boolean shouldKeepCharged(ItemStack stack, EntityLivingBase shooter) {
        return false;
    }

    public float getProjectileSpeed(ItemStack stack, EntityLivingBase living) {
        return TF2Attribute.getModifier("Proj Speed", stack, ItemFromData.getData(stack).getFloat(PropertyType.PROJECTILE_SPEED), living);
    }

    @Override
    public boolean isAmmoSufficient(ItemStack stack, EntityLivingBase living, boolean all) {
        return living.field_70170_p.field_72995_K && living != ClientProxy.getLocalPlayer() || (!this.hasClip(stack) || all) && !this.searchForAmmo(living, stack).func_190926_b() || this.hasClip(stack) && (this.getClip(stack) > 0 || !TF2ConfigVars.mustReload && living instanceof EntityPlayer && ((EntityPlayer)living).field_71075_bZ.field_75098_d);
    }

    public boolean isItemStackDamageable() {
        return false;
    }

    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || stack.func_77942_o() && this.hasKillstreak(stack, 2) && stack.func_77978_p().func_74762_e("StrKil") > 0;
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, damage);
        if (damage > this.getMaxDamage(stack)) {
            stack.func_77964_b(this.getMaxDamage(stack));
        }
    }

    public boolean canHeadshot(EntityLivingBase living, ItemStack stack) {
        return TF2Attribute.getModifier("Headshot", stack, 0.0f, living) > 0.0f && ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).lastFire <= 0;
    }

    public int getHeadshotCrit(EntityLivingBase living, ItemStack stack) {
        return 2;
    }

    public float getAdditionalGravity(EntityLivingBase living, ItemStack stack, double initial) {
        return TF2Attribute.getModifier("Gravity", stack, (float)initial, living);
    }

    @Override
    public WeaponsCapability.RageType getRageType(ItemStack stack, EntityLivingBase living) {
        return TF2Attribute.getModifier("Knockback Rage", stack, 0.0f, living) != 0.0f ? WeaponsCapability.RageType.KNOCKBACK : (TF2Attribute.getModifier("Minicrit Rage", stack, 0.0f, living) != 0.0f ? WeaponsCapability.RageType.MINICRIT : null);
    }

    @Override
    public float getMaxRage(ItemStack stack, EntityLivingBase living) {
        WeaponsCapability.RageType type = this.getRageType(stack, living);
        if (type == null) {
            return 0.0f;
        }
        switch (type) {
            case KNOCKBACK: {
                return 1.0f;
            }
        }
        return TF2Attribute.getModifier("Build Rage Damage", stack, 0.0f, living);
    }

    public float getCharge(EntityLivingBase living, ItemStack stack) {
        if (living == null) {
            return 0.0f;
        }
        if (WeaponsCapability.get((Entity)living).lastHitCharge != 0.0f) {
            return WeaponsCapability.get((Entity)living).lastHitCharge;
        }
        if (this.holdingMode(stack, living) == 0) {
            return 0.0f;
        }
        return MathHelper.func_76131_a((float)((float)WeaponsCapability.get((Entity)living).chargeTicks / (float)this.holdingMode(stack, living)), (float)0.0f, (float)1.0f);
    }

    public void playHitSound(ItemStack stack, EntityLivingBase living, Entity target) {
        SoundEvent sound = ItemWeapon.getData(stack).hasProperty(PropertyType.SPECIAL_1_SOUND) && WeaponsCapability.get((Entity)living).hitNoMiss > 0 && (float)(WeaponsCapability.get((Entity)living).hitNoMiss + 1) >= TF2Attribute.getModifier("Hit Crit", stack, 0.0f, living) ? ItemFromData.getSound(stack, PropertyType.SPECIAL_1_SOUND) : ItemFromData.getSound(stack, PropertyType.HIT_SOUND);
        TF2Util.playSound(target, sound, ItemFromData.getData(stack).getName().equals("fryingpan") ? 2.0f : 0.7f, 1.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean showDurabilityBar(ItemStack stack) {
        return this.hasClip(stack) && this.getClip(stack) != this.getWeaponClipSize(stack, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g) || super.showDurabilityBar(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double getDurabilityForDisplay(ItemStack stack) {
        if (super.showDurabilityBar(stack)) {
            return super.getDurabilityForDisplay(stack);
        }
        if (stack == Minecraft.func_71410_x().field_71439_g.func_184614_ca() && this.IsReloadingFullClip(stack)) {
            WeaponsCapability cap = WeaponsCapability.get((Entity)Minecraft.func_71410_x().field_71439_g);
            if (cap.reloadingHand != null && cap.reloadCool > 0) {
                double ready = (double)this.getClip(stack) / (double)this.getWeaponClipSize(stack, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
                return (double)cap.reloadCool / (double)this.getWeaponReloadTime(stack, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g) * (1.0 - ready);
            }
        }
        return 1.0 - (double)this.getClip(stack) / (double)this.getWeaponClipSize(stack, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    public void drawOverlay(ItemStack stack, EntityPlayer player, Tessellator tessellator, BufferBuilder buffer, ScaledResolution resolution) {
        if (this.hasKillstreak(stack, 1)) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ClientProxy.healingTexture);
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glDisable((int)3008);
            GuiIngame gui = Minecraft.func_71410_x().field_71456_v;
            ClientProxy.setColor(TF2Util.getTeamColor((Entity)player), 0.7f, 0.0f, 0.25f, 0.8f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(30.0, (double)(resolution.func_78328_b() - 20), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(71.0, (double)(resolution.func_78328_b() - 20), 0.0).func_187315_a(0.01, 1.0).func_181675_d();
            buffer.func_181662_b(71.0, (double)(resolution.func_78328_b() - 46), 0.0).func_187315_a(0.01, 0.99).func_181675_d();
            buffer.func_181662_b(30.0, (double)(resolution.func_78328_b() - 46), 0.0).func_187315_a(0.0, 0.99).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            long timestart = stack.func_77978_p().func_74762_e("StrLst");
            long timeend = stack.func_77978_p().func_74762_e("StrCol");
            float progress = MathHelper.func_76131_a((float)(1.0f - (float)(WeaponsCapability.get((Entity)player).ticksTotal - timestart) / (float)(timeend - timestart)), (float)0.0f, (float)1.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(30.0, (double)(resolution.func_78328_b() - 20), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)(30.0f + progress * 41.0f), (double)(resolution.func_78328_b() - 20), 0.0).func_187315_a(0.01, 1.0).func_181675_d();
            buffer.func_181662_b((double)(30.0f + progress * 41.0f), (double)(resolution.func_78328_b() - 21), 0.0).func_187315_a(0.01, 0.99).func_181675_d();
            buffer.func_181662_b(30.0, (double)(resolution.func_78328_b() - 21), 0.0).func_187315_a(0.0, 0.99).func_181675_d();
            tessellator.func_78381_a();
            Gui.func_146110_a((int)28, (int)(resolution.func_78328_b() - 18), (float)83.0f, (float)68.0f, (int)45, (int)40, (float)128.0f, (float)128.0f);
            gui.func_73732_a(gui.func_175179_f(), Integer.toString(stack.func_77978_p().func_74762_e("StrKil")), 50, resolution.func_78328_b() - 44, 0xFFFFFF);
            gui.func_73732_a(gui.func_175179_f(), "STREAK", 50, resolution.func_78328_b() - 31, 0xFFFFFF);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3008);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void onHitFinal(ItemStack stack, EntityLivingBase attacker, Entity target, DamageSource source) {
        if (TF2Attribute.getModifier("Silent Kill", stack, 0.0f, attacker) != 0.0f) {
            target.func_174810_b(false);
            if (target instanceof EntityPlayer) {
                target.field_70170_p.func_82736_K().func_82764_b("showDeathMessages", Boolean.toString(((TF2EventsCommon.TF2WorldStorage)target.field_70170_p.getCapability(TF2weapons.WORLD_CAP, null)).silent));
            }
        }
    }

    public static ItemWeapon getWeapon(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemWeapon ? (ItemWeapon)stack.func_77973_b() : null;
    }

    static {
        HEALTH_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785AAB6");
        SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE97871BC2");
        HEADS_HEALTH = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785FC3A");
        HEADS_SPEED = UUID.fromString("FA233E1C-4180-4865-B01B-B4A79785FC3A");
    }
}

