/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemToken;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;
import rafradek.TF2weapons.util.WeaponData;

public abstract class ItemUsable
extends ItemFromData {
    public static int sps;

    public ItemUsable() {
        this.func_77637_a(TF2weapons.tabweapontf2);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        return new ActionResult(this.canAltFire(worldIn, (EntityLivingBase)playerIn, itemStackIn) && this.getAltFiringSpeed(itemStackIn, (EntityLivingBase)playerIn) != Short.MAX_VALUE || TF2ConfigVars.swapAttackButton || ((WeaponsCapability)playerIn.getCapability(TF2weapons.WEAPONS_CAP, null)).getPrimaryCooldown() > 0 ? EnumActionResult.SUCCESS : EnumActionResult.PASS, (Object)itemStackIn);
    }

    public abstract boolean use(ItemStack var1, EntityLivingBase var2, World var3, EnumHand var4, TF2Message.PredictionMessage var5);

    public boolean startUse(ItemStack stack, EntityLivingBase living, World world, int oldState, int newState) {
        ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).pressedStart = true;
        return false;
    }

    public boolean endUse(ItemStack stack, EntityLivingBase living, World world, int oldState, int newState) {
        if ((oldState & 1) == 1 && (newState & 1) == 0) {
            WeaponsCapability.get((Entity)living).hitNoMiss = 0;
        }
        return false;
    }

    @Override
    public void func_77663_a(ItemStack stack, World par2World, Entity par3Entity, int par4, boolean par5) {
        boolean doublewield;
        super.func_77663_a(stack, par2World, par3Entity, par4, par5);
        if (stack.func_190926_b()) {
            return;
        }
        WeaponsCapability cap = (WeaponsCapability)par3Entity.getCapability(TF2weapons.WEAPONS_CAP, null);
        WeaponData.WeaponDataCapability stackcap = (WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null);
        EntityLivingBase living = (EntityLivingBase)par3Entity;
        int mincool = 0;
        if (living instanceof EntityPlayer && !par2World.field_72995_K) {
            mincool = -200;
        }
        stackcap.fire1Cool = stackcap.fire1Cool > mincool ? (stackcap.fire1Cool -= 50) : mincool;
        stackcap.fire2Cool = stackcap.fire2Cool > mincool ? (stackcap.fire2Cool -= 50) : mincool;
        boolean offhand = stack == living.func_184592_cb();
        boolean bl = doublewield = offhand && ItemUsable.isDoubleWielding(living);
        if (stackcap.active == 0 && (par5 || doublewield)) {
            stackcap.active = 1;
            if (!par2World.field_72995_K && living.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111127_a(ItemWeapon.HEALTH_MODIFIER) != null) {
                float addHealth = (float)living.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111127_a(ItemWeapon.HEALTH_MODIFIER).func_111164_d();
                living.func_70606_j(living.func_110138_aP() / (living.func_110138_aP() - addHealth) * living.func_110143_aJ());
            }
            stackcap.fire1Cool = Math.max(stackcap.fire1Cool, this.getDeployTime(stack, living));
            stackcap.fire2Cool = Math.max(stackcap.fire2Cool, this.getDeployTime(stack, living));
        } else if (stackcap.active > 0 && (offhand && !doublewield || !offhand && !par5)) {
            cap.setInactiveHand(offhand ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND, stack);
            cap.lastWeapon = stack;
        }
        if (par3Entity.field_70173_aa % 5 == 0 && stackcap.active == 2 && TF2Attribute.getModifier("Mark Death", stack, 0.0f, living) > 0.0f) {
            living.func_70690_d(new PotionEffect(TF2weapons.markDeath, (int)TF2Attribute.getModifier("Mark Death", stack, 0.0f, living) * 20));
        }
    }

    public void draw(WeaponsCapability weaponsCapability, ItemStack stack, EntityLivingBase living, World world) {
        if (living instanceof EntityPlayerMP) {
            TF2weapons.network.sendTo(new TF2Message.UseMessage(-1, false, this.getAmmoAmount(living, stack), EnumHand.MAIN_HAND), (EntityPlayerMP)living);
        }
    }

    public void holster(WeaponsCapability cap, ItemStack stack, EntityLivingBase living, World world) {
        cap.chargeTicks = 0;
        cap.setCharging(false);
    }

    public static double calculateModifiers(IAttributeInstance attribute, UUID except, double initial, double additionToMult) {
        double initialO = initial;
        for (AttributeModifier modifier : attribute.func_111130_a(0)) {
            if (modifier.func_111167_a().equals(except)) continue;
            initial += initialO * modifier.func_111164_d() * additionToMult;
        }
        for (AttributeModifier modifier : attribute.func_111130_a(1)) {
            if (modifier.func_111167_a().equals(except)) continue;
            initial += initialO * modifier.func_111164_d();
        }
        for (AttributeModifier modifier : attribute.func_111130_a(2)) {
            if (modifier.func_111167_a().equals(except)) continue;
            initial *= 1.0 + modifier.func_111164_d();
        }
        return initial;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return true;
    }

    public boolean canFireInternal(World world, EntityLivingBase living, ItemStack stack, EnumHand hand) {
        if (world.field_72995_K && living != Minecraft.func_71410_x().field_71439_g) {
            return WeaponsCapability.get((Entity)living).canFire(hand, true);
        }
        return this.canFire(world, living, stack);
    }

    public boolean canFire(World world, EntityLivingBase living, ItemStack stack) {
        return ((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).active > 0 && ItemToken.allowUse(living, this.getUsableClasses(stack)) && (living.func_184607_cu().func_190926_b() || this.getDoubleWieldBonus(stack, living) != 1.0f) && this.getFiringSpeed(stack, living) != Integer.MAX_VALUE;
    }

    public Set<String> getUsableClasses(ItemStack stack) {
        if (ItemUsable.getData(stack).get(PropertyType.SLOT).isEmpty() && ItemUsable.getData(stack).hasProperty(PropertyType.BASED_ON)) {
            stack = ItemUsable.getNewStack(ItemUsable.getData(stack).getString(PropertyType.BASED_ON));
        }
        return ItemUsable.getData(stack).get(PropertyType.SLOT).keySet();
    }

    public abstract boolean fireTick(ItemStack var1, EntityLivingBase var2, World var3);

    public abstract boolean altFireTick(ItemStack var1, EntityLivingBase var2, World var3);

    public int getFiringSpeed(ItemStack stack, EntityLivingBase living) {
        int speed = (int)TF2Attribute.getModifier("Fire Rate", stack, ItemFromData.getData(stack).getInt(PropertyType.FIRE_SPEED), living);
        if (living != null && ItemUsable.isDoubleWielding(living)) {
            speed = (int)((float)speed * (this.getDoubleWieldBonus(stack, living) * 2.0f));
        }
        if (TF2Attribute.getModifier("Fire Rate Health", stack, 1.0f, living) != 1.0f) {
            speed = (int)((float)speed * this.getHealthBasedBonus(stack, living, TF2Attribute.getModifier("Fire Rate Health", stack, 1.0f, living)));
        }
        if (living != null && (WeaponsCapability.get((Entity)living).isExpJump() || living.func_184613_cA()) && TF2Attribute.getModifier("Airborne Bonus", stack, 0.0f, living) != 0.0f) {
            speed = (int)((float)speed * 0.35f);
        }
        if (living != null && living.func_110148_a(SharedMonsterAttributes.field_188790_f) != null) {
            double modifiers = ItemUsable.calculateModifiers(living.func_110148_a(SharedMonsterAttributes.field_188790_f), field_185050_h, living.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b(), 1.4);
            speed = (int)((double)speed * ((living instanceof EntityPlayer ? 4.0 : living.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b()) / modifiers));
        }
        if (speed <= 0) {
            return Integer.MAX_VALUE;
        }
        return speed;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return player.field_70170_p.field_72995_K && !TF2ConfigVars.swapAttackButton || !player.field_70170_p.field_72995_K && !TF2PlayerCapability.get((EntityPlayer)player).breakBlocks;
    }

    public static boolean isDoubleWielding(EntityLivingBase living) {
        return ItemFromData.getData(living.func_184614_ca()) != ItemFromData.BLANK_DATA && living.func_184614_ca().func_77973_b() instanceof ItemUsable && living.func_184592_cb().func_77973_b() instanceof ItemUsable && ((ItemUsable)living.func_184592_cb().func_77973_b()).getDoubleWieldBonus(living.func_184592_cb(), living) != 1.0f && ((ItemUsable)living.func_184614_ca().func_77973_b()).getDoubleWieldBonus(living.func_184614_ca(), living) != 1.0f;
    }

    public float getDoubleWieldBonus(ItemStack stack, EntityLivingBase living) {
        return !ItemFromData.getData(stack).hasProperty(PropertyType.DUAL_WIELD_SPEED) ? 1.0f : ItemFromData.getData(stack).getFloat(PropertyType.DUAL_WIELD_SPEED);
    }

    public boolean canAltFireInternal(World worldObj, EntityLivingBase player, ItemStack item, EnumHand hand) {
        if (worldObj.field_72995_K && player != Minecraft.func_71410_x().field_71439_g) {
            return WeaponsCapability.get((Entity)player).canFire(hand, false);
        }
        return this.canAltFire(worldObj, player, item);
    }

    public boolean canAltFire(World worldObj, EntityLivingBase player, ItemStack item) {
        return ((WeaponData.WeaponDataCapability)item.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).active > 0 && ((WeaponsCapability)player.getCapability(TF2weapons.WEAPONS_CAP, null)).invisTicks == 0 && ItemToken.allowUse(player, this.getUsableClasses(item)) && (player.func_184607_cu().func_190926_b() || this.getDoubleWieldBonus(item, player) != 1.0f);
    }

    public void altUse(ItemStack stack, EntityLivingBase living, World world) {
    }

    public float getHealthBasedBonus(ItemStack item, EntityLivingBase living, float maxbonus) {
        if (living != null && living.func_110143_aJ() < living.func_110138_aP() * 0.8f) {
            float multiplier = MathHelper.func_76131_a((float)TF2Util.position(0.1f, 0.8f, living.func_110143_aJ() / living.func_110138_aP()), (float)0.0f, (float)1.0f);
            return TF2Util.lerp(1.0f, maxbonus, multiplier);
        }
        return 1.0f;
    }

    public short getAltFiringSpeed(ItemStack item, EntityLivingBase player) {
        return Short.MAX_VALUE;
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (newStack.hasCapability(TF2weapons.WEAPONS_DATA_CAP, null) && !slotChanged) {
            ((WeaponData.WeaponDataCapability)newStack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).active = ((WeaponData.WeaponDataCapability)oldStack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).active;
            ((WeaponData.WeaponDataCapability)newStack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).fire1Cool = ((WeaponData.WeaponDataCapability)oldStack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).fire1Cool;
            ((WeaponData.WeaponDataCapability)newStack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).fire2Cool = ((WeaponData.WeaponDataCapability)oldStack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).fire2Cool;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public int getDeployTime(ItemStack stack, EntityLivingBase living) {
        return (int)TF2Attribute.getModifier("Deploy Time", stack, 750.0f, living);
    }

    public int getStateOverride(ItemStack stack, EntityLivingBase living, int original) {
        if (TF2Attribute.getModifier("Auto Fire", stack, 0.0f, living) != 0.0f) {
            boolean fire;
            boolean bl = fire = (original & 1) == 0 || WeaponsCapability.get((Entity)living).autoFire;
            if (fire) {
                return 1;
            }
            return 4;
        }
        return original;
    }

    public boolean shouldEntityFire(ItemStack stack, EntityLivingBase living, EntityLivingBase target) {
        return true;
    }

    @Override
    public boolean canSwitchTo(ItemStack stack) {
        return true;
    }
}

