/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.WeaponsCapability;

public class ItemToken
extends Item {
    public static final UUID SPEED_UUID = UUID.fromString("769e0d47-bb57-45ed-8fe4-ab84592d842b");
    public static final UUID HEALTH_UUID = UUID.fromString("ff0b26f3-cf6d-49e6-9989-3886ec3d3b83");
    public static final UUID HEALTH_MULT_UUID = UUID.fromString("ff0b26f3-cf6d-49e6-9989-3886ec3d3e83");
    public static final float[] SPEED_VALUES = new float[]{0.7638f, 0.0583f, 0.329f, 0.2347f, 0.0f, 0.329f, 0.4111f, 0.329f, 0.4111f};
    public static final float[] FOV_VALUES = new float[]{0.7638f, 0.0583f, 0.329f, 0.2347f, 0.0f, 0.329f, 0.4111f, 0.329f, 0.4111f};
    public static final float[] HEALTH_VALUES = new float[]{-7.5f, 0.0f, -2.5f, -2.5f, 10.0f, -7.5f, -5.0f, -7.5f, -7.5f};
    public static final double[] EXPLOSION_VALUES = new double[]{1.0, 0.667, 0.95, 0.75, 0.5, 1.0, 0.95, 1.0, 1.0};
    public static final String[] CLASS_NAMES = new String[]{"scout", "soldier", "pyro", "demoman", "heavy", "engineer", "medic", "sniper", "spy"};

    public ItemToken() {
        this.func_77627_a(true);
        this.func_77637_a(TF2weapons.tabsurvivaltf2);
        this.func_77655_b("token");
    }

    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        if (!this.func_194125_a(par2CreativeTabs)) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            par3List.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    public void updateAttributes(ItemStack stack, EntityLivingBase living) {
        living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(SPEED_UUID);
        living.func_110148_a(SharedMonsterAttributes.field_111267_a).func_188479_b(HEALTH_UUID);
        living.func_110148_a(SharedMonsterAttributes.field_111267_a).func_188479_b(HEALTH_MULT_UUID);
        if (!stack.func_190926_b() && stack.func_77960_j() >= 0 && stack.func_77960_j() < CLASS_NAMES.length) {
            WeaponsCapability.get((Entity)living).setUsedToken(stack.func_77960_j());
            living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(SPEED_UUID, "tokenspeed", (double)SPEED_VALUES[stack.func_77960_j()], 1));
            living.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(HEALTH_UUID, "tokenhealth", (double)HEALTH_VALUES[stack.func_77960_j()], 0));
            living.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(HEALTH_MULT_UUID, "tokenhealthmult", (double)(TF2ConfigVars.damageMultiplier - 1.0f), 2));
        } else {
            WeaponsCapability.get((Entity)living).setUsedToken(-1);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer living, EnumHand hand) {
        if (!world.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)living, (Object)TF2weapons.instance, (int)0, (World)world, (int)0, (int)0, (int)0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)living.func_184586_b(hand));
    }

    public static boolean allowUse(EntityLivingBase living, String clazz) {
        return ItemToken.allowUse(living, (Set<String>)Sets.newHashSet((Object[])new String[]{clazz}));
    }

    public static boolean allowUse(EntityLivingBase living, Set<String> clazz) {
        return !(living instanceof EntityPlayer) || ItemToken.allowUse(WeaponsCapability.get((Entity)living).getUsedToken(), clazz);
    }

    public static boolean allowUse(int livingclass, Set<String> clazz) {
        return clazz.isEmpty() || livingclass < 0 || livingclass >= CLASS_NAMES.length || clazz.contains(CLASS_NAMES[livingclass]);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + CLASS_NAMES[stack.func_77960_j()];
    }

    public static int getClassID(String name) {
        switch (name) {
            case "scout": {
                return 0;
            }
            case "soldier": {
                return 1;
            }
            case "pyro": {
                return 2;
            }
            case "demoman": {
                return 3;
            }
            case "heavy": {
                return 4;
            }
            case "engineer": {
                return 5;
            }
            case "medic": {
                return 6;
            }
            case "sniper": {
                return 7;
            }
            case "spy": {
                return 8;
            }
        }
        return 0;
    }
}

