/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.building.EntityDispenser;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.entity.mercenary.EntityEngineer;
import rafradek.TF2weapons.entity.projectile.EntityStickybomb;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemProjectileWeapon;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;

public class ItemStickyLauncher
extends ItemProjectileWeapon {
    public boolean usePrediction() {
        return false;
    }

    @Override
    public float getProjectileSpeed(ItemStack stack, EntityLivingBase living) {
        return super.getProjectileSpeed(stack, living) * (1.0f + (float)((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).chargeTicks * 0.02f);
    }

    @Override
    public void shoot(ItemStack stack, EntityLivingBase living, World world, int thisCritical, EnumHand hand) {
        if (!world.field_72995_K) {
            EntityStickybomb bomb = new EntityStickybomb(world);
            bomb.initProjectile(living, hand, stack);
            bomb.setCritical(thisCritical);
            world.func_72838_d((Entity)bomb);
            ArrayList<EntityStickybomb> list = ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).activeBomb;
            list.add(bomb);
            if ((float)list.size() > TF2Attribute.getModifier("Stickybomb Count", stack, 8.0f, living)) {
                EntityStickybomb firstBomb = list.get(0);
                firstBomb.explode(firstBomb.field_70165_t, firstBomb.field_70163_u, firstBomb.field_70161_v, null, 1.0f);
            }
        }
    }

    @Override
    public boolean altFireTick(ItemStack stack, EntityLivingBase living, World world) {
        if (!world.field_72995_K) {
            ArrayList<EntityStickybomb> list = ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).activeBomb;
            if (list == null || list.isEmpty()) {
                return false;
            }
            boolean exploded = false;
            TF2PlayerCapability cap = (TF2PlayerCapability)living.getCapability(TF2weapons.PLAYER_CAP, null);
            if (cap != null) {
                cap.engineerKilled = false;
                cap.dispenserKilled = false;
                cap.sentryKilled = false;
                cap.stickybombKilled = 0;
            }
            for (int i = 0; i < list.size(); ++i) {
                EntityStickybomb bomb = list.get(i);
                if (bomb.field_70173_aa <= bomb.getArmTime() || bomb.getType() == 1 && !living.func_174813_aQ().func_72314_b(1.5, 0.25, 1.5).func_72317_d(0.0, -1.25, 0.0).func_72318_a(bomb.func_174791_d()) && !TF2Util.lookingAt(living, 30.0, bomb.field_70165_t, bomb.field_70163_u, bomb.field_70161_v)) continue;
                bomb.explode(bomb.field_70165_t, bomb.field_70163_u + (double)(bomb.field_70131_O / 2.0f), bomb.field_70161_v, null, 1.0f);
                --i;
                exploded = true;
            }
            if (exploded) {
                living.func_184185_a(ItemFromData.getSound(stack, PropertyType.DETONATE_SOUND), 1.0f, 1.0f);
            }
        }
        return false;
    }

    @Override
    public void onDealDamage(ItemStack stack, EntityLivingBase attacker, Entity target, DamageSource source, float amount) {
        super.onDealDamage(stack, attacker, target, source, amount);
        TF2PlayerCapability cap = (TF2PlayerCapability)attacker.getCapability(TF2weapons.PLAYER_CAP, null);
        if (attacker instanceof EntityPlayer && !target.func_70089_S()) {
            if (target instanceof EntityLivingBase && !(target instanceof EntityBuilding)) {
                ++cap.stickybombKilled;
            }
            if (target instanceof EntityEngineer) {
                cap.engineerKilled = true;
            } else if (target instanceof EntitySentry) {
                cap.sentryKilled = true;
            } else if (target instanceof EntityDispenser) {
                cap.dispenserKilled = true;
            }
        }
    }

    @Override
    public int holdingMode(ItemStack stack, EntityLivingBase shooter) {
        return 80;
    }
}

