/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemBackpack;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;

public class ItemSoldierBackpack
extends ItemBackpack {
    public static ItemStack horn = ItemStack.field_190927_a;

    public ItemSoldierBackpack() {
        this.func_185043_a(new ResourceLocation("active"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn != null && WeaponsCapability.get((Entity)entityIn) != null && WeaponsCapability.get((Entity)entityIn).isRageActive(WeaponsCapability.RageType.BANNER)) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public Potion getBuff(ItemStack stack) {
        return Potion.func_180142_b((String)ItemSoldierBackpack.getData(stack).getString(PropertyType.EFFECT_TYPE));
    }

    @Override
    public WeaponsCapability.RageType getRageType(ItemStack stack, EntityLivingBase living) {
        return WeaponsCapability.RageType.BANNER;
    }

    @Override
    public float getMaxRage(ItemStack stack, EntityLivingBase living) {
        return 1.0f;
    }

    @Override
    public ItemStack getBackpackItemToUse(ItemStack stack, EntityLivingBase player) {
        if (horn.func_190926_b()) {
            horn = new ItemStack(TF2weapons.itemHorn);
        }
        return horn;
    }

    public void addRage(ItemStack stack, float damage, EntityLivingBase target, EntityLivingBase attacker) {
        if (target instanceof EntityTF2Character && !(attacker instanceof EntityPlayer)) {
            damage *= 0.5f;
        } else if (!(target instanceof EntityPlayer)) {
            damage *= 0.35f;
        }
        this.addRage(stack, attacker, damage / ItemSoldierBackpack.getData(stack).getFloat(PropertyType.DAMAGE));
    }

    @Override
    public void onArmorTickAny(World world, final EntityLivingBase player, ItemStack itemStack) {
        super.onArmorTickAny(world, player, itemStack);
        if (!world.field_72995_K && player.field_70173_aa % 5 == 0 && WeaponsCapability.get((Entity)player).isRageActive(WeaponsCapability.RageType.BANNER)) {
            for (EntityLivingBase living : world.func_175647_a(EntityLivingBase.class, player.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0), (Predicate)new Predicate<EntityLivingBase>(){

                public boolean apply(EntityLivingBase input) {
                    return TF2Util.isOnSameTeam((Entity)player, (Entity)input);
                }
            })) {
                TF2Util.addAndSendEffect(living, new PotionEffect(this.getBuff(itemStack), 25));
            }
        }
    }

    public void setActive(EntityLivingBase player, ItemStack stack) {
        float duration = TF2Attribute.getModifier("Effect Duration", stack, ItemSoldierBackpack.getData(stack).getInt(PropertyType.DURATION), player) * (float)(TF2ConfigVars.longDurationBanner ? 2 : 5);
        WeaponsCapability.get((Entity)player).setRageActive(WeaponsCapability.RageType.BANNER, true, 1.0f / duration * 20.0f);
    }
}

