/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.mercenary.EntitySniper;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemBulletWeapon;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2DamageSource;
import rafradek.TF2weapons.util.TF2Util;

public class ItemSniperRifle
extends ItemBulletWeapon {
    public static UUID slowdownUUID = UUID.fromString("12843092-A5D6-BBCD-3D4F-A3DD4D8C65A9");
    public static AttributeModifier slowdown = new AttributeModifier(slowdownUUID, "sniper slowdown", -0.73, 2);

    @Override
    public boolean canAltFire(World worldObj, EntityLivingBase player, ItemStack item) {
        return super.canAltFire(worldObj, player, item) && ((WeaponsCapability)player.getCapability(TF2weapons.WEAPONS_CAP, null)).getPrimaryCooldown() <= 0;
    }

    @Override
    public boolean use(ItemStack stack, EntityLivingBase living, World world, EnumHand hand, TF2Message.PredictionMessage message) {
        if (!(living instanceof EntityTF2Character) || stack.func_77978_p().func_74767_n("WaitProper")) {
            super.use(stack, living, world, hand, message);
            if (TF2Attribute.getModifier("Weapon Mode", stack, 0.0f, living) != 2.0f) {
                this.disableZoom(stack, living);
            } else {
                ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).chargeTicks = (int)((float)((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).chargeTicks - ItemSniperRifle.getChargeTime(stack, living) * 0.08f);
            }
            stack.func_77978_p().func_74757_a("WaitProper", false);
            if (message != null && (message.readData == null || message.readData.isEmpty())) {
                ((TF2PlayerCapability)living.getCapability(TF2weapons.PLAYER_CAP, null)).headshotsRow = 0;
            }
            return true;
        }
        stack.func_77978_p().func_74757_a("WaitProper", true);
        this.altUse(stack, living, world);
        ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).setPrimaryCooldown(2500);
        return false;
    }

    @Override
    public void altUse(ItemStack stack, EntityLivingBase living, World world) {
        WeaponsCapability cap = (WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null);
        if (!cap.isCharging()) {
            cap.setCharging(true);
            if (living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(slowdownUUID) == null) {
                living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(slowdown);
            }
        } else {
            this.disableZoom(stack, living);
        }
        cap.setPrimaryCooldown(400);
    }

    @Override
    public boolean fireTick(ItemStack stack, EntityLivingBase living, World world) {
        if (!world.field_72995_K && living instanceof EntityPlayer && living.field_70173_aa % 20 == 0 && TF2Attribute.getModifier("Weapon Mode", stack, 0.0f, living) == 1.0f && !((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).isCharging()) {
            TF2Util.playSound((Entity)living, ItemSniperRifle.getSound(stack, PropertyType.NO_FIRE_SOUND), 0.7f, 1.0f);
        }
        return super.fireTick(stack, living, world);
    }

    public void disableZoom(ItemStack stack, EntityLivingBase living) {
        WeaponsCapability cap = (WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null);
        cap.setCharging(false);
        living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(slowdown);
    }

    @Override
    public boolean canHeadshot(EntityLivingBase living, ItemStack stack) {
        return !(((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).chargeTicks <= 4 && TF2Attribute.getModifier("Weapon Mode", stack, 0.0f, living) != 2.0f || TF2Attribute.getModifier("No Headshot", stack, 0.0f, living) != 0.0f && TF2Attribute.getModifier("Jarate Hit", stack, 0.0f, living) == 0.0f);
    }

    @Override
    public int getHeadshotCrit(EntityLivingBase living, ItemStack stack) {
        return TF2Attribute.getModifier("Jarate Hit", stack, 0.0f, living) != 0.0f ? 1 : 2;
    }

    @Override
    public boolean showTracer(ItemStack stack) {
        return TF2Attribute.getModifier("Weapon Mode", stack, 0.0f, null) >= 1.0f;
    }

    @Override
    public boolean showSpecialTracer(ItemStack stack) {
        return TF2Attribute.getModifier("Weapon Mode", stack, 0.0f, null) == 1.0f;
    }

    @Override
    public float getWeaponDamage(ItemStack stack, EntityLivingBase living, Entity target) {
        return super.getWeaponDamage(stack, living, target) * (living != null ? this.getZoomBonus(stack, living) * ((float)((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).chargeTicks >= ItemSniperRifle.getChargeTime(stack, living) ? TF2Attribute.getModifier("Damage Charged", stack, 1.0f, living) : 1.0f) : 1.0f);
    }

    @Override
    public float getWeaponMaxDamage(ItemStack stack, EntityLivingBase living) {
        return super.getWeaponMaxDamage(stack, living);
    }

    @Override
    public float getWeaponMinDamage(ItemStack stack, EntityLivingBase living) {
        return super.getWeaponMinDamage(stack, living);
    }

    public float getZoomBonus(ItemStack stack, EntityLivingBase living) {
        return 1.0f + Math.max(0.0f, ((float)((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).chargeTicks - ItemSniperRifle.getChargeStartTime(stack, living)) / ((ItemSniperRifle.getChargeTime(stack, living) - ItemSniperRifle.getChargeStartTime(stack, living)) / 2.0f));
    }

    public static float getChargeTime(ItemStack stack, EntityLivingBase living) {
        return 66.0f / TF2Attribute.getModifier("Charge", stack, 1.0f, living);
    }

    public static float getChargeStartTime(ItemStack stack, EntityLivingBase living) {
        return 26.0f / (TF2Attribute.getModifier("Charge", stack, 0.5f, living) + 0.5f);
    }

    @Override
    public short getAltFiringSpeed(ItemStack item, EntityLivingBase player) {
        return 400;
    }

    @Override
    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        super.func_77663_a(par1ItemStack, par2World, par3Entity, par4, par5);
        WeaponsCapability cap = (WeaponsCapability)par3Entity.getCapability(TF2weapons.WEAPONS_CAP, null);
        if (cap.reloadCool > 0 && par5 && cap.isCharging()) {
            this.disableZoom(par1ItemStack, (EntityLivingBase)par3Entity);
        }
        if (cap.isCharging() && par5 && (TF2Attribute.getModifier("Weapon Mode", par1ItemStack, 0.0f, (EntityLivingBase)par3Entity) != 2.0f || cap.getPrimaryCooldown() <= 0) && (float)cap.chargeTicks < ItemSniperRifle.getChargeTime(par1ItemStack, (EntityLivingBase)par3Entity)) {
            ++cap.chargeTicks;
        }
        if (par3Entity instanceof EntitySniper && ((EntitySniper)par3Entity).func_70638_az() != null && par1ItemStack.func_77978_p().func_74767_n("WaitProper") && ((EntitySniper)par3Entity).func_110143_aJ() < 8.0f && cap.getPrimaryCooldown() > 250) {
            ((WeaponsCapability)par3Entity.getCapability(TF2weapons.WEAPONS_CAP, null)).setPrimaryCooldown(250);
        }
    }

    @Override
    public void holster(WeaponsCapability cap, ItemStack stack, EntityLivingBase living, World world) {
        this.disableZoom(stack, living);
        super.holster(cap, stack, living, world);
    }

    @Override
    public boolean canFire(World worldObj, EntityLivingBase player, ItemStack item) {
        if (super.canFire(worldObj, player, item)) {
            return !(player instanceof EntityPlayer) || TF2Attribute.getModifier("Weapon Mode", item, 0.0f, player) != 1.0f || ((WeaponsCapability)player.getCapability(TF2weapons.WEAPONS_CAP, null)).isCharging();
        }
        return false;
    }

    @Override
    public void onDealDamage(ItemStack stack, EntityLivingBase attacker, Entity target, DamageSource source, float amount) {
        super.onDealDamage(stack, attacker, target, source, amount);
        boolean headshot = ((TF2DamageSource)source).hasAttackFlag(2);
        if (target instanceof EntityLivingBase && TF2Attribute.getModifier("Jarate Hit", stack, 0.0f, attacker) != 0.0f && (headshot || WeaponsCapability.get((Entity)attacker).chargeTicks > 12)) {
            int time = (int)(TF2Attribute.getModifier("Jarate Hit", stack, 0.0f, attacker) * this.getZoomBonus(stack, attacker));
            if (headshot) {
                --time;
            }
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(TF2weapons.jarate, time * 20));
        }
    }

    @Override
    public void doFireSound(ItemStack stack, EntityLivingBase living, World world, int critical) {
        if (ItemFromData.getData(stack).hasProperty(PropertyType.CHARGED_FIRE_SOUND) && (float)((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).chargeTicks >= ItemSniperRifle.getChargeTime(stack, living)) {
            SoundEvent soundToPlay = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(ItemFromData.getData(stack).getString(PropertyType.CHARGED_FIRE_SOUND) + (critical == 2 ? ".crit" : "")));
            living.func_184185_a(soundToPlay, 4.0f, 1.0f);
            if (world.field_72995_K) {
                ClientProxy.removeReloadSound(living);
            }
        } else {
            super.doFireSound(stack, living, world, critical);
        }
    }

    @Override
    public void drawOverlay(ItemStack stack, EntityPlayer player, Tessellator tessellator, BufferBuilder renderer, ScaledResolution resolution) {
        WeaponsCapability cap = WeaponsCapability.get((Entity)player);
        if (cap.isCharging()) {
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3008);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ClientProxy.scopeTexture);
            double widthDrawStart = (double)(resolution.func_78326_a() - resolution.func_78328_b()) / 2.0;
            double widthDrawEnd = widthDrawStart + (double)resolution.func_78328_b();
            renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            renderer.func_181662_b(widthDrawStart, (double)resolution.func_78328_b(), -90.0).func_187315_a(0.0, 1.0).func_181675_d();
            renderer.func_181662_b(widthDrawEnd, (double)resolution.func_78328_b(), -90.0).func_187315_a(1.0, 1.0).func_181675_d();
            renderer.func_181662_b(widthDrawEnd, 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
            renderer.func_181662_b(widthDrawStart, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ClientProxy.blackTexture);
            renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            renderer.func_181662_b(0.0, (double)resolution.func_78328_b(), -90.0).func_187315_a(0.0, 1.0).func_181675_d();
            renderer.func_181662_b(widthDrawStart, (double)resolution.func_78328_b(), -90.0).func_187315_a(1.0, 1.0).func_181675_d();
            renderer.func_181662_b(widthDrawStart, 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
            renderer.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            renderer.func_181662_b(widthDrawEnd, (double)resolution.func_78328_b(), -90.0).func_187315_a(0.0, 1.0).func_181675_d();
            renderer.func_181662_b((double)resolution.func_78326_a(), (double)resolution.func_78328_b(), -90.0).func_187315_a(1.0, 1.0).func_181675_d();
            renderer.func_181662_b((double)resolution.func_78326_a(), 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
            renderer.func_181662_b(widthDrawEnd, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ClientProxy.chargeTexture);
            GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)0.7f);
            renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            renderer.func_181662_b((double)resolution.func_78326_a() / 2.0 + 50.0, (double)resolution.func_78328_b() / 2.0 + 15.0, -90.0).func_187315_a(0.0, 0.25).func_181675_d();
            renderer.func_181662_b((double)resolution.func_78326_a() / 2.0 + 100.0, (double)resolution.func_78328_b() / 2.0 + 15.0, -90.0).func_187315_a(0.508, 0.25).func_181675_d();
            renderer.func_181662_b((double)resolution.func_78326_a() / 2.0 + 100.0, (double)resolution.func_78328_b() / 2.0, -90.0).func_187315_a(0.508, 0.0).func_181675_d();
            renderer.func_181662_b((double)resolution.func_78326_a() / 2.0 + 50.0, (double)resolution.func_78328_b() / 2.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            if ((float)cap.chargeTicks >= ItemSniperRifle.getChargeStartTime(stack, (EntityLivingBase)player)) {
                renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                renderer.func_181662_b((double)resolution.func_78326_a() / 2.0 + 110.0, (double)resolution.func_78328_b() / 2.0 + 18.0, -90.0).func_187315_a(0.0, 0.57).func_181675_d();
                renderer.func_181662_b((double)resolution.func_78326_a() / 2.0 + 121.0, (double)resolution.func_78328_b() / 2.0 + 18.0, -90.0).func_187315_a(0.125, 0.57).func_181675_d();
                renderer.func_181662_b((double)resolution.func_78326_a() / 2.0 + 121.0, (double)resolution.func_78328_b() / 2.0 - 3.0, -90.0).func_187315_a(0.125, 0.25).func_181675_d();
                renderer.func_181662_b((double)resolution.func_78326_a() / 2.0 + 110.0, (double)resolution.func_78328_b() / 2.0 - 3.0, -90.0).func_187315_a(0.0, 0.25).func_181675_d();
                tessellator.func_78381_a();
            }
            double progress = (float)cap.chargeTicks / ItemSniperRifle.getChargeTime(stack, (EntityLivingBase)player);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            renderer.func_181662_b((double)resolution.func_78326_a() / 2.0 + 50.0, (double)resolution.func_78328_b() / 2.0 + 15.0, -90.0).func_187315_a(0.0, 0.25).func_181675_d();
            renderer.func_181662_b((double)resolution.func_78326_a() / 2.0 + 50.0 + progress * 50.0, (double)resolution.func_78328_b() / 2.0 + 15.0, -90.0).func_187315_a(progress * 0.508, 0.25).func_181675_d();
            renderer.func_181662_b((double)resolution.func_78326_a() / 2.0 + 50.0 + progress * 50.0, (double)resolution.func_78328_b() / 2.0, -90.0).func_187315_a(progress * 0.508, 0.0).func_181675_d();
            renderer.func_181662_b((double)resolution.func_78326_a() / 2.0 + 50.0, (double)resolution.func_78328_b() / 2.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            if (progress >= 1.0) {
                renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                renderer.func_181662_b((double)resolution.func_78326_a() / 2.0 + 110.0, (double)resolution.func_78328_b() / 2.0 + 18.0, -90.0).func_187315_a(0.0, 0.57).func_181675_d();
                renderer.func_181662_b((double)resolution.func_78326_a() / 2.0 + 121.0, (double)resolution.func_78328_b() / 2.0 + 18.0, -90.0).func_187315_a(0.125, 0.57).func_181675_d();
                renderer.func_181662_b((double)resolution.func_78326_a() / 2.0 + 121.0, (double)resolution.func_78328_b() / 2.0 - 3.0, -90.0).func_187315_a(0.125, 0.25).func_181675_d();
                renderer.func_181662_b((double)resolution.func_78326_a() / 2.0 + 110.0, (double)resolution.func_78328_b() / 2.0 - 3.0, -90.0).func_187315_a(0.0, 0.25).func_181675_d();
                tessellator.func_78381_a();
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3008);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        super.drawOverlay(stack, player, tessellator, renderer, resolution);
    }

    static {
        slowdown.func_111168_a(false);
    }
}

