/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.entity.EntityDummy;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.mercenary.EntityScout;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.entity.projectile.EntityBall;
import rafradek.TF2weapons.entity.projectile.EntityProjectileBase;
import rafradek.TF2weapons.item.ItemAmmo;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;

public class ItemProjectileWeapon
extends ItemWeapon {
    @Override
    public void shoot(ItemStack stack, EntityLivingBase living, World world, int thisCritical, EnumHand hand) {
        if (!world.field_72995_K) {
            try {
                EntityProjectileBase proj = MapList.projectileClasses.get(ItemFromData.getData(stack).getString(PropertyType.PROJECTILE)).getConstructor(World.class).newInstance(world);
                proj.initProjectile(living, hand, stack);
                proj.setCritical(thisCritical);
                this.onProjectileShoot(stack, proj, living, world, thisCritical, hand);
                world.func_72838_d((Entity)proj);
                proj.infinite = this.isProjectileInfinite(living, stack);
                proj.trace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void onProjectileShoot(ItemStack stack, EntityProjectileBase proj, EntityLivingBase living, World world, int thisCritical, EnumHand hand) {
    }

    @Override
    public void onDealDamage(ItemStack stack, EntityLivingBase attacker, Entity target, DamageSource source, float amount) {
        super.onDealDamage(stack, attacker, target, source, amount);
        if (target instanceof EntityLivingBase && !(target instanceof EntityBuilding) && ItemProjectileWeapon.getData(stack).getName().equals("sandmanball")) {
            EntityBall ball = (EntityBall)source.func_76364_f();
            double reduce = Math.max(0.5, (25.0 - ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e()) / 25.0);
            if (attacker instanceof EntityTF2Character) {
                reduce *= (double)((EntityTF2Character)attacker).scaleWithDifficulty(0.5f, 1.0f);
            }
            if (!ball.canBePickedUp && ball.throwPos.func_72436_e(target.func_174791_d()) > 1100.0) {
                TF2Util.stun((EntityLivingBase)target, (int)(160.0 * reduce), true);
                target.func_184185_a(TF2Sounds.WEAPON_STUN_MAX, 4.0f, 1.0f);
            } else if (!ball.canBePickedUp && ball.throwPos.func_72436_e(target.func_174791_d()) > 12.0) {
                TF2Util.stun((EntityLivingBase)target, (int)(ball.throwPos.func_72438_d(target.func_174791_d()) * 8.0 * reduce), false);
                target.func_184185_a(TF2Sounds.WEAPON_STUN, 1.6f, 1.0f);
            }
        }
    }

    public boolean isProjectileInfinite(EntityLivingBase living, ItemStack stack) {
        return !(living instanceof EntityDummy) && this.searchForAmmo(living, stack) == ItemAmmo.STACK_FILL;
    }

    @Override
    public boolean canFire(World world, EntityLivingBase living, ItemStack stack) {
        return super.canFire(world, living, stack) && (!(living instanceof EntityScout) || ((EntityScout)living).usedSlot != 2 || ((EntityScout)living).ballCooldown <= 0);
    }
}

