/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFence;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.building.EntityDispenser;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.entity.building.EntityTeleporter;
import rafradek.TF2weapons.item.IItemNoSwitch;
import rafradek.TF2weapons.item.IItemOverlay;
import rafradek.TF2weapons.item.IItemSlotNumber;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemMonsterPlacerPlus;
import rafradek.TF2weapons.item.ItemToken;
import rafradek.TF2weapons.item.ItemWrench;
import rafradek.TF2weapons.util.PlayerPersistStorage;
import rafradek.TF2weapons.util.TF2Util;

public class ItemPDA
extends ItemFromData
implements IItemSlotNumber,
IItemOverlay,
IItemNoSwitch {
    private static final DataParameter<NBTTagCompound>[] VIEWS = new DataParameter[]{TF2PlayerCapability.SENTRY_VIEW, TF2PlayerCapability.DISPENSER_VIEW, TF2PlayerCapability.TELEPORTERA_VIEW, TF2PlayerCapability.TELEPORTERB_VIEW};
    private static final String[] GUI_BUILD_NAMES = new String[]{"gui.build.sentry", "gui.build.dispenser", "gui.build.entrance", "gui.build.exit", "gui.build.disposable"};

    public ItemPDA() {
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("building"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (!stack.func_77942_o() || stack.func_77978_p().func_74771_c("Building") == 0) {
                    return 0.0f;
                }
                byte building = stack.func_77978_p().func_74771_c("Building");
                if (building == 1 || building == 5) {
                    return 0.33f;
                }
                if (building == 2) {
                    return 0.66f;
                }
                return 1.0f;
            }
        });
    }

    @Override
    public boolean catchSlotHotkey(ItemStack stack, EntityPlayer player) {
        return ItemToken.allowUse((EntityLivingBase)player, "engineer") && !stack.func_77942_o() || stack.func_77978_p().func_74771_c("Building") == 0;
    }

    @Override
    public void onSlotSelection(ItemStack stack, EntityPlayer player, int slot) {
        if (!player.field_70170_p.field_72995_K && TF2PlayerCapability.get((EntityPlayer)player).carrying == null && slot < 5) {
            if (slot == 4 && TF2PlayerCapability.get(player).calculateMaxSentries() <= 0) {
                return;
            }
            if (!PlayerPersistStorage.get(player).hasBuilding(slot)) {
                int metal = EntityBuilding.getCost(slot, TF2Util.getFirstItem((IInventory)player.field_71071_by, (Predicate<ItemStack>)((Predicate)stackL -> TF2Attribute.getModifier("Teleporter Cost", stackL, 1.0f, (EntityLivingBase)player) != 1.0f)));
                if (WeaponsCapability.get((Entity)player).hasMetal(metal)) {
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    stack.func_77978_p().func_74774_a("Building", (byte)(slot + 1));
                }
            } else {
                PlayerPersistStorage.get((EntityPlayer)player).buildings[slot] = null;
            }
        }
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.forceItemSlot(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            PlayerPersistStorage storage = PlayerPersistStorage.get((EntityPlayer)entityIn);
            stack.func_77978_p().func_74757_a("IsC", TF2PlayerCapability.get((EntityPlayer)((EntityPlayer)entityIn)).carrying != null);
            if (TF2PlayerCapability.get((EntityPlayer)((EntityPlayer)entityIn)).carrying != null) {
                stack.func_77978_p().func_74774_a("Building", (byte)((byte)TF2PlayerCapability.get((EntityPlayer)((EntityPlayer)entityIn)).carryingType + 1));
            } else if (stack.func_77978_p().func_74771_c("Building") > 0) {
                int metal = EntityBuilding.getCost(stack.func_77978_p().func_74771_c("Building") - 1, TF2Util.getFirstItem((IInventory)((EntityPlayer)entityIn).field_71071_by, (Predicate<ItemStack>)((Predicate)stackL -> stackL.func_77973_b() instanceof ItemWrench)));
                if (!WeaponsCapability.get(entityIn).hasMetal(metal) || storage.hasBuilding(stack.func_77978_p().func_74771_c("Building") - 1)) {
                    stack.func_77978_p().func_74774_a("Building", (byte)0);
                }
            }
        }
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            if (!stack.func_77942_o() || stack.func_77978_p().func_74771_c("Building") == 0) {
                return EnumActionResult.PASS;
            }
            return EnumActionResult.SUCCESS;
        }
        if (!playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack) || !stack.func_77942_o() || stack.func_77978_p().func_74771_c("Building") == 0) {
            return EnumActionResult.PASS;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        pos = pos.func_177972_a(facing);
        double d0 = 0.0;
        if (facing == EnumFacing.UP && iblockstate.func_177230_c() instanceof BlockFence) {
            d0 = 0.5;
        }
        boolean disposable = stack.func_77978_p().func_74771_c("Building") == 5;
        int id = 16 + stack.func_77978_p().func_74771_c("Building") * 2;
        if (stack.func_77978_p().func_74771_c("Building") == 4) {
            id -= 2;
        } else if (disposable) {
            id = 18;
        }
        EntityBuilding entity = (EntityBuilding)ItemMonsterPlacerPlus.spawnCreature((Entity)playerIn, worldIn, id, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + d0, (double)pos.func_177952_p() + 0.5, TF2PlayerCapability.get((EntityPlayer)playerIn).carrying);
        if (entity != null) {
            entity.setEntTeam(TF2Util.getTeamForDisplay((Entity)playerIn));
            entity.setOwner((EntityLivingBase)playerIn);
            if (entity instanceof EntitySentry) {
                ((EntitySentry)entity).attackRateMult = TF2Attribute.getModifier("Sentry Fire Rate", stack, 1.0f, (EntityLivingBase)playerIn);
                TF2Util.addModifierSafe((EntityLivingBase)entity, SharedMonsterAttributes.field_111265_b, new AttributeModifier("upgraderange", (double)(TF2Attribute.getModifier("Sentry Range", stack, 1.0f, (EntityLivingBase)entity) - 1.0f), 2), true);
                ((EntitySentry)entity).setHeat((int)TF2Attribute.getModifier("Piercing", stack, 0.0f, (EntityLivingBase)playerIn));
                if (disposable || !TF2Util.getFirstItem((IInventory)playerIn.field_71071_by, (Predicate<ItemStack>)((Predicate)stackL -> stackL.func_77973_b() instanceof ItemWrench && TF2Attribute.getModifier("Weapon Mode", stackL, 0.0f, (EntityLivingBase)playerIn) == 2.0f)).func_190926_b()) {
                    ((EntitySentry)entity).setMini(true);
                    if (entity.getLevel() > 1) {
                        entity.func_70645_a(DamageSource.field_76377_j);
                    }
                }
            }
            if (TF2PlayerCapability.get((EntityPlayer)playerIn).carrying != null) {
                entity.setConstructing(true);
                entity.redeploy = true;
            }
            TF2Util.addModifierSafe((EntityLivingBase)entity, SharedMonsterAttributes.field_111267_a, new AttributeModifier(EntityBuilding.UPGRADE_HEALTH_UUID, "upgradehealth", (double)(TF2Attribute.getModifier("Building Health", stack, 1.0f, (EntityLivingBase)entity) - 1.0f), 2), true);
            if (entity instanceof EntityDispenser) {
                ((EntityDispenser)entity).setRange(TF2Attribute.getModifier("Dispenser Range", stack, 1.0f, (EntityLivingBase)entity));
            }
            entity.field_70177_z = playerIn.field_70759_as;
            entity.field_70761_aq = playerIn.field_70759_as;
            entity.field_70759_as = playerIn.field_70759_as;
            entity.fromPDA = true;
            if (stack.func_77978_p().func_74771_c("Building") == 5 && entity.getDisposableID() == -1) {
                entity.setDisposableID(PlayerPersistStorage.get((EntityPlayer)playerIn).disposableBuildings.size());
            }
            if (entity instanceof EntityTeleporter) {
                ((EntityTeleporter)entity).setID(127);
                ((EntityTeleporter)entity).setExit(stack.func_77978_p().func_74771_c("Building") == 4);
            }
            PlayerPersistStorage.get(playerIn).setBuilding(entity, TF2PlayerCapability.get(playerIn).calculateMaxSentries());
            TF2PlayerCapability.get((EntityPlayer)playerIn).carrying = null;
            if (!playerIn.field_71075_bZ.field_75098_d && TF2PlayerCapability.get((EntityPlayer)playerIn).carrying == null) {
                WeaponsCapability.get((Entity)playerIn).consumeMetal(EntityBuilding.getCost(stack.func_77978_p().func_74771_c("Building") - 1, TF2Util.getFirstItem((IInventory)playerIn.field_71071_by, (Predicate<ItemStack>)((Predicate)stackL -> stackL.func_77973_b() instanceof ItemWrench))), false);
            }
        }
        stack.func_77978_p().func_74774_a("Building", (byte)0);
        return EnumActionResult.SUCCESS;
    }

    @Override
    public boolean showInfoBox(ItemStack stack, EntityPlayer player) {
        return true;
    }

    @Override
    public String[] getInfoBoxLines(ItemStack stack, EntityPlayer player) {
        return new String[]{"METAL", Integer.toString(((WeaponsCapability)player.getCapability(TF2weapons.WEAPONS_CAP, null)).getMetal())};
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer living, EnumHand hand) {
        if (living.func_70093_af()) {
            living.func_184586_b(hand).func_77978_p().func_74757_a("ShowHud", !living.func_184586_b(hand).func_77978_p().func_74767_n("ShowHud"));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)living.func_184586_b(hand));
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)living.func_184586_b(hand));
    }

    @Override
    public boolean canSwitchTo(ItemStack stack) {
        return true;
    }

    @Override
    public void drawOverlay(ItemStack stack, EntityPlayer player, Tessellator tessellator, BufferBuilder buffer, ScaledResolution resolution) {
        if (!stack.func_77942_o() || stack.func_77978_p().func_74771_c("Building") == 0) {
            int cost;
            int i;
            TF2PlayerCapability plcap = TF2PlayerCapability.get(player);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ClientProxy.blueprintTexture);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
            GuiIngame gui = Minecraft.func_71410_x().field_71456_v;
            boolean hasTag = stack.func_77942_o();
            int buildCount = TF2Attribute.getModifier("Extra Sentry", stack, 0.0f, (EntityLivingBase)player) > 0.0f ? 5 : 4;
            for (i = 0; i < buildCount; ++i) {
                cost = EntityBuilding.getCost(i, TF2Util.getFirstItem((IInventory)player.field_71071_by, (Predicate<ItemStack>)((Predicate)stackL -> stackL.func_77973_b() instanceof ItemWrench)));
                if (hasTag && i < 4 && ((NBTTagCompound)plcap.dataManager.func_187225_a(VIEWS[i])).func_186856_d() != 0) {
                    gui.func_73729_b(resolution.func_78326_a() / 2 - 140 + i * 72, resolution.func_78328_b() / 2, 0, 64, 64, 64);
                    gui.func_73729_b(resolution.func_78326_a() / 2 - 132 + i * 72, resolution.func_78328_b() / 2 + 12, 208, 64 + i * 48, 48, 48);
                    continue;
                }
                if (WeaponsCapability.get((Entity)player).getMetal() < cost) continue;
                gui.func_73729_b(resolution.func_78326_a() / 2 - 140 + i * 72, resolution.func_78328_b() / 2, i == 4 ? 0 : i * 64, 0, 64, 64);
            }
            for (i = 0; i < buildCount; ++i) {
                cost = EntityBuilding.getCost(i, TF2Util.getFirstItem((IInventory)player.field_71071_by, (Predicate<ItemStack>)((Predicate)stackL -> stackL.func_77973_b() instanceof ItemWrench)));
                gui.func_73731_b(gui.func_175179_f(), Integer.toString(cost), resolution.func_78326_a() / 2 - 72 - gui.func_175179_f().func_78256_a(Integer.toString(cost)) + i * 72, resolution.func_78328_b() / 2 - 8, -1);
                gui.func_73732_a(gui.func_175179_f(), "[" + (i + 1) + "]", resolution.func_78326_a() / 2 - 108 + i * 72, resolution.func_78328_b() / 2 + 72, -1);
                gui.func_73731_b(gui.func_175179_f(), I18n.func_135052_a((String)GUI_BUILD_NAMES[i], (Object[])new Object[0]), resolution.func_78326_a() / 2 - 140 + i * 72, resolution.func_78328_b() / 2 - 18, -1);
                if (WeaponsCapability.get((Entity)player).getMetal() >= cost || hasTag && i < 4 && ((NBTTagCompound)plcap.dataManager.func_187225_a(VIEWS[i])).func_186856_d() != 0) continue;
                gui.func_175179_f().func_78279_b(I18n.func_135052_a((String)"gui.build.nometal", (Object[])new Object[0]), resolution.func_78326_a() / 2 - 140 + i * 72, resolution.func_78328_b() / 2 + 20, 80, -1044721);
            }
            gui.func_73732_a(gui.func_175179_f(), I18n.func_135052_a((String)"gui.build", (Object[])new Object[0]), resolution.func_78326_a() / 2, resolution.func_78328_b() / 2 - 40, -1);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public boolean stopSlotSwitch(ItemStack stack, EntityLivingBase living) {
        return stack.func_77978_p().func_74767_n("IsC");
    }
}

