/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import java.util.List;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.entity.IEntityTF2;
import rafradek.TF2weapons.entity.boss.EntityHHH;
import rafradek.TF2weapons.entity.boss.EntityMerasmus;
import rafradek.TF2weapons.entity.boss.EntityMonoculus;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.building.EntityDispenser;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.entity.building.EntityTeleporter;
import rafradek.TF2weapons.entity.mercenary.EntityDemoman;
import rafradek.TF2weapons.entity.mercenary.EntityEngineer;
import rafradek.TF2weapons.entity.mercenary.EntityHeavy;
import rafradek.TF2weapons.entity.mercenary.EntityMedic;
import rafradek.TF2weapons.entity.mercenary.EntityPyro;
import rafradek.TF2weapons.entity.mercenary.EntitySaxtonHale;
import rafradek.TF2weapons.entity.mercenary.EntityScout;
import rafradek.TF2weapons.entity.mercenary.EntitySniper;
import rafradek.TF2weapons.entity.mercenary.EntitySoldier;
import rafradek.TF2weapons.entity.mercenary.EntitySpy;
import rafradek.TF2weapons.entity.mercenary.TF2CharacterAdditionalData;
import rafradek.TF2weapons.item.ItemToken;

public class ItemMonsterPlacerPlus
extends Item {
    public ItemMonsterPlacerPlus() {
        this.func_77627_a(true);
        this.func_77637_a(TF2weapons.tabspawnertf2);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        pos = pos.func_177972_a(facing);
        double d0 = 0.0;
        if (facing == EnumFacing.UP && iblockstate.func_177230_c() instanceof BlockFence) {
            d0 = 0.5;
        }
        boolean hastag = stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("SavedEntity");
        EntityLiving entity = ItemMonsterPlacerPlus.spawnCreature((Entity)playerIn, worldIn, stack.func_77952_i(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + d0, (double)pos.func_177952_p() + 0.5, hastag ? stack.func_77978_p().func_74775_l("SavedEntity") : null);
        if (entity != null) {
            if (entity instanceof EntityLivingBase && stack.func_82837_s()) {
                entity.func_96094_a(stack.func_82833_r());
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (entity instanceof EntityBuilding) {
                if (entity instanceof EntityTeleporter || !playerIn.func_184812_l_() || !playerIn.func_70093_af()) {
                    ((EntityBuilding)entity).setOwner((EntityLivingBase)playerIn);
                }
                if (hastag) {
                    ((EntityBuilding)entity).setConstructing(true);
                    ((EntityBuilding)entity).redeploy = true;
                }
                entity.field_70177_z = playerIn.field_70759_as;
                entity.field_70761_aq = playerIn.field_70759_as;
                entity.field_70759_as = playerIn.field_70759_as;
                if (entity instanceof EntityTeleporter) {
                    ((EntityTeleporter)entity).setExit(stack.func_77952_i() > 23);
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_178782_a();
            if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof BlockLiquid)) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
            }
            if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, raytraceresult.field_178784_b, itemStackIn)) {
                boolean hastag = itemStackIn.func_77978_p() != null && itemStackIn.func_77978_p().func_74764_b("SavedEntity");
                EntityLiving entity = ItemMonsterPlacerPlus.spawnCreature((Entity)playerIn, worldIn, itemStackIn.func_77952_i(), (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, hastag ? itemStackIn.func_77978_p().func_74775_l("SavedEntity") : null);
                if (entity == null) {
                    return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
                }
                if (entity instanceof EntityLivingBase && itemStackIn.func_82837_s()) {
                    entity.func_96094_a(itemStackIn.func_82833_r());
                }
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemStackIn.func_190918_g(1);
                }
                if (entity instanceof EntityBuilding) {
                    if (entity instanceof EntityTeleporter || !playerIn.func_184812_l_() || !playerIn.func_70093_af()) {
                        ((EntityBuilding)entity).setOwner((EntityLivingBase)playerIn);
                    }
                    if (hastag) {
                        ((EntityBuilding)entity).setConstructing(true);
                        ((EntityBuilding)entity).redeploy = true;
                    }
                    if (entity instanceof EntitySentry && itemStackIn.func_77942_o() && itemStackIn.func_77978_p().func_74767_n("Mini")) {
                        ((EntitySentry)entity).setMini(true);
                    }
                    entity.field_70177_z = playerIn.field_70759_as;
                    entity.field_70761_aq = playerIn.field_70759_as;
                    entity.field_70759_as = playerIn.field_70759_as;
                }
                playerIn.func_71029_a(StatList.func_188057_b((Item)this));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
    }

    public static EntityLiving spawnCreature(Entity spawner, World par0World, int par1, double par2, double par4, double par6, NBTTagCompound nbtdata) {
        Object entity = null;
        for (int j = 0; j < 1; ++j) {
            int team = par1 % 2;
            if (par1 < 18 || par1 >= 36 && par1 < 45) {
                switch (par1 % 9) {
                    case 0: {
                        entity = new EntityScout(par0World);
                        break;
                    }
                    case 1: {
                        entity = new EntitySoldier(par0World);
                        break;
                    }
                    case 2: {
                        entity = new EntityPyro(par0World);
                        break;
                    }
                    case 3: {
                        entity = new EntityDemoman(par0World);
                        break;
                    }
                    case 4: {
                        entity = new EntityHeavy(par0World);
                        break;
                    }
                    case 5: {
                        entity = new EntityEngineer(par0World);
                        break;
                    }
                    case 6: {
                        entity = new EntityMedic(par0World);
                        break;
                    }
                    case 7: {
                        entity = new EntitySniper(par0World);
                        break;
                    }
                    case 8: {
                        entity = new EntitySpy(par0World);
                    }
                }
                team = par1 / 9;
                if (par1 >= 36) {
                    team = 2;
                }
            } else if (par1 / 2 == 9) {
                entity = new EntitySentry(par0World);
            } else if (par1 / 2 == 10) {
                entity = new EntityDispenser(par0World);
            } else if (par1 / 2 == 11) {
                entity = new EntityTeleporter(par0World);
            } else if (par1 / 2 == 13) {
                entity = new EntitySaxtonHale(par0World);
            } else if (par1 == 28) {
                entity = new EntityMonoculus(par0World);
            } else if (par1 == 29) {
                entity = new EntityHHH(par0World);
            } else if (par1 == 30) {
                entity = new EntityMerasmus(par0World);
            }
            if (entity == null) continue;
            IEntityTF2 entityliving = entity;
            if (nbtdata != null) {
                entityliving.func_70020_e(nbtdata);
            }
            entity.func_70012_b(par2, par4, par6, MathHelper.func_76142_g((float)(par0World.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            ((EntityLiving)entityliving).field_70759_as = ((EntityLiving)entityliving).field_70177_z;
            ((EntityLiving)entityliving).field_70761_aq = ((EntityLiving)entityliving).field_70177_z;
            entityliving.func_110163_bv();
            TF2CharacterAdditionalData data = new TF2CharacterAdditionalData();
            data.team = team;
            data.noEquipment = team < 2 && spawner != null && spawner.func_70093_af();
            boolean bl = data.isGiant = team == 2 && spawner != null && spawner.func_70093_af();
            if (nbtdata == null) {
                entityliving.func_180482_a(par0World.func_175649_E(new BlockPos((Entity)entityliving)), data);
            }
            entityliving.func_70642_aH();
            if (entity instanceof EntityBuilding) {
                ((EntityBuilding)entity).setEntTeam(team);
            }
            if (entity instanceof EntitySaxtonHale && par1 % 2 == 1) {
                ((EntitySaxtonHale)((Object)entity)).setHostile();
            }
            if (!par0World.func_184144_a((Entity)entity, entity.func_174813_aQ()).isEmpty()) {
                return null;
            }
            par0World.func_72838_d((Entity)entity);
        }
        return entity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        int i;
        if (!this.func_194125_a(par2CreativeTabs)) {
            return;
        }
        for (i = 0; i < 18; ++i) {
            par3List.add((Object)new ItemStack((Item)this, 1, i));
        }
        for (i = 36; i < 45; ++i) {
            par3List.add((Object)new ItemStack((Item)this, 1, i));
        }
        par3List.add((Object)new ItemStack((Item)this, 1, 26));
        par3List.add((Object)new ItemStack((Item)this, 1, 27));
        par3List.add((Object)new ItemStack((Item)this, 1, 28));
        par3List.add((Object)new ItemStack((Item)this, 1, 29));
        par3List.add((Object)new ItemStack((Item)this, 1, 30));
    }

    public String func_77653_i(ItemStack p_77653_1_) {
        String s = ("" + I18n.func_74838_a((String)(this.func_77658_a() + ".name"))).trim();
        int i = p_77653_1_.func_77952_i();
        String s1 = "hale";
        if (i < 18 || i >= 36 && i < 45) {
            s1 = ItemToken.CLASS_NAMES[i % 9];
        }
        if (p_77653_1_.func_77952_i() == 28) {
            s1 = "monoculus";
        }
        if (p_77653_1_.func_77952_i() == 29) {
            s1 = "hhh";
        }
        if (p_77653_1_.func_77952_i() == 30) {
            s1 = "merasmus";
        }
        s1 = I18n.func_74838_a((String)("entity." + s1 + ".name"));
        if (p_77653_1_.func_77952_i() == 27) {
            s1 = s1.concat(" " + I18n.func_74838_a((String)"item.placer.hostile"));
        }
        return s.concat(" " + s1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77960_j() < 18) {
            tooltip.add("Hold " + (String)KeyBinding.func_193626_b((String)"key.sneak").get() + " to spawn with default equipment");
        }
        if (stack.func_77960_j() >= 36 && stack.func_77960_j() < 45) {
            tooltip.add("Hold " + (String)KeyBinding.func_193626_b((String)"key.sneak").get() + " to spawn a giant");
        }
    }
}

