/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import com.google.common.base.Predicate;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.client.audio.WeaponSound;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.item.ItemBulletWeapon;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;
import rafradek.TF2weapons.util.WeaponData;

public class ItemMinigun
extends ItemBulletWeapon {
    public static UUID slowdownUUID = UUID.fromString("12843092-A5D6-BBCD-3D4F-A3DD4D8C94C8");
    public static AttributeModifier slowdown = new AttributeModifier(slowdownUUID, "minigun slowdown", -0.5, 2);

    public ItemMinigun() {
        this.func_185043_a(new ResourceLocation("spin"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn != null && entityIn.hasCapability(TF2weapons.WEAPONS_CAP, null) && ((WeaponsCapability)entityIn.getCapability(TF2weapons.WEAPONS_CAP, null)).chargeTicks > 0) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    @Override
    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        super.func_77663_a(par1ItemStack, par2World, par3Entity, par4, par5);
        WeaponsCapability cap = (WeaponsCapability)par3Entity.getCapability(TF2weapons.WEAPONS_CAP, null);
        if (par5 && par1ItemStack.func_77978_p() != null) {
            if ((cap.state == 0 || cap.state == 4) && cap.chargeTicks > 0) {
                cap.killsSpinning = 0;
                cap.chargeTicks -= 2;
                ((EntityLivingBase)par3Entity).func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(slowdown);
            }
            if ((cap.state & 4) == 4 && this.getRageType(par1ItemStack, (EntityLivingBase)par3Entity) == WeaponsCapability.RageType.KNOCKBACK && !cap.isRageActive(WeaponsCapability.RageType.KNOCKBACK) && cap.getRage(WeaponsCapability.RageType.KNOCKBACK) >= 1.0f) {
                cap.setRageActive(WeaponsCapability.RageType.KNOCKBACK, true, 0.15f - 0.03f * TF2Attribute.getModifier("Knockback Rage", par1ItemStack, 0.0f, null));
            }
        }
    }

    @Override
    public float getWeaponDamage(ItemStack stack, EntityLivingBase living, Entity target) {
        float base = super.getWeaponDamage(stack, living, target);
        if (living != null && WeaponsCapability.get((Entity)living).isRageActive(WeaponsCapability.RageType.KNOCKBACK)) {
            base *= 0.6f;
        }
        return base * (living != null ? TF2Util.lerp(0.5f, 1.0f, (float)((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).minigunTicks / 20.0f) : 1.0f);
    }

    @Override
    public float getWeaponSpreadBase(ItemStack stack, EntityLivingBase living) {
        float base = super.getWeaponSpreadBase(stack, living);
        if (TF2Attribute.getModifier("Weapon Mode", stack, 0.0f, living) != 1.0f) {
            return base * (living != null ? TF2Util.lerp(1.5f, 1.0f, (float)((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).minigunTicks / 20.0f) : 1.0f);
        }
        return base * TF2Util.lerp(3.0f, 0.5f, Math.min(1.0f, ((float)this.getClip(stack) - (float)this.getWeaponClipSize(stack, living) * 0.2f) / ((float)this.getWeaponClipSize(stack, living) * 0.8f)));
    }

    @Override
    public int getFiringSpeed(ItemStack stack, EntityLivingBase living) {
        if (TF2Attribute.getModifier("Weapon Mode", stack, 0.0f, living) != 1.0f) {
            return super.getFiringSpeed(stack, living);
        }
        float mult = Math.max(0.0f, ((float)this.getClip(stack) - (float)this.getWeaponClipSize(stack, living) * 0.0f) / ((float)this.getWeaponClipSize(stack, living) * 1.0f));
        return (int)((float)super.getFiringSpeed(stack, living) * TF2Util.lerp(0.8f, 3.0f, mult * mult * mult));
    }

    @Override
    public boolean startUse(ItemStack stack, EntityLivingBase living, World world, int oldState, int newState) {
        if (world.field_72995_K && oldState == 0 && (!ClientProxy.fireSounds.containsKey((Object)living) || ((WeaponSound)((Object)ClientProxy.fireSounds.get((Object)living))).type != 3)) {
            ClientProxy.playWeaponSound(living, ItemFromData.getSound(stack, PropertyType.WIND_UP_SOUND), false, 3, stack);
        }
        return false;
    }

    @Override
    public boolean endUse(ItemStack stack, EntityLivingBase living, World world, int action, int newState) {
        WeaponsCapability cap = (WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null);
        if (newState == 0) {
            cap.minigunTicks = 0;
        }
        if (world.field_72995_K && newState == 0 && cap.chargeTicks > 0 && (!ClientProxy.fireSounds.containsKey((Object)living) || ((WeaponSound)((Object)ClientProxy.fireSounds.get((Object)living))).type != 4)) {
            ClientProxy.playWeaponSound(living, ItemFromData.getSound(stack, PropertyType.WIND_DOWN_SOUND), false, 4, stack);
        }
        return false;
    }

    @Override
    public boolean fireTick(ItemStack stack, EntityLivingBase living, World world) {
        if (world.field_72995_K && this.canFire(world, living, stack)) {
            if (!(TF2Util.calculateCritPre(stack, living) == 2 || ClientProxy.fireSounds.containsKey((Object)living) && ((WeaponSound)((Object)ClientProxy.fireSounds.get((Object)living))).type == 0)) {
                ClientProxy.playWeaponSound(living, ItemFromData.getSound(stack, PropertyType.FIRE_LOOP_SOUND), true, 0, stack);
            } else if (!(TF2Util.calculateCritPre(stack, living) != 2 || ClientProxy.fireSounds.containsKey((Object)living) && ((WeaponSound)((Object)ClientProxy.fireSounds.get((Object)living))).type == 1)) {
                ResourceLocation playSoundCrit = new ResourceLocation(ItemFromData.getData(stack).getString(PropertyType.FIRE_LOOP_SOUND) + ".crit");
                ClientProxy.playWeaponSound(living, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)playSoundCrit), true, 1, stack);
            }
        }
        this.spinMinigun(stack, living, world);
        return false;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    @Override
    public boolean altFireTick(ItemStack stack, EntityLivingBase living, World world) {
        if (world.field_72995_K && this.canFire(world, living, stack) && (!ClientProxy.fireSounds.containsKey((Object)living) || ((WeaponSound)((Object)ClientProxy.fireSounds.get((Object)living))).type > 2)) {
            ClientProxy.playWeaponSound(living, ItemFromData.getSound(stack, PropertyType.SPIN_SOUND), true, 2, stack);
        }
        if ((((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).state & 1) != 1) {
            this.spinMinigun(stack, living, world);
        }
        return false;
    }

    public void spinMinigun(ItemStack stack, final EntityLivingBase living, World world) {
        if (super.canFire(world, living, stack)) {
            WeaponsCapability cap = (WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null);
            float ammo = TF2Attribute.getModifier("Ammo Spinned", stack, 0.0f, living);
            int spinuptime = (int)TF2Attribute.getModifier("Minigun Spinup", stack, 18.0f, living);
            if (cap.chargeTicks >= spinuptime || living instanceof EntityPlayer && ((EntityPlayer)living).func_184812_l_()) {
                float flamedmg;
                if (cap.minigunTicks < 20) {
                    ++cap.minigunTicks;
                }
                if (ammo > 0.0f && !this.searchForAmmo(living, stack).func_190926_b() && (float)living.field_70173_aa % (20.0f / ammo) == 0.0f) {
                    this.consumeAmmoGlobal(living, stack, 1);
                }
                if (living.field_70173_aa % 10 == 0 && (flamedmg = TF2Attribute.getModifier("Ring Fire", stack, 0.0f, living)) > 0.0f) {
                    if (world.field_72995_K) {
                        for (int i = 0; i < 50; ++i) {
                            ClientProxy.spawnFlameParticle(world, living, 0.0f, true);
                        }
                    } else {
                        for (EntityLivingBase target : world.func_175647_a(EntityLivingBase.class, living.func_174813_aQ().func_72314_b(4.0, -0.5, 4.0).func_72317_d(0.0, -0.5, 0.0), (Predicate)new Predicate<EntityLivingBase>(){

                            public boolean apply(EntityLivingBase input) {
                                return input != living && TF2Util.canHit(living, (Entity)input) && input.func_70068_e((Entity)living) < 16.0;
                            }
                        })) {
                            TF2Util.dealDamage((Entity)target, world, living, stack, 0, flamedmg, TF2Util.causeDirectDamage(stack, (Entity)living, 0).func_76361_j());
                            TF2Util.igniteAndAchievement((Entity)target, living, 6, 1.0f);
                        }
                    }
                }
            }
            if (living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(slowdownUUID) == null) {
                living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(slowdown);
            }
            if (living.func_70051_ag()) {
                living.field_70159_w *= 0.6;
                living.field_70179_y *= 0.6;
                living.func_70031_b(false);
            }
            if (world.field_72995_K) {
                ClientProxy.removeSprint();
            }
            if (WeaponData.getCapability((ItemStack)stack).fire1Cool <= 0 && cap.chargeTicks < spinuptime) {
                ++cap.chargeTicks;
            }
        }
    }

    @Override
    public boolean canFire(World world, EntityLivingBase living, ItemStack stack) {
        return super.canFire(world, living, stack) && (((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).chargeTicks >= (int)TF2Attribute.getModifier("Minigun Spinup", stack, 18.0f, living) || living instanceof EntityPlayer && ((EntityPlayer)living).func_184812_l_());
    }

    @Override
    public void holster(WeaponsCapability cap, ItemStack stack, EntityLivingBase living, World world) {
        living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(slowdown);
        super.holster(cap, stack, living, world);
    }

    @Override
    public void onDealDamage(ItemStack stack, EntityLivingBase attacker, Entity target, DamageSource source, float amount) {
        super.onDealDamage(stack, attacker, target, source, amount);
        if (attacker instanceof EntityPlayer && !target.func_70089_S() && target instanceof EntityLivingBase && TF2Util.isEnemy(attacker, (EntityLivingBase)target)) {
            ++((WeaponsCapability)attacker.getCapability(TF2weapons.WEAPONS_CAP, null)).killsSpinning;
        }
    }

    @Override
    public int getWeaponReloadTime(ItemStack stack, EntityLivingBase living) {
        if (WeaponsCapability.get((Entity)living).chargeTicks < (int)TF2Attribute.getModifier("Minigun Spinup", stack, 18.0f, living) - 10) {
            return super.getWeaponReloadTime(stack, living) / 2;
        }
        return super.getWeaponReloadTime(stack, living);
    }

    static {
        slowdown.func_111168_a(false);
    }
}

