/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemBulletWeapon;
import rafradek.TF2weapons.item.ItemProjectileWeapon;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.util.PropertyType;

public class ItemMeleeWeapon
extends ItemBulletWeapon {
    @Override
    public float getMaxRange(ItemStack stack) {
        return TF2Attribute.getModifier("Range", stack, 2.4f, null);
    }

    public float getBulletSize() {
        return 0.35f;
    }

    @Override
    public boolean showTracer(ItemStack stack) {
        return false;
    }

    @Override
    public short getAltFiringSpeed(ItemStack item, EntityLivingBase player) {
        if (TF2Attribute.getModifier("Ball Release", item, 0.0f, player) > 0.0f) {
            if (player instanceof EntityTF2Character) {
                return (short)this.getFiringSpeed(ItemMeleeWeapon.getNewStack("sandmanball"), player);
            }
            return 2000;
        }
        return super.getAltFiringSpeed(item, player);
    }

    @Override
    public boolean canAltFire(World worldObj, EntityLivingBase player, ItemStack item) {
        return super.canAltFire(worldObj, player, item) && (!(player instanceof EntityPlayer) || !((EntityPlayer)player).func_184811_cZ().func_185141_a((Item)this));
    }

    @Override
    public void altUse(ItemStack stack, EntityLivingBase living, World world) {
        ItemStack ballStack;
        if (TF2Attribute.getModifier("Ball Release", stack, 0.0f, living) > 0.0f && !this.searchForAmmo(living, ballStack = ItemMeleeWeapon.getNewStack("sandmanball")).func_190926_b()) {
            int cooldown = this.getFiringSpeed(ballStack, living) / 50;
            if (!TF2ConfigVars.fastItemCooldown) {
                cooldown = (int)((float)cooldown * ItemMeleeWeapon.getData(ballStack).getFloat(PropertyType.COOLDOWN_LONG));
            }
            if (living instanceof EntityPlayer) {
                ((EntityPlayer)living).func_184811_cZ().func_185145_a((Item)this, cooldown);
            }
            ItemStack oldHeldItem = living.func_184614_ca();
            living.func_184611_a(EnumHand.MAIN_HAND, ballStack);
            ((ItemProjectileWeapon)ballStack.func_77973_b()).use(ballStack, living, world, EnumHand.MAIN_HAND, null);
            living.func_184611_a(EnumHand.MAIN_HAND, oldHeldItem);
        }
    }

    @Override
    public void draw(WeaponsCapability weaponsCapability, ItemStack stack, EntityLivingBase living, World world) {
        super.draw(weaponsCapability, stack, living, world);
        if (living instanceof EntityPlayerMP) {
            TF2weapons.network.sendTo(new TF2Message.UseMessage(this.getClip(stack), false, this.getAmmoAmount(living, ItemMeleeWeapon.getNewStack("sandmanball")), EnumHand.MAIN_HAND), (EntityPlayerMP)living);
        }
    }

    @Override
    public boolean use(ItemStack stack, EntityLivingBase living, World world, EnumHand hand, TF2Message.PredictionMessage message) {
        ItemWeapon.shouldSwing = true;
        living.func_184609_a(hand);
        ItemWeapon.shouldSwing = false;
        return super.use(stack, living, world, hand, message);
    }

    @Override
    public float critChance(ItemStack stack, Entity entity) {
        float chance = 0.15f;
        if (entity instanceof EntityPlayer) {
            chance += TF2PlayerCapability.get((EntityPlayer)entity).getTotalLastDamage() / 177.0f;
        }
        return Math.min(chance, 0.6f);
    }

    @Override
    public boolean doMuzzleFlash(ItemStack stack, EntityLivingBase attacker, EnumHand hand) {
        return false;
    }

    @Override
    public boolean showInfoBox(ItemStack stack, EntityPlayer player) {
        return TF2Attribute.getModifier("Ball Release", stack, 0.0f, (EntityLivingBase)player) > 0.0f || TF2Attribute.getModifier("Kill Count", stack, 0.0f, (EntityLivingBase)player) > 0.0f;
    }

    @Override
    public String[] getInfoBoxLines(ItemStack stack, EntityPlayer player) {
        String[] result = new String[2];
        if (TF2Attribute.getModifier("Kill Count", stack, 0.0f, (EntityLivingBase)player) > 0.0f) {
            result[0] = "HEADS";
            result[1] = Integer.toString(((WeaponsCapability)player.getCapability(TF2weapons.WEAPONS_CAP, null)).getHeads());
        } else {
            result[0] = "BALLS";
            int ammoLeft = ((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).cachedAmmoCount[14];
            result[1] = Integer.toString(ammoLeft);
        }
        return result;
    }
}

