/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2EventsCommon;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.IEntityTF2;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemUsable;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.util.Contract;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.ReflectionAccess;
import rafradek.TF2weapons.util.TF2Util;

public class ItemMedigun
extends ItemUsable {
    @Override
    public boolean use(ItemStack stack, EntityLivingBase living, World world, EnumHand hand, TF2Message.PredictionMessage message) {
        if (world.field_72995_K && living == Minecraft.func_71410_x().field_71439_g) {
            RayTraceResult trace = this.trace(stack, living, world);
            if (world.func_73045_a(((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).getHealTarget()) == null && trace != null && trace.field_72308_g != null && trace.field_72308_g instanceof EntityLivingBase && !(trace.field_72308_g instanceof EntityBuilding)) {
                ArrayList<RayTraceResult> list = new ArrayList<RayTraceResult>();
                trace.hitInfo = new float[]{0.0f, 0.0f};
                list.add(trace);
                message.target = list;
            }
        } else if (!world.field_72995_K && message != null && message.readData != null) {
            ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).setHealTarget((Integer)message.readData.get(0)[0]);
        }
        return true;
    }

    public void heal(ItemStack stack, EntityLivingBase living, World world, EntityLivingBase target) {
        if (!(living instanceof EntityPlayer) || !((EntityPlayer)living).field_71075_bZ.field_75098_d) {
            if (!this.isAmmoSufficient(stack, living, true)) {
                return;
            }
            int use = 16;
            if (target.func_110143_aJ() >= target.func_110138_aP()) {
                use /= 2;
            }
            if (target.func_110139_bj() >= target.func_110138_aP() * this.getMaxOverheal(stack, living, target) * 0.9f) {
                use /= 2;
                if (stack.func_77978_p().func_74760_g("ubercharge") >= 1.0f) {
                    use = living instanceof EntityPlayer ? (use /= 4) : 0;
                }
            } else if (stack.func_77978_p().func_74760_g("ubercharge") >= 1.0f) {
                use = use * 2 / 3;
            }
            if (use != 0) {
                this.consumeAmmoGlobal(living, stack, use);
            }
        }
        int lastHitTime = target.field_70173_aa - target.getEntityData().func_74762_e("lasthit");
        float heal = this.getHealAmount(stack, living);
        if (!(target instanceof IEntityTF2)) {
            heal *= TF2ConfigVars.damageMultiplier;
        }
        if (lastHitTime > 200) {
            heal *= 1.0f + Math.min(2.0f, ((float)lastHitTime - 200.0f) / 50.0f);
        }
        float overheal = heal + target.func_110138_aP() * 0.001666f;
        float ubercharge = TF2Attribute.getModifier("Uber Rate", stack, 0.00125f, living);
        if (TF2Attribute.getModifier("Life Steal", stack, 0.0f, living) != 0.0f && !TF2Util.isOnSameTeam((Entity)living, (Entity)target)) {
            heal = heal * (0.8f + TF2Attribute.getModifier("Life Steal", stack, 0.0f, living) * 0.2f) * (1.0f - (float)target.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e() * 0.03f);
            TF2Util.dealDamage((Entity)target, world, living, stack, 0, heal, TF2Util.causeDirectDamage(stack, (Entity)living, 0).func_76348_h());
            float lifesteal = TF2Util.getReducedHealing(living, target, heal * TF2Attribute.getModifier("Life Steal", stack, 0.0f, living) * 0.15f);
            if (!TF2Util.isEnemy(living, target)) {
                lifesteal *= 0.25f;
            }
            if (target instanceof EntityPlayer) {
                lifesteal *= 2.0f;
            }
            living.func_70691_i(lifesteal);
        } else {
            if (target.func_110143_aJ() < target.func_110138_aP()) {
                overheal = target.func_110143_aJ() + heal - target.func_110138_aP() + 0.04f;
                target.func_70691_i(heal);
                if (living instanceof EntityPlayerMP && (target instanceof EntityTF2Character || target instanceof EntityPlayer)) {
                    float f;
                    ((TF2PlayerCapability)living.getCapability(TF2weapons.PLAYER_CAP, null)).healed += heal;
                    if (f >= 20.0f) {
                        ((TF2PlayerCapability)living.getCapability(TF2weapons.PLAYER_CAP, null)).healed -= 20.0f;
                        ((TF2PlayerCapability)living.getCapability(TF2weapons.PLAYER_CAP, null)).completeObjective(Contract.Objective.HEAL_20, stack);
                    }
                }
            }
            if (target.func_110143_aJ() >= target.func_110138_aP() && target.func_110139_bj() < target.func_110138_aP() * this.getMaxOverheal(stack, living, target)) {
                target.func_110149_m(Math.min(target.func_110139_bj() + overheal, target.func_110138_aP() * this.getMaxOverheal(stack, living, null)));
                target.func_184212_Q().func_187227_b(TF2EventsCommon.ENTITY_OVERHEAL, (Object)Float.valueOf(target.func_110139_bj()));
            }
            if (target.func_110143_aJ() >= target.func_110138_aP() && (double)target.func_110139_bj() >= (double)target.func_110138_aP() * ((double)this.getMaxOverheal(stack, living, target) - 0.075)) {
                ubercharge /= 2.0f;
            }
        }
        if (!stack.func_77978_p().func_74767_n("Activated") && stack.func_77978_p().func_74760_g("ubercharge") < 1.0f) {
            stack.func_77978_p().func_74776_a("ubercharge", Math.min(1.0f, stack.func_77978_p().func_74760_g("ubercharge") + ubercharge));
            if (stack.func_77978_p().func_74760_g("ubercharge") == 1.0f) {
                living.func_184185_a(ItemFromData.getSound(stack, PropertyType.CHARGED_SOUND), 1.25f, 1.0f);
            }
        }
    }

    public RayTraceResult trace(ItemStack stack, EntityLivingBase living, World world) {
        double range;
        double startX = 0.0;
        double startY = 0.0;
        double startZ = 0.0;
        double endX = 0.0;
        double endY = 0.0;
        double endZ = 0.0;
        startX = living.field_70165_t;
        startY = living.field_70163_u + (double)living.func_70047_e();
        startZ = living.field_70161_v;
        float spreadPitch = living.field_70125_A / 180.0f;
        float spreadYaw = living.field_70759_as / 180.0f;
        endX = -MathHelper.func_76126_a((float)(spreadYaw * (float)Math.PI)) * MathHelper.func_76134_b((float)(spreadPitch * (float)Math.PI));
        endY = -MathHelper.func_76126_a((float)(spreadPitch * (float)Math.PI));
        endZ = MathHelper.func_76134_b((float)(spreadYaw * (float)Math.PI)) * MathHelper.func_76134_b((float)(spreadPitch * (float)Math.PI));
        float var9 = MathHelper.func_76133_a((double)(endX * endX + endY * endY + endZ * endZ));
        List<RayTraceResult> list = TF2Util.pierce(world, (Entity)living, startX, startY, startZ, startX + (endX = endX / (double)var9 * (range = (double)ItemMedigun.getData(stack).getFloat(PropertyType.RANGE))), startY + (endY = endY / (double)var9 * range), startZ + (endZ = endZ / (double)var9 * range), false, 0.2f, false);
        return !list.isEmpty() && list.get((int)0).field_72308_g != null ? list.get(0) : null;
    }

    @Override
    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        Entity healTargetEnt;
        super.func_77663_a(par1ItemStack, par2World, par3Entity, par4, par5);
        if (par1ItemStack.func_190926_b()) {
            return;
        }
        if (!par2World.field_72995_K && par5 && !this.canFire(par2World, (EntityLivingBase)par3Entity, par1ItemStack)) {
            ((WeaponsCapability)par3Entity.getCapability(TF2weapons.WEAPONS_CAP, null)).setHealTarget(-1);
        }
        Potion effect = Potion.func_180142_b((String)ItemFromData.getData(par1ItemStack).getString(PropertyType.EFFECT_TYPE));
        if (!par2World.field_72995_K && par1ItemStack.func_77978_p().func_74767_n("Activated")) {
            float uber = par1ItemStack.func_77978_p().func_74760_g("ubercharge") - 0.00625f;
            par1ItemStack.func_77978_p().func_74776_a("ubercharge", Math.max(0.0f, uber));
            if (par5 && effect != null && par3Entity.field_70173_aa % 4 == 0) {
                TF2Util.addAndSendEffect((EntityLivingBase)par3Entity, new PotionEffect(effect, 15));
            }
            if (par1ItemStack.func_77978_p().func_74760_g("ubercharge") == 0.0f) {
                par1ItemStack.func_77978_p().func_74757_a("Activated", false);
                TF2Util.playSound(par3Entity, ItemFromData.getSound(par1ItemStack, PropertyType.UBER_STOP_SOUND), 1.5f, 1.0f);
                ((EntityLivingBase)par3Entity).func_184589_d(effect);
            }
        }
        if (par5 && !par2World.field_72995_K && (healTargetEnt = par2World.func_73045_a(((WeaponsCapability)par3Entity.getCapability(TF2weapons.WEAPONS_CAP, null)).getHealTarget())) != null && healTargetEnt instanceof EntityLivingBase) {
            EntityLivingBase healTarget = (EntityLivingBase)healTargetEnt;
            double range = (double)ItemMedigun.getData(par1ItemStack).getFloat(PropertyType.RANGE) + 1.6;
            if (!par2World.field_72995_K && healTarget != null && par3Entity.func_70068_e((Entity)healTarget) > range * range) {
                ((WeaponsCapability)par3Entity.getCapability(TF2weapons.WEAPONS_CAP, null)).setHealTarget(-1);
            } else if (healTarget != null && healTarget instanceof EntityLivingBase) {
                this.heal(par1ItemStack, (EntityLivingBase)par3Entity, par2World, healTarget);
                if (effect != null && par1ItemStack.func_77978_p().func_74767_n("Activated") && (healTarget.func_70660_b(effect) == null || healTarget.field_70173_aa % 4 == 0)) {
                    TF2Util.addAndSendEffect(healTarget, new PotionEffect(effect, 15));
                }
            }
        }
        if (!par2World.field_72995_K && (par5 || par4 == 40)) {
            try {
                ((ItemStack)((NonNullList)ReflectionAccess.entityHandInv.get(par3Entity)).get(par5 ? 0 : 1)).func_77978_p().func_74776_a("ubercharge", par1ItemStack.func_77978_p().func_74760_g("ubercharge"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void holster(WeaponsCapability cap, ItemStack stack, EntityLivingBase living, World world) {
        cap.setHealTarget(-1);
        living.func_184589_d(TF2weapons.uber);
        super.holster(cap, stack, living, world);
    }

    @Override
    public boolean canFire(World world, EntityLivingBase living, ItemStack stack) {
        return !(living instanceof EntityPlayer) || ((EntityPlayer)living).field_71075_bZ.field_75098_d || !this.searchForAmmo(living, stack).func_190926_b();
    }

    @Override
    public boolean fireTick(ItemStack stack, EntityLivingBase living, World world) {
        return false;
    }

    @Override
    public boolean altFireTick(ItemStack stack, EntityLivingBase living, World world) {
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return true;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return true;
    }

    public float getHealAmount(ItemStack stack, EntityLivingBase living) {
        return TF2Attribute.getModifier("Heal", stack, ItemFromData.getData(stack).getFloat(PropertyType.HEAL), living);
    }

    public float getMaxOverheal(ItemStack stack, EntityLivingBase living, EntityLivingBase target) {
        if (target instanceof EntityTF2Character && ((EntityTF2Character)target).isGiant()) {
            return 0.0f;
        }
        return TF2Attribute.getModifier("Overheal", stack, ItemFromData.getData(stack).getFloat(PropertyType.MAX_OVERHEAL), living);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        tooltip.add("Charge: " + Float.toString(stack.func_77978_p().func_74760_g("ubercharge")));
    }

    @Override
    public boolean startUse(ItemStack stack, EntityLivingBase living, World world, int oldState, int newState) {
        if ((newState & 1) - (oldState & 1) == 1) {
            if (world.field_72995_K) {
                RayTraceResult trace = this.trace(stack, living, world);
                if (trace == null || trace.field_72308_g == null || !(trace.field_72308_g instanceof EntityLivingBase)) {
                    ClientProxy.playWeaponSound(living, ItemFromData.getSound(stack, PropertyType.NO_TARGET_SOUND), false, 1, stack);
                }
            } else if (((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).getHealTarget() != -1) {
                ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).setHealTarget(-1);
            }
        }
        if (!world.field_72995_K && (newState & 2) - (oldState & 2) == 2 && stack.func_77978_p().func_74760_g("ubercharge") == 1.0f) {
            stack.func_77978_p().func_74757_a("Activated", true);
            TF2Util.playSound((Entity)living, ItemFromData.getSound(stack, PropertyType.UBER_START_SOUND), 0.75f, 1.0f);
            Entity healTargetEnt = world.func_73045_a(((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).getHealTarget());
            if (healTargetEnt instanceof EntityLivingBase) {
                ((EntityLivingBase)healTargetEnt).func_70690_d(new PotionEffect(Potion.func_180142_b((String)ItemFromData.getData(stack).getString(PropertyType.EFFECT_TYPE)), 1));
            }
            if (stack.func_77978_p().func_74767_n("Strange")) {
                stack.func_77978_p().func_74768_a("Ubercharges", stack.func_77978_p().func_74762_e("Ubercharges") + 1);
                TF2EventsCommon.onStrangeUpdate(stack, living);
            }
        }
        return false;
    }

    @Override
    public boolean endUse(ItemStack stack, EntityLivingBase living, World world, int oldState, int newState) {
        if (!world.field_72995_K && !TF2ConfigVars.medigunLock && (oldState & 1 - newState & 1) == 1) {
            ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).setHealTarget(-1);
        }
        return false;
    }

    @Override
    public void drawOverlay(ItemStack stack, EntityPlayer player, Tessellator tessellator, BufferBuilder renderer, ScaledResolution resolution) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ClientProxy.healingTexture);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)3008);
        ClientProxy.setColor(TF2Util.getTeamColor((Entity)player), 0.7f, 0.0f, 0.25f, 0.8f);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b((double)(resolution.func_78326_a() - 138), (double)(resolution.func_78328_b() - 20), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)(resolution.func_78326_a() - 14), (double)(resolution.func_78328_b() - 20), 0.0).func_187315_a(0.01, 1.0).func_181675_d();
        renderer.func_181662_b((double)(resolution.func_78326_a() - 14), (double)(resolution.func_78328_b() - 50), 0.0).func_187315_a(0.01, 0.99).func_181675_d();
        renderer.func_181662_b((double)(resolution.func_78326_a() - 138), (double)(resolution.func_78328_b() - 50), 0.0).func_187315_a(0.0, 0.99).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b((double)(resolution.func_78326_a() - 140), (double)(resolution.func_78328_b() - 18), 0.0).func_187315_a(0.0, 0.265625).func_181675_d();
        renderer.func_181662_b((double)(resolution.func_78326_a() - 12), (double)(resolution.func_78328_b() - 18), 0.0).func_187315_a(1.0, 0.265625).func_181675_d();
        renderer.func_181662_b((double)(resolution.func_78326_a() - 12), (double)(resolution.func_78328_b() - 52), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)(resolution.func_78326_a() - 140), (double)(resolution.func_78328_b() - 52), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        float uber = stack.func_77978_p().func_74760_g("ubercharge");
        Minecraft.func_71410_x().field_71456_v.func_73731_b(Minecraft.func_71410_x().field_71456_v.func_175179_f(), "UBERCHARGE: " + Math.round(uber * 100.0f) + "%", resolution.func_78326_a() - 130, resolution.func_78328_b() - 48, 0xFFFFFF);
        GL11.glDisable((int)3553);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.33f);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        renderer.func_181662_b((double)(resolution.func_78326_a() - 132), (double)(resolution.func_78328_b() - 22), 0.0).func_181675_d();
        renderer.func_181662_b((double)(resolution.func_78326_a() - 20), (double)(resolution.func_78328_b() - 22), 0.0).func_181675_d();
        renderer.func_181662_b((double)(resolution.func_78326_a() - 20), (double)(resolution.func_78328_b() - 36), 0.0).func_181675_d();
        renderer.func_181662_b((double)(resolution.func_78326_a() - 132), (double)(resolution.func_78328_b() - 36), 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        renderer.func_181662_b((double)(resolution.func_78326_a() - 132), (double)(resolution.func_78328_b() - 22), 0.0).func_181675_d();
        renderer.func_181662_b((double)((float)(resolution.func_78326_a() - 132) + 112.0f * uber), (double)(resolution.func_78328_b() - 22), 0.0).func_181675_d();
        renderer.func_181662_b((double)((float)(resolution.func_78326_a() - 132) + 112.0f * uber), (double)(resolution.func_78328_b() - 36), 0.0).func_181675_d();
        renderer.func_181662_b((double)(resolution.func_78326_a() - 132), (double)(resolution.func_78328_b() - 36), 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

