/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rafradek.TF2weapons.common.TF2Achievements;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.IEntityTF2;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemMeleeWeapon;
import rafradek.TF2weapons.util.TF2Util;

public class ItemKnife
extends ItemMeleeWeapon {
    public ItemKnife() {
        this.func_185043_a(new ResourceLocation("backstab"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71476_x != null && Minecraft.func_71410_x().field_71476_x.field_72308_g != null && TF2Util.getDistanceSqBox(Minecraft.func_71410_x().field_71476_x.field_72308_g, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, entityIn.field_70130_N, entityIn.field_70131_O) <= (double)(ItemKnife.this.getMaxRange(stack) * ItemKnife.this.getMaxRange(stack)) && ItemKnife.this.isBackstab(entityIn, Minecraft.func_71410_x().field_71476_x.field_72308_g, stack)) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    @Override
    public void handleShoot(EntityLivingBase living, ItemStack stack, World world, HashMap<Entity, float[]> map, int critical, int flags) {
        for (Entity target : map.keySet()) {
            if (!this.isBackstab(living, target, stack)) continue;
            ++flags;
            break;
        }
        super.handleShoot(living, stack, world, map, critical, flags);
    }

    public boolean isBackstab(EntityLivingBase living, Entity target, ItemStack stack) {
        if (target != null && target instanceof EntityLivingBase && (!(target instanceof IEntityTF2) || ((IEntityTF2)target).isBackStabbable(living, stack))) {
            float ourAngle = 180.0f + MathHelper.func_76142_g((float)living.field_70759_as);
            float angle2 = (float)(MathHelper.func_181159_b((double)(living.field_70165_t - target.field_70165_t), (double)(living.field_70161_v - target.field_70161_v)) * 180.0 / Math.PI);
            angle2 = angle2 >= 0.0f ? 180.0f - angle2 : -180.0f - angle2;
            float enemyAngle = 180.0f + MathHelper.func_76142_g((float)target.func_70079_am());
            float difference = 180.0f - Math.abs(Math.abs(ourAngle - enemyAngle) - 180.0f);
            float difference2 = 180.0f - Math.abs(Math.abs((angle2 += 180.0f) - enemyAngle) - 180.0f);
            if (difference < 90.0f && difference2 < 90.0f) {
                return true;
            }
        }
        return false;
    }

    public float getBackstabBonusDamage(ItemStack stack, EntityLivingBase living, Entity target) {
        float base = 4.0f;
        if (living instanceof EntityPlayer && ((EntityPlayer)living).func_184811_cZ().func_185141_a((Item)this)) {
            base -= (base - 1.0f) * ((EntityPlayer)living).func_184811_cZ().func_185143_a((Item)this, 0.0f);
        }
        base = (float)((double)base * Math.pow(TF2Attribute.getModifier("Backstab Damage", stack, 1.0f, living), 2.0));
        if (target instanceof IEntityTF2) {
            base = ((IEntityTF2)target).getBackstabDamageReduction(living, stack, base);
        }
        if (target.getEntityData().func_74764_b("TF2BD")) {
            base *= target.getEntityData().func_74760_g("TF2BD");
        }
        return Math.max(1.0f, base);
    }

    @Override
    public float getWeaponDamage(ItemStack stack, EntityLivingBase living, Entity target) {
        return super.getWeaponDamage(stack, living, target) * (this.isBackstab(living, target, stack) ? this.getBackstabBonusDamage(stack, living, target) : 1.0f);
    }

    @Override
    public int setCritical(ItemStack stack, EntityLivingBase shooter, Entity target, int old) {
        return super.setCritical(stack, shooter, target, this.isBackstab(shooter, target, stack) ? 2 : old);
    }

    @Override
    public void onDealDamage(ItemStack stack, EntityLivingBase attacker, Entity target, DamageSource source, float amount) {
        super.onDealDamage(stack, attacker, target, source, amount);
        if (attacker instanceof EntityPlayer && this.isBackstab(attacker, target, stack) && target.func_70089_S() && (!(target instanceof EntityTF2Character) || !((EntityTF2Character)target).isGiant())) {
            if (target instanceof EntityLiving) {
                if (target.getEntityData().func_74764_b("TF2BD")) {
                    target.getEntityData().func_74776_a("TF2BD", Math.max(0.5f, target.getEntityData().func_74760_g("TF2BD") * 0.9f));
                } else {
                    target.getEntityData().func_74776_a("TF2BD", 0.9f);
                }
            }
            ((EntityPlayer)attacker).func_184811_cZ().func_185145_a((Item)this, this.getFiringSpeed(stack, attacker) / 12);
        }
        boolean isBackstab = this.isBackstab(attacker, target, stack);
        if (attacker instanceof EntityPlayerMP && isBackstab && target instanceof EntityLivingBase && !target.func_70089_S() && TF2Util.isEnemy(attacker, (EntityLivingBase)target)) {
            ((EntityPlayerMP)attacker).func_71029_a(TF2Achievements.KILLED_BACKSTAB);
            if (TF2Attribute.getModifier("Disguise Backstab", stack, 0.0f, attacker) != 0.0f) {
                WeaponsCapability.get((Entity)attacker).stabbedDisguise = true;
                if (!(target instanceof EntityPlayer)) {
                    WeaponsCapability.get((Entity)attacker).setDisguiseType("M:" + EntityList.func_191301_a((Entity)target).toString());
                } else {
                    WeaponsCapability.get((Entity)attacker).setDisguiseType("P:" + target.func_70005_c_());
                }
                ((EntityLivingBase)target).field_70725_aQ = 15;
                WeaponsCapability.get((Entity)attacker).setDisguised(true);
            }
        }
    }
}

