/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.item.ItemApplicableEffect;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.WeaponData;

public class ItemKillstreakKit
extends ItemApplicableEffect {
    public static final String[] NAMES = new String[]{"standard", "specialized", "pro"};

    public ItemKillstreakKit() {
        this.func_77637_a(TF2weapons.tabutilitytf2);
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        if (!this.func_194125_a(par2CreativeTabs)) {
            return;
        }
        for (TF2Attribute attribute : TF2Attribute.attributes) {
            if (attribute == null || attribute.perKill == 0.0f) continue;
            for (int level = 0; level < 3; ++level) {
                par3List.add((Object)new ItemStack((Item)this, 1, attribute.id + (level << 9)));
            }
        }
    }

    public TF2Attribute getAttribute(ItemStack stack) {
        return TF2Attribute.attributes[MathHelper.func_76125_a((int)(stack.func_77960_j() & 0x1FF), (int)0, (int)TF2Attribute.attributes.length)];
    }

    public int getLevel(ItemStack stack) {
        return (stack.func_77960_j() >> 9) + 1;
    }

    public String func_77667_c(ItemStack stack) {
        return "item.killstreakkit." + NAMES[MathHelper.func_76125_a((int)(this.getLevel(stack) - 1), (int)0, (int)2)];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        TF2Attribute attrib = this.getAttribute(stack);
        if (attrib != null) {
            tooltip.add("For each kill gain up to:");
            tooltip.add(attrib.getTranslatedString(attrib.defaultValue + attrib.perKill * ItemKillstreakKit.getBonusMult(this.getLevel(stack), attrib, null), true));
        }
    }

    public static float getBonusMult(int level, TF2Attribute attrib, WeaponData weapon) {
        float base = 1.0f;
        switch (level) {
            case 1: {
                base = 1.0f;
                break;
            }
            case 2: {
                base = 1.25f;
                break;
            }
            case 3: {
                base = 1.5f;
            }
        }
        if (weapon != null && attrib.effect.equals("Fire Rate") && weapon.getBoolean(PropertyType.RELOADS_CLIP)) {
            base *= 0.89f;
        }
        return base;
    }

    public static float getLevelDrain(int level, TF2Attribute attrib) {
        float base = 0.7f;
        switch (level) {
            case 1: {
                base = 0.83f;
                break;
            }
            case 2: {
                base = 0.88f;
                break;
            }
            case 3: {
                base = 0.93f;
            }
        }
        return base;
    }

    public static int getCooldown(int level, int kills) {
        int cooldown;
        float drain = 1.0f;
        for (int i = 1; i < kills; ++i) {
            drain *= ItemKillstreakKit.getLevelDrain(level, null);
        }
        switch (level) {
            case 1: {
                cooldown = 900;
                break;
            }
            case 2: {
                cooldown = 1050;
                break;
            }
            case 3: {
                cooldown = 1200;
                break;
            }
            default: {
                return 1200;
            }
        }
        return (int)((float)cooldown * drain);
    }

    public static float getKillstreakBonus(TF2Attribute attrib, int level, int kills, WeaponData weapon) {
        float levelDrain = 1.0f;
        for (int i = 0; i < kills / 5; ++i) {
            levelDrain *= ItemKillstreakKit.getLevelDrain(level, attrib);
        }
        float value = attrib.defaultValue + (5.0f * (1.0f - levelDrain) / (1.0f - ItemKillstreakKit.getLevelDrain(level, attrib)) + (float)(kills % 5) * levelDrain) * (Math.abs(attrib.perKill) * ItemKillstreakKit.getBonusMult(level, attrib, weapon));
        if (attrib.perKill < 0.0f) {
            value = 1.0f / value;
        }
        return value;
    }

    @Override
    public boolean isApplicable(ItemStack stack, ItemStack weapon) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Weapon") ? super.isApplicable(stack, weapon) : weapon.func_77973_b() instanceof ItemWeapon;
    }

    @Override
    public void apply(ItemStack stack, ItemStack weapon) {
        weapon.func_77978_p().func_74774_a("StrLev", (byte)this.getLevel(stack));
        weapon.func_77978_p().func_74777_a("StrAtt", (short)(stack.func_77960_j() & 0x1FF));
    }
}

