/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.item.ItemFabricator;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemKillstreakKit;
import rafradek.TF2weapons.item.ItemRobotPart;

public class ItemKillstreakFabricator
extends ItemFabricator {
    public static Map<TF2Attribute, NonNullList<ItemFabricator.TF2Ingredient>> standardInput = new HashMap<TF2Attribute, NonNullList<ItemFabricator.TF2Ingredient>>();
    public static Map<TF2Attribute, NonNullList<ItemFabricator.TF2Ingredient>> specializedInput = new HashMap<TF2Attribute, NonNullList<ItemFabricator.TF2Ingredient>>();
    public static Map<TF2Attribute, NonNullList<ItemFabricator.TF2Ingredient>> proInput = new HashMap<TF2Attribute, NonNullList<ItemFabricator.TF2Ingredient>>();

    public ItemKillstreakFabricator() {
        this.func_77637_a(TF2weapons.tabsurvivaltf2);
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        if (!this.func_194125_a(par2CreativeTabs)) {
            return;
        }
        for (TF2Attribute attribute : TF2Attribute.attributes) {
            if (attribute == null || attribute.perKill == 0.0f) continue;
            for (int level = 0; level < 3; ++level) {
                par3List.add((Object)new ItemStack((Item)this, 1, attribute.id + (level << 9)));
            }
        }
    }

    public int getLevel(ItemStack stack) {
        return (stack.func_77960_j() >> 9) + 1;
    }

    @Override
    public NonNullList<ItemFabricator.TF2Ingredient> getInput(ItemStack stack, EntityPlayer player) {
        TF2Attribute attr = this.getAttribute(stack);
        switch (this.getLevel(stack)) {
            case 1: {
                return standardInput.get(attr);
            }
            case 2: {
                return specializedInput.get(attr);
            }
            case 3: {
                return proInput.get(attr);
            }
        }
        return null;
    }

    @Override
    public NonNullList<ItemStack> getOutput(ItemStack stack, EntityPlayer player) {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)new ItemStack(TF2weapons.itemKillstreak, 1, stack.func_77960_j()));
        return list;
    }

    public String func_77667_c(ItemStack stack) {
        return "item.killstreakfabricator." + ItemKillstreakKit.NAMES[MathHelper.func_76125_a((int)(this.getLevel(stack) - 1), (int)0, (int)2)];
    }

    public TF2Attribute getAttribute(ItemStack stack) {
        return TF2Attribute.attributes[MathHelper.func_76125_a((int)(stack.func_77960_j() & 0x1FF), (int)0, (int)TF2Attribute.attributes.length)];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        TF2Attribute attrib = this.getAttribute(stack);
        if (attrib != null) {
            tooltip.add("For each kill gain up to:");
            tooltip.add(attrib.getTranslatedString(attrib.defaultValue + attrib.perKill * ItemKillstreakKit.getBonusMult(this.getLevel(stack), attrib, null), true));
        }
        tooltip.add("");
        super.func_77624_a(stack, world, tooltip, advanced);
    }

    public static void initKillstreaks() {
        int i = 0;
        for (TF2Attribute attribute : TF2Attribute.attributes) {
            if (attribute == null || attribute.perKill == 0.0f) continue;
            int meta1 = ItemRobotPart.LEVEL1[i % ItemRobotPart.LEVEL1.length];
            int meta2 = ItemRobotPart.LEVEL2[i % ItemRobotPart.LEVEL2.length];
            int meta3 = ItemRobotPart.LEVEL3[i % ItemRobotPart.LEVEL3.length];
            NonNullList list = NonNullList.func_191196_a();
            list.add((Object)new ItemFabricator.IngredientItemStack(new ItemStack(TF2weapons.itemRobotPart, 12, meta1)));
            standardInput.put(attribute, (NonNullList<ItemFabricator.TF2Ingredient>)list);
            list = NonNullList.func_191196_a();
            list.add((Object)new ItemFabricator.IngredientItemStack(new ItemStack(TF2weapons.itemRobotPart, 12, meta2)));
            list.add((Object)new ItemFabricator.IngredientItemStack(new ItemStack(TF2weapons.itemRobotPart, 8, meta1)));
            list.add((Object)new ItemFabricator.IngredientPredicate((Predicate<ItemStack>)((Predicate)stack -> stack.func_77973_b() instanceof ItemKillstreakKit && ((ItemKillstreakKit)stack.func_77973_b()).getLevel((ItemStack)stack) == 0 || stack.func_77973_b() instanceof ItemFromData && stack.func_77978_p().func_74771_c("StrLev") > 0), 1, "Killstreak kit or weapon"));
            specializedInput.put(attribute, (NonNullList<ItemFabricator.TF2Ingredient>)list);
            list = NonNullList.func_191196_a();
            list.add((Object)new ItemFabricator.IngredientItemStack(new ItemStack(TF2weapons.itemRobotPart, 9, meta3)));
            list.add((Object)new ItemFabricator.IngredientItemStack(new ItemStack(TF2weapons.itemRobotPart, 8, meta2)));
            list.add((Object)new ItemFabricator.IngredientPredicate((Predicate<ItemStack>)((Predicate)stack -> stack.func_77973_b() instanceof ItemKillstreakKit && ((ItemKillstreakKit)stack.func_77973_b()).getLevel((ItemStack)stack) == 1 || stack.func_77973_b() instanceof ItemFromData && stack.func_77978_p().func_74771_c("StrLev") > 1), 1, "Specialized killstreak kit or weapon"));
            proInput.put(attribute, (NonNullList<ItemFabricator.TF2Ingredient>)list);
            ++i;
        }
    }
}

