/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.item.ItemBackpack;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemJetpackTrigger;
import rafradek.TF2weapons.item.ItemToken;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;

public class ItemJetpack
extends ItemBackpack {
    public static ItemStack trigger = ItemStack.field_190927_a;

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77978_p().func_74765_d("Charge") > 0;
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)stack.func_77978_p().func_74765_d("Charge") / (double)this.getCooldown(stack, null);
    }

    @Override
    public ItemStack getBackpackItemToUse(ItemStack stack, EntityLivingBase player) {
        if (trigger.func_190926_b()) {
            trigger = ItemFromData.getNewStack("trigger");
        }
        return trigger;
    }

    @Override
    public void onArmorTickAny(World world, EntityLivingBase player, ItemStack itemStack) {
        super.onArmorTickAny(world, player, itemStack);
        if (!world.field_72995_K) {
            if (player.field_70173_aa % 4 == 0 && itemStack.func_77978_p().func_74765_d("Charge") > 0 && this.getAmmoAmount(player, itemStack) >= this.getActualAmmoUse(itemStack, player, 1)) {
                itemStack.func_77978_p().func_74777_a("Charge", (short)(itemStack.func_77978_p().func_74762_e("Charge") - 4));
                if (player.field_70173_aa % (4 * Math.round((float)this.getCooldown(itemStack, player) / 75.0f)) == 0) {
                    this.consumeAmmoGlobal(player, itemStack, this.getActualAmmoUse(itemStack, player, 1));
                }
                if (itemStack.func_77978_p().func_74765_d("Charge") <= 0) {
                    itemStack.func_77978_p().func_74777_a("Charges", (short)(itemStack.func_77978_p().func_74765_d("Charges") + 1));
                }
            }
            if (itemStack.func_77978_p().func_74767_n("Active")) {
                if (player.field_70122_E) {
                    TF2Util.playSound((Entity)player, ItemJetpack.getSound(itemStack, PropertyType.FIRE_STOP_SOUND), 1.0f, 1.0f);
                    itemStack.func_77978_p().func_74757_a("Active", false);
                }
                TF2Util.stomp(player);
            }
            if (itemStack.func_77978_p().func_74771_c("Load") > 0) {
                itemStack.func_77978_p().func_74774_a("Load", (byte)(itemStack.func_77978_p().func_74771_c("Load") - 1));
                if (itemStack.func_77978_p().func_74771_c("Load") == 0) {
                    itemStack.func_77978_p().func_74774_a("Charges", (byte)(itemStack.func_77978_p().func_74771_c("Charges") - 1));
                    Vec3d vel = player.func_70676_i(1.0f);
                    vel = vel.func_186678_a((double)TF2Attribute.getModifier("Self Push Force", itemStack, 1.0f, player));
                    WeaponsCapability.get((Entity)player).setExpJump(true);
                    player.field_70159_w = vel.field_72450_a;
                    player.field_70181_x = vel.field_72448_b + (player instanceof EntityPlayer ? 0.1 : 0.25);
                    player.field_70179_y = vel.field_72449_c;
                    TF2Util.playSound((Entity)player, ItemJetpack.getSound(itemStack, PropertyType.FIRE_SOUND), 1.0f, 1.0f);
                    itemStack.func_77978_p().func_74757_a("Active", true);
                    if (player instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)player));
                    }
                }
            }
            if (itemStack.func_77978_p().func_74765_d("Charge") == 0 && itemStack.func_77978_p().func_74771_c("Charges") < this.getMaxCharges(itemStack, player)) {
                itemStack.func_77978_p().func_74777_a("Charge", (short)this.getCooldown(itemStack, player));
            }
        } else if (itemStack.func_77978_p().func_74767_n("Active") || itemStack.func_77978_p().func_74771_c("Load") > 0) {
            Vec3d vec = TF2Util.getRotationVector(0.0f, player.field_70761_aq);
            Vec3d vec2 = TF2Util.getRotationVector(0.0f, player.field_70761_aq + 90.0f);
            world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, player.field_70165_t - vec.field_72450_a * 0.4 + vec2.field_72450_a * 0.3, player.field_70163_u + 1.0, player.field_70161_v - vec.field_72449_c * 0.4 + vec2.field_72449_c * 0.3, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, player.field_70165_t - vec.field_72450_a * 0.4 - vec2.field_72450_a * 0.3, player.field_70163_u + 1.0, player.field_70161_v - vec.field_72449_c * 0.4 - vec2.field_72449_c * 0.3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public int getCooldown(ItemStack stack, EntityLivingBase living) {
        return (int)((float)ItemJetpack.getData(stack).getInt(PropertyType.COOLDOWN) * (TF2ConfigVars.fastItemCooldown ? 1.0f : ItemJetpack.getData(stack).getFloat(PropertyType.COOLDOWN_LONG)) / (TF2Attribute.getModifier("Charge", stack, 1.0f, living) + TF2Attribute.getModifier("Charges", stack, 0.0f, living) * 0.12f));
    }

    @Override
    public int getAmmoType(ItemStack stack) {
        return TF2ConfigVars.freeUseItems ? 0 : super.getAmmoType(stack);
    }

    public boolean canActivate(ItemStack stack, EntityLivingBase player) {
        return ItemToken.allowUse(player, "pyro") && (!stack.func_77978_p().func_74767_n("Active") || TF2Attribute.getModifier("Jetpack", stack, 0.0f, player) > 0.0f) && stack.func_77978_p().func_74771_c("Load") <= 0 && stack.func_77978_p().func_74771_c("Charges") > 0;
    }

    public int getMaxCharges(ItemStack stack, EntityLivingBase player) {
        return (int)TF2Attribute.getModifier("Charges", stack, 2.0f, player);
    }

    public void activateJetpack(ItemStack stack, EntityLivingBase player, boolean setTimer) {
        player.field_70181_x = Math.max(player.field_70181_x, 0.0) + 0.5;
        player.field_70160_al = true;
        player.field_70143_R = 0.0f;
        if (!player.field_70170_p.field_72995_K) {
            TF2Util.playSound((Entity)player, ItemJetpack.getSound(stack, PropertyType.CHARGE_SOUND), 1.0f, 1.0f);
            WeaponsCapability.get((Entity)player).setExpJump(true);
            stack.func_77978_p().func_74774_a("Load", (byte)12);
            if (player instanceof EntityPlayerMP) {
                TF2weapons.network.sendTo(new TF2Message.ActionMessage(30, player), (EntityPlayerMP)player);
            }
        } else {
            for (int i = 0; i < 50; ++i) {
                ClientProxy.spawnFlameParticle(player.field_70170_p, player, 0.0f, true);
            }
        }
        if (setTimer && !(player.func_184614_ca().func_77973_b() instanceof ItemJetpackTrigger)) {
            WeaponsCapability.get((Entity)player).setPrimaryCooldown(1500);
            WeaponsCapability.get((Entity)player).setSecondaryCooldown(1500);
        }
    }
}

