/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.entity.projectile.EntityProjectileBase;
import rafradek.TF2weapons.item.ItemProjectileWeapon;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;

public class ItemHuntsman
extends ItemProjectileWeapon {
    public static UUID slowdownUUID = UUID.fromString("12843092-A5D6-BBCD-3D4F-A3DD4ABC65A9");
    public static AttributeModifier slowdown = new AttributeModifier(slowdownUUID, "sniper slowdown", -0.51, 2);

    public ItemHuntsman() {
        this.func_185043_a(new ResourceLocation("loaded"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (ItemHuntsman.this.getClip(stack) > 0) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("lighted"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("ArrowLit")) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("charge"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemHuntsman.this.getCharge(entityIn, stack);
            }
        });
    }

    @Override
    public int holdingMode(ItemStack stack, EntityLivingBase shooter) {
        return (int)((shooter instanceof EntityTF2Character ? ((EntityTF2Character)shooter).scaleWithDifficulty(60.0f, 20.0f) : 20.0f) * TF2Attribute.getModifier("Fire Rate", stack, 1.0f, shooter));
    }

    @Override
    public boolean shouldKeepCharged(ItemStack stack, EntityLivingBase shooter) {
        return true;
    }

    @Override
    public float getProjectileSpeed(ItemStack stack, EntityLivingBase living) {
        return super.getProjectileSpeed(stack, living) * (0.7f + 0.3f * this.getCharge(living, stack));
    }

    @Override
    public float getWeaponSpreadBase(ItemStack stack, EntityLivingBase living) {
        float base = living != null && WeaponsCapability.get((Entity)living).chargeTicks >= this.holdingMode(stack, living) * 5 ? super.getWeaponSpreadBase(stack, living) : 0.0f;
        return base + (float)this.getClip(stack) * 0.06f;
    }

    @Override
    public boolean canHeadshot(EntityLivingBase living, ItemStack stack) {
        return this.getCharge(living, stack) > 0.0f;
    }

    @Override
    public boolean shootAllAtOnce(ItemStack stack, EntityLivingBase living) {
        return true;
    }

    @Override
    public float getWeaponDamage(ItemStack stack, EntityLivingBase living, Entity target) {
        return super.getWeaponDamage(stack, living, target) * (this.getCharge(living, stack) * 1.4f + 1.0f);
    }

    @Override
    public float getAdditionalGravity(EntityLivingBase living, ItemStack stack, double initial) {
        return super.getAdditionalGravity(living, stack, initial) * (1.0f - this.getCharge(living, stack) * 0.5f);
    }

    @Override
    public float getCharge(EntityLivingBase living, ItemStack stack) {
        if (living == null) {
            return 0.0f;
        }
        if (WeaponsCapability.get((Entity)living).lastHitCharge != 0.0f) {
            return WeaponsCapability.get((Entity)living).lastHitCharge;
        }
        int chargeTicks = WeaponsCapability.get((Entity)living).chargeTicks;
        int maxCharge = this.holdingMode(stack, living);
        return chargeTicks <= maxCharge * 5 ? MathHelper.func_76131_a((float)((float)chargeTicks / (float)maxCharge), (float)0.0f, (float)1.0f) : 0.0f;
    }

    @Override
    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        super.func_77663_a(par1ItemStack, par2World, par3Entity, par4, par5);
        if (!par2World.field_72995_K && par3Entity.field_70173_aa % 10 == 0) {
            WeaponsCapability cap = (WeaponsCapability)par3Entity.getCapability(TF2weapons.WEAPONS_CAP, null);
            if (par5 && (OreDictionary.itemMatches((ItemStack)new ItemStack(Blocks.field_150478_aa), (ItemStack)((EntityLivingBase)par3Entity).func_184592_cb(), (boolean)false) || OreDictionary.itemMatches((ItemStack)new ItemStack(Blocks.field_150478_aa), (ItemStack)new ItemStack(par2World.func_180495_p(par3Entity.func_180425_c()).func_177230_c()), (boolean)false) || OreDictionary.itemMatches((ItemStack)new ItemStack(Blocks.field_150478_aa), (ItemStack)new ItemStack(par2World.func_180495_p(par3Entity.func_180425_c().func_177984_a()).func_177230_c()), (boolean)false))) {
                par1ItemStack.func_77978_p().func_74757_a("ArrowLit", true);
            }
        }
    }

    @Override
    public boolean use(ItemStack stack, EntityLivingBase living, World world, EnumHand hand, TF2Message.PredictionMessage message) {
        boolean use = super.use(stack, living, world, hand, message);
        WeaponsCapability cap = (WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null);
        if (cap.isCharging()) {
            TF2Util.addModifierSafe(living, SharedMonsterAttributes.field_111263_d, slowdown, false);
        }
        return use;
    }

    @Override
    public void onProjectileShoot(ItemStack stack, EntityProjectileBase proj, EntityLivingBase living, World world, int thisCritical, EnumHand hand) {
        if (this.getClip(stack) != 0) {
            proj.damageModifier *= 0.66f;
        }
    }

    @Override
    public void shoot(ItemStack stack, EntityLivingBase living, World world, int thisCritical, EnumHand hand) {
        if (!world.field_72995_K) {
            ItemStack arrow = new ItemStack(stack.func_77978_p().func_74775_l("LastLoaded"));
            if (arrow.func_190926_b() || arrow.func_77973_b() == Items.field_151032_g) {
                super.shoot(stack, living, world, thisCritical, hand);
            } else if (arrow.func_77973_b() instanceof ItemArrow) {
                EntityArrow entityarrow = ((ItemArrow)arrow.func_77973_b()).func_185052_a(world, arrow, living);
                float motion = this.getProjectileSpeed(stack, living) * 2.6f - super.getProjectileSpeed(stack, living);
                entityarrow.func_184547_a((Entity)living, living.field_70125_A, living.field_70177_z, 0.0f, motion, this.getWeaponSpread(stack, living) * 66.0f);
                entityarrow.field_70251_a = living instanceof EntityPlayer && !((ItemArrow)arrow.func_77973_b()).isInfinite(arrow, stack, (EntityPlayer)living) ? EntityArrow.PickupStatus.ALLOWED : EntityArrow.PickupStatus.DISALLOWED;
                entityarrow.func_70239_b(entityarrow.func_70242_d() - 2.0 + (double)(this.getWeaponDamage(stack, living, null) / motion * 0.975f));
                if (stack.func_77978_p().func_74767_n("ArrowLit")) {
                    entityarrow.func_70015_d(500);
                    stack.func_77978_p().func_74757_a("ArrowLit", false);
                }
                entityarrow.getEntityData().func_74757_a("TF2Arrow", true);
                world.func_72838_d((Entity)entityarrow);
            }
        }
    }

    @Override
    public boolean endUse(ItemStack stack, EntityLivingBase living, World world, int action, int newState) {
        WeaponsCapability cap = (WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null);
        boolean charging = cap.isCharging();
        boolean ret = super.endUse(stack, living, world, action, newState);
        if (charging) {
            living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(slowdown);
        }
        return ret;
    }

    @Override
    public boolean altFireTick(ItemStack stack, EntityLivingBase living, World world) {
        WeaponsCapability cap = (WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null);
        if (cap.isCharging()) {
            cap.setCharging(false);
            cap.setPrimaryCooldown(750);
            living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(slowdown);
            living.func_184185_a(ItemHuntsman.getSound(stack, PropertyType.WIND_DOWN_SOUND), 1.0f, 1.0f);
        }
        return false;
    }

    static {
        slowdown.func_111168_a(false);
    }
}

