/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2EventsCommon;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.building.EntityDispenser;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.inventory.InventoryWearables;
import rafradek.TF2weapons.item.IItemOverlay;
import rafradek.TF2weapons.item.ItemAmmo;
import rafradek.TF2weapons.item.ItemKillstreakKit;
import rafradek.TF2weapons.item.ItemToken;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;
import rafradek.TF2weapons.util.WeaponData;

public class ItemFromData
extends Item
implements IItemOverlay {
    public static final WeaponData BLANK_DATA = new WeaponData("toloadfiles");
    public static final Predicate<WeaponData> VISIBLE_WEAPON = new Predicate<WeaponData>(){

        public boolean apply(WeaponData input) {
            return !input.getBoolean(PropertyType.HIDDEN) && input.getInt(PropertyType.ROLL_HIDDEN) == 0 && !input.getString(PropertyType.CLASS).equals("cosmetic") && !input.getString(PropertyType.CLASS).equals("crate");
        }
    };

    public ItemFromData() {
        this.func_77637_a(TF2weapons.tabutilitytf2);
        this.func_77655_b("tf2usable");
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("team"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn != null) {
                    if (TF2Util.getTeamColorNumber((Entity)entityIn) == 12) {
                        return 0.0f;
                    }
                    if (TF2Util.getTeamColorNumber((Entity)entityIn) == 9 || TF2Util.getTeamColorNumber((Entity)entityIn) == 11) {
                        return 1.0f;
                    }
                    return 0.5f;
                }
                return 0.0f;
            }
        });
    }

    public void func_77663_a(ItemStack stack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (ItemFromData.getData(stack) == BLANK_DATA && par3Entity instanceof EntityPlayer) {
            ((EntityPlayer)par3Entity).field_71071_by.func_70299_a(par4, ItemStack.field_190927_a);
            stack.func_190920_e(0);
            return;
        }
    }

    public static WeaponData getData(ItemStack stack) {
        WeaponData value = BLANK_DATA;
        if (stack.hasCapability(TF2weapons.WEAPONS_DATA_CAP, null) && (value = ((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).inst) == BLANK_DATA && stack.func_77942_o() && MapList.nameToData.containsKey(stack.func_77978_p().func_74779_i("Type"))) {
            value = ((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).inst = MapList.nameToData.get(stack.func_77978_p().func_74779_i("Type"));
        }
        return value;
    }

    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        if (!this.func_194125_a(par2CreativeTabs) && par2CreativeTabs != TF2weapons.tabrareweapontf2) {
            return;
        }
        for (Map.Entry<String, WeaponData> entry : MapList.nameToData.entrySet()) {
            Item item;
            boolean isRare;
            boolean bl = isRare = entry.getValue().getInt(PropertyType.ROLL_HIDDEN) == 2;
            if (entry.getValue().hasProperty(PropertyType.HIDDEN) && entry.getValue().getBoolean(PropertyType.HIDDEN) || (!isRare || par2CreativeTabs != TF2weapons.tabrareweapontf2) && (isRare || par2CreativeTabs == TF2weapons.tabrareweapontf2) || (item = MapList.weaponClasses.get(entry.getValue().getString(PropertyType.CLASS))) != this) continue;
            par3List.add((Object)ItemFromData.getNewStack(entry.getKey()));
        }
    }

    public static ItemStack getNewStack(String type) {
        if (!MapList.nameToData.containsKey(type)) {
            return ItemStack.field_190927_a;
        }
        return ItemFromData.getNewStack(MapList.nameToData.get(type));
    }

    public static ItemStack getNewStack(WeaponData type) {
        ItemStack stack = new ItemStack(MapList.weaponClasses.get(type.getString(PropertyType.CLASS)));
        ((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).inst = type;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Type", type.getName());
        tag.func_74782_a("Attributes", (NBTBase)new NBTTagCompound());
        stack.func_77982_d(tag);
        return stack;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new WeaponData.WeaponDataCapability();
    }

    public static List<ItemStack> getRandomWeapons(Random random, Predicate<WeaponData> predicate, int count) {
        ArrayList<WeaponData> weapons = new ArrayList<WeaponData>();
        for (Map.Entry<String, WeaponData> entry : MapList.nameToData.entrySet()) {
            if (!predicate.apply((Object)entry.getValue())) continue;
            weapons.add(entry.getValue());
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < count && !weapons.isEmpty(); ++i) {
            ret.add(ItemFromData.getNewStack((WeaponData)weapons.remove(random.nextInt(weapons.size()))));
        }
        return ret;
    }

    public static ItemStack getRandomWeapon(Random random, Predicate<WeaponData> predicate) {
        return (ItemStack)Iterables.getFirst(ItemFromData.getRandomWeapons(random, predicate, 1), (Object)ItemStack.field_190927_a);
    }

    public static ItemStack getRandomWeaponOfType(String type, float chanceOfParent, Random random) {
        if (chanceOfParent >= 0.0f && random.nextFloat() <= chanceOfParent) {
            return ItemFromData.getNewStack(type);
        }
        ArrayList<String> weapons = new ArrayList<String>();
        if (chanceOfParent < 0.0f) {
            weapons.add(type);
        }
        for (Map.Entry<String, WeaponData> entry : MapList.nameToData.entrySet()) {
            if (entry.getValue().getBoolean(PropertyType.HIDDEN) || entry.getValue().getInt(PropertyType.ROLL_HIDDEN) != 0 || !entry.getValue().getString(PropertyType.BASED_ON).equals(type)) continue;
            weapons.add(entry.getKey());
        }
        if (weapons.size() > 0) {
            return ItemFromData.getNewStack((String)weapons.get(random.nextInt(weapons.size())));
        }
        return ItemFromData.getNewStack(type);
    }

    public static ItemStack getRandomWeaponOfClass(String clazz, Random random, boolean showHidden) {
        ArrayList<WeaponData> weapons = new ArrayList<WeaponData>();
        for (Map.Entry<String, WeaponData> entry : MapList.nameToData.entrySet()) {
            if (entry.getValue().getBoolean(PropertyType.HIDDEN) || !showHidden && entry.getValue().getInt(PropertyType.ROLL_HIDDEN) != 0 || !entry.getValue().getString(PropertyType.CLASS).equals(clazz)) continue;
            weapons.add(entry.getValue());
        }
        if (weapons.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ItemFromData.getNewStack((WeaponData)weapons.get(random.nextInt(weapons.size())));
    }

    public static ItemStack getRandomWeaponOfSlotMob(final String mob, final int slot, Random random, final boolean showHidden, float stockWeight, boolean stockOnly) {
        Predicate<WeaponData> base = new Predicate<WeaponData>(){

            public boolean apply(WeaponData input) {
                return !input.getBoolean(PropertyType.HIDDEN) && (input.getInt(PropertyType.ROLL_HIDDEN) <= 0 || showHidden) && ItemFromData.isItemOfClassSlot(input, slot, mob);
            }
        };
        if (stockWeight == 1.0f && !stockOnly) {
            return ItemFromData.getRandomWeapon(random, base);
        }
        ItemStack stock = ItemFromData.getRandomWeapon(random, (Predicate<WeaponData>)Predicates.and((Predicate)base, (Predicate)new Predicate<WeaponData>(){

            public boolean apply(WeaponData input) {
                return input.getBoolean(PropertyType.STOCK);
            }
        }));
        if (stockOnly) {
            return stock;
        }
        Predicate unipredicate = Predicates.and((Predicate)base, (Predicate)new Predicate<WeaponData>(){

            public boolean apply(WeaponData input) {
                return !input.getBoolean(PropertyType.STOCK);
            }
        });
        float unicount = ItemFromData.getWeaponCount((Predicate<WeaponData>)unipredicate);
        ItemStack uni = ItemFromData.getRandomWeapon(random, (Predicate<WeaponData>)unipredicate);
        if (uni.func_190926_b()) {
            return stock;
        }
        if (stock.func_190926_b()) {
            return uni;
        }
        if (random.nextFloat() < unicount / (unicount + stockWeight)) {
            return uni;
        }
        return stock;
    }

    public static List<ItemStack> getRandomWeaponsOfSlotMob(final String mob, final int slot, Random random, final boolean showHidden, int count) {
        return ItemFromData.getRandomWeapons(random, new Predicate<WeaponData>(){

            public boolean apply(WeaponData input) {
                return !input.getBoolean(PropertyType.HIDDEN) && (input.getInt(PropertyType.ROLL_HIDDEN) <= 0 || showHidden) && ItemFromData.isItemOfClassSlot(input, slot, mob);
            }
        }, count);
    }

    public static int getWeaponCount(Predicate<WeaponData> predicate) {
        int count = 0;
        for (Map.Entry<String, WeaponData> entry : MapList.nameToData.entrySet()) {
            if (!predicate.apply((Object)entry.getValue())) continue;
            ++count;
        }
        return count;
    }

    public static boolean isSameType(ItemStack stack, String name) {
        return !stack.func_190926_b() && ItemFromData.getData(stack) != BLANK_DATA && (ItemFromData.getData(stack).getName().equals(name) || ItemFromData.getData(stack).getString(PropertyType.BASED_ON).equals(name));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return ItemFromData.getData(oldStack) != ItemFromData.getData(newStack) || slotChanged;
    }

    public String func_77653_i(ItemStack stack) {
        if (ItemFromData.getData(stack) == BLANK_DATA) {
            return "Weapon";
        }
        String name = this.getTranslatedName(stack);
        if (stack.func_77978_p().func_74767_n("Strange")) {
            name = TextFormatting.GOLD + TF2EventsCommon.STRANGE_TITLES[stack.func_77978_p().func_74762_e("StrangeLevel")] + " " + name;
        }
        if (stack.func_77978_p().func_74767_n("Australium")) {
            name = TextFormatting.GOLD + "Australium " + name;
        }
        if (stack.func_77978_p().func_74767_n("Valve")) {
            name = TextFormatting.DARK_PURPLE + "Valve " + name;
        }
        return name;
    }

    public static SoundEvent getSound(ItemStack stack, PropertyType name) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(ItemFromData.getData(stack).getString(name)));
    }

    public static int getSlotForClass(WeaponData data, String name) {
        return data.hasProperty(PropertyType.SLOT) && data.get(PropertyType.SLOT).containsKey(name) ? data.get(PropertyType.SLOT).get(name) : -1;
    }

    public static int getSlotForClass(WeaponData data, EntityTF2Character name) {
        return ItemFromData.getSlotForClass(data, ItemToken.CLASS_NAMES[name.getClassIndex()]);
    }

    public static boolean isItemOfClassSlot(WeaponData data, int slot, String name) {
        return data.hasProperty(PropertyType.SLOT) && data.get(PropertyType.SLOT).containsKey(name) && data.get(PropertyType.SLOT).get(name) == slot;
    }

    public static boolean isItemOfClass(WeaponData data, String name) {
        return data.hasProperty(PropertyType.SLOT) && data.get(PropertyType.SLOT).containsKey(name);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77942_o()) {
            TF2Attribute attribute;
            NBTTagFloat tagFloat;
            NBTBase tag;
            NBTTagCompound attributeList = stack.func_77978_p().func_74775_l("Attributes");
            for (String name : attributeList.func_150296_c()) {
                tag = attributeList.func_74781_a(name);
                if (!(tag instanceof NBTTagFloat)) continue;
                tagFloat = (NBTTagFloat)tag;
                attribute = TF2Attribute.attributes[Integer.parseInt(name)];
                if (attribute == null || attribute.state == TF2Attribute.State.HIDDEN) continue;
                tooltip.add(attribute.getTranslatedString(tagFloat.func_150288_h(), true));
            }
            attributeList = MapList.buildInAttributes.get(ItemFromData.getData(stack).getName());
            for (String name : attributeList.func_150296_c()) {
                tag = attributeList.func_74781_a(name);
                if (!(tag instanceof NBTTagFloat)) continue;
                tagFloat = (NBTTagFloat)tag;
                attribute = TF2Attribute.attributes[Integer.parseInt(name)];
                if (attribute == null || attribute.state == TF2Attribute.State.HIDDEN) continue;
                tooltip.add(attribute.getTranslatedString(tagFloat.func_150288_h(), true));
            }
            if (stack.func_77978_p().func_74764_b("StrAtt")) {
                tooltip.add("Killstreak Active");
                TF2Attribute attribute2 = TF2Attribute.attributes[stack.func_77978_p().func_74765_d("StrAtt")];
                if (attribute2 != null && attribute2.state != TF2Attribute.State.HIDDEN) {
                    tooltip.add(attribute2.getTranslatedString(ItemKillstreakKit.getKillstreakBonus(attribute2, stack.func_77978_p().func_74771_c("StrLev"), stack.func_77978_p().func_74762_e("StrKil"), ItemFromData.getData(stack)), true));
                }
            }
            if (ItemFromData.getData(stack).hasProperty(PropertyType.DESC)) {
                tooltip.add("");
                for (String line : ItemFromData.getData(stack).getString(PropertyType.DESC).split("\n")) {
                    tooltip.add(line);
                }
            }
            if (stack.func_77978_p().func_74767_n("Bought")) {
                tooltip.add("");
                tooltip.add("This item cannot be destroyed");
            }
        }
    }

    public boolean hasKillstreak(ItemStack stack, int minLevel) {
        return stack.func_77978_p().func_74771_c("StrLev") >= minLevel;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return 12000;
    }

    @Override
    public boolean showInfoBox(ItemStack stack, EntityPlayer player) {
        return false;
    }

    @Override
    public String[] getInfoBoxLines(ItemStack stack, EntityPlayer player) {
        return null;
    }

    @Override
    public void drawOverlay(ItemStack stack, EntityPlayer player, Tessellator tesselator, BufferBuilder buffer, ScaledResolution resolution) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showDurabilityBar(ItemStack stack) {
        return this.getMaxRage(stack, null) > 0.0f ? this.getRage(stack, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g) < this.getMaxRage(stack, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g) : super.showDurabilityBar(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public double getDurabilityForDisplay(ItemStack stack) {
        return this.getMaxRage(stack, null) > 0.0f ? (double)(1.0f - this.getRage(stack, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g) / this.getMaxRage(stack, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) : super.getDurabilityForDisplay(stack);
    }

    public WeaponsCapability.RageType getRageType(ItemStack stack, EntityLivingBase living) {
        return null;
    }

    public float getMaxRage(ItemStack stack, EntityLivingBase living) {
        return 0.0f;
    }

    public float getRage(ItemStack stack, EntityLivingBase living) {
        return WeaponsCapability.get((Entity)living).getRage(this.getRageType(stack, living));
    }

    public void setRage(ItemStack stack, EntityLivingBase living, float value) {
        WeaponsCapability.get((Entity)living).setRage(this.getRageType(stack, living), MathHelper.func_76131_a((float)value, (float)0.0f, (float)this.getMaxRage(stack, living)));
    }

    public void addRage(ItemStack stack, EntityLivingBase living, float value) {
        this.setRage(stack, living, this.getRage(stack, living) + value);
    }

    public boolean isAmmoSufficient(ItemStack stack, EntityLivingBase living, boolean all) {
        return !this.searchForAmmo(living, stack).func_190926_b();
    }

    public void consumeAmmoGlobal(EntityLivingBase living, ItemStack stack, int amount) {
        if (EntityDispenser.isNearDispenser(living.field_70170_p, living)) {
            return;
        }
        amount = this.getActualAmmoUse(stack, living, amount);
        if (living instanceof EntityTF2Character) {
            ((EntityTF2Character)living).useAmmo(amount);
        }
        if (!(living instanceof EntityPlayer) || ((EntityPlayer)living).func_184812_l_()) {
            return;
        }
        if (TF2Attribute.getModifier("Metal Ammo", stack, 0.0f, living) != 0.0f) {
            ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).consumeMetal(amount, false);
        }
        if (amount > 0) {
            ItemStack stackAmmo;
            while (amount > 0 && !(stackAmmo = this.searchForAmmo(living, stack)).func_190926_b()) {
                if (stackAmmo.func_77973_b() instanceof ItemAmmo) {
                    amount = ((ItemAmmo)stackAmmo.func_77973_b()).consumeAmmo(living, stackAmmo, amount);
                    continue;
                }
                if (stackAmmo.func_77973_b() instanceof ItemArrow) {
                    stack.func_77978_p().func_74782_a("LastLoaded", (NBTBase)stackAmmo.serializeNBT());
                }
                int ammo = amount;
                amount -= stackAmmo.func_190916_E();
                stackAmmo.func_190918_g(ammo);
            }
        }
    }

    public ItemStack searchForAmmo(EntityLivingBase owner, ItemStack stack) {
        if (EntityDispenser.isNearDispenser(owner.field_70170_p, owner) || owner instanceof EntityPlayer && ((EntityPlayer)owner).field_71075_bZ.field_75098_d) {
            return ItemAmmo.STACK_FILL;
        }
        int type = ((ItemFromData)stack.func_77973_b()).getAmmoType(stack);
        if (type == 0 || type == 14 && TF2ConfigVars.freeUseItems) {
            return ItemAmmo.STACK_FILL;
        }
        if (owner instanceof EntityTF2Character) {
            return ((EntityTF2Character)owner).getAmmo(ItemFromData.getSlotForClass(ItemFromData.getData(stack), (EntityTF2Character)owner)) > 0 ? ItemAmmo.STACK_FILL : ItemStack.field_190927_a;
        }
        if (!(owner instanceof EntityPlayer)) {
            return ItemAmmo.STACK_FILL;
        }
        int metalammo = (int)TF2Attribute.getModifier("Metal Ammo", stack, 0.0f, owner);
        if (metalammo != 0) {
            return ((WeaponsCapability)owner.getCapability(TF2weapons.WEAPONS_CAP, null)).hasMetal(metalammo) ? ItemAmmo.STACK_FILL : ItemStack.field_190927_a;
        }
        if (owner.field_70170_p.field_72995_K && (type >= ((TF2PlayerCapability)owner.getCapability(TF2weapons.PLAYER_CAP, null)).cachedAmmoCount.length || ((TF2PlayerCapability)owner.getCapability(TF2weapons.PLAYER_CAP, null)).cachedAmmoCount[type] > 0)) {
            return ItemAmmo.STACK_FILL;
        }
        if (!((InventoryWearables)((Object)owner.getCapability(TF2weapons.INVENTORY_CAP, null))).func_70301_a(3).func_190926_b()) {
            IItemHandler inv = (IItemHandler)((InventoryWearables)((Object)owner.getCapability(TF2weapons.INVENTORY_CAP, null))).func_70301_a(3).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stackCap = inv.getStackInSlot(i);
                if (stackCap.func_190926_b() || (!(stackCap.func_77973_b() instanceof ItemAmmo) || ((ItemAmmo)stackCap.func_77973_b()).getTypeInt(stackCap) != type) && (type != 1000 || !(stackCap.func_77973_b() instanceof ItemArrow))) continue;
                return stackCap;
            }
        }
        for (int i = 0; i < ((EntityPlayer)owner).field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stackInv = (ItemStack)((EntityPlayer)owner).field_71071_by.field_70462_a.get(i);
            if (stackInv == null || (!(stackInv.func_77973_b() instanceof ItemAmmo) || ((ItemAmmo)stackInv.func_77973_b()).getTypeInt(stackInv) != type) && (type != 1000 || !(stackInv.func_77973_b() instanceof ItemArrow))) continue;
            return stackInv;
        }
        return ItemStack.field_190927_a;
    }

    public int getAmmoType(ItemStack stack) {
        return TF2Attribute.getModifier("No Ammo", stack, 0.0f, null) != 0.0f ? 0 : ItemFromData.getData(stack).getInt(PropertyType.AMMO_TYPE);
    }

    public int getAmmoAmount(EntityLivingBase owner, ItemStack stack) {
        int type = this.getAmmoType(stack);
        if (type == 0) {
            return 999;
        }
        if (type == 14 && owner instanceof EntityPlayer && TF2ConfigVars.freeUseItems) {
            return ((EntityPlayer)owner).func_184811_cZ().func_185141_a((Item)this) ? 0 : 1;
        }
        if (EntityDispenser.isNearDispenser(owner.field_70170_p, owner) || owner instanceof EntityPlayer && ((EntityPlayer)owner).field_71075_bZ.field_75098_d) {
            return 999;
        }
        if (owner instanceof EntityTF2Character) {
            return (int)((float)((EntityTF2Character)owner).getAmmo() / TF2Attribute.getModifier("Ammo Eff", stack, 1.0f, owner));
        }
        if (TF2Attribute.getModifier("Ball Release", stack, 0.0f, owner) > 0.0f) {
            stack = ItemFromData.getNewStack("sandmanball");
        }
        if (TF2Attribute.getModifier("Metal Ammo", stack, 0.0f, owner) != 0.0f) {
            return ((WeaponsCapability)owner.getCapability(TF2weapons.WEAPONS_CAP, null)).getMetal();
        }
        int ammoCount = 0;
        if (!((InventoryWearables)((Object)owner.getCapability(TF2weapons.INVENTORY_CAP, null))).func_70301_a(3).func_190926_b()) {
            IItemHandler inv = (IItemHandler)((InventoryWearables)((Object)owner.getCapability(TF2weapons.INVENTORY_CAP, null))).func_70301_a(3).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stackCap = inv.getStackInSlot(i);
                if (!stackCap.func_190926_b() && stackCap.func_77973_b() instanceof ItemAmmo && ((ItemAmmo)stackCap.func_77973_b()).getTypeInt(stackCap) == type) {
                    ammoCount += ((ItemAmmo)stackCap.func_77973_b()).getAmount(stackCap);
                    continue;
                }
                if (type != 1000 || stackCap.func_190926_b() || !(stackCap.func_77973_b() instanceof ItemArrow)) continue;
                ammoCount += stackCap.func_190916_E();
            }
        }
        for (int i = 0; i < ((EntityPlayer)owner).field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stackInv = (ItemStack)((EntityPlayer)owner).field_71071_by.field_70462_a.get(i);
            if (!stackInv.func_190926_b() && stackInv.func_77973_b() instanceof ItemAmmo && ((ItemAmmo)stackInv.func_77973_b()).getTypeInt(stackInv) == type) {
                ammoCount += ((ItemAmmo)stackInv.func_77973_b()).getAmount(stackInv);
                continue;
            }
            if (type != 1000 || stackInv.func_190926_b() || !(stackInv.func_77973_b() instanceof ItemArrow)) continue;
            ammoCount += stackInv.func_190916_E();
        }
        return (int)((float)ammoCount / TF2Attribute.getModifier("Ammo Eff", stack, 1.0f, owner));
    }

    public int getActualAmmoUse(ItemStack stack, EntityLivingBase living, int amount) {
        if (this.getAmmoType(stack) == 0 || amount == 0) {
            return 0;
        }
        if (TF2Attribute.getModifier("Metal Ammo", stack, 0.0f, living) != 0.0f) {
            amount = (int)TF2Attribute.getModifier("Metal Ammo", stack, 0.0f, living);
        }
        stack.func_77978_p().func_74776_a("UsedAmmo", stack.func_77978_p().func_74760_g("UsedAmmo") + (float)amount * TF2Attribute.getModifier("Ammo Eff", stack, 1.0f, living));
        amount = 0;
        while (stack.func_77978_p().func_74760_g("UsedAmmo") >= 1.0f) {
            stack.func_77978_p().func_74776_a("UsedAmmo", stack.func_77978_p().func_74760_g("UsedAmmo") - 1.0f);
            ++amount;
        }
        return amount;
    }

    public int getVisibilityFlags(ItemStack stack, EntityLivingBase living) {
        return ItemFromData.getData(stack).getInt(PropertyType.WEAR);
    }

    public String getTranslatedName(ItemStack stack) {
        WeaponData data = ItemFromData.getData(stack);
        String key = "weapon." + data.getName();
        return I18n.func_94522_b((String)key) ? I18n.func_74838_a((String)key) : (ItemFromData.getData(stack).hasProperty(PropertyType.NAME) ? ItemFromData.getData(stack).getString(PropertyType.NAME) : ItemFromData.getData(stack).getName());
    }

    public boolean canSwitchTo(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshDefinition() {
        return stack -> {
            if (stack.hasCapability(TF2weapons.WEAPONS_DATA_CAP, null)) {
                if (((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).inst != BLANK_DATA) {
                    return ClientProxy.nameToModel.get(((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).inst.getName());
                }
                if (stack.func_77942_o()) {
                    return ClientProxy.nameToModel.get(stack.func_77978_p().func_74779_i("Type"));
                }
            }
            return ClientProxy.nameToModel.get("minigun");
        };
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(WeaponData weapon) {
        String modelName = weapon.getString(PropertyType.RENDER);
        if (modelName == null || modelName.isEmpty()) {
            return;
        }
        ModelResourceLocation model = new ModelResourceLocation(modelName, "inventory");
        ModelLoader.registerItemVariants((Item)MapList.weaponClasses.get(weapon.getString(PropertyType.CLASS)), (ResourceLocation[])new ResourceLocation[]{model});
        ClientProxy.nameToModel.put(weapon.getName(), model);
        if (weapon.hasProperty(PropertyType.RENDER_BACKSTAB)) {
            modelName = weapon.getString(PropertyType.RENDER_BACKSTAB);
            model = new ModelResourceLocation(modelName, "inventory");
            ModelLoader.registerItemVariants((Item)MapList.weaponClasses.get(weapon.getString(PropertyType.CLASS)), (ResourceLocation[])new ResourceLocation[]{model});
            ClientProxy.nameToModel.put(weapon.getName() + "/b", model);
        }
    }

    public static class AttributeProvider {
        public Map<TF2Attribute, Float> attributes;

        public AttributeProvider(Map<TF2Attribute, Float> attributes) {
            this.attributes = attributes;
        }
    }

    public static class PropertyAttribute
    extends PropertyType<AttributeProvider> {
        public PropertyAttribute(int id, String name, Class<AttributeProvider> type) {
            super(id, name, type);
        }

        @Override
        public AttributeProvider deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HashMap<TF2Attribute, Float> attributes = new HashMap<TF2Attribute, Float>();
            for (Map.Entry attribute : json.getAsJsonObject().entrySet()) {
                String attributeName = (String)attribute.getKey();
                float attributeValue = ((JsonElement)attribute.getValue()).getAsFloat();
                Iterator<String> iterator2 = MapList.nameToAttribute.keySet().iterator();
                boolean has = false;
                while (iterator2.hasNext()) {
                    if (!iterator2.next().equals(attributeName)) continue;
                    attributes.put(MapList.nameToAttribute.get(attributeName), Float.valueOf(attributeValue));
                    has = true;
                }
                if (has) continue;
                attributes.put(TF2Attribute.attributes[Integer.parseInt(attributeName)], Float.valueOf(attributeValue));
            }
            return new AttributeProvider(attributes);
        }

        @Override
        public void serialize(DataOutput buf, WeaponData data, AttributeProvider value) throws IOException {
            buf.writeByte(value.attributes.size());
            for (Map.Entry<TF2Attribute, Float> attr : value.attributes.entrySet()) {
                buf.writeByte(attr.getKey().id);
                buf.writeFloat(attr.getValue().floatValue());
            }
        }

        @Override
        public AttributeProvider deserialize(DataInput buf, WeaponData data) throws IOException {
            HashMap<TF2Attribute, Float> map = new HashMap<TF2Attribute, Float>();
            int attributeCount = buf.readByte();
            for (int i = 0; i < attributeCount; ++i) {
                map.put(TF2Attribute.attributes[buf.readUnsignedByte()], Float.valueOf(buf.readFloat()));
            }
            return new AttributeProvider(map);
        }
    }
}

