/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.client.audio.WeaponSound;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.item.ItemAirblast;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;

public class ItemFlameThrower
extends ItemAirblast {
    @Override
    public boolean canAltFire(World worldObj, EntityLivingBase player, ItemStack item) {
        return super.canAltFire(worldObj, player, item) || TF2Attribute.getModifier("Rage Crit", item, 0.0f, player) != 0.0f && this.getRage(item, player) >= this.getMaxRage(item, player);
    }

    @Override
    public boolean canFire(World world, EntityLivingBase living, ItemStack stack) {
        return super.canFire(world, living, stack);
    }

    @Override
    public boolean startUse(ItemStack stack, EntityLivingBase living, World world, int action, int newState) {
        if (world.field_72995_K && (newState & 1) - (action & 1) == 1 && this.canFire(world, living, stack)) {
            SoundEvent playSound = ItemFromData.getSound(stack, PropertyType.FIRE_START_SOUND);
            ClientProxy.playWeaponSound(living, playSound, false, 2, stack);
        }
        return false;
    }

    @Override
    public boolean endUse(ItemStack stack, EntityLivingBase living, World world, int action, int newState) {
        if ((action & 1) == 1) {
            if (world.field_72995_K && ClientProxy.fireSounds.get((Object)living) != null) {
                ((WeaponSound)((Object)ClientProxy.fireSounds.get((Object)living))).setDone();
            }
            living.func_184185_a(ItemFromData.getSound(stack, PropertyType.FIRE_STOP_SOUND), 1.0f, 1.0f);
        }
        return false;
    }

    @Override
    public boolean fireTick(ItemStack stack, EntityLivingBase living, World world) {
        if (world.field_72995_K && ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).getPrimaryCooldown() <= 50 && this.canFire(world, living, stack)) {
            if (((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).startedPress()) {
                SoundEvent playSound = ItemFromData.getSound(stack, PropertyType.FIRE_START_SOUND);
                ClientProxy.playWeaponSound(living, playSound, false, 2, stack);
            }
            if (living.func_70055_a(Material.field_151586_h)) {
                world.func_175688_a(EnumParticleTypes.WATER_BUBBLE, living.field_70165_t, living.field_70163_u + (double)living.func_70047_e() - 0.1, living.field_70161_v, living.field_70159_w, 0.2 + living.field_70181_x, living.field_70179_y, new int[0]);
            } else {
                ClientProxy.spawnFlameParticle(world, living, 0.0f, false);
                ClientProxy.spawnFlameParticle(world, living, 0.5f, false);
            }
            if (TF2Util.calculateCritPre(stack, living) != 2 && (!ClientProxy.fireSounds.containsKey((Object)living) || !Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)ClientProxy.fireSounds.get((Object)living)) || ((WeaponSound)((Object)ClientProxy.fireSounds.get((Object)living))).type != 0 && ((WeaponSound)((Object)ClientProxy.fireSounds.get((Object)living))).type != 2)) {
                ClientProxy.playWeaponSound(living, ItemFromData.getSound(stack, PropertyType.FIRE_LOOP_SOUND), true, 0, stack);
            } else if (!(TF2Util.calculateCritPre(stack, living) != 2 || ClientProxy.fireSounds.containsKey((Object)living) && Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)ClientProxy.fireSounds.get((Object)living)) && ((WeaponSound)((Object)ClientProxy.fireSounds.get((Object)living))).type == 1)) {
                ResourceLocation playSoundCrit = new ResourceLocation(ItemFromData.getData(stack).getString(PropertyType.FIRE_LOOP_SOUND) + ".crit");
                ClientProxy.playWeaponSound(living, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)playSoundCrit), true, 1, stack);
            }
        }
        return false;
    }

    @Override
    public float getProjectileSpeed(ItemStack stack, EntityLivingBase living) {
        float speed = super.getProjectileSpeed(stack, living);
        return speed * 0.6f + TF2Attribute.getModifier("Flame Range", stack, speed * 0.4f, living);
    }

    @Override
    public WeaponsCapability.RageType getRageType(ItemStack stack, EntityLivingBase living) {
        return TF2Attribute.getModifier("Rage Crit", stack, 0.0f, null) == 1.0f ? WeaponsCapability.RageType.PHLOG : super.getRageType(stack, living);
    }

    @Override
    public float getMaxRage(ItemStack stack, EntityLivingBase living) {
        return TF2Attribute.getModifier("Rage Crit", stack, 0.0f, null) == 1.0f ? 20.0f : super.getMaxRage(stack, living);
    }

    @Override
    public void onDealDamage(ItemStack stack, EntityLivingBase attacker, Entity target, DamageSource source, float amount) {
        super.onDealDamage(stack, attacker, target, source, amount);
        if (target instanceof EntityLivingBase && TF2Attribute.getModifier("Rage Crit", stack, 0.0f, attacker) != 0.0f && !WeaponsCapability.get((Entity)attacker).isRageActive(WeaponsCapability.RageType.PHLOG)) {
            float mult = 1.0f;
            if (attacker instanceof EntityPlayer) {
                mult = target instanceof EntityPlayer ? 1.0f : (TF2Util.isEnemy(attacker, (EntityLivingBase)target) ? 0.4f : 0.1f);
            } else if (target instanceof EntityPlayer) {
                mult = 4.0f;
            }
            this.addRage(stack, attacker, amount * mult);
        }
    }

    @Override
    public void func_77663_a(ItemStack stack, World par2World, Entity par3Entity, int par4, boolean par5) {
        super.func_77663_a(stack, par2World, par3Entity, par4, par5);
        if (WeaponsCapability.get(par3Entity).isRageActive(WeaponsCapability.RageType.PHLOG) && par5 && par3Entity.field_70173_aa % 5 == 0) {
            ((EntityLivingBase)par3Entity).func_70690_d(new PotionEffect(TF2weapons.critBoost, 5));
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        return stack;
    }

    @Override
    public boolean showInfoBox(ItemStack stack, EntityPlayer player) {
        return super.showInfoBox(stack, player) || TF2Attribute.getModifier("Rage Crit", stack, 0.0f, (EntityLivingBase)player) != 0.0f;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    @Override
    public void altUse(ItemStack stack, EntityLivingBase living, World world) {
        if (TF2Attribute.getModifier("Rage Crit", stack, 0.0f, living) != 0.0f && this.getRage(stack, living) >= this.getMaxRage(stack, living)) {
            living.func_184598_c(EnumHand.MAIN_HAND);
            living.func_70690_d(new PotionEffect(TF2weapons.stun, 40, 1));
            TF2Util.addAndSendEffect(living, new PotionEffect(TF2weapons.uber, 40, 0));
            living.func_70690_d(new PotionEffect(TF2weapons.noKnockback, 40, 0));
            living.func_184185_a(ItemFromData.getSound(stack, PropertyType.CHARGE_SOUND), 1.0f, 1.0f);
            WeaponsCapability.get((Entity)living).setRageActive(WeaponsCapability.RageType.PHLOG, true, 2.0f);
        } else {
            super.altUse(stack, living, world);
        }
    }
}

