/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.item.ItemAmmo;
import rafradek.TF2weapons.util.TF2Util;

public class ItemFireAmmo
extends ItemAmmo {
    public int uses;
    int type;

    public ItemFireAmmo(int type, int uses, int maxStack) {
        this.type = type;
        this.uses = uses;
        this.func_77625_d(maxStack);
        this.func_77627_a(false);
    }

    @Override
    public int getTypeInt(ItemStack stack) {
        return this.type;
    }

    @Override
    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        if (!this.func_194125_a(par2CreativeTabs)) {
            return;
        }
        par3List.add((Object)new ItemStack((Item)this));
    }

    public int getMaxDamage(ItemStack stack) {
        return this.uses - 1;
    }

    @Override
    public int getItemStackLimit(ItemStack stack) {
        return this.func_77639_j();
    }

    public int restoreAmmo(ItemStack stack, int amount) {
        if (amount > 0 && stack.func_190916_E() == 1) {
            int itemDamage = stack.func_77952_i();
            stack.func_77964_b(Math.max(0, itemDamage - amount));
            return Math.min(itemDamage, amount);
        }
        return 0;
    }

    @Override
    public int consumeAmmo(EntityLivingBase living, ItemStack stack, int amount) {
        if (stack == STACK_FILL) {
            return 0;
        }
        if (amount > 0) {
            int left = Math.max(0, amount - this.getAmount(stack));
            if (stack.func_190916_E() > 1) {
                ItemStack remain = stack.func_77979_a(1);
                remain.func_77972_a(amount, living);
                if (living instanceof EntityPlayer) {
                    remain = TF2Util.pickAmmo(remain, (EntityPlayer)living, true);
                }
                if (!remain.func_190926_b()) {
                    living.func_70099_a(remain, 0.0f).func_174867_a(0);
                }
            } else {
                stack.func_77964_b(stack.func_77952_i() + amount);
                if (stack.func_77952_i() > stack.func_77958_k()) {
                    stack.func_190918_g(1);
                }
            }
            return left;
        }
        return 0;
    }

    @Override
    public int getAmount(ItemStack stack) {
        return (this.uses - stack.func_77952_i()) * stack.func_190916_E();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        if (this.getTypeInt(stack) == 10 && TF2weapons.refinedFuel != null) {
            Provider cap = new Provider(stack, 3, TF2weapons.refinedFuel);
            return cap;
        }
        return null;
    }

    public static class Provider
    implements ICapabilityProvider,
    IFluidHandlerItem {
        FluidTankProperties prop;
        ItemStack stack;
        int mult;
        Fluid fluid;

        public Provider(ItemStack stack, int mult, Fluid fluid) {
            this.stack = stack;
            this.mult = mult;
            this.fluid = fluid;
        }

        public IFluidTankProperties[] getTankProperties() {
            if (this.stack.func_190926_b()) {
                return new IFluidTankProperties[0];
            }
            return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(this.fluid, ((ItemFireAmmo)this.stack.func_77973_b()).getAmount(this.stack) * this.mult), ((ItemFireAmmo)this.stack.func_77973_b()).uses * this.mult)};
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.stack.func_190926_b()) {
                return 0;
            }
            if (resource.getFluid() != this.fluid) {
                return resource.amount;
            }
            int resourceUsed = Math.max(((ItemFireAmmo)this.stack.func_77973_b()).uses - ((ItemFireAmmo)this.stack.func_77973_b()).getAmount(this.stack), resource.amount / this.mult) * this.mult;
            if (doFill) {
                this.stack.func_77964_b(this.stack.func_77952_i() - resourceUsed / this.mult);
            }
            return resourceUsed;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (this.stack.func_190926_b()) {
                return null;
            }
            if (resource.getFluid() != this.fluid) {
                return null;
            }
            int resourceUsed = Math.min(((ItemFireAmmo)this.stack.func_77973_b()).getAmount(this.stack), resource.amount / this.mult) * this.mult;
            if (doDrain) {
                this.stack.func_77964_b(this.stack.func_77952_i() + resourceUsed / this.mult);
                if (this.stack.func_77952_i() > this.stack.func_77958_k()) {
                    this.stack.func_190918_g(1);
                }
            }
            return new FluidStack(this.fluid, resourceUsed);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.drain(new FluidStack(this.fluid, maxDrain), doDrain);
        }

        public ItemStack getContainer() {
            return this.stack;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null);
        }
    }
}

