/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import com.google.common.base.Predicate;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;
import rafradek.TF2weapons.util.WeaponData;

public abstract class ItemFabricator
extends Item {
    public abstract NonNullList<TF2Ingredient> getInput(ItemStack var1, EntityPlayer var2);

    public abstract NonNullList<ItemStack> getOutput(ItemStack var1, EntityPlayer var2);

    @SideOnly(value=Side.CLIENT)
    public List<String> getOutputNames(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        for (ItemStack output : this.getOutput(stack, null)) {
            list.add(output.func_190916_E() + "x " + I18n.func_135052_a((String)(output.func_77977_a() + ".name"), (Object[])new Object[0]));
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getInputNames(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        for (TF2Ingredient input : this.getInput(stack, null)) {
            list.add(input.getCount() + "x " + input.getName());
        }
        return list;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add("When used, this item will produce");
        tooltip.addAll(this.getOutputNames(stack));
        tooltip.add("");
        tooltip.add("After consuming those items from inventory");
        tooltip.addAll(this.getInputNames(stack));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer living, EnumHand hand) {
        if (!world.field_72995_K) {
            ItemStack stack = living.func_184586_b(hand);
            IItemHandler handler = (IItemHandler)living.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (TF2Ingredient input : this.getInput(stack, living)) {
                if (TF2Util.hasEnoughItem(handler, (Predicate<ItemStack>)input, input.getCount())) continue;
                return new ActionResult(EnumActionResult.FAIL, (Object)living.func_184586_b(hand));
            }
            for (TF2Ingredient input : this.getInput(stack, living)) {
                TF2Util.removeItemsMatching(handler, input.getCount(), input);
            }
            for (ItemStack out : this.getOutput(stack, living)) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)living, (ItemStack)out);
            }
            stack.func_190918_g(1);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)living.func_184586_b(hand));
    }

    public static class IngredientPredicate
    extends TF2Ingredient {
        public Predicate<ItemStack> test;
        public int count;
        public String name;

        public IngredientPredicate(Predicate<ItemStack> test, int count, String name) {
            this.test = test;
            this.name = name;
            this.count = count;
        }

        public boolean apply(ItemStack input) {
            return this.test.apply((Object)input);
        }

        @Override
        public String getName() {
            return I18n.func_135052_a((String)this.name, (Object[])new Object[0]);
        }

        @Override
        public int getCount() {
            return this.count;
        }
    }

    public static class IngredientItemStack
    extends TF2Ingredient {
        public ItemStack test;

        public IngredientItemStack(ItemStack test) {
            this.test = test;
        }

        public boolean apply(ItemStack input) {
            return ItemHandlerHelper.canItemStacksStack((ItemStack)input, (ItemStack)this.test);
        }

        @Override
        public String getName() {
            return I18n.func_135052_a((String)(this.test.func_77977_a() + ".name"), (Object[])new Object[0]);
        }

        @Override
        public int getCount() {
            return this.test.func_190916_E();
        }
    }

    public static abstract class TF2Ingredient
    implements Predicate<ItemStack> {
        public abstract String getName();

        public abstract int getCount();
    }

    public static class ItemList {
        public HashMap<String, Integer> items = new HashMap();
    }

    public static class PropertyItemList
    extends PropertyType<ItemList> {
        public PropertyItemList(int id, String name, Class<ItemList> type) {
            super(id, name, type);
        }

        @Override
        public ItemList deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ItemList content = new ItemList();
            for (Map.Entry attribute : json.getAsJsonObject().entrySet()) {
                String itemName = (String)attribute.getKey();
                int chance = ((JsonElement)attribute.getValue()).getAsInt();
                content.items.put(itemName, chance);
            }
            return content;
        }

        @Override
        public void serialize(DataOutput buf, WeaponData data, ItemList value) throws IOException {
            buf.writeByte(value.items.size());
            for (Map.Entry<String, Integer> entry : value.items.entrySet()) {
                buf.writeUTF(entry.getKey());
                buf.writeShort(entry.getValue());
            }
        }

        @Override
        public ItemList deserialize(DataInput buf, WeaponData data) throws IOException {
            int attributeCount = buf.readByte();
            ItemList content = new ItemList();
            for (int i = 0; i < attributeCount; ++i) {
                String entry = buf.readUTF();
                short value = buf.readShort();
                content.items.put(entry, Integer.valueOf(value));
            }
            return content;
        }
    }
}

