/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemWearable;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.WeaponData;

public class ItemCrate
extends ItemFromData {
    public ItemCrate() {
        this.func_77625_d(64);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (!worldIn.field_72995_K && !itemStackIn.func_77978_p().func_74767_n("Open") && playerIn.field_71071_by.func_70431_c(new ItemStack(TF2weapons.itemTF2, 1, 7))) {
            itemStackIn.func_77978_p().func_74757_a("Open", true);
            playerIn.field_71071_by.func_174925_a(TF2weapons.itemTF2, 7, 1, null);
        }
        if (!worldIn.field_72995_K && itemStackIn.func_77978_p().func_74767_n("Open")) {
            ItemStack stack = ItemStack.field_190927_a;
            if (playerIn.func_70681_au().nextInt(32) == 0) {
                stack = ItemFromData.getRandomWeaponOfClass("cosmetic", playerIn.func_70681_au(), false);
                ((ItemWearable)stack.func_77973_b()).applyRandomEffect(stack, playerIn.func_70681_au());
            } else {
                int choosen = playerIn.func_70681_au().nextInt(ItemCrate.getData((ItemStack)itemStackIn).get(PropertyType.CONTENT).maxCrateValue);
                int currVal = 0;
                for (Map.Entry<String, Integer> entry : ItemCrate.getData((ItemStack)itemStackIn).get(PropertyType.CONTENT).content.entrySet()) {
                    if (choosen >= (currVal += entry.getValue().intValue())) continue;
                    stack = ItemFromData.getNewStack(entry.getKey());
                    break;
                }
            }
            if (!(stack.func_77973_b() instanceof ItemWearable)) {
                stack.func_77978_p().func_74757_a("Strange", true);
            }
            if (!playerIn.field_71071_by.func_70441_a(stack)) {
                playerIn.func_71019_a(stack, true);
            }
            playerIn.func_71029_a(TF2weapons.cratesOpened);
            itemStackIn.func_190918_g(1);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77942_o()) {
            super.func_77624_a(stack, world, tooltip, advanced);
            if (stack.func_77978_p().func_74767_n("Open")) {
                tooltip.add("The crate is opened now");
                tooltip.add("Right click to get the item");
            }
            tooltip.add("Possible content:");
            for (String name : ItemCrate.getData((ItemStack)stack).get(PropertyType.CONTENT).content.keySet()) {
                WeaponData data = MapList.nameToData.get(name);
                if (data == null) continue;
                tooltip.add(I18n.func_135052_a((String)("weapon." + data.getName()), (Object[])new Object[0]));
            }
        }
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return 2400;
    }

    public static class CrateContent {
        public HashMap<String, Integer> content = new HashMap();
        public int maxCrateValue;
    }

    public static class PropertyContent
    extends PropertyType<CrateContent> {
        public PropertyContent(int id, String name, Class<CrateContent> type) {
            super(id, name, type);
        }

        @Override
        public CrateContent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            CrateContent content = new CrateContent();
            HashMap map = new HashMap();
            for (Map.Entry attribute : json.getAsJsonObject().entrySet()) {
                String itemName = (String)attribute.getKey();
                int chance = ((JsonElement)attribute.getValue()).getAsInt();
                content.content.put(itemName, chance);
                content.maxCrateValue += chance;
            }
            return content;
        }

        @Override
        public void serialize(DataOutput buf, WeaponData data, CrateContent value) throws IOException {
            buf.writeByte(value.content.size());
            for (Map.Entry<String, Integer> entry : value.content.entrySet()) {
                buf.writeUTF(entry.getKey());
                buf.writeShort(entry.getValue());
            }
        }

        @Override
        public CrateContent deserialize(DataInput buf, WeaponData data) throws IOException {
            int attributeCount = buf.readByte();
            CrateContent content = new CrateContent();
            for (int i = 0; i < attributeCount; ++i) {
                String entry = buf.readUTF();
                short value = buf.readShort();
                content.content.put(entry, Integer.valueOf(value));
                content.maxCrateValue += value;
            }
            return content;
        }
    }
}

