/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import rafradek.TF2weapons.TF2EventsCommon;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.mercenary.EntitySpy;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemToken;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.ReflectionAccess;

public class ItemCloak
extends ItemFromData {
    public ItemCloak() {
        this.func_185043_a(new ResourceLocation("active"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn != null && ItemCloak.this.isFeignDeath(stack, entityIn) && WeaponsCapability.get((Entity)entityIn).isFeign()) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    @Override
    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        super.func_77663_a(par1ItemStack, par2World, par3Entity, par4, par5);
        if (par1ItemStack.func_77978_p().func_74767_n("Active") && WeaponsCapability.get(par3Entity).isInvisible()) {
            int maxdamage = this.getMaxDamage(par1ItemStack);
            if (!(par3Entity instanceof EntityPlayer && ((EntityPlayer)par3Entity).field_71075_bZ.field_75098_d || par3Entity instanceof EntityTF2Character && ((EntityTF2Character)par3Entity).isRobot())) {
                par1ItemStack.func_77964_b(Math.min(maxdamage, par1ItemStack.func_77952_i() + 3));
                if (par5 || par1ItemStack == ((EntityLivingBase)par3Entity).func_184592_cb()) {
                    try {
                        ((ItemStack)((NonNullList)ReflectionAccess.entityHandInv.get(par3Entity)).get(par5 ? 0 : 1)).func_77964_b(par1ItemStack.func_77952_i());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (par1ItemStack.func_77978_p().func_74767_n("Strange") && par3Entity.field_70173_aa % 20 == 0) {
                TF2EventsCommon.onStrangeUpdate(par1ItemStack, (EntityLivingBase)par3Entity);
            }
            if (par1ItemStack.func_77952_i() >= maxdamage) {
                par1ItemStack.func_77964_b(maxdamage);
                this.setCloak(false, par1ItemStack, (EntityLivingBase)par3Entity, par2World);
            }
        } else if (par1ItemStack.func_77978_p().func_74767_n("Active") && !WeaponsCapability.get(par3Entity).isInvisible()) {
            par1ItemStack.func_77978_p().func_74757_a("Active", false);
        } else if (par3Entity.field_70173_aa % 2 == 0) {
            par1ItemStack.func_77964_b(Math.max(par1ItemStack.func_77952_i() - (int)TF2Attribute.getModifier("Effect Duration", par1ItemStack, TF2Attribute.getModifier("Charge", par1ItemStack, 2.0f, null), null), 0));
            if (par5 || par1ItemStack == ((EntityLivingBase)par3Entity).func_184592_cb()) {
                try {
                    ((ItemStack)((NonNullList)ReflectionAccess.entityHandInv.get(par3Entity)).get(par5 ? 0 : 1)).func_77964_b(par1ItemStack.func_77952_i());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return (int)TF2Attribute.getModifier("Effect Duration", stack, 600.0f, null);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer living, EnumHand hand) {
        ItemStack stack = living.func_184586_b(hand);
        if (ItemToken.allowUse((EntityLivingBase)living, "spy")) {
            if (living.func_82150_aj() || !this.isFeignDeath(stack, (EntityLivingBase)living) && stack.func_77952_i() < this.getMaxDamage(stack) - 72) {
                this.setCloak(!WeaponsCapability.get((Entity)living).isInvisible(), stack, (EntityLivingBase)living, world);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (!living.func_82150_aj() && this.isFeignDeath(stack, (EntityLivingBase)living) && stack.func_77952_i() == 0) {
                WeaponsCapability.get((Entity)living).setFeign(!WeaponsCapability.get((Entity)living).isFeign());
                if (WeaponsCapability.get((Entity)living).isFeign()) {
                    living.func_184185_a(ItemCloak.getSound(stack, PropertyType.CHARGE_SOUND), 1.0f, 1.0f);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public boolean isFeignDeath(ItemStack stack, EntityLivingBase living) {
        return TF2Attribute.getModifier("Weapon Mode", stack, 0.0f, living) == 1.0f;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        if (item.func_77978_p().func_74767_n("Active")) {
            this.setCloak(false, item, (EntityLivingBase)player, player.field_70170_p);
        }
        return super.onDroppedByPlayer(item, player);
    }

    public static Tuple<Integer, ItemStack> searchForWatches(EntityLivingBase living) {
        if (living instanceof EntitySpy) {
            return new Tuple((Object)3, (Object)((EntitySpy)living).loadout.getStackInSlot(3));
        }
        if (living instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)living;
            if (!player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof ItemCloak && player.func_184592_cb().func_77978_p().func_74767_n("Active")) {
                return new Tuple((Object)40, (Object)player.func_184592_cb());
            }
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemCloak) || !stack.func_77978_p().func_74767_n("Active")) continue;
                return new Tuple((Object)i, (Object)stack);
            }
        }
        return new Tuple((Object)-1, (Object)ItemStack.field_190927_a);
    }

    public static ItemStack getFeignDeathWatch(EntityLivingBase living) {
        ItemStack stack = living.func_184614_ca();
        if (stack.func_77973_b() instanceof ItemCloak && ((ItemCloak)stack.func_77973_b()).isFeignDeath(stack, living) && stack.func_77952_i() == 0) {
            return stack;
        }
        stack = living.func_184592_cb();
        if (stack.func_77973_b() instanceof ItemCloak && ((ItemCloak)stack.func_77973_b()).isFeignDeath(stack, living) && stack.func_77952_i() == 0) {
            return stack;
        }
        IItemHandler items = (IItemHandler)living.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < items.getSlots(); ++i) {
            stack = items.getStackInSlot(i);
            if (!(stack.func_77973_b() instanceof ItemCloak) || !((ItemCloak)stack.func_77973_b()).isFeignDeath(stack, living) || stack.func_77952_i() != 0) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void setCloak(boolean active, ItemStack stack, EntityLivingBase living, World world) {
        if (!active || !(living instanceof EntityPlayer) || ((ItemStack)ItemCloak.searchForWatches(living).func_76340_b()).func_190926_b()) {
            if (!active) {
                living.func_82142_c(false);
                ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).invisTicks = 20;
            }
            stack.func_77978_p().func_74757_a("Active", active);
            WeaponsCapability.get((Entity)living).setInvisible(active);
            if (active) {
                living.func_184185_a(ItemFromData.getSound(stack, PropertyType.CLOAK_SOUND), 1.5f, 1.0f);
                stack.func_77964_b(Math.min(this.getMaxDamage(stack), stack.func_77952_i() + this.getMaxDamage(stack) - (int)TF2Attribute.getModifier("Cloak Drain", stack, this.getMaxDamage(stack), living)));
            } else {
                living.func_184185_a(ItemFromData.getSound(stack, PropertyType.DECLOAK_SOUND), 1.5f, 1.0f);
                if (this.isFeignDeath(stack, living)) {
                    living.func_174810_b(false);
                }
            }
            if (!world.field_72995_K) {
                // empty if block
            }
        }
    }

    public static void setInvisiblity(EntityLivingBase living) {
        boolean cloaked = ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).invisTicks >= 20;
        boolean disguised = WeaponsCapability.get((Entity)living).isDisguised();
        living.func_82142_c(cloaked || disguised && ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).invisTicks == 0 && !WeaponsCapability.get((Entity)living).isInvisible());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        tooltip.add("Charge: " + (100 - (int)(100.0f * ((float)stack.func_77952_i() / (float)this.getMaxDamage(stack)))) + "%");
    }

    @Override
    public boolean showInfoBox(ItemStack stack, EntityPlayer player) {
        return true;
    }

    @Override
    public String[] getInfoBoxLines(ItemStack stack, EntityPlayer player) {
        return new String[]{"CLOAK", 100 - (int)(100.0f * ((float)stack.func_77952_i() / (float)this.getMaxDamage(stack))) + "%"};
    }
}

