/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.projectile.EntityFlame;
import rafradek.TF2weapons.entity.projectile.EntityProjectileBase;
import rafradek.TF2weapons.item.ItemMeleeWeapon;
import rafradek.TF2weapons.item.ItemProjectileWeapon;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2DamageSource;
import rafradek.TF2weapons.util.TF2Util;

public class ItemBulletWeapon
extends ItemWeapon {
    public static ThreadLocal<HashMap<Entity, float[]>> lastShot = new ThreadLocal<HashMap<Entity, float[]>>(){

        @Override
        protected HashMap<Entity, float[]> initialValue() {
            return new HashMap<Entity, float[]>();
        }
    };
    public static ThreadLocal<Integer> lastFlags = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    public static ArrayList<RayTraceResult> lastShotClient = new ArrayList();
    public static boolean processShotServer;

    public void handleShoot(EntityLivingBase living, ItemStack stack, World world, HashMap<Entity, float[]> map, int critical, int flags) {
        Iterator<Entity> iterator = map.keySet().iterator();
        boolean damageDone = false;
        while (iterator.hasNext()) {
            DamageSource var22 = TF2Util.causeDirectDamage(stack, (Entity)living, critical);
            ((TF2DamageSource)var22).addAttackFlag(flags);
            if (!(this instanceof ItemMeleeWeapon)) {
                var22.func_76349_b();
            }
            Entity entity = iterator.next();
            ((TF2DamageSource)var22).setAttackPower(map.get(entity)[0]);
            if (!((ItemWeapon)stack.func_77973_b()).onHit(stack, living, entity, map.get(entity)[1], critical, false)) continue;
            Vec3d pushvec = entity.func_174791_d().func_178788_d(living.func_174791_d()).func_72432_b();
            if (map.get(entity) == null || map.get(entity)[1] == 0.0f || !TF2Util.dealDamage(entity, world, living, stack, critical, map.get(entity)[1], var22)) continue;
            damageDone = true;
            if (stack.func_190926_b()) continue;
            double knockbackAmount = ((ItemBulletWeapon)stack.func_77973_b()).getKnockbackForDamage(stack, living, map.get(entity)[1], var22);
            if (entity instanceof EntityLivingBase) {
                knockbackAmount *= 1.0 - ((EntityLivingBase)entity).func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
            }
            if (!(knockbackAmount > 0.0)) continue;
            boolean flag = (double)map.get(entity)[1] >= 3.75 && ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).fanCool <= 0 && TF2Attribute.getModifier("KnockbackFAN", stack, 0.0f, living) != 0.0f;
            pushvec = new Vec3d(pushvec.field_72450_a * knockbackAmount * (flag ? 2.8 : 1.0), (pushvec.field_72448_b + (double)(flag ? 1 : 0)) * knockbackAmount, pushvec.field_72449_c * knockbackAmount * (flag ? 2.8 : 1.0));
            entity.func_70024_g(pushvec.field_72450_a, pushvec.field_72448_b, pushvec.field_72449_c);
            boolean bl = entity.field_70160_al = entity.field_70160_al || -(pushvec.field_72448_b * knockbackAmount) > 0.02;
            if (!(entity instanceof EntityPlayerMP)) continue;
            TF2weapons.network.sendTo(new TF2Message.VelocityAddMessage(pushvec, entity.field_70160_al), (EntityPlayerMP)entity);
        }
        if (damageDone && living.hasCapability(TF2weapons.WEAPONS_CAP, null)) {
            ++WeaponsCapability.get((Entity)living).hitNoMiss;
            if ((float)WeaponsCapability.get((Entity)living).hitNoMiss >= TF2Attribute.getModifier("Hit Crit", stack, 0.0f, living)) {
                WeaponsCapability.get((Entity)living).hitNoMiss = 0;
            }
        }
        map.clear();
    }

    @Override
    public boolean use(ItemStack stack, EntityLivingBase living, World world, EnumHand hand, TF2Message.PredictionMessage message) {
        if (world.field_72995_K && living == ClientProxy.getLocalPlayer()) {
            lastShotClient.clear();
        }
        super.use(stack, living, world, hand, message);
        if (world.field_72995_K && living == ClientProxy.getLocalPlayer()) {
            ((WeaponsCapability)ClientProxy.getLocalPlayer().getCapability(TF2weapons.WEAPONS_CAP, null)).recoil += ItemBulletWeapon.getData(stack).getFloat(PropertyType.RECOIL);
            message.target = lastShotClient;
        } else if (!world.field_72995_K) {
            if (TF2Attribute.getModifier("Onyx Projectile", stack, 0.0f, living) != 0.0f) {
                new ItemProjectileWeapon().shoot(stack, living, world, critical, hand);
            }
            if (living instanceof EntityPlayer) {
                if (message.readData == null) {
                    WeaponsCapability.get((Entity)living).hitNoMiss = 0;
                    return false;
                }
                int flags = 0;
                int totalCrit = TF2Util.calculateCritPre(stack, living);
                HashMap<Entity, float[]> shotInfo = new HashMap<Entity, float[]>();
                for (RayTraceResult obj : message.target) {
                    Entity target = obj.field_72308_g;
                    if (target == null) continue;
                    if (!shotInfo.containsKey(target) || shotInfo.get(target) == null) {
                        shotInfo.put(target, new float[3]);
                    }
                    int critical = totalCrit;
                    if (((float[])obj.hitInfo)[0] != 0.0f && critical != 2) {
                        critical = this.getHeadshotCrit(living, stack);
                        flags |= 2;
                    }
                    if ((critical = this.setCritical(stack, living, target, critical)) > totalCrit) {
                        totalCrit = critical;
                    }
                    float[] values = shotInfo.get(target);
                    values[0] = values[0] + 1.0f;
                    values[1] = values[1] + TF2Util.calculateDamage(target, world, living, stack, critical, ((float[])obj.hitInfo)[1]);
                }
                this.handleShoot(living, stack, world, shotInfo, totalCrit, flags);
            } else {
                this.handleShoot(living, stack, world, lastShot.get(), critical, lastFlags.get());
                lastShot.get().clear();
            }
        }
        if (((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).fanCool <= 0 && TF2Attribute.getModifier("KnockbackFAN", stack, 0.0f, living) != 0.0f) {
            ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).fanCool = 30;
        }
        return true;
    }

    public boolean showTracer(ItemStack stack) {
        return true;
    }

    public boolean showSpecialTracer(ItemStack stack) {
        return TF2Attribute.getModifier("Trace Round", stack, 0.0f, null) != 0.0f;
    }

    @Override
    public void shoot(ItemStack stack, EntityLivingBase living, World world, int critical, EnumHand hand) {
        boolean removeBlocks;
        if (ItemBulletWeapon.getData(stack).hasProperty(PropertyType.PROJECTILE) && TF2Attribute.getModifier("Onyx Projectile", stack, 0.0f, living) == 0.0f) {
            if (!world.field_72995_K) {
                new ItemProjectileWeapon().shoot(stack, living, world, critical, hand);
            }
            return;
        }
        boolean bl = removeBlocks = TF2Attribute.getModifier("Destroy Block", stack, 0.0f, living) > 0.0f;
        if (!world.field_72995_K && living instanceof EntityPlayer && !removeBlocks) {
            return;
        }
        double startX = 0.0;
        double startY = 0.0;
        double startZ = 0.0;
        double endX = 0.0;
        double endY = 0.0;
        double endZ = 0.0;
        float spreadPitch = living.field_70125_A / 180.0f * (float)Math.PI;
        float spreadYaw = living.field_70759_as / 180.0f * (float)Math.PI;
        Vec3d rand = TF2Util.radiusRandom2D(this.getWeaponSpread(stack, living), world.field_73012_v, -spreadYaw, -spreadPitch, this.getMaxRange(stack));
        startX = living.field_70165_t;
        startY = living.field_70163_u + (double)living.func_70047_e();
        startZ = living.field_70161_v;
        endX = 0.0;
        endY = 0.0;
        endZ = 0.0;
        endX += rand.field_72450_a;
        endY += rand.field_72448_b;
        endZ += rand.field_72449_c;
        endX += startX;
        endY += startY;
        endZ += startZ;
        if (world.field_72995_K) {
            if (this.showTracer(stack)) {
                float mult = hand == EnumHand.MAIN_HAND ? 1.0f : -1.0f;
                ClientProxy.spawnBulletParticle(world, living, startX - (double)(MathHelper.func_76134_b((float)(living.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f * mult), startY - 0.1, startZ - (double)(MathHelper.func_76126_a((float)(living.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f * mult), endX, endY, endZ, this.showSpecialTracer(stack) ? 0 : 13, this.showSpecialTracer(stack) ? 2 : critical, 0, this.showSpecialTracer(stack) ? 50.0f : 1.0f);
            }
            if (living != Minecraft.func_71410_x().field_71439_g) {
                return;
            }
        }
        List<RayTraceResult> list = TF2Util.pierce(world, (Entity)living, startX, startY, startZ, endX, endY, endZ, this.canHeadshot(living, stack), this.getBulletSize(stack, living), this.canPenetrate(stack, living), TF2Attribute.getModifier("Destroy Projectiles", stack, 0.0f, living) == 0.0f ? TF2Util.TARGETABLE : Predicates.or(target -> target instanceof EntityProjectileBase && !(target instanceof EntityFlame), TF2Util.TARGETABLE));
        for (RayTraceResult var4 : list) {
            if (var4.field_72308_g != null) {
                float distance = 0.0f;
                if (living != null) {
                    distance = (float)TF2Util.getDistanceBox((Entity)living, var4.field_72308_g.field_70165_t, var4.field_72308_g.field_70163_u, var4.field_72308_g.field_70161_v, var4.field_72308_g.field_70130_N, var4.field_72308_g.field_70131_O);
                }
                if (!world.field_72995_K && !(living instanceof EntityPlayer)) {
                    if (!lastShot.get().containsKey(var4.field_72308_g) || lastShot.get().get(var4.field_72308_g) == null) {
                        lastShot.get().put(var4.field_72308_g, new float[3]);
                    }
                    if (var4.hitInfo != null && var4.hitInfo instanceof Boolean && ((Boolean)var4.hitInfo).booleanValue() && critical != 2) {
                        critical = this.getHeadshotCrit(living, stack);
                        lastFlags.set(lastFlags.get() | 2);
                    }
                    ItemWeapon.critical = critical = this.setCritical(stack, living, var4.field_72308_g, critical);
                    float[] values = lastShot.get().get(var4.field_72308_g);
                    values[0] = values[0] + 1.0f;
                    values[1] = values[1] + TF2Util.calculateDamage(var4.field_72308_g, world, living, stack, critical, distance);
                    continue;
                }
                if (!world.field_72995_K) continue;
                var4.hitInfo = new float[]{var4.hitInfo != null && var4.hitInfo instanceof Boolean && (Boolean)var4.hitInfo != false ? 1.0f : 0.0f, distance};
                lastShotClient.add(var4);
                continue;
            }
            if (var4.func_178782_a() == null) continue;
            if (world.field_72995_K) {
                ClientProxy.spawnBulletHoleParticle(world, var4);
                for (int i = 0; i < 2; ++i) {
                    world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, var4.field_72307_f.field_72450_a + (double)var4.field_178784_b.func_82601_c() * 0.05, var4.field_72307_f.field_72448_b + (double)var4.field_178784_b.func_96559_d() * 0.05, var4.field_72307_f.field_72449_c + (double)var4.field_178784_b.func_82599_e() * 0.05, (double)var4.field_178784_b.func_82601_c() * 0.07 * (double)i, (double)var4.field_178784_b.func_96559_d() * 0.07 * (double)i, (double)var4.field_178784_b.func_82599_e() * 0.07 * (double)i, new int[]{Block.func_176210_f((IBlockState)world.func_180495_p(var4.func_178782_a()))});
                }
                if (!ItemBulletWeapon.getData(stack).hasProperty(PropertyType.HIT_SOUND)) continue;
                SoundEvent event = ItemBulletWeapon.getData(stack).hasProperty(PropertyType.HIT_WORLD_SOUND) ? ItemBulletWeapon.getSound(stack, PropertyType.HIT_WORLD_SOUND) : ItemBulletWeapon.getSound(stack, PropertyType.HIT_SOUND);
                world.func_184134_a(var4.field_72307_f.field_72450_a, var4.field_72307_f.field_72448_b, var4.field_72307_f.field_72449_c, event, SoundCategory.PLAYERS, ItemBulletWeapon.getData(stack).getName().equals("fryingpan") ? 2.0f : 0.7f, 1.0f, false);
                continue;
            }
            if (world.field_72995_K) continue;
            if (TF2Attribute.getModifier("Explode Bullet", stack, 0.0f, living) != 0.0f) {
                TF2Util.explosion(world, living, stack, (Entity)living, null, var4.field_72307_f.field_72450_a + (double)var4.field_178784_b.func_82601_c() * 0.05, var4.field_72307_f.field_72448_b + (double)var4.field_178784_b.func_96559_d() * 0.05, var4.field_72307_f.field_72449_c + (double)var4.field_178784_b.func_82599_e() * 0.05, TF2Attribute.getModifier("Explode Bullet", stack, 0.0f, living), 1.0f, critical, (float)living.func_174791_d().func_72438_d(var4.field_72307_f));
                continue;
            }
            if (!removeBlocks) continue;
            float damage = TF2Util.calculateDamage((Entity)TF2weapons.dummyEnt, world, living, stack, critical, (float)living.func_174791_d().func_72438_d(var4.field_72307_f));
            TF2Util.damageBlock(var4.func_178782_a(), living, world, stack, critical, damage *= TF2Attribute.getModifier("Destroy Block", stack, 0.0f, living), new Vec3d(endX, endY, endZ), null);
        }
    }

    public float[] calculateRatioX(float yaw, float pitch) {
        float[] result = new float[3];
        float angledYaw = Math.abs(MathHelper.func_76142_g((float)yaw));
        float distanceYaw = Math.max(angledYaw, 90.0f) - Math.min(angledYaw, 90.0f);
        result[0] = distanceYaw / 90.0f + (1.0f - distanceYaw / 90.0f) * (-pitch / 90.0f);
        result[2] = 1.0f - distanceYaw / 90.0f;
        result[1] = 0.0f;
        return result;
    }

    public float[] calculateRatioY(float yaw, float pitch) {
        float[] result = new float[3];
        float angledYaw = Math.abs(MathHelper.func_76142_g((float)yaw));
        float distanceYaw = Math.max(angledYaw, 90.0f) - Math.min(angledYaw, 90.0f);
        result[0] = 0.0f;
        result[2] = distanceYaw / 90.0f * (-pitch / 90.0f);
        result[1] = 1.0f - Math.abs(pitch) / 90.0f;
        return result;
    }

    public float getMaxRange(ItemStack stack) {
        return 256.0f;
    }

    public float getBulletSize(ItemStack stack, EntityLivingBase living) {
        return 0.04f / (float)this.getWeaponPelletCount(stack, living);
    }

    public int setCritical(ItemStack stack, EntityLivingBase shooter, Entity target, int old) {
        return TF2Util.calculateCritPost(target, shooter, old, stack);
    }
}

