/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.pattern.BlockMaterialMatcher;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.entity.boss.EntityHHH;
import rafradek.TF2weapons.entity.boss.EntityMerasmus;
import rafradek.TF2weapons.entity.boss.EntityMonoculus;
import rafradek.TF2weapons.entity.boss.EntityTF2Boss;

public class ItemBossSpawner
extends Item {
    public static final String[] NAMES = new String[]{"hhh", "monoculus", "merasmus"};
    public static BlockPattern patternHHH = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"NAN", "BCB", "NBN"}).func_177662_a('A', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150428_aP))).func_177662_a('C', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150343_Z))).func_177662_a('B', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150407_cf))).func_177662_a('N', BlockWorldState.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();

    public ItemBossSpawner() {
        this.func_77627_a(true);
    }

    public String func_77667_c(ItemStack stack) {
        return "item." + NAMES[stack.func_77960_j() % NAMES.length];
    }

    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        if (!this.func_194125_a(par2CreativeTabs)) {
            return;
        }
        for (int i = 0; i < NAMES.length; ++i) {
            par3List.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)("item." + NAMES[stack.func_77960_j() % NAMES.length] + ".desc"), (Object[])new Object[0]));
    }

    /*
     * Enabled aggressive block sorting
     */
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || TF2ConfigVars.disableBossSpawnItems) {
            return EnumActionResult.SUCCESS;
        }
        EntityTF2Boss boss = null;
        long time = world.func_72820_D();
        ItemStack stack = player.func_184586_b(hand);
        TF2PlayerCapability cap = TF2PlayerCapability.get(player);
        if (time % 24000L < 13500L || time % 24000L > 21500L) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("gui.boss.night", new Object[0]));
            return EnumActionResult.SUCCESS;
        }
        if (stack.func_77952_i() == 0 && (long)cap.hhhSummonedDay < time / 24000L) {
            BlockPattern.PatternHelper pattern = patternHHH.func_177681_a(world, pos);
            if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150427_aO) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("gui.boss.portal", new Object[0]));
                return EnumActionResult.SUCCESS;
            }
            boss = new EntityHHH(world);
            cap.hhhSummonedDay = (int)(time / 24000L);
        } else if (stack.func_77952_i() == 1 && (long)cap.monoculusSummonedDay < time / 24000L) {
            if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150427_aO) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("gui.boss.portal", new Object[0]));
                return EnumActionResult.SUCCESS;
            }
            boss = new EntityMonoculus(world);
            cap.monoculusSummonedDay = (int)(time / 24000L);
        } else if (stack.func_77952_i() == 2 && (long)cap.merasmusSummonedDay < time / 24000L) {
            if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150427_aO) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("gui.boss.portal", new Object[0]));
                return EnumActionResult.SUCCESS;
            }
            boss = new EntityMerasmus(world);
            cap.merasmusSummonedDay = (int)(time / 24000L);
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("gui.boss.nextnight", new Object[0]));
        }
        if (boss != null) {
            boss.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.05, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            boss.func_180482_a(world.func_175649_E(pos), null);
            boss.summoned = true;
            world.func_72838_d((Entity)boss);
            stack.func_190918_g(1);
        }
        return EnumActionResult.SUCCESS;
    }
}

