/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import com.google.common.collect.Multimap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.inventory.InventoryLoadout;
import rafradek.TF2weapons.inventory.InventoryWearables;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemWearable;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;

public class ItemBackpack
extends ItemFromData {
    private UUID ARMOR_MOD = UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E");
    private UUID MAX_HEALTH_MOD = UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D");
    private UUID ARMOR_TOUGHNESS_MOD = UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D");

    public ItemBackpack() {
        this.func_185043_a(new ResourceLocation("bodyModel"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (ItemWearable.usedModel == 1) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("headModel"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (ItemWearable.usedModel == 2) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77978_p().func_74765_d("Cooldown") > 0 || super.showDurabilityBar(stack);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return stack.func_77978_p().func_74765_d("Cooldown") > 0 ? (double)(stack.func_77978_p().func_74765_d("Cooldown") / this.getCooldown(stack)) : super.getDurabilityForDisplay(stack);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.CHEST) {
            multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(this.ARMOR_MOD, "Armor modifier", (double)TF2Attribute.getModifier("Armor", stack, ItemBackpack.getData(stack).getFloat(PropertyType.ARMOR), null), 0));
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(this.MAX_HEALTH_MOD, "Health modifier", (double)TF2Attribute.getModifier("Health", stack, 0.0f, null), 0));
            multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(this.ARMOR_TOUGHNESS_MOD, "Armor toughness modifier", (double)(TF2Attribute.getModifier("Armor", stack, 0.0f, null) * 0.5f + ItemBackpack.getData(stack).getFloat(PropertyType.ARMOR_TOUGHNESS)), 0));
        }
        return multimap;
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.CHEST;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        this.onArmorTickAny(world, (EntityLivingBase)player, itemStack);
    }

    public EntityEquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EntityEquipmentSlot.CHEST;
    }

    @Override
    public int getVisibilityFlags(ItemStack stack, EntityLivingBase living) {
        return stack.func_77978_p().func_74765_d("Cooldown") == 0 ? ItemFromData.getData(stack).getInt(PropertyType.WEAR) : 0;
    }

    public int getCooldown(ItemStack stack) {
        return 1200;
    }

    public ItemStack getBackpackItemToUse(ItemStack stack, EntityLivingBase player) {
        return ItemStack.field_190927_a;
    }

    public void onArmorTickAny(World world, EntityLivingBase player, ItemStack itemStack) {
        if (!world.field_72995_K) {
            float heal;
            if (player.field_70173_aa % 20 == 0 && (heal = TF2Attribute.getModifier("Health Regen", itemStack, 0.0f, player)) > 0.0f) {
                int lastHitTime = player.field_70173_aa - player.getEntityData().func_74762_e("lasthit");
                if (lastHitTime >= 120) {
                    player.func_70691_i(heal);
                } else if (lastHitTime >= 60) {
                    player.func_70691_i(TF2Util.lerp(heal, heal / 4.0f, (float)(lastHitTime - 60) / 60.0f));
                } else {
                    player.func_70691_i(heal / 4.0f);
                }
            }
            if (itemStack.func_77978_p().func_74765_d("Cooldown") > 0) {
                itemStack.func_77978_p().func_74777_a("Cooldown", (short)(itemStack.func_77978_p().func_74765_d("Cooldown") - 1));
            }
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.field_77351_y == EnumEnchantmentType.ARMOR_CHEST || enchantment.field_77351_y == EnumEnchantmentType.ARMOR || enchantment.field_77351_y == EnumEnchantmentType.WEARABLE;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer living, EnumHand hand) {
        if (!world.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)living, (Object)TF2weapons.instance, (int)0, (World)world, (int)0, (int)0, (int)0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)living.func_184586_b(hand));
    }

    public static ItemStack getBackpack(EntityLivingBase living) {
        if (living.hasCapability(TF2weapons.INVENTORY_CAP, null) && ((InventoryWearables)((Object)living.getCapability(TF2weapons.INVENTORY_CAP, null))).func_70301_a(2).func_77973_b() instanceof ItemBackpack) {
            return ((InventoryWearables)((Object)living.getCapability(TF2weapons.INVENTORY_CAP, null))).func_70301_a(2);
        }
        if (living instanceof EntityTF2Character) {
            InventoryLoadout loadout = ((EntityTF2Character)living).loadout;
            for (int i = 0; i < loadout.getSlots(); ++i) {
                if (!(loadout.getStackInSlot(i).func_77973_b() instanceof ItemBackpack)) continue;
                return loadout.getStackInSlot(i);
            }
        }
        if (living.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemBackpack) {
            return living.func_184582_a(EntityEquipmentSlot.CHEST);
        }
        return ItemStack.field_190927_a;
    }
}

