/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.item.ItemAmmo;
import rafradek.TF2weapons.item.ItemFireAmmo;
import rafradek.TF2weapons.item.ItemUsable;
import rafradek.TF2weapons.util.TF2Util;

public class ItemAmmoPackage
extends Item {
    public static final int[] AMMO_PACKAGE_MIN = new int[]{0, 3, 10, 10, 3, 20, 1, 2, 2, 20, 60, 2, 200, 2, 1};
    public static final int[] AMMO_PACKAGE_MAX = new int[]{0, 3, 10, 10, 4, 25, 2, 3, 3, 40, 60, 3, 200, 3, 2};

    public ItemAmmoPackage() {
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77637_a(TF2weapons.tabsurvivaltf2);
    }

    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        if (!this.func_194125_a(par2CreativeTabs)) {
            return;
        }
        par3List.add((Object)new ItemStack((Item)this, 1, 1));
    }

    public int getMaxStackSize(ItemStack stack) {
        return stack.func_77960_j() % 16 == 0 ? 64 : 1;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (!worldIn.field_72995_K) {
            int ammoType = itemStackIn.func_77960_j() % 16;
            for (ItemStack stack : playerIn.field_71071_by.field_70462_a) {
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemUsable) || ((ItemUsable)stack.func_77973_b()).getAmmoType(stack) == 0 || ((ItemUsable)stack.func_77973_b()).getAmmoType(stack) >= ItemAmmo.AMMO_TYPES.length) continue;
                ammoType = ((ItemUsable)stack.func_77973_b()).getAmmoType(stack);
                break;
            }
            ItemStack out = ItemAmmoPackage.convertPackage(itemStackIn, playerIn, ammoType);
            out = TF2Util.mergeStackByDamage((IItemHandler)playerIn.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), out);
            if (!playerIn.field_71071_by.func_70441_a(out)) {
                playerIn.func_70099_a(out, 0.0f);
            }
            itemStackIn.func_190918_g(1);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public static ItemStack convertPackage(ItemStack stack, EntityPlayer player, int ammoType) {
        Item item;
        if (ammoType == 0) {
            ammoType = player.func_70681_au().nextInt(13) + 1;
        }
        switch (ammoType) {
            case 2: {
                item = TF2weapons.itemAmmoMinigun;
                break;
            }
            case 3: {
                item = TF2weapons.itemAmmoPistol;
                break;
            }
            case 5: {
                item = TF2weapons.itemAmmoSMG;
                break;
            }
            case 9: {
                item = TF2weapons.itemAmmoSyringe;
                break;
            }
            case 10: {
                item = TF2weapons.itemAmmoFire;
                break;
            }
            case 12: {
                item = TF2weapons.itemAmmoMedigun;
                break;
            }
            default: {
                item = TF2weapons.itemAmmo;
            }
        }
        int amount = AMMO_PACKAGE_MIN[ammoType] + player.func_70681_au().nextInt(AMMO_PACKAGE_MAX[ammoType] + 1);
        amount *= stack.func_77960_j() / 16 + 1;
        ItemStack ammo = new ItemStack(item);
        if (item instanceof ItemFireAmmo) {
            if (amount > ammo.func_77958_k() + 1) {
                ammo.func_190920_e(Math.round((float)amount / (float)(ammo.func_77958_k() + 1)));
            } else {
                ammo.func_77964_b(ammo.func_77958_k() + 1 - amount);
            }
        } else {
            ammo.func_77964_b(ammoType);
            ammo.func_190920_e(amount);
        }
        WeaponsCapability.get((Entity)player).setMetal(WeaponsCapability.get((Entity)player).getMetal() + 40 * (stack.func_77960_j() / 16 + 1));
        return ammo;
    }
}

