/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.util.PropertyType;

public class ItemAmmo
extends Item {
    public static final String[] AMMO_TYPES = new String[]{"none", "shotgun", "minigun", "pistol", "revolver", "smg", "sniper", "rocket", "grenade", "syringe", "fire", "sticky", "medigun", "flare", "ball", "custom"};
    public static final int[] AMMO_MAX_STACK = new int[]{64, 64, 64, 64, 64, 64, 16, 32, 32, 64, 1, 32, 1, 64, 64, 64};
    public static ItemStack STACK_FILL;

    public ItemAmmo() {
        this.func_77627_a(true);
    }

    public String getType(ItemStack stack) {
        return AMMO_TYPES[this.getTypeInt(stack)];
    }

    public int getTypeInt(ItemStack stack) {
        return stack.func_77960_j();
    }

    public boolean isValidForWeapon(ItemStack ammo, ItemStack weapon) {
        return this.getTypeInt(ammo) == ItemFromData.getData(weapon).getInt(PropertyType.AMMO_TYPE);
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_77640_w() {
        return TF2weapons.tabsurvivaltf2;
    }

    public String func_77667_c(ItemStack stack) {
        return "item.tf2ammo." + this.getType(stack);
    }

    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        if (!this.func_194125_a(par2CreativeTabs)) {
            return;
        }
        for (int i = 1; i < AMMO_TYPES.length - 1; ++i) {
            if (i == 10 || i == 12 || i == 2 || i == 3 || i == 5 || i == 9) continue;
            par3List.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return AMMO_MAX_STACK[MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)AMMO_MAX_STACK.length)];
    }

    public int consumeAmmo(EntityLivingBase living, ItemStack stack, int amount) {
        if (stack == STACK_FILL) {
            return 0;
        }
        if (amount > 0) {
            int left = Math.max(0, amount - stack.func_190916_E());
            stack.func_190918_g(amount);
            return left;
        }
        return 0;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer living, EnumHand hand) {
        if (!world.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)living, (Object)TF2weapons.instance, (int)0, (World)world, (int)0, (int)0, (int)0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)living.func_184586_b(hand));
    }

    public int getAmount(ItemStack stack) {
        return stack.func_190916_E();
    }
}

