/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.item;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityTeleport;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.client.audio.WeaponSound;
import rafradek.TF2weapons.common.TF2Achievements;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.projectile.EntityProjectileBase;
import rafradek.TF2weapons.entity.projectile.EntityRocket;
import rafradek.TF2weapons.entity.projectile.EntityStickybomb;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemProjectileWeapon;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;

public class ItemAirblast
extends ItemProjectileWeapon {
    @Override
    public boolean canAltFire(World worldObj, EntityLivingBase player, ItemStack item) {
        return super.canAltFire(worldObj, player, item) && WeaponsCapability.get((Entity)player).getPrimaryCooldown() <= 50 && TF2Attribute.getModifier("Cannot Airblast", item, 0.0f, player) == 0.0f;
    }

    @Override
    public short getAltFiringSpeed(ItemStack item, EntityLivingBase player) {
        return (short)TF2Attribute.getModifier("Airblast Rate", item, 750.0f, player);
    }

    public static boolean isPushable(EntityLivingBase living, Entity target) {
        return !(target instanceof EntityBuilding || target instanceof EntityProjectileBase && !((EntityProjectileBase)target).isPushable() || target instanceof EntityArrow && target.field_70122_E || target instanceof IThrowableEntity && ((IThrowableEntity)target).getThrower() == living || TF2Util.isOnSameTeam((Entity)living, target));
    }

    @Override
    public void playHitSound(ItemStack stack, EntityLivingBase living, Entity target) {
        if (target.func_70027_ad() && ItemAirblast.getData(stack).hasProperty(PropertyType.SPECIAL_1_SOUND)) {
            TF2Util.playSound(target, ItemFromData.getSound(stack, PropertyType.SPECIAL_1_SOUND), 0.7f, 1.0f);
        } else {
            super.playHitSound(stack, living, target);
        }
    }

    @Override
    public void altUse(ItemStack stack, EntityLivingBase living, World world) {
        ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).setPrimaryCooldown(this.getAltFiringSpeed(stack, living));
        if (world.field_72995_K) {
            if (ClientProxy.fireSounds.get((Object)living) != null) {
                ((WeaponSound)((Object)ClientProxy.fireSounds.get((Object)living))).setDone();
            }
            return;
        }
        int ammoUse = 15;
        if (!(living instanceof EntityPlayer && ((EntityPlayer)living).field_71075_bZ.field_75098_d || this.getAmmoAmount(living, stack) >= ammoUse)) {
            return;
        }
        this.consumeAmmoGlobal(living, stack, ammoUse);
        TF2Util.playSound((Entity)living, ItemFromData.getSound(stack, PropertyType.AIRBLAST_SOUND), 1.0f, 1.0f);
        Vec3d lookVec = living.func_70676_i(1.0f);
        Vec3d eyeVec = new Vec3d(living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v);
        eyeVec.func_178787_e(lookVec);
        float size = TF2Attribute.getModifier("Flame Range", stack, 5.0f, living);
        List list = world.func_72872_a(Entity.class, new AxisAlignedBB(eyeVec.field_72450_a - (double)size, eyeVec.field_72448_b - (double)size, eyeVec.field_72449_c - (double)size, eyeVec.field_72450_a + (double)size, eyeVec.field_72448_b + (double)size, eyeVec.field_72449_c + (double)size));
        for (Entity entity : list) {
            if (!ItemAirblast.isPushable(living, entity) || entity.func_70092_e(living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v) > (double)(size * size) || !TF2Util.lookingAt(living, 60.0, entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v)) continue;
            if (entity instanceof IThrowableEntity && !(entity instanceof EntityStickybomb)) {
                ((IThrowableEntity)entity).setThrower((Entity)living);
            } else if (entity instanceof EntityStickybomb) {
                ((EntityStickybomb)entity).addStickCooldown();
            } else if (entity instanceof EntityArrow) {
                ((EntityArrow)entity).field_70250_c = living;
                ((EntityArrow)entity).func_70239_b(((EntityArrow)entity).func_70242_d() * 1.35);
            }
            if (entity instanceof IProjectile) {
                IProjectile proj = (IProjectile)entity;
                float speed = (float)Math.sqrt(entity.field_70159_w * entity.field_70159_w + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y) * (0.65f + TF2Attribute.getModifier("Flame Range", stack, 0.5f, living));
                List<RayTraceResult> rayTraces = TF2Util.pierce(world, (Entity)living, eyeVec.field_72450_a, eyeVec.field_72448_b, eyeVec.field_72449_c, eyeVec.field_72450_a + lookVec.field_72450_a * 256.0, eyeVec.field_72448_b + lookVec.field_72448_b * 256.0, eyeVec.field_72449_c + lookVec.field_72449_c * 256.0, false, 0.08f, false);
                if (!rayTraces.isEmpty() && rayTraces.get((int)0).field_72307_f != null) {
                    proj.func_70186_c(rayTraces.get((int)0).field_72307_f.field_72450_a - entity.field_70165_t, rayTraces.get((int)0).field_72307_f.field_72448_b - entity.field_70163_u - (double)(entity.field_70131_O / 2.0f), rayTraces.get((int)0).field_72307_f.field_72449_c - entity.field_70161_v, speed, 0.0f);
                } else {
                    proj.func_70186_c(eyeVec.field_72450_a + lookVec.field_72450_a * 256.0 - entity.field_70165_t, eyeVec.field_72448_b + lookVec.field_72448_b * 256.0 - entity.field_70163_u, eyeVec.field_72449_c + lookVec.field_72449_c * 256.0 - entity.field_70161_v, speed, 0.0f);
                }
            } else {
                double mult = (entity instanceof EntityLivingBase ? 1.0 - ((EntityLivingBase)entity).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e() : 0.2) + (double)TF2Attribute.getModifier("Flame Range", stack, 0.8f, living);
                entity.field_70159_w = lookVec.field_72450_a * 0.6 * mult;
                entity.field_70181_x = (lookVec.field_72448_b * 0.2 + 0.36) * mult;
                entity.field_70179_y = lookVec.field_72449_c * 0.6 * mult;
            }
            if (entity instanceof EntityProjectileBase) {
                ((EntityProjectileBase)entity).reflected = true;
                ((EntityProjectileBase)entity).setCritical(Math.max(((EntityProjectileBase)entity).getCritical(), 1));
                if (entity instanceof EntityRocket && ((EntityRocket)entity).shootingEntity instanceof EntityPlayer) {
                    ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).tickAirblasted = living.field_70173_aa;
                }
            }
            if (!(entity instanceof EntityLivingBase)) {
                entity.func_184185_a(ItemFromData.getSound(stack, PropertyType.AIRBLAST_ROCKET_SOUND), 1.5f, 1.0f);
            }
            if (living instanceof EntityPlayerMP) {
                ((EntityPlayerMP)living).func_71029_a(TF2Achievements.PROJECTILES_REFLECTED);
            }
            EntityTracker tracker = ((WorldServer)world).func_73039_n();
            tracker.func_151248_b(entity, (Packet)new SPacketEntityVelocity(entity));
            tracker.func_151248_b(entity, (Packet)new SPacketEntityTeleport(entity));
        }
    }
}

